; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=-macrofusion,-branchfusion -post-RA-scheduler=0 | FileCheck %s --check-prefix=NOFUSION_NOPOSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=-macrofusion,+branchfusion -post-RA-scheduler=0 | FileCheck %s --check-prefixes=BRANCHFUSION_NOPOSTRA,BRANCHFUSIONONLY_NOPOSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=+macrofusion,-branchfusion -post-RA-scheduler=0 | FileCheck %s --check-prefixes=BRANCHFUSION_NOPOSTRA,MACROFUSION_NOPOSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=-macrofusion,-branchfusion -post-RA-scheduler=1 | FileCheck %s --check-prefix=NOFUSION_POSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=-macrofusion,+branchfusion -post-RA-scheduler=1 | FileCheck %s --check-prefix=BRANCHFUSION_POSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=+macrofusion,-branchfusion -post-RA-scheduler=1 | FileCheck %s --check-prefix=BRANCHFUSION_POSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=-macrofusion,-branchfusion -enable-misched=0 -misched-postra=1 -enable-post-misched | FileCheck %s --check-prefix=NOFUSION_MISCHEDPOSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=-macrofusion,+branchfusion -enable-misched=0 -misched-postra=1 -enable-post-misched | FileCheck %s --check-prefix=BRANCHFUSION_MISCHEDPOSTRA
; RUN: llc < %s -mtriple=x86_64-- -mattr=+macrofusion,-branchfusion -enable-misched=0 -misched-postra=1 -enable-post-misched | FileCheck %s --check-prefix=BRANCHFUSION_MISCHEDPOSTRA



; testb should be scheduled right before je to enable macro-fusion.

define i32 @macrofuse_test_je(i32 %flags, i8* %p) nounwind {
; NOFUSION_NOPOSTRA-LABEL: macrofuse_test_je:
; NOFUSION_NOPOSTRA:       # %bb.0: # %entry
; NOFUSION_NOPOSTRA-NEXT:    xorl %eax, %eax
; NOFUSION_NOPOSTRA-NEXT:    testl $512, %edi # imm = 0x200
; NOFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_NOPOSTRA-NEXT:    je .LBB0_2
; NOFUSION_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_NOPOSTRA-NEXT:  .LBB0_2: # %if.end
; NOFUSION_NOPOSTRA-NEXT:    retq
;
; BRANCHFUSION_NOPOSTRA-LABEL: macrofuse_test_je:
; BRANCHFUSION_NOPOSTRA:       # %bb.0: # %entry
; BRANCHFUSION_NOPOSTRA-NEXT:    xorl %eax, %eax
; BRANCHFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_NOPOSTRA-NEXT:    testl $512, %edi # imm = 0x200
; BRANCHFUSION_NOPOSTRA-NEXT:    je .LBB0_2
; BRANCHFUSION_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_NOPOSTRA-NEXT:  .LBB0_2: # %if.end
; BRANCHFUSION_NOPOSTRA-NEXT:    retq
;
; NOFUSION_POSTRA-LABEL: macrofuse_test_je:
; NOFUSION_POSTRA:       # %bb.0: # %entry
; NOFUSION_POSTRA-NEXT:    xorl %eax, %eax
; NOFUSION_POSTRA-NEXT:    testl $512, %edi # imm = 0x200
; NOFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_POSTRA-NEXT:    je .LBB0_2
; NOFUSION_POSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_POSTRA-NEXT:    movl $1, %eax
; NOFUSION_POSTRA-NEXT:  .LBB0_2: # %if.end
; NOFUSION_POSTRA-NEXT:    retq
;
; BRANCHFUSION_POSTRA-LABEL: macrofuse_test_je:
; BRANCHFUSION_POSTRA:       # %bb.0: # %entry
; BRANCHFUSION_POSTRA-NEXT:    xorl %eax, %eax
; BRANCHFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_POSTRA-NEXT:    testl $512, %edi # imm = 0x200
; BRANCHFUSION_POSTRA-NEXT:    je .LBB0_2
; BRANCHFUSION_POSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSION_POSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_POSTRA-NEXT:  .LBB0_2: # %if.end
; BRANCHFUSION_POSTRA-NEXT:    retq
;
; NOFUSION_MISCHEDPOSTRA-LABEL: macrofuse_test_je:
; NOFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; NOFUSION_MISCHEDPOSTRA-NEXT:    xorl %eax, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:    testl $512, %edi # imm = 0x200
; NOFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_MISCHEDPOSTRA-NEXT:    je .LBB0_2
; NOFUSION_MISCHEDPOSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:  .LBB0_2: # %if.end
; NOFUSION_MISCHEDPOSTRA-NEXT:    retq
;
; BRANCHFUSION_MISCHEDPOSTRA-LABEL: macrofuse_test_je:
; BRANCHFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    xorl %eax, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    testl $512, %edi # imm = 0x200
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    je .LBB0_2
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  .LBB0_2: # %if.end
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    retq
entry:
  %and = and i32 %flags, 512
  %tobool = icmp eq i32 %and, 0
  store i8 1, i8* %p
  br i1 %tobool, label %if.end, label %if.then

if.then:
  br label %if.end

if.end:
  %hasflag = phi i32 [ 1, %if.then ], [ 0, %entry ]
  ret i32 %hasflag
}

define i32 @macrofuse_cmp_je(i32 %flags, i8* %p) nounwind {
; NOFUSION_NOPOSTRA-LABEL: macrofuse_cmp_je:
; NOFUSION_NOPOSTRA:       # %bb.0: # %entry
; NOFUSION_NOPOSTRA-NEXT:    cmpl $512, %edi # imm = 0x200
; NOFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_NOPOSTRA-NEXT:    je .LBB1_1
; NOFUSION_NOPOSTRA-NEXT:  # %bb.2: # %if.then
; NOFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_NOPOSTRA-NEXT:    retq
; NOFUSION_NOPOSTRA-NEXT:  .LBB1_1:
; NOFUSION_NOPOSTRA-NEXT:    xorl %eax, %eax
; NOFUSION_NOPOSTRA-NEXT:    retq
;
; BRANCHFUSION_NOPOSTRA-LABEL: macrofuse_cmp_je:
; BRANCHFUSION_NOPOSTRA:       # %bb.0: # %entry
; BRANCHFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_NOPOSTRA-NEXT:    cmpl $512, %edi # imm = 0x200
; BRANCHFUSION_NOPOSTRA-NEXT:    je .LBB1_1
; BRANCHFUSION_NOPOSTRA-NEXT:  # %bb.2: # %if.then
; BRANCHFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_NOPOSTRA-NEXT:    retq
; BRANCHFUSION_NOPOSTRA-NEXT:  .LBB1_1:
; BRANCHFUSION_NOPOSTRA-NEXT:    xorl %eax, %eax
; BRANCHFUSION_NOPOSTRA-NEXT:    retq
;
; NOFUSION_POSTRA-LABEL: macrofuse_cmp_je:
; NOFUSION_POSTRA:       # %bb.0: # %entry
; NOFUSION_POSTRA-NEXT:    cmpl $512, %edi # imm = 0x200
; NOFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_POSTRA-NEXT:    je .LBB1_1
; NOFUSION_POSTRA-NEXT:  # %bb.2: # %if.then
; NOFUSION_POSTRA-NEXT:    movl $1, %eax
; NOFUSION_POSTRA-NEXT:    retq
; NOFUSION_POSTRA-NEXT:  .LBB1_1:
; NOFUSION_POSTRA-NEXT:    xorl %eax, %eax
; NOFUSION_POSTRA-NEXT:    retq
;
; BRANCHFUSION_POSTRA-LABEL: macrofuse_cmp_je:
; BRANCHFUSION_POSTRA:       # %bb.0: # %entry
; BRANCHFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_POSTRA-NEXT:    cmpl $512, %edi # imm = 0x200
; BRANCHFUSION_POSTRA-NEXT:    je .LBB1_1
; BRANCHFUSION_POSTRA-NEXT:  # %bb.2: # %if.then
; BRANCHFUSION_POSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_POSTRA-NEXT:    retq
; BRANCHFUSION_POSTRA-NEXT:  .LBB1_1:
; BRANCHFUSION_POSTRA-NEXT:    xorl %eax, %eax
; BRANCHFUSION_POSTRA-NEXT:    retq
;
; NOFUSION_MISCHEDPOSTRA-LABEL: macrofuse_cmp_je:
; NOFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; NOFUSION_MISCHEDPOSTRA-NEXT:    cmpl $512, %edi # imm = 0x200
; NOFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_MISCHEDPOSTRA-NEXT:    je .LBB1_1
; NOFUSION_MISCHEDPOSTRA-NEXT:  # %bb.2: # %if.then
; NOFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:    retq
; NOFUSION_MISCHEDPOSTRA-NEXT:  .LBB1_1:
; NOFUSION_MISCHEDPOSTRA-NEXT:    xorl %eax, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:    retq
;
; BRANCHFUSION_MISCHEDPOSTRA-LABEL: macrofuse_cmp_je:
; BRANCHFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    cmpl $512, %edi # imm = 0x200
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    je .LBB1_1
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  # %bb.2: # %if.then
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    retq
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  .LBB1_1:
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    xorl %eax, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    retq
entry:
  %sub = sub i32 %flags, 512
  %tobool = icmp eq i32 %sub, 0
  store i8 1, i8* %p
  br i1 %tobool, label %if.end, label %if.then

if.then:
  br label %if.end

if.end:
  %hasflag = phi i32 [ 1, %if.then ], [ 0, %entry ]
  ret i32 %hasflag
}

define i32 @macrofuse_alu_je(i32 %flags, i8* %p) nounwind {
; NOFUSION_NOPOSTRA-LABEL: macrofuse_alu_je:
; NOFUSION_NOPOSTRA:       # %bb.0: # %entry
; NOFUSION_NOPOSTRA-NEXT:    movl %edi, %eax
; NOFUSION_NOPOSTRA-NEXT:    addl $-512, %eax # imm = 0xFE00
; NOFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_NOPOSTRA-NEXT:    je .LBB2_2
; NOFUSION_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_NOPOSTRA-NEXT:  .LBB2_2: # %if.end
; NOFUSION_NOPOSTRA-NEXT:    retq
;
; BRANCHFUSIONONLY_NOPOSTRA-LABEL: macrofuse_alu_je:
; BRANCHFUSIONONLY_NOPOSTRA:       # %bb.0: # %entry
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    movl %edi, %eax
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    addl $-512, %eax # imm = 0xFE00
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    je .LBB2_2
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:  .LBB2_2: # %if.end
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    retq
;
; MACROFUSION_NOPOSTRA-LABEL: macrofuse_alu_je:
; MACROFUSION_NOPOSTRA:       # %bb.0: # %entry
; MACROFUSION_NOPOSTRA-NEXT:    movl %edi, %eax
; MACROFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; MACROFUSION_NOPOSTRA-NEXT:    addl $-512, %eax # imm = 0xFE00
; MACROFUSION_NOPOSTRA-NEXT:    je .LBB2_2
; MACROFUSION_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; MACROFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; MACROFUSION_NOPOSTRA-NEXT:  .LBB2_2: # %if.end
; MACROFUSION_NOPOSTRA-NEXT:    retq
;
; NOFUSION_POSTRA-LABEL: macrofuse_alu_je:
; NOFUSION_POSTRA:       # %bb.0: # %entry
; NOFUSION_POSTRA-NEXT:    movl %edi, %eax
; NOFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_POSTRA-NEXT:    addl $-512, %eax # imm = 0xFE00
; NOFUSION_POSTRA-NEXT:    je .LBB2_2
; NOFUSION_POSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_POSTRA-NEXT:    movl $1, %eax
; NOFUSION_POSTRA-NEXT:  .LBB2_2: # %if.end
; NOFUSION_POSTRA-NEXT:    retq
;
; BRANCHFUSION_POSTRA-LABEL: macrofuse_alu_je:
; BRANCHFUSION_POSTRA:       # %bb.0: # %entry
; BRANCHFUSION_POSTRA-NEXT:    movl %edi, %eax
; BRANCHFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_POSTRA-NEXT:    addl $-512, %eax # imm = 0xFE00
; BRANCHFUSION_POSTRA-NEXT:    je .LBB2_2
; BRANCHFUSION_POSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSION_POSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_POSTRA-NEXT:  .LBB2_2: # %if.end
; BRANCHFUSION_POSTRA-NEXT:    retq
;
; NOFUSION_MISCHEDPOSTRA-LABEL: macrofuse_alu_je:
; NOFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; NOFUSION_MISCHEDPOSTRA-NEXT:    movl %edi, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_MISCHEDPOSTRA-NEXT:    addl $-512, %eax # imm = 0xFE00
; NOFUSION_MISCHEDPOSTRA-NEXT:    je .LBB2_2
; NOFUSION_MISCHEDPOSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:  .LBB2_2: # %if.end
; NOFUSION_MISCHEDPOSTRA-NEXT:    retq
;
; BRANCHFUSION_MISCHEDPOSTRA-LABEL: macrofuse_alu_je:
; BRANCHFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movl %edi, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    addl $-512, %eax # imm = 0xFE00
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    je .LBB2_2
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  .LBB2_2: # %if.end
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    retq
entry:
  %sub = sub i32 %flags, 512
  %tobool = icmp eq i32 %sub, 0
  store i8 1, i8* %p
  br i1 %tobool, label %if.end, label %if.then

if.then:
  br label %if.end

if.end:
  %hasflag = phi i32 [ 1, %if.then ], [ %sub, %entry ]
  ret i32 %hasflag
}

define i32 @macrofuse_dec_je(i32 %flags, i8* %p) nounwind {
; NOFUSION_NOPOSTRA-LABEL: macrofuse_dec_je:
; NOFUSION_NOPOSTRA:       # %bb.0: # %entry
; NOFUSION_NOPOSTRA-NEXT:    movl %edi, %eax
; NOFUSION_NOPOSTRA-NEXT:    decl %eax
; NOFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_NOPOSTRA-NEXT:    je .LBB3_2
; NOFUSION_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_NOPOSTRA-NEXT:  .LBB3_2: # %if.end
; NOFUSION_NOPOSTRA-NEXT:    retq
;
; BRANCHFUSIONONLY_NOPOSTRA-LABEL: macrofuse_dec_je:
; BRANCHFUSIONONLY_NOPOSTRA:       # %bb.0: # %entry
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    movl %edi, %eax
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    decl %eax
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    je .LBB3_2
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:  .LBB3_2: # %if.end
; BRANCHFUSIONONLY_NOPOSTRA-NEXT:    retq
;
; MACROFUSION_NOPOSTRA-LABEL: macrofuse_dec_je:
; MACROFUSION_NOPOSTRA:       # %bb.0: # %entry
; MACROFUSION_NOPOSTRA-NEXT:    movl %edi, %eax
; MACROFUSION_NOPOSTRA-NEXT:    movb $1, (%rsi)
; MACROFUSION_NOPOSTRA-NEXT:    decl %eax
; MACROFUSION_NOPOSTRA-NEXT:    je .LBB3_2
; MACROFUSION_NOPOSTRA-NEXT:  # %bb.1: # %if.then
; MACROFUSION_NOPOSTRA-NEXT:    movl $1, %eax
; MACROFUSION_NOPOSTRA-NEXT:  .LBB3_2: # %if.end
; MACROFUSION_NOPOSTRA-NEXT:    retq
;
; NOFUSION_POSTRA-LABEL: macrofuse_dec_je:
; NOFUSION_POSTRA:       # %bb.0: # %entry
; NOFUSION_POSTRA-NEXT:    movl %edi, %eax
; NOFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_POSTRA-NEXT:    decl %eax
; NOFUSION_POSTRA-NEXT:    je .LBB3_2
; NOFUSION_POSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_POSTRA-NEXT:    movl $1, %eax
; NOFUSION_POSTRA-NEXT:  .LBB3_2: # %if.end
; NOFUSION_POSTRA-NEXT:    retq
;
; BRANCHFUSION_POSTRA-LABEL: macrofuse_dec_je:
; BRANCHFUSION_POSTRA:       # %bb.0: # %entry
; BRANCHFUSION_POSTRA-NEXT:    movl %edi, %eax
; BRANCHFUSION_POSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_POSTRA-NEXT:    decl %eax
; BRANCHFUSION_POSTRA-NEXT:    je .LBB3_2
; BRANCHFUSION_POSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSION_POSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_POSTRA-NEXT:  .LBB3_2: # %if.end
; BRANCHFUSION_POSTRA-NEXT:    retq
;
; NOFUSION_MISCHEDPOSTRA-LABEL: macrofuse_dec_je:
; NOFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; NOFUSION_MISCHEDPOSTRA-NEXT:    movl %edi, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; NOFUSION_MISCHEDPOSTRA-NEXT:    decl %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:    je .LBB3_2
; NOFUSION_MISCHEDPOSTRA-NEXT:  # %bb.1: # %if.then
; NOFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; NOFUSION_MISCHEDPOSTRA-NEXT:  .LBB3_2: # %if.end
; NOFUSION_MISCHEDPOSTRA-NEXT:    retq
;
; BRANCHFUSION_MISCHEDPOSTRA-LABEL: macrofuse_dec_je:
; BRANCHFUSION_MISCHEDPOSTRA:       # %bb.0: # %entry
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movl %edi, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movb $1, (%rsi)
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    decl %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    je .LBB3_2
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  # %bb.1: # %if.then
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    movl $1, %eax
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:  .LBB3_2: # %if.end
; BRANCHFUSION_MISCHEDPOSTRA-NEXT:    retq
entry:
  %sub = sub i32 %flags, 1
  %tobool = icmp eq i32 %sub, 0
  store i8 1, i8* %p
  br i1 %tobool, label %if.end, label %if.then

if.then:
  br label %if.end

if.end:
  %hasflag = phi i32 [ 1, %if.then ], [ %sub, %entry ]
  ret i32 %hasflag
}
