.\"
.\" "$Id: cups-lpd.man,v 1.4 2003/04/26 17:09:54 mike Exp $"
.\"
.\"   cups-lpd man page for the Common UNIX Printing System (CUPS).
.\"   Based on cvs revision 1.10
.\"
.\"   Copyright 1997-2003 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636-3111 USA
.\"
.\"       Voice: (301) 373-9603
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH cups-lpd 8 "Common UNIX Printing System" "13 Fvrier 2001" "Easy Software Products"
.SH NOM
cups-lpd \- Reoit les travaux d'impression et renvoie le statut des imprimantes aux clients lpd
.SH SYNOPSIS
.B cups-lpd
[ -o
.I option=valeur
]
.SH DESCRIPTION
\fBcups-lpd\fR est un mini serveur Line Printer Daemon (\ LPD\ ) qui
gre les client gnriques utilisant le protocole LPD.
\fBcups-lpd\fR ne fonctionne pas comme un dmon rseau solitaire, mais 
utilise le super-serveur \fBinetd(8)\fR. Ajoutez la ligne suivante au fichier
\fBinetd.conf\fR pour activer le dmon \fBcups-lpd\fR\ :
.br
.nf

    printer stream tcp nowait lp /path/to/cups/daemon/cups-lpd cups-lpd
.fi
.LP
Si vous utilisez le super-serveur \fIxinetd(8)\fR, ajoutez la ligne suivante au fichier
\fBxinetd.conf\fR\ :
.br
.nf

    service printer
    {
        socket_type = stream
        protocol = tcp
        wait = no
        user = lp
        server = /path/to/cups/daemon/cups-lpd
    }
.fi
.LP
/path/to/cups/daemon est habituellement /usr/lib/cups/daemon ou
/usr/libexec/cups/daemon, suivant votre systme d'exploitation. Vous
pouvez trouver cette information dans le fichier cupsd.conf.
.SH SCURIT
\fBcups-lpd\fR n'applique pour le moment aucun des contrles d'accs dfinis
dans les fichiers \fIcupsd.conf(5)\fR, \fIhosts.allow(5)\fR ou
\fIhosts.deny(5)\fR utiliss par les wrappers TCP. L'excution de
\fBcups-lpd\fR sur un serveur permet donc le lancement d'impressions depuis
n'importe quel ordinateur de votre rseau, voire mme de n'importe quel
ordinateur sur Terre.
.LP
Bien que \fIxinetd\fR possde un contrle d'accs intgr, il est recommand
d'utiliser le wrapper TCP fourni avec \fIinetd\fR pour limiter les accs aux
ordinateurs pouvant lancer des impressions sur un serveur.
.SH OPTIONS
L'option \fI-o\fR ajoute des options  tous les travaux d'impression.
Cette option est souvent utilise pour dsactiver le filtre \ l\  de manire
 ce que les travaux passant par le rseau soient filtrs correctement.
.br
.nf

    printer stream tcp nowait lp /usr/lib/cups/daemon/cups-lpd cups-lpd \ 
        -o document-format=application/octet-stream

    server = /usr/lib/cups/daemon/cups-lpd
    server_args = -o document-format=application/octet-stream
.fi
.LP
Dans cet exemple, le format du document est rinitialis  la valeur
\fIapplication/octet-stream\fR, ce qui force l'auto-dtection du type de
fichier.
.SH COMPATIBILIT
\fBcups-lpd\fR ne se conforme pas  la RFC 1179 concernant l'utilisation
des ports systmes (1  1\|024), car l'utilisation de ces ports n'empche pas
un utilisateur d'envoyer un travail d'impression. Bien que ce comportement
soit diffrent de celui des implmentations LPD Berkeley, il ne devrait pas
affecter le droulement correct des impressions.
.LP
Le format de sortie des demandes d'tat se conforme  la RFC 2569, Mapping
between LPD and IPP Protocols. Comme bon nombre d'implmentations LPD ne suivent
pas cette dfinition, la rcupration d'tat par un client LPD peut tre
errone.
.SH VOIR AUSSI
inetd(8), xinetd(8),
CUPS Software Administrators Manual,
http://localhost:631/documentation.html
.SH COPYRIGHT
Copyright 1993-2003 Easy Software Products, Tous droits rservs.
.SH TRADUCTION
Gilles QUERRET <gilles.querret@nerim.net>
.\"
.\" End of "$Id: cups-lpd.man,v 1.4 2003/04/26 17:09:54 mike Exp $".
.\"
