#include "palettedialog.h"

#include <kdebug.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <kapplication.h>

#include <qlayout.h>

paletteDialog::paletteDialog(QPixmap *p, QWidget *parent, const char *name)
  : QDialog(parent, name, TRUE)
{
    resize(340, 280);
    QVBoxLayout *box = new QVBoxLayout( this, 10 );

    pal= new paletteWidget(p, this);
    pal->move(10, 10);
    box->addWidget( pal );

    QPushButton *dismiss = new QPushButton( i18n("Dismiss"), this );
    box->addWidget( dismiss );

    connect( dismiss, SIGNAL(clicked()), SLOT(accept()) );
    connect( pal, SIGNAL(colourSelected(int)), pal, SLOT(editColour(int)) );
}

QPixmap *paletteDialog::pixmap()
{
  return pal->pixmap();
}

#include "palettedialog.moc"
