// -*- c++ -*-

// $Id: canvas.h,v 1.15 2002/09/25 23:45:28 waba Exp $

#ifndef CANVAS_H
#define CANVAS_H

#include <qwidget.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qobject.h>
#include <qwmatrix.h>

#include "kpaintundo.h"

class Tool;

class Canvas : public QWidget
{
  Q_OBJECT

public:
  Canvas(int width, int height, QWidget *parent= 0, const char *name=0);
  Canvas(const QString & filename, QWidget *parent= 0, const char *name=0);
  ~Canvas();

  QPixmap *pixmap();
  void setPixmap(QPixmap *);
  void setDepth(int);
  int getDepth() const { return pix->depth(); }

  const QRect &selection() const;
  void setSelection(const QRect&);
  bool hasSelection() const { return haveSelection_; }
  void clearSelection();

  /** copies from selection into clipboard and then cuts selection */
  void cut();
  /** copys from selection into clipboard */
  void copy();
  /* paste from clipboard into canvas */
  void paste( int x, int y );
  /* clear the whole image */
  void clear();

  void undo();
  void redo();

  //static inline bool hasClipboardData();
  //static inline const QPixmap *clipboardData();

  QPixmap *zoomedPixmap();
  const QWMatrix &zoomMatrix() const;
  const QWMatrix &zoomLineMatrix() const;
  void setZoom(int);
  int zoom();
  void updateZoomed();
  void updateZoomedClipboard(); //jwc
  void resizeImage(int, int);
  int imageWidth() const;
  int imageHeight() const;

  bool load(const QString & filename = QString::null, const char *format= 0);
  bool save(const QString & filename = QString::null, const char *format= 0);

  bool isActive();
  bool isModified();
  void clearModified();

  // This controls which tool the events go to (if any)
  void activate(Tool *tool);
  void deactivate();

  // Handle paint events
  void paintEvent(QPaintEvent *e);

  // Redirect events tools can use
  void mousePressEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent *e);
  void mouseReleaseEvent(QMouseEvent *e);
  void keyPressEvent(QKeyEvent *e);
  void keyReleaseEvent(QKeyEvent *e);

public slots:
  void markModified();

signals:
  void sizeChanged();
  void pixmapChanged(QPixmap *);
  void modified();
  void selection(bool);
  void clipboard(bool);
  void startDrawing();

protected:
  enum state {
    ACTIVE,
    INACTIVE
  };

  QWMatrix matrix;
  QWMatrix rev_matrix;
  QWMatrix rev_line_matrix;
  Tool *currentTool;

  /** Zoomed copy */
  QPixmap *zoomed;

  /** Master copy */
  QPixmap *pix;

  /** Clipboard Data from Cut/Copy */
  QPixmap clipboardPix;

  /** % of original size */
  int zoomFactor;

  /** Has the pixmap been modified? */
  bool modified_;
  state s;
  QRect selection_;
  QRect clipboardRect_; // jwc
  bool haveSelection_;

  static int inst; // how many instances have we ?
  
  KUndo undoStack;
};

#endif // CANVAS_H
