/***************************************************************************
                            VoiceManager.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef VOICEMANAGER_H
#define VOICEMANAGER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 Manages the voices used by synthesizers.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Manages internally the voices used by synth devices.

*/
@interface  VoiceManager : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Cronstructor.
     
*/
- initWithInt: (int)totalvoices;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 Allocates a voice used in channel @p chn, and playing key @p key

*/
- (int) allocateVoice: (int)chn key: (int)key;

/** 
 Deallocates the voice with ID @p id.

*/
- deallocateVoice: (int)identifier;

/** 
 -initSearch must be called always before @ref  #--search to initialize
 internal variables.

*/
- initSearch;

/** 
 Returns -1 if channel chn is not currently used, or a voice using
 channel @p chn if any.

 Calling search repeteadly, will return all the voices using channel 
 @p chn, and a -1 after the last one.

*/
- (int) search: (int)chn;

/** 
 This is a convenience function that differs from the above in that it also
 looks for a specific note (the second parameter)

*/
- (int) search: (int)chn note: (int)note;

/** 
 Returns the channel that voice @p v is using.
     
*/
- (int) channel: (int)v;

/** 
 Returns the note that voice @p v is playing.
     
*/
- (int) note: (int)v;

/** 
 Returns true or false if the voice @p v is being used or not respectively.
     
*/
- (int) used: (int)v;

/** 
 Clears the lists of used voices.
     
*/
- clearLists;
@end

#endif
