/***************************************************************************
                            KMainWindow.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAINWINDOW_H
#define KMAINWINDOW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KXMLGUIBuilder.h>
#include <kdeobjc/KXMLGUIClient.h>
#include <qtobjc/QMainWindow.h>

/**

 Top level widget that provides toolbars, a status line and a frame.

 It should be used as a top level (parent-less) widget.
 It manages the geometry for all its children, including your
 main widget.

 Normally, you will inherit from KMainWindow,
 then construct (or use some existing) widget as
 your main view. You can set only one main view.

 You can add as many toolbars as you like. There can be only one menubar
 and only one statusbar.

 The toolbars, menubar, and statusbar can be created by the
 KMainWindow and - unlike the old KMainWindow - may, but do not
 have to, be deleted by you. KMainWindow will handle that internally.

 Height and width can be operated independently from each other. Simply
 define the minimum/maximum height/width of your main widget and
 KMainWindow will take this into account. For fixed size windows set
 your main widget to a fixed size.

 Fixed aspect ratios (-heightForWidth) and fixed width widgets are
 not supported.

 KMainWindow will set icon, mini icon and caption, which it gets
 from @ref KApplication. It provides full session management, and
 will save its position, geometry and positions of toolbars and
 menubar on logout. If you want to save additional data, reimplement
 @ref -saveProperties and (to read them again on next login) @ref
 -readProperties. To save special data about your data, reimplement
 @ref -saveGlobalProperties. To warn user that application or
 windows have unsaved data on close or logout, reimplement @ref
 -queryClose and/or @ref -queryExit.

 There is also a macro RESTORE which can restore all your windows
 on next login.

  Note that a KMainWindow per-default is created with the
  WDestructiveClose flag, i.e. it is automatically destroyed when the
  window is closed. If you do not want this behavior, specify 0 as
  widget flag in the constructor.

 
 @author Reginald Stadlbauer (reggie@kde.org) Stephan Kulow (coolo@kde.org), Matthias Ettrich (ettrich@kde.org), Chris Schlaeger (cs@kde.org), Sven Radej (radej@kde.org). Maintained by Sven Radej (radej@kde.org)

 @short KDE top level main window.
*/

@class KPopupMenu;
@class KMenuBar;
@class KStatusBar;
@class KToolBar;
@class KAccel;
@class KConfig;

@class KAction; 
@class KActionCollection; 
@class KXMLGUIFactory; 

@interface KMainWindow : QMainWindow

/** 
 Construct a main window.

 KMainWindows must be created on the heap with 'new', like:
  <pre> KMainWindow *kmw = new KMainWindow (...</pre>

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;

/** 
 Destructor.

 Will also destroy the toolbars, and menubar if
 needed.
     
*/
- (void) dealloc;

/** 
 Retrieve the standard help menu.

 It contains entires for the
 help system (activated by F1), an optional "What's This?" entry
 (activated by Shift F1), an application specific dialog box,
 and an "About KDE" dialog box.

 Example (adding a standard help menu to your application):
 <pre>
 KPopupMenu *help = helpMenu( <myTextString> );
 -menuBar->insertItem( i18n("&Help"), help );
 </pre>

*/
- (KPopupMenu*) helpMenu: (NSString *)aboutAppText showWhatsThis: (BOOL)showWhatsThis;
- (KPopupMenu*) helpMenu;

/** 
 Returns the help menu. Creates a standard help menu if none exists yet.

 It contains entries for the
 help system (activated by F1), an optional "What's This?" entry
 (activated by Shift F1), an application specific dialog box,
 and an "About KDE" dialog box. You must create the application
 specific dialog box yourself. When the "About application"
 menu entry is activated, a signal will trigger the
 @ref showAboutApplication slot. See @ref showAboutApplication for more
 information.

 Example (adding a help menu to your application):
 <pre>
 -menuBar->insertItem( i18n("&Help"), -customHelpMenu );
 </pre>

*/
- (KPopupMenu*) customHelpMenu: (BOOL)showWhatsThis;
- (KPopupMenu*) customHelpMenu;

/** 
 Restore the session specified by @p number.

 Returns @p false if this
 fails, otherwise returns @p true and shows the window.
 You should call @ref -canBeRestored first.
 If @p show is true (default), this widget will be shown automatically.
     
*/
- (BOOL) restore: (int)number show: (BOOL)show;
- (BOOL) restore: (int)number ;
- (KXMLGUIFactory*) guiFactory;

/** 
 Create a GUI given a local XML file.

 If @p xmlfile is NULL,
 then it will try to construct a local XML filename like
 appnameui.rc where 'appname' is your app's name.  If that file
 does not exist, then the XML UI code will only use the global
 (standard) XML file for the layout purposes.

*/
- createGUI: (NSString *)xmlfile _conserveMemory: (BOOL)_conserveMemory;
- createGUI;

/** 
 Enables the build of a standard help menu when calling -createGUI.

 The default behavior is to build one, you must call this function
 to disable it
     
*/
- setHelpMenuEnabled: (BOOL)showHelpMenu;
- setHelpMenuEnabled;

/** 
 Return @p true when the help menu is enabled
     
*/
- (BOOL) isHelpMenuEnabled;

/** 
 Returns a pointer to the menu bar.

 If there is no menu bar yet one will be created.

*/
- (KMenuBar*) menuBar;

/** 
 Returns a pointer to the status bar.

  If there is no
 status bar yet one will be created.
     
*/
- (KStatusBar*) statusBar;

/** 
 Returns a pointer to the toolbar with the specified name.
 This refers to toolbars created dynamically from the XML UI
 framework.  If the toolbar does not exist one will be created.

*/
- (KToolBar*) toolBar: (NSString *)name;
- (KToolBar*) toolBar;

/** 

*/
- (KAccel*) accel;
- setFrameBorderWidth: (int)arg1;

/** 
 Call this to enable "auto-save" of toolbar/menubar/statusbar settings
 (and optionally window size).
 If the *bars were moved around/shown/hidden when the window is closed,
 saveMainWindowSettings( -[KGlobal config], groupName ) will be called.

 Typically, you will call -setAutoSaveSettings in your
 KMainWindow-inherited class constructor, and it will take care
 of restoring and saving automatically. Make sure you call this
 _after all_ your *bars have been created.
     
*/
//- setAutoSaveSettings: (QString*) groupName saveWindowSize: (BOOL)saveWindowSize;
//- setAutoSaveSettings;

/** 
 Disable the auto-save-settings feature.
 You don't normally need to call this, ever.
     
*/
- resetAutoSaveSettings;

/** 
 Read settings for statusbar, menubar and toolbar from their respective
 groups in the config file and apply them.

*/
- applyMainWindowSettings: (KConfig*)config groupName: (NSString *)groupName;
- applyMainWindowSettings: (KConfig*)config ;

/** 
 Save settings for statusbar, menubar and toolbar to their respective
 groups in the config file @p config.

*/
- saveMainWindowSettings: (KConfig*)config groupName: (NSString *)groupName;
- saveMainWindowSettings: (KConfig*)config ;

/** 

     
*/
- finalizeGUI: (BOOL)force;

/** 

*/
- (BOOL) initialGeometrySet;

/** 

*/
- (QSize*) sizeForCentralWidgetSize: (QSize *)size;

/** 
 Makes a KDE compliant caption.

*/
- setCaption: (NSString *)caption;

/** 
 Makes a KDE compliant caption.

*/
- setCaption: (NSString *)caption modified: (BOOL)modified;

/** 
 Make a plain caption without any modifications.

*/
- setPlainCaption: (NSString *)caption;

/** 
 Open the help page for the application.

  The application name is
 used as a key to determine what to display and the system will attempt
 to open <appName>/index.html.

 This method is intended for use by a help button in the toolbar or
 components outside the regular help menu. Use @ref -helpMenu when you
 want to provide access to the help system from the help menu.

 Example (adding a help button to the first toolbar):

 <pre>
 KIconLoader &loader = *-[KGlobal iconLoader];
 QPixmap pixmap = loader.loadIcon( "help" );
 toolBar(0)->insertButton( pixmap, 0, SIGNAL(-clicked),
   this, SLOT(-appHelpActivated), true, i18n("Help") );
 </pre>

     
*/
- appHelpActivated;

/** 
 Apply a state change

 Enable and disable actions as defined in the XML rc file
     
*/
- slotStateChanged: (NSString *)newstate;

/** 

     
*/
- setSettingsDirty;

/** 

 Try to restore the toplevel widget as defined by the number (1..X).

 If the session did not contain so high a number, the configuration
 is not changed and @p false returned.

 That means clients could simply do the following:
 <pre>
 if (-[kapp isRestored]){
   int n = 1;
   while (-[KMainWindow canBeRestored]){
     (new childMW)->restore(n);
     n++;
   }
 } else {
 // create default application as usual
 }
 </pre>
 Note that @ref -[QWidget show] is called implicitly in restore.

 With this you can easily restore all toplevel windows of your
 application.

 If your application uses different kinds of toplevel
 windows, then you can use @ref -[KMainWindow classNameOfToplevel]
 to determine the exact type before calling the childMW
 constructor in the example from above.

 If your client has only one kind of toplevel widgets (which should
 be pretty usual) then you should use the RESTORE-macro:

 <pre>
 if (-[kapp isRestored])
   RESTORE(childMW)
 else {
 // create default application as usual
 }
 </pre>

 The macro expands to the term above but is easier to use and
 less code to write.

     
*/
+ (BOOL) canBeRestored: (int)number;

/** 
 Returns the @ref -className of the @p number of the toplevel window which
 should be restored.

  This is only useful if your application uses
 different kinds of toplevel windows.
     
*/
+ (NSString *) classNameOfToplevel: (int)number;

/** 
       Called before the very last window is closed, either by the
       user or indirectly by the session manager.

       It is not recommended to do any user interaction in this
       function other than indicating severe errors. Better ask the
       user on @ref -queryClose (see below).

       However, @ref -queryExit is useful to do some final cleanups. A
       typical example would be to write configuration data back.

       Note that the application may continue to run after @ref -queryExit
       (the user may have cancelled a shutdown). The purpose of
       @ref -queryExit is purely to prepare the application (with possible
       user interaction) so it can safely be closed later (without
       user interaction).

       If you need to do serious things on exit (like shutting a
       dial-up connection down), connect to the signal
       @ref -[KApplication shutDown].

       Default implementation returns @p true. Returning @p false will
       cancel the exiting. In the latter case, the last window will
       remain visible.

*/
- (BOOL) queryExit;

/** 
       Called before the window is closed, either by the user or indirectly by
       the session manager.

       The purpose of this function is to prepare the window in a way that it is
       safe to close it, i.e. without the user losing some data.

       Default implementation returns true. Returning @p false will cancel
       the closing.

       Reimplement this function to prevent the user from losing data.
       Example:
       <pre>

           switch ( -[KMessageBox warningYesNoCancel]( this,
				   i18n("Save changes to Document Foo?")) ) {
           case -[KMessageBox Yes]:
             // save document here. If saving fails, return FALSE;
             return TRUE;
           case -[KMessageBox No]:
             return TRUE;
           default: // cancel
             return FALSE;

    </pre>

    
*/
- (BOOL) queryClose;

/** 
 Save your instance-specific properties. The function is
 invoked when the session manager requests your application
 to save its state.

 You @em must @em not change the group of the @p kconfig object, since
 KMainWindow uses one group for each window.  Please
 reimplement these function in childclasses.

 Note: No user interaction is allowed
 in this function!

     
*/
- saveProperties: (KConfig*)arg1;

/** 
 Read your instance-specific properties.
    
*/
- readProperties: (KConfig*)arg1;

/** 
 Save your application-wide properties. The function is
 invoked when the session manager requests your application
 to save its state.

 This function is similar to @ref -saveProperties but is only called for
 the very first main window, regardless how many main window are open.

 Override it if you need to save other data about your documents on
 session end. sessionConfig is a config to which that data should be
 saved. Normally, you don't need this function. But if you want to save
 data about your documents that are not in opened windows you might need
 it.

 Default implementation does nothing.
     
*/
- saveGlobalProperties: (KConfig*)sessionConfig;

/** 
 The counterpart of @ref -saveGlobalProperties.

 Read the application-specific properties in again.
     
*/
- readGlobalProperties: (KConfig*)sessionConfig;
- savePropertiesInternal: (KConfig*)arg1 int: (int)arg2;
- (BOOL) readPropertiesInternal: (KConfig*)arg1 int: (int)arg2;

/** 
 For inherited classes
     
*/
- (BOOL) settingsDirty;

/** 
 For inherited classes
     
*/
- (NSString *) settingsGroup;

/** 
 For inherited classes
 Note that the group must be set before calling
     
*/
- saveWindowSize: (KConfig*)config;

/** 
 For inherited classes
 Note that the group must be set before calling, and that
 a -geometry on the command line has priority.
     
*/
- restoreWindowSize: (KConfig*)config;
- parseGeometry: (BOOL)parsewidth;

/** 
 This slot does nothing.

 It must be reimplemented if you want
 to use a custom About Application dialog box. This slot is
 connected to the About Application entry in the menu returned
 by @ref customHelpMenu.

 Example:
 <pre>

 void -[MyMainLevel setupInterface]
 {
   ..
   -menuBar->insertItem( i18n("&Help"), -customHelpMenu );
   ..
 }

 void -[MyMainLevel showAboutApplication]( void )
 {
   <activate your custom dialog>
 }
 </pre>
    
*/
- showAboutApplication;
@end

@class KAction; 
@class KActionCollection; 
@class KXMLGUIFactory; 

@interface KMainWindow (KXMLGUIBuilderImplementation) <KXMLGUIBuilderInterface>
@end

@class KXMLGUIClientInterface; 

@class KAction; 
@class KActionCollection; 
@class KXMLGUIFactory; 

@interface KMainWindow (KXMLGUIClientImplementation) <KXMLGUIClientInterface>
@end

/** Override these methods in subclasses of KMainWindow to customise event handling behaviour */
@protocol KMainWindowEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) e;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Reimplemented to call the -queryClose and -queryExit handlers.

 We recommend that you reimplement the handlers rather than @ref -closeEvent.
 If you do it anyway, ensure to call the base implementation to keep
 @ref -queryExit running.
     
*/
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) e;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
