/* -*- C++ -*-

  $Id: LineStyle.h,v 1.4 2000/07/27 06:53:16 wtrobin Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef LineStyle_h_
#define LineStyle_h_

#include <qintdict.h>

class QPixmap;

class LineStyle {
public:
  LineStyle (long i);
  ~LineStyle ();

  long styleID () const;
  QPixmap& pixmap ();

  static void install (LineStyle* arrow);
  static LineStyle* getLineStyle (long id);
  static QIntDictIterator<LineStyle> getLineStyles ();

private:
  static void initialize ();

  long id;
  QPixmap *preview;

  static QIntDict<LineStyle> *styles;
};

#endif
