/*
 * main.cpp
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <klocale.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kglobal.h>

#include "warning.h"
#include "power.h"
#include "battery.h"
#include "pcmcia.h"
#include "portable.h"


extern "C"
{

  KCModule *create_pcmcia(QWidget *parent, const char *) 
  { 
    return new PcmciaConfig(parent, "kcmlaptop");
  }

  KCModule *create_bwarning(QWidget *parent, const char *) 
  { 
    return new WarningConfig(0, parent, "kcmlaptop");
  }
  KCModule *create_cwarning(QWidget *parent, const char *) 
  { 
    return new WarningConfig(1, parent, "kcmlaptop");
  }
  KCModule *create_battery(QWidget *parent, const char *) 
  { 
    return new BatteryConfig(parent, "kcmlaptop");
  }
  KCModule *create_power(QWidget *parent, const char *) 
  { 
    return new PowerConfig(parent, "kcmlaptop");
  }

  void init_battery()
  {
    KConfig config("kcmlaptoprc");  
    config.setGroup("BatteryDefault");
    bool enable = false;
    if (!config.hasKey("Enable")) {  // if they have APM or PCMCIA, Enable=true
	struct power_result pr = laptop_portable::poll_battery_state();
	if ((laptop_portable::has_power_management() && 
             !(pr.powered &&
              (pr.percentage < 0 || pr.percentage == 0xff)))||
	    0 == access("/var/run/stab", R_OK|F_OK) ||
	    0 == access("/var/lib/pcmcia/stab", R_OK|F_OK))
		enable = true;
    } else {
	    enable = config.readBoolEntry("Enable", false);
    }
    if (!enable)
      return;
    kapp->startServiceByDesktopName("klaptopdaemon");
  }
}
