/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.ParseException;
import java.text.RBTableBuilder;
import java.util.Vector;
import sun.text.CompactIntArray;
import sun.text.IntHashtable;

final class RBCollationTables {
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    static final int PRIMARYORDERMASK = -65536;
    static final int SECONDARYORDERMASK = 65280;
    static final int TERTIARYORDERMASK = 255;
    static final int PRIMARYDIFFERENCEONLY = -65536;
    static final int SECONDARYDIFFERENCEONLY = -256;
    static final int PRIMARYORDERSHIFT = 16;
    static final int SECONDARYORDERSHIFT = 8;
    private String rules = null;
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private CompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private IntHashtable contractFlags = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBCollationTables(String string, int n2) throws ParseException {
        this.rules = string;
        RBTableBuilder rBTableBuilder = new RBTableBuilder(new BuildAPI());
        rBTableBuilder.build(string, n2);
    }

    public String getRules() {
        return this.rules;
    }

    public boolean isFrenchSec() {
        return this.frenchSec;
    }

    public boolean isSEAsianSwapping() {
        return this.seAsianSwapping;
    }

    Vector getContractValues(char c2) {
        int n2 = this.mapping.elementAt(c2);
        return this.getContractValues(n2 - 0x7F000000);
    }

    Vector getContractValues(int n2) {
        if (n2 >= 0) {
            return (Vector)this.contractTable.elementAt(n2);
        }
        return null;
    }

    boolean usedInContractSeq(char c2) {
        return this.contractFlags.get(c2) == 1;
    }

    int getMaxExpansion(int n2) {
        int n3 = 1;
        if (this.expandTable != null) {
            int n4 = 0;
            while (n4 < this.expandTable.size()) {
                int[] nArray = (int[])this.expandTable.elementAt(n4);
                int n5 = nArray.length;
                if (n5 > n3 && nArray[n5 - 1] == n2) {
                    n3 = n5;
                }
                ++n4;
            }
        }
        return n3;
    }

    final int[] getExpandValueList(int n2) {
        return (int[])this.expandTable.elementAt(n2 - 0x7E000000);
    }

    int getUnicodeOrder(char c2) {
        return this.mapping.elementAt(c2);
    }

    short getMaxSecOrder() {
        return this.maxSecOrder;
    }

    short getMaxTerOrder() {
        return this.maxTerOrder;
    }

    static void reverse(StringBuffer stringBuffer, int n2, int n3) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 < n5) {
            char c2 = stringBuffer.charAt(n4);
            stringBuffer.setCharAt(n4, stringBuffer.charAt(n5));
            stringBuffer.setCharAt(n5, c2);
            ++n4;
            --n5;
        }
    }

    static final int getEntry(Vector vector, String string, boolean bl2) {
        int n2 = 0;
        while (n2 < vector.size()) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n2);
            if (entryPair.fwd == bl2 && entryPair.entryName.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    final class BuildAPI {
        private BuildAPI() {
        }

        void fillInTables(boolean bl2, boolean bl3, CompactIntArray compactIntArray, Vector vector, Vector vector2, IntHashtable intHashtable, short s2, short s3) {
            RBCollationTables.this.frenchSec = bl2;
            RBCollationTables.this.seAsianSwapping = bl3;
            RBCollationTables.this.mapping = compactIntArray;
            RBCollationTables.this.contractTable = vector;
            RBCollationTables.this.expandTable = vector2;
            RBCollationTables.this.contractFlags = intHashtable;
            RBCollationTables.this.maxSecOrder = s2;
            RBCollationTables.this.maxTerOrder = s3;
        }
    }
}

