
#include <stdio.h>
#include <string.h>
#include <signal.h>

#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <sys/wait.h>
#include <sys/types.h>

#include "pop3.h"

/* added by Glynn Clements <glynn@sensei.co.uk> 1997-06-02 */

/**************************************************************************/

static char timestamp[256];
static int stamplen;

/**************************************************************************/

static void
sigchld_handler(int signum)
{
	if (wait(NULL) < 0)
		perror("do_md5: waitpid()");
}


static int
do_md5(char *pass, int passlen, char *hash)
{
	int send_pipe[2], recv_pipe[2];
	pid_t pid;
	FILE *fp;

	if (pipe(send_pipe) < 0)
	{
		perror("do_md5: pipe()");
		return -1;
	}

	if (pipe(recv_pipe) < 0)
	{
		perror("do_md5: pipe()");
		return -1;
	}

	pid = fork();
	switch (pid)
	{
	case -1:
		perror("do_md5: fork()");
		return -1;

	case 0:
		dup2(send_pipe[0], STDIN_FILENO);
		close(send_pipe[1]);
		dup2(recv_pipe[1], STDOUT_FILENO);
		close(recv_pipe[0]);

		execl(APOP_MD5_PROGRAM, APOP_MD5_PROGRAM, NULL);
		perror("do_md5: execl()");
		return -1;

	default:
		signal(SIGCHLD, sigchld_handler);

		close(send_pipe[0]);
		close(recv_pipe[1]);
		write(send_pipe[1], pass, passlen);
		close(send_pipe[1]);

		fp = fdopen(recv_pipe[0], "r");
		if (!fp)
		{
			perror("do_md5: fdopen()");
			return -1;
		}
		fscanf(fp, "%32s", hash);
		fclose(fp);
	}

	return 0;
}

/**************************************************************************/

char *
apop_timestamp()
{
	time_t t;
	struct tm *tm;

	time(&t);
	tm = localtime(&t);
	strftime(timestamp, sizeof(timestamp), "<%a %b %d %H:%M:%S %Y>", tm);

	return timestamp;
}

/**************************************************************************/

/* Verify a usercode/password-hash */
int
verify_user_apop(user, pass)
char *user;
char *pass;
{
	char buff[1024];
	int userlen, passlen;
	FILE *fp;
	char *p, *q;
	struct passwd *pwd;

	for (p = user; *p; p++)
		*p = tolower(*p);
	userlen = p - user;

	pwd = getpwnam(user);
	if (!pwd)
	{
		fprintf(stderr, "User not found in /etc/passwd: %s\n", user);
		return -1;
	}

	fp = fopen(APOP_PASSWORD_FILE, "r");
	if (!fp)
	{
		perror("verify_user_apop: fopen()");
		return -1;
	}

	while (1)
	{
		if (feof(fp))
		{
			fprintf(stderr, "User not found in /etc/apop: %s\n", user);
			return -1;
		}

		fgets(buff, sizeof(buff), fp);
		if (strncmp(buff, user, userlen) != 0)
			continue;
		if (buff[userlen] != ':')
			continue;

		q = timestamp + strlen(timestamp);
		for (p = buff + userlen + 1; *p && *p != '\n'; p++, q++)
			*q = *p;
		passlen = q - timestamp;
		break;
	}
	fclose(fp);

	if (do_md5(timestamp, passlen, buff) < 0)
		return -1;

	if (strcmp(pass, buff) != 0)
	{
		fprintf(stderr, "Invalid password for user %s\n", user);
		return -1;
	}

	if (setuid(pwd->pw_uid) < 0)
	{
		perror("verify_user_apop: setuid()");
		return -1;
	}

	return 0;
}

/**************************************************************************/

