.TH XvQueryEncodings __libmansuffix__ __vendorversion__
.SH Name
XvQueryEncodings \- return list of encodings for an adaptor
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "XvQueryEncodings(Display *" dpy ", XvPortID " port ",
.BI "                 unsigned int *" p_num_encodings ",
.BI "                 XvEncodingInfo **" pp_encoding_info ");"
.fi
.SH Arguments
.\"
.IP \fIdpy\fR 8
Specifies the connection to the X server.
.IP \fIXvPortID\fR 8
Specifies the port whose adaptor is to be queried for its
list of encodings.
.IP \fIp_num_encodings\fR 8
A pointer to where the number of encodings supported
by the adaptor is written.
.IP \fIpp_encoding_info\fR 8
A pointer to where the list of returned
encoding information is returned.
XvEncodingInfo has the following structure:
.EX

    typedef struct {
      XvEncodingID encoding_id;
      char *name;
      unsigned long width;
      unsigned long height;
      XvRational rate;
      unsigned long num_encodings;
    } XvEncodingInfo;

.EE
.IP \fIencoding_id\fR 8
Specifies the encoding-id of the encoding.  The encoding-id is used to
identify an encoding when a port's encoding attribute is changed.
.IP \fIname\fR 8
A pointer to a formatted string that identifies the encoding.  The string
has the format "\fItiming-signaltype\fR".  For example "ntsc-composite".
.IP \fIwidth,height\fR 8
The width and height, in pixels, of the decoded video image.
.IP \fIrate\fR 8
The field rate of the decoded video.
.PP
The XvRational structure is used to specify a fractional number.
It has the following structure:
.EX

    typedef struct {
      int numerator;
      int denominator;
    } XvRational;

.EE
The \fInumerator\fP and \fIdenominator\fP fields specify the 
appropriate parts of a fractional number.
.\"
.SH Description
XvQueryEncodings(__libmansuffix__) returns encoding information about an adaptor.  Each
encoding is described by the XvEncodingInfo structure described above.  The 
encodings are identified by an encoding-id, which can be used to set or get
the encoding attribute of a port.
.SH Returned Values
.IP [Success] 8
Returned if XvQueryEncodings(__libmansuffix__) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvQueryEncodings(__libmansuffix__) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.\"
.SH See Also
.\"
XvFreeEncodingInfo(__libmansuffix__)
.br
