/*****************************************************************************\
  dj4100_cmap.cpp : Implimentation for the DJ4100 color maps

  Copyright (c) 1996 - 2006, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  \***************************************************************************/


#ifdef APDK_DJ3600

#include "config.h"

#include "global_types.h"

APDK_BEGIN_NAMESPACE

// 600x600x1, KCMY - Plain Normal

unsigned char ucMapDJ4100_KCMY_6x6x1[] =
{
  195,    37,    28,    16,   151,   131,    67,     9,   110,   219,   103,     2,    94,   238,   102,     0,    76,   243,    93,     0,    60,   245,    90,     0,    49,   246,    89,     0, 
   42,   247,    86,     0,    35,   248,    84,     0,    30,   249,    81,     0,    25,   250,    79,     0,    21,   250,    78,     0,    17,   251,    77,     0,    12,   252,    74,     0, 
    8,   253,    72,     0,     4,   254,    71,     0,     0,   255,    70,     0,   148,   130,    14,   114,    99,   232,    30,     0,   102,   236,   109,     0,    87,   240,   103,     0, 
   68,   244,   102,     0,    55,   246,    97,     0,    47,   246,    95,     0,    40,   247,    91,     0,    34,   248,    87,     0,    29,   249,    84,     0,    25,   250,    81,     0, 
   21,   250,    80,     0,    17,   251,    78,     0,    13,   252,    76,     0,     9,   253,    73,     0,     5,   254,    71,     0,     0,   254,    69,     0,   101,   222,     1,   210, 
   98,   220,     1,   117,    83,   237,    30,     0,    77,   241,    68,     0,    63,   244,    90,     0,    53,   246,    96,     0,    44,   247,    96,     0,    38,   248,    93,     0, 
   32,   248,    89,     0,    28,   249,    86,     0,    24,   250,    84,     0,    20,   250,    81,     0,    17,   251,    80,     0,    13,   252,    77,     0,     9,   253,    74,     0, 
    5,   253,    71,     0,     0,   253,    68,     0,    85,   224,     0,   211,    81,   227,     0,   145,    76,   233,     0,    54,    67,   239,    22,     0,    56,   243,    52,     0, 
   45,   246,    68,     0,    38,   247,    78,     0,    33,   248,    82,     0,    29,   249,    83,     0,    25,   250,    84,     0,    22,   250,    84,     0,    18,   251,    82,     0, 
   15,   252,    79,     0,    11,   252,    76,     0,     8,   253,    72,     0,     4,   254,    70,     0,     0,   253,    66,     0,    66,   224,     1,   218,    64,   227,     0,   178, 
   61,   233,     0,   114,    59,   237,     0,    40,    52,   243,    16,     0,    41,   246,    35,     0,    33,   248,    49,     0,    28,   249,    58,     0,    24,   250,    64,     0, 
   21,   250,    68,     0,    18,   251,    72,     0,    16,   251,    72,     0,    12,   252,    71,     0,     9,   253,    69,     0,     6,   253,    67,     0,     3,   254,    65,     0, 
    0,   250,    62,     0,    49,   226,     0,   228,    49,   226,     1,   200,    45,   233,     0,   152,    43,   237,     0,    88,    43,   242,     0,    30,    38,   246,    11,     0, 
   30,   248,    24,     0,    25,   249,    35,     0,    20,   250,    45,     0,    17,   251,    52,     0,    15,   252,    57,     0,    12,   252,    59,     0,    10,   253,    60,     0, 
    7,   253,    60,     0,     4,   253,    60,     0,     1,   251,    59,     0,     0,   240,    56,     0,    36,   227,     0,   237,    36,   225,     1,   217,    33,   232,     0,   183, 
   32,   236,     0,   129,    31,   241,     0,    71,    31,   245,     0,    26,    28,   248,     7,     0,    23,   249,    16,     0,    19,   250,    25,     0,    15,   251,    34,     0, 
   12,   252,    42,     0,     9,   252,    47,     0,     6,   252,    50,     0,     4,   249,    51,     0,     2,   245,    52,     0,     0,   238,    53,     2,     0,   225,    50,     0, 
   26,   226,     1,   246,    27,   227,     0,   234,    26,   228,     0,   208,    24,   234,     0,   164,    23,   239,     0,   108,    23,   244,     0,    60,    23,   247,     0,    22, 
   21,   250,     3,     0,    17,   251,    11,     0,    14,   252,    19,     0,    10,   252,    27,     0,     6,   250,    37,     3,     1,   242,    46,     8,     0,   233,    48,     7, 
    0,   224,    47,     5,     0,   217,    46,     2,     0,   209,    44,     0,    17,   220,     4,   249,    18,   227,     2,   246,    19,   227,     1,   228,    17,   233,     0,   194, 
   16,   237,     0,   144,    16,   241,     0,    93,    16,   245,     0,    51,    16,   249,     0,    21,    15,   251,     1,     0,    12,   252,     7,     0,     9,   251,    16,     2, 
    4,   247,    27,     7,     0,   234,    36,    10,     0,   223,    38,     7,     0,   213,    39,     4,     0,   204,    39,     2,     0,   196,    38,     0,    10,   214,     7,   249, 
   10,   220,     5,   249,    12,   228,     2,   241,    12,   230,     1,   214,    10,   234,     1,   177,     9,   237,     3,   127,    10,   242,     3,    81,    11,   247,     0,    45, 
   11,   250,     0,    20,    11,   252,     0,     0,     6,   247,    11,     6,     1,   242,    20,    10,     0,   230,    25,     9,     0,   220,    28,     6,     0,   210,    30,     4, 
    0,   199,    32,     2,     0,   188,    32,     0,     5,   212,     9,   250,     5,   216,     7,   250,     7,   224,     4,   247,     9,   228,     1,   227,     8,   233,     0,   199, 
    7,   235,     2,   158,     7,   239,     3,   112,     8,   245,     1,    71,     9,   249,     0,    40,     9,   251,     0,    18,     9,   253,     0,     0,     1,   243,    14,    10, 
    0,   230,    17,     8,     0,   219,    20,     5,     0,   209,    23,     3,     0,   198,    25,     2,     0,   186,    26,     0,     2,   212,    10,   250,     3,   215,     8,   250, 
    4,   221,     5,   249,     7,   228,     1,   241,     7,   231,     0,   216,     7,   234,     0,   184,     6,   237,     2,   142,     6,   242,     2,    98,     7,   247,     0,    63, 
    7,   250,     0,    36,     8,   251,     0,    17,     8,   253,     0,     0,     0,   240,    13,    10,     0,   224,    14,     6,     0,   211,    16,     3,     0,   199,    19,     1, 
    0,   186,    21,     0,     1,   213,     9,   250,     1,   215,     7,   250,     3,   219,     5,   250,     5,   226,     1,   248,     6,   229,     0,   230,     5,   233,     0,   205, 
    5,   234,     0,   167,     6,   238,     0,   123,     6,   244,     0,    85,     6,   248,     0,    56,     6,   250,     0,    34,     6,   252,     0,    16,     6,   253,     0,     0, 
    0,   237,    11,     7,     0,   218,    12,     3,     0,   202,    14,     1,     0,   189,    16,     0,     1,   215,     6,   250,     2,   217,     5,   250,     2,   219,     3,   250, 
    4,   224,     0,   249,     4,   229,     0,   242,     4,   231,     0,   218,     4,   233,     0,   189,     4,   236,     0,   149,     4,   240,     0,   109,     4,   245,     0,    77, 
    4,   249,     0,    51,     4,   251,     0,    31,     4,   252,     0,    15,     5,   254,     0,     0,     0,   233,     9,     5,     0,   212,    10,     2,     0,   194,    12,     0, 
    1,   217,     3,   250,     2,   218,     2,   250,     2,   220,     1,   250,     3,   223,     0,   250,     2,   228,     0,   247,     3,   229,     0,   227,     2,   231,     0,   204, 
    3,   233,     0,   172,     3,   237,     0,   133,     3,   242,     0,    99,     3,   247,     0,    70,     3,   249,     0,    47,     3,   251,     0,    29,     3,   253,     0,    14, 
    3,   254,     0,     0,     0,   228,     7,     2,     0,   204,     8,     0,     1,   220,     0,   250,     2,   220,     0,   250,     2,   220,     0,   250,     1,   222,     0,   250, 
    1,   225,     0,   247,     1,   226,     0,   232,     1,   228,     0,   213,     1,   230,     0,   188,     1,   234,     0,   156,     1,   239,     0,   120,     1,   243,     0,    90, 
    1,   247,     0,    65,     1,   250,     0,    44,     1,   252,     0,    28,     1,   253,     0,    14,     2,   255,     0,     0,     0,   224,     5,     0,     0,   221,     0,   250, 
    0,   221,     0,   250,     0,   221,     0,   250,     0,   221,     0,   250,     0,   221,     0,   244,     0,   222,     0,   234,     0,   224,     0,   219,     0,   227,     0,   200, 
    0,   230,     0,   175,     0,   235,     0,   142,     0,   240,     0,   110,     0,   243,     0,    83,     0,   247,     0,    60,     0,   249,     0,    42,     0,   251,     0,    27, 
    0,   254,     0,    14,     0,   255,     0,     0,   170,    27,    82,    59,   147,    60,   128,     8,   114,   177,   177,     2,    92,   230,   175,     2,    76,   237,   152,     2, 
   59,   243,   141,     1,    49,   248,   135,     0,    40,   249,   128,     0,    32,   250,   124,     0,    28,   250,   115,     0,    24,   250,   106,     0,    19,   251,    99,     0, 
   15,   252,    93,     0,    11,   252,    86,     0,     7,   253,    80,     0,     3,   253,    76,     0,     0,   249,    72,     0,   149,    27,    14,   130,   146,    49,    33,    18, 
   93,   238,   108,     0,    79,   239,   118,     1,    68,   245,   117,     0,    61,   246,   114,     0,    52,   247,   107,     0,    43,   247,   101,     0,    35,   248,    95,     0, 
   29,   249,    88,     0,    24,   250,    84,     0,    19,   251,    81,     0,    15,   252,    78,     0,    11,   252,    74,     0,     7,   253,    72,     0,     3,   253,    70,     0, 
    0,   241,    66,     0,   105,   173,     2,   232,   100,   224,     0,   209,    91,   185,    11,    13,    73,   235,    69,     1,    62,   244,    91,     0,    54,   246,    96,     0, 
   46,   247,    94,     0,    39,   247,    90,     0,    32,   248,    85,     0,    27,   249,    81,     0,    23,   250,    78,     0,    18,   251,    76,     0,    14,   252,    74,     0, 
   10,   253,    72,     0,     6,   253,    70,     0,     3,   253,    69,     0,     0,   243,    67,     0,    81,   210,     2,   240,    80,   219,     2,   196,    74,   224,     2,    95, 
   72,   219,     5,     8,    56,   238,    42,     2,    46,   245,    64,     0,    38,   247,    73,     0,    32,   248,    78,     0,    27,   249,    79,     0,    23,   250,    78,     0, 
   20,   251,    77,     0,    16,   251,    75,     0,    12,   252,    73,     0,     9,   253,    71,     0,     5,   254,    70,     0,     2,   253,    68,     0,     0,   242,    65,     0, 
   60,   221,     2,   243,    62,   223,     1,   217,    58,   231,     0,   155,    56,   228,     3,    74,    55,   222,     5,    14,    43,   241,    25,     1,    33,   247,    43,     0, 
   28,   249,    54,     0,    24,   250,    60,     0,    20,   250,    64,     0,    16,   251,    67,     0,    13,   252,    68,     0,    10,   253,    67,     0,     7,   253,    66,     0, 
    4,   254,    66,     0,     1,   252,    64,     0,     0,   238,    61,     0,    44,   225,     1,   242,    46,   225,     1,   229,    44,   229,     0,   188,    41,   235,     0,   124, 
   40,   236,     1,    57,    39,   241,     1,    13,    33,   247,    13,     0,    26,   249,    28,     0,    20,   250,    40,     0,    17,   251,    47,     0,    13,   252,    52,     0, 
   11,   252,    55,     0,     8,   253,    56,     0,     5,   254,    58,     0,     2,   253,    58,     0,     0,   247,    57,     0,     0,   229,    55,     0,    32,   226,     1,   246, 
   33,   227,     1,   238,    34,   226,     1,   211,    31,   234,     0,   163,    29,   239,     0,   100,    29,   243,     0,    47,    29,   246,     0,    14,    26,   248,     5,     0, 
   20,   250,    18,     0,    15,   251,    29,     0,    11,   252,    37,     0,     8,   253,    43,     0,     5,   254,    46,     0,     2,   253,    49,     0,     1,   249,    50,     0, 
    0,   235,    50,     0,     0,   217,    50,     0,    24,   221,     3,   249,    24,   227,     1,   246,    26,   227,     1,   229,    23,   232,     0,   193,    22,   237,     0,   139, 
   22,   242,     0,    84,    21,   246,     0,    42,    21,   248,     0,    16,    21,   249,     1,     1,    15,   250,    12,     0,    10,   252,    22,     1,     6,   252,    30,     0, 
    3,   249,    36,     0,     1,   243,    40,     0,     0,   231,    42,     1,     0,   218,    42,     0,     0,   206,    44,     0,    16,   214,     7,   249,    17,   222,     4,   249, 
   17,   228,     1,   242,    18,   228,     1,   217,    16,   234,     0,   176,    15,   240,     0,   120,    15,   244,     0,    72,    15,   247,     0,    37,    14,   249,     0,    18, 
   13,   248,     2,     6,     9,   249,    11,     4,     5,   249,    19,     4,     1,   241,    28,     5,     0,   229,    32,     3,     0,   216,    34,     1,     0,   205,    35,     0, 
    0,   193,    38,     0,     7,   207,    11,   250,     9,   215,     7,   250,    10,   224,     3,   248,    12,   228,     1,   229,    10,   233,     0,   199,     9,   237,     0,   153, 
    9,   242,     0,   103,     9,   246,     1,    63,     8,   247,     2,    36,     8,   249,     2,    19,     6,   244,     7,    13,     1,   241,    16,    13,     0,   236,    20,     9, 
    0,   225,    23,     4,     0,   212,    25,     1,     0,   198,    28,     0,     0,   181,    32,     0,     4,   205,    10,   250,     2,   209,    10,   250,     3,   217,     7,   250, 
    7,   228,     0,   243,     6,   231,     0,   217,     5,   235,     0,   183,     5,   239,     0,   134,     5,   241,     0,    87,     4,   243,     2,    55,     3,   243,     4,    34, 
    3,   244,     4,    19,     0,   236,    11,    17,     0,   229,    13,    10,     0,   220,    15,     5,     0,   211,    18,     1,     0,   197,    22,     0,     0,   179,    26,     0, 
    2,   204,    10,   250,     0,   207,     8,   250,     0,   213,     6,   250,     3,   224,     0,   249,     3,   229,     0,   233,     2,   233,     0,   205,     2,   233,     0,   161, 
    3,   233,     0,   110,     2,   236,     2,    74,     1,   237,     4,    50,     1,   238,     5,    31,     1,   239,     5,    19,     0,   228,     7,    12,     0,   217,     9,     6, 
    0,   208,    12,     2,     0,   197,    16,     0,     0,   180,    21,     0,     0,   205,    10,   250,     0,   207,     4,   250,     0,   212,     3,   250,     1,   219,     0,   248, 
    1,   223,     0,   236,     1,   225,     0,   211,     1,   225,     0,   177,     0,   227,     1,   132,     0,   229,     2,    94,     0,   231,     3,    65,     0,   231,     4,    42, 
    0,   234,     3,    27,     0,   235,     3,    15,     0,   221,     5,     8,     0,   208,     7,     4,     0,   197,    10,     1,     0,   182,    16,     0,     0,   206,     7,   250, 
    0,   207,     2,   249,     0,   209,     1,   246,     0,   211,     1,   241,     0,   214,     0,   230,     0,   214,     1,   209,     0,   214,     1,   183,     0,   218,     1,   145, 
    0,   221,     1,   107,     0,   225,     1,    78,     0,   227,     2,    55,     0,   228,     2,    36,     0,   231,     1,    22,     0,   230,     1,    11,     0,   215,     4,     5, 
    0,   200,     6,     2,     0,   186,    11,     0,     0,   209,     5,   250,     0,   203,     1,   242,     0,   203,     0,   237,     0,   204,     0,   232,     0,   206,     0,   224, 
    0,   205,     0,   208,     0,   206,     0,   186,     0,   210,     0,   155,     0,   214,     0,   121,     0,   218,     0,    92,     0,   222,     0,    67,     0,   224,     1,    47, 
    0,   226,     0,    31,     0,   228,     0,    18,     0,   226,     1,     8,     0,   209,     4,     3,     0,   194,     8,     0,     0,   211,     2,   250,     0,   201,     0,   237, 
    0,   199,     0,   231,     0,   200,     0,   227,     0,   201,     0,   220,     0,   200,     0,   207,     0,   201,     0,   189,     0,   204,     0,   164,     0,   209,     0,   134, 
    0,   213,     0,   105,     0,   218,     0,    80,     0,   221,     0,    60,     0,   223,     0,    41,     0,   226,     0,    27,     0,   228,     0,    15,     0,   225,     1,     5, 
    0,   208,     6,     0,     0,   214,     0,   250,     0,   207,     0,   229,     0,   207,     0,   228,     0,   207,     0,   225,     0,   207,     0,   220,     0,   207,     0,   210, 
    0,   207,     0,   195,     0,   209,     0,   175,     0,   214,     0,   149,     0,   218,     0,   121,     0,   224,     0,    95,     0,   229,     0,    72,     0,   231,     0,    54, 
    0,   234,     0,    36,     0,   236,     0,    23,     0,   237,     0,    12,     0,   239,     0,     0,   145,    17,   135,   102,   131,    12,   166,    60,   101,    79,   222,     0, 
   89,   147,   211,     0,    71,   193,   198,     1,    53,   222,   192,     2,    42,   242,   185,     3,    37,   243,   168,     2,    29,   249,   155,     1,    25,   251,   145,     0, 
   22,   251,   130,     0,    18,   251,   117,     0,    14,   252,   106,     0,     9,   253,    97,     0,     5,   253,    88,     0,     2,   250,    81,     0,     0,   240,    74,     0, 
  132,    13,    84,   167,   118,    26,   128,    92,    92,   123,   164,     6,    71,   196,   178,     5,    59,   236,   179,     3,    53,   241,   169,     2,    44,   246,   155,     1, 
   36,   250,   140,     0,    30,   250,   127,     0,    25,   250,   117,     0,    20,   251,   108,     0,    16,   251,   100,     0,    12,   252,    92,     0,     8,   253,    85,     0, 
    4,   254,    80,     0,     1,   251,    76,     0,     0,   232,    69,     0,   104,    14,     1,   239,   101,    24,    12,   186,    83,    65,    40,    24,    65,   189,    84,    11, 
   51,   238,   105,     3,    44,   246,   107,     1,    38,   248,   103,     0,    32,   249,    97,     0,    27,   249,    91,     0,    22,   250,    86,     0,    18,   251,    83,     0, 
   14,   252,    79,     0,    10,   253,    76,     0,     6,   253,    73,     0,     3,   253,    71,     0,     1,   249,    69,     0,     0,   227,    62,     0,    79,   114,     7,   248, 
   76,   143,     8,   228,    70,   157,    19,   120,    69,   145,    24,    26,    50,   211,    57,    11,    39,   243,    71,     2,    32,   248,    78,     0,    27,   249,    78,     0, 
   23,   250,    77,     0,    19,   251,    76,     0,    15,   251,    74,     0,    12,   252,    72,     0,     8,   253,    70,     0,     5,   254,    69,     0,     2,   253,    68,     0, 
    0,   245,    66,     0,     0,   225,    62,     0,    57,   166,    10,   248,    57,   197,     6,   242,    56,   209,     6,   194,    52,   191,    14,    95,    51,   168,    21,    28, 
   40,   219,    37,    10,    29,   245,    48,     1,    24,   249,    58,     0,    19,   251,    64,     0,    15,   251,    68,     0,    11,   252,    69,     0,     8,   253,    69,     0, 
    5,   254,    68,     0,     3,   253,    68,     0,     1,   249,    66,     0,     0,   237,    63,     0,     0,   220,    59,     0,    41,   197,     8,   248,    42,   213,     4,   245, 
   43,   223,     2,   224,    39,   227,     3,   155,    38,   209,    13,    75,    39,   207,    11,    23,    31,   240,    16,     2,    23,   247,    30,     1,    18,   250,    42,     0, 
   13,   251,    50,     0,    10,   253,    54,     0,     7,   253,    57,     0,     4,   253,    59,     0,     1,   251,    60,     0,     0,   243,    58,     0,     0,   231,    56,     0, 
    0,   214,    55,     0,    29,   209,     7,   248,    30,   218,     4,   247,    31,   225,     1,   237,    29,   231,     0,   191,    28,   234,     1,   120,    28,   235,     2,    57, 
   27,   240,     2,    20,    25,   245,     6,     2,    18,   248,    20,     1,    12,   250,    31,     2,     8,   251,    40,     2,     5,   252,    44,     0,     2,   252,    48,     0, 
    0,   247,    50,     0,     0,   234,    50,     0,     0,   220,    49,     0,     0,   207,    50,     0,    21,   209,     8,   249,    22,   216,     5,   249,    23,   226,     1,   245, 
   24,   227,     1,   214,    21,   235,     0,   161,    20,   239,     0,    96,    20,   242,     1,    49,    20,   244,     1,    21,    18,   243,     4,     5,    13,   245,    15,     3, 
    6,   246,    28,     7,     2,   243,    36,     7,     0,   239,    40,     5,     0,   233,    41,     1,     0,   220,    41,     0,     0,   210,    42,     0,     0,   200,    44,     0, 
   13,   204,    11,   249,    14,   212,     8,   249,    16,   223,     3,   248,    17,   227,     1,   230,    15,   233,     0,   193,    14,   237,     0,   135,    14,   239,     1,    80, 
   14,   241,     2,    43,    13,   241,     3,    23,    10,   239,     9,    13,     4,   238,    18,    13,     0,   238,    27,    12,     0,   229,    29,     6,     0,   219,    31,     2, 
    0,   209,    33,     0,     0,   200,    35,     0,     0,   187,    38,     0,     5,   201,    15,   250,     6,   207,    12,   250,     8,   217,     7,   249,    10,   228,     2,   240, 
   10,   231,     0,   211,     8,   235,     1,   168,     7,   238,     4,   114,     6,   239,     7,    73,     6,   238,     8,    44,     5,   239,     9,    27,     3,   234,    12,    18, 
    1,   231,    17,    14,     0,   227,    20,     8,     0,   217,    22,     3,     0,   205,    25,     0,     0,   191,    28,     0,     0,   172,    31,     0,     1,   198,    14,   250, 
    3,   203,    10,   250,     1,   211,    10,   250,     5,   225,     1,   248,     6,   229,     0,   226,     4,   233,     0,   193,     4,   233,     1,   140,     1,   233,     7,    97, 
    0,   234,    10,    65,     0,   233,    10,    42,     0,   235,     9,    27,     0,   228,    11,    18,     0,   221,    12,    10,     0,   215,    14,     4,     0,   205,    17,     1, 
    0,   189,    21,     0,     0,   168,    25,     0,     0,   196,    13,   250,     0,   200,     8,   250,     0,   209,     5,   250,     2,   220,     0,   249,     1,   228,     0,   239, 
    1,   229,     0,   209,     1,   225,     1,   161,     0,   224,     3,   112,     0,   225,     4,    77,     0,   226,     5,    52,     0,   227,     5,    33,     0,   229,     4,    20, 
    0,   219,     6,    12,     0,   211,     8,     6,     0,   202,    11,     2,     0,   190,    15,     0,     0,   170,    20,     0,     0,   196,    11,   250,     0,   199,     4,   250, 
    0,   206,     1,   248,     0,   210,     0,   239,     0,   212,     0,   225,     0,   211,     0,   202,     0,   211,     0,   168,     0,   214,     0,   126,     0,   217,     1,    91, 
    0,   219,     1,    63,     0,   218,     2,    41,     0,   222,     2,    26,     0,   222,     1,    15,     0,   211,     4,     8,     0,   200,     5,     3,     0,   190,     9,     1, 
    0,   174,    15,     0,     0,   197,     8,   250,     0,   197,     1,   248,     0,   195,     0,   236,     0,   196,     0,   225,     0,   197,     0,   212,     0,   195,     0,   193, 
    0,   196,     0,   167,     0,   200,     0,   133,     0,   204,     0,   101,     0,   209,     0,    74,     0,   211,     0,    53,     0,   213,     0,    34,     0,   215,     0,    22, 
    0,   214,     0,    11,     0,   202,     2,     5,     0,   191,     5,     2,     0,   178,    11,     0,     0,   200,     5,   250,     0,   192,     0,   241,     0,   182,     0,   224, 
    0,   182,     0,   213,     0,   182,     0,   203,     0,   182,     0,   187,     0,   183,     0,   165,     0,   188,     0,   136,     0,   192,     0,   108,     0,   197,     0,    84, 
    0,   202,     0,    62,     0,   204,     0,    43,     0,   207,     0,    29,     0,   209,     0,    18,     0,   207,     0,     9,     0,   195,     2,     3,     0,   184,     8,     0, 
    0,   202,     2,   250,     0,   188,     0,   234,     0,   175,     0,   212,     0,   173,     0,   201,     0,   173,     0,   193,     0,   173,     0,   181,     0,   175,     0,   162, 
    0,   180,     0,   138,     0,   185,     0,   114,     0,   190,     0,    92,     0,   196,     0,    71,     0,   199,     0,    53,     0,   202,     0,    36,     0,   204,     0,    25, 
    0,   206,     0,    14,     0,   204,     1,     5,     0,   195,     6,     0,     0,   205,     0,   251,     0,   199,     0,   230,     0,   190,     0,   208,     0,   190,     0,   204, 
    0,   190,     0,   197,     0,   189,     0,   188,     0,   189,     0,   173,     0,   192,     0,   152,     0,   197,     0,   128,     0,   202,     0,   105,     0,   208,     0,    84, 
    0,   213,     0,    65,     0,   215,     0,    49,     0,   218,     0,    33,     0,   221,     0,    21,     0,   222,     0,    10,     0,   224,     0,     0,   100,     0,   225,   205, 
  100,     1,   225,   135,    93,     1,   235,    24,    80,    51,   233,     0,    62,   117,   223,     0,    45,   162,   215,     0,    35,   190,   210,     0,    28,   213,   201,     2, 
   20,   232,   194,     4,    14,   247,   188,     5,    13,   249,   168,     3,    10,   250,   149,     3,     7,   250,   131,     3,     5,   250,   114,     1,     3,   246,   101,     0, 
    0,   239,    89,     2,     0,   229,    78,     0,   100,     5,   137,   225,    91,    19,   169,   155,    86,    24,   165,    41,    70,    75,   215,     3,    50,   164,   213,     0, 
   41,   205,   203,     1,    33,   228,   197,     1,    23,   246,   193,     4,    21,   246,   176,     3,    16,   252,   159,     0,    13,   252,   142,     0,    10,   253,   127,     0, 
    7,   253,   112,     0,     4,   253,   101,     0,     1,   250,    91,     0,     0,   240,    81,     0,     0,   222,    73,     0,    88,    13,    48,   221,    85,    26,    70,   173, 
   76,    53,    77,    76,    64,    86,   115,    22,    38,   183,   169,    13,    25,   229,   179,    10,    22,   243,   176,     4,    18,   249,   163,     2,    15,   251,   147,     1, 
   13,   252,   133,     0,    10,   252,   119,     1,     7,   252,   108,     1,     4,   252,    98,     0,     1,   251,    90,     0,     0,   243,    81,     0,     0,   232,    74,     0, 
    0,   215,    68,     0,    71,    37,    21,   250,    71,    42,    24,   223,    63,    74,    41,   115,    61,    74,    45,    37,    42,   161,    78,    27,    28,   226,    94,    13, 
   23,   244,    94,     2,    19,   247,    92,     1,    16,   249,    88,     1,    12,   250,    85,     2,     9,   251,    81,     2,     6,   251,    77,     2,     4,   251,    73,     0, 
    1,   250,    71,     0,     0,   240,    68,     0,     0,   227,    63,     0,     0,   211,    58,     0,    50,   104,    25,   249,    52,   120,    21,   245,    49,   135,    24,   196, 
   48,   134,    30,   107,    48,   124,    35,    40,    33,   185,    57,    25,    24,   227,    62,     7,    18,   244,    70,     1,    12,   250,    72,     2,     9,   252,    70,     0, 
    7,   253,    69,     0,     4,   254,    69,     0,     2,   251,    68,     0,     0,   244,    65,     0,     0,   232,    62,     0,     0,   219,    59,     0,     0,   205,    57,     0, 
   35,   147,    23,   249,    38,   167,    16,   249,    39,   185,    11,   241,    37,   195,    12,   182,    33,   172,    27,    95,    34,   153,    32,    41,    27,   196,    39,    19, 
   19,   228,    45,     6,    13,   239,    51,     2,     6,   247,    60,     6,     5,   250,    59,     0,     2,   250,    62,     0,     0,   242,    62,     0,     0,   230,    60,     0, 
    0,   220,    57,     0,     0,   210,    55,     0,     0,   199,    54,     0,    25,   173,    19,   249,    28,   189,    13,   249,    28,   202,     9,   247,    29,   220,     4,   226, 
   24,   216,    12,   147,    25,   190,    20,    73,    24,   190,    22,    34,    19,   220,    23,    13,    13,   232,    32,     7,     7,   235,    42,     8,     0,   239,    53,    13, 
    0,   240,    51,     5,     0,   236,    51,     1,     0,   224,    51,     0,     0,   213,    50,     0,     0,   204,    50,     0,     0,   193,    50,     0,    17,   188,    17,   249, 
   19,   197,    13,   249,    20,   207,     9,   249,    21,   225,     2,   241,    19,   228,     3,   189,    19,   220,     6,   110,    19,   216,     8,    56,    17,   221,    11,    28, 
   11,   228,    19,    16,     7,   231,    27,    12,     2,   229,    36,    12,     0,   225,    40,     9,     0,   222,    41,     3,     0,   215,    41,     0,     0,   207,    43,     0, 
    0,   199,    44,     0,     0,   187,    45,     0,     9,   191,    18,   250,    11,   198,    15,   250,    12,   206,    10,   249,    14,   223,     4,   246,    14,   228,     2,   211, 
   13,   225,     3,   147,    11,   223,     8,    92,     9,   224,    13,    55,     8,   227,    15,    33,     4,   227,    21,    23,     2,   226,    25,    16,     0,   222,    28,    11, 
    0,   214,    30,     5,     0,   207,    32,     1,     0,   199,    34,     0,     0,   190,    36,     0,     0,   177,    39,     0,     2,   189,    20,   250,     3,   195,    18,   250, 
    5,   204,    13,   250,     7,   219,     6,   247,     9,   226,     3,   223,     5,   225,     8,   179,     6,   221,     8,   119,     5,   222,    10,    77,     3,   224,    15,    52, 
    2,   225,    15,    33,     0,   222,    19,    24,     0,   218,    19,    14,     0,   214,    20,     7,     0,   206,    22,     2,     0,   194,    26,     0,     0,   181,    29,     0, 
    0,   163,    31,     0,     0,   187,    16,   250,     0,   192,    15,   250,     2,   201,    10,   250,     1,   214,     7,   249,     4,   226,     0,   237,     2,   224,     5,   199, 
    0,   219,    10,   145,     0,   219,    11,   100,     0,   220,    12,    68,     0,   220,    12,    44,     0,   221,    11,    28,     0,   215,    11,    18,     0,   209,    13,    10, 
    0,   204,    15,     4,     0,   195,    17,     0,     0,   178,    22,     0,     0,   155,    25,     0,     0,   186,    13,   250,     0,   188,     9,   250,     0,   198,     6,   250, 
    0,   210,     3,   248,     0,   220,     0,   240,     0,   219,     1,   208,     0,   211,     3,   159,     0,   210,     4,   112,     0,   212,     5,    79,     0,   213,     6,    53, 
    0,   214,     6,    33,     0,   216,     5,    21,     0,   208,     6,    13,     0,   200,     8,     7,     0,   194,    10,     2,     0,   179,    15,     0,     0,   157,    20,     0, 
    0,   185,    10,   250,     0,   186,     5,   251,     0,   194,     1,   248,     0,   197,     0,   235,     0,   199,     0,   219,     0,   198,     0,   196,     0,   196,     0,   163, 
    0,   199,     0,   123,     0,   202,     1,    90,     0,   204,     1,    63,     0,   205,     2,    41,     0,   208,     1,    26,     0,   209,     1,    16,     0,   199,     3,     9, 
    0,   191,     5,     3,     0,   181,     8,     0,     0,   162,    15,     0,     0,   185,     8,   251,     0,   183,     2,   249,     0,   180,     0,   237,     0,   175,     0,   218, 
    0,   175,     0,   201,     0,   175,     0,   182,     0,   177,     0,   156,     0,   182,     0,   125,     0,   186,     0,    96,     0,   190,     0,    71,     0,   194,     0,    51, 
    0,   197,     0,    33,     0,   199,     0,    21,     0,   198,     0,    12,     0,   190,     1,     5,     0,   181,     3,     1,     0,   167,    10,     0,     0,   187,     6,   251, 
    0,   179,     1,   244,     0,   168,     0,   224,     0,   158,     0,   199,     0,   157,     0,   183,     0,   159,     0,   166,     0,   162,     0,   144,     0,   166,     0,   122, 
    0,   171,     0,    99,     0,   176,     0,    78,     0,   181,     0,    59,     0,   185,     0,    41,     0,   188,     0,    28,     0,   190,     0,    18,     0,   189,     0,     9, 
    0,   181,     1,     3,     0,   173,     7,     0,     0,   191,     3,   251,     0,   176,     0,   237,     0,   161,     0,   211,     0,   149,     0,   185,     0,   148,     0,   170, 
    0,   150,     0,   156,     0,   153,     0,   139,     0,   156,     0,   121,     0,   161,     0,   102,     0,   166,     0,    83,     0,   172,     0,    65,     0,   177,     0,    49, 
    0,   181,     0,    34,     0,   184,     0,    24,     0,   186,     0,    14,     0,   185,     1,     6,     0,   182,     6,     0,     0,   195,     0,   251,     0,   187,     0,   232, 
    0,   179,     0,   211,     0,   169,     0,   185,     0,   169,     0,   177,     0,   170,     0,   166,     0,   172,     0,   152,     0,   175,     0,   133,     0,   179,     0,   113, 
    0,   184,     0,    95,     0,   190,     0,    76,     0,   196,     0,    59,     0,   200,     0,    44,     0,   203,     0,    30,     0,   206,     0,    19,     0,   207,     0,     8, 
    0,   208,     0,     0,    87,     1,   225,   206,    85,     1,   227,   162,    78,     0,   236,    91,    73,     0,   243,     9,    61,    35,   239,     0,    42,    89,   230,     0, 
   29,   125,   224,     0,    21,   159,   217,     0,    14,   187,   208,     3,     8,   212,   198,     8,     3,   226,   185,    14,     0,   228,   171,    14,     0,   227,   149,    11, 
    0,   226,   129,     8,     0,   223,   112,     5,     0,   219,    97,     2,     0,   213,    84,     0,    80,     4,   182,   240,    77,     6,   209,   219,    71,    11,   204,   126, 
   65,     7,   225,    18,    45,    77,   229,     2,    32,   129,   222,     0,    24,   170,   216,     0,    17,   198,   210,     0,    11,   220,   203,     1,     6,   236,   196,     3, 
    4,   245,   182,     0,     2,   246,   163,     0,     1,   242,   136,     0,     0,   236,   117,     1,     0,   230,   100,     0,     0,   221,    87,     0,     0,   208,    80,     0, 
   72,    12,   101,   249,    74,    16,   112,   223,    70,    46,    97,   111,    59,    41,   134,    50,    38,    92,   190,    17,    24,   145,   207,     7,    15,   187,   208,     2, 
    8,   214,   203,     4,     3,   233,   193,     4,     2,   244,   183,     0,     1,   242,   160,     0,     0,   239,   137,     1,     0,   234,   116,     0,     0,   228,   101,     0, 
    0,   221,    88,     0,     0,   213,    79,     0,     0,   200,    74,     0,    57,    34,    61,   229,    64,    29,    58,   225,    61,    51,    65,   140,    51,    66,    75,    75, 
   39,    93,   104,    37,    15,   166,   151,    40,     2,   209,   163,    35,     0,   223,   161,    21,     0,   228,   147,     9,     0,   234,   135,     3,     0,   232,   118,     2, 
    0,   230,   103,     1,     0,   224,    91,     1,     0,   218,    82,     0,     0,   212,    76,     0,     0,   205,    70,     0,     0,   193,    66,     0,    40,    60,    45,   250, 
   43,    72,    39,   242,    41,    80,    47,   183,    41,    81,    49,   101,    38,    85,    52,    52,    20,   153,    86,    54,    13,   196,    90,    28,     5,   224,    97,    21, 
    4,   234,    87,    11,     2,   243,    82,     5,     2,   244,    74,     0,     1,   242,    71,     0,     0,   232,    67,     0,     0,   220,    63,     0,     0,   210,    60,     0, 
    0,   201,    58,     0,     0,   189,    54,     0,    25,   108,    42,   250,    31,   115,    35,   249,    32,   119,    34,   239,    31,   126,    36,   179,    26,   134,    47,   113, 
   26,   131,    51,    64,    15,   171,    68,    47,     5,   208,    76,    35,     0,   222,    79,    26,     1,   226,    71,    13,     0,   231,    65,     6,     0,   230,    61,     1, 
    0,   220,    59,     0,     0,   211,    56,     0,     0,   202,    55,     0,     0,   194,    54,     0,     0,   182,    53,     0,    16,   137,    37,   250,    22,   149,    29,   249, 
   23,   160,    25,   249,    24,   176,    20,   234,    19,   179,    30,   166,    16,   165,    42,   102,    13,   158,    51,    67,     6,   190,    59,    48,     3,   210,    58,    28, 
    0,   215,    59,    20,     0,   217,    55,    11,     0,   216,    53,     3,     0,   210,    52,     0,     0,   201,    52,     0,     0,   192,    51,     0,     0,   184,    51,     0, 
    0,   172,    50,     0,    10,   159,    32,   250,    14,   169,    26,   250,    15,   178,    21,   249,    16,   195,    15,   246,    13,   204,    18,   205,    13,   192,    23,   130, 
    7,   181,    40,    90,     4,   189,    45,    63,     1,   209,    45,    41,     0,   213,    44,    26,     0,   210,    44,    15,     0,   208,    43,     7,     0,   205,    43,     2, 
    0,   198,    43,     0,     0,   189,    44,     0,     0,   179,    44,     0,     0,   166,    44,     0,     3,   168,    30,   250,     6,   178,    26,   250,     7,   186,    21,   250, 
    8,   198,    15,   248,     8,   212,    14,   227,     6,   207,    20,   169,     4,   202,    26,   113,     0,   204,    34,    78,     0,   209,    33,    51,     1,   210,    30,    29, 
    0,   210,    31,    18,     0,   204,    32,    10,     0,   198,    33,     5,     0,   193,    34,     1,     0,   183,    36,     0,     0,   171,    37,     0,     0,   159,    38,     0, 
    0,   172,    25,   250,     1,   179,    22,   250,     2,   187,    20,   250,     2,   199,    16,   249,     3,   214,    11,   235,     2,   209,    16,   191,     0,   205,    20,   137, 
    0,   205,    22,    92,     0,   206,    23,    60,     0,   209,    22,    38,     0,   206,    21,    24,     0,   203,    21,    14,     0,   198,    22,     6,     0,   191,    24,     1, 
    0,   178,    27,     0,     0,   163,    29,     0,     0,   149,    31,     0,     0,   170,    16,   251,     0,   175,    16,   250,     0,   184,    15,   250,     0,   197,    11,   250, 
    0,   211,     7,   244,     0,   207,    10,   202,     0,   201,    12,   150,     0,   200,    13,   104,     0,   201,    13,    70,     0,   203,    14,    46,     0,   204,    13,    29, 
    0,   199,    14,    18,     0,   195,    14,    10,     0,   191,    16,     4,     0,   180,    18,     0,     0,   160,    22,     0,     0,   140,    25,     0,     0,   170,    12,   251, 
    0,   171,    10,   251,     0,   180,     8,   251,     0,   194,     5,   250,     0,   205,     1,   242,     0,   200,     3,   205,     0,   193,     5,   159,     0,   191,     6,   114, 
    0,   193,     7,    80,     0,   196,     7,    55,     0,   198,     8,    34,     0,   199,     7,    22,     0,   192,     8,    13,     0,   187,     9,     7,     0,   182,    11,     2, 
    0,   164,    15,     0,     0,   141,    20,     0,     0,   170,     9,   251,     0,   168,     5,   251,     0,   175,     2,   250,     0,   181,     1,   240,     0,   183,     0,   222, 
    0,   182,     0,   195,     0,   180,     1,   161,     0,   181,     2,   122,     0,   184,     2,    90,     0,   187,     2,    64,     0,   188,     3,    42,     0,   192,     2,    27, 
    0,   194,     2,    16,     0,   185,     4,     9,     0,   178,     5,     4,     0,   167,     8,     0,     0,   146,    14,     0,     0,   170,     7,   251,     0,   166,     2,   251, 
    0,   166,     0,   242,     0,   160,     0,   221,     0,   155,     0,   195,     0,   156,     0,   171,     0,   159,     0,   146,     0,   162,     0,   119,     0,   166,     0,    93, 
    0,   171,     0,    69,     0,   176,     0,    50,     0,   179,     0,    33,     0,   182,     0,    21,     0,   182,     0,    12,     0,   175,     1,     6,     0,   166,     3,     1, 
    0,   153,    10,     0,     0,   171,     5,   251,     0,   163,     1,   247,     0,   154,     0,   228,     0,   143,     0,   200,     0,   137,     0,   171,     0,   138,     0,   149, 
    0,   140,     0,   131,     0,   142,     0,   113,     0,   147,     0,    94,     0,   152,     0,    74,     0,   158,     0,    58,     0,   162,     0,    40,     0,   166,     0,    28, 
    0,   168,     0,    18,     0,   168,     0,    10,     0,   163,     1,     3,     0,   159,     7,     0,     0,   174,     3,   251,     0,   161,     0,   240,     0,   148,     0,   213, 
    0,   135,     0,   185,     0,   129,     0,   155,     0,   129,     0,   137,     0,   131,     0,   123,     0,   133,     0,   108,     0,   136,     0,    94,     0,   141,     0,    79, 
    0,   147,     0,    63,     0,   152,     0,    48,     0,   156,     0,    34,     0,   160,     0,    24,     0,   162,     0,    15,     0,   162,     0,     7,     0,   167,     5,     0, 
    0,   180,     0,   251,     0,   173,     0,   235,     0,   165,     0,   215,     0,   156,     0,   191,     0,   150,     0,   160,     0,   152,     0,   147,     0,   154,     0,   134, 
    0,   156,     0,   119,     0,   160,     0,   104,     0,   164,     0,    89,     0,   171,     0,    71,     0,   177,     0,    56,     0,   183,     0,    40,     0,   186,     0,    28, 
    0,   190,     0,    18,     0,   192,     0,     7,     0,   193,     0,     0,    71,     1,   225,   219,    69,     1,   226,   190,    62,     0,   235,   140,    58,     0,   242,    55, 
   54,     3,   246,     0,    43,    27,   243,     0,    27,    67,   236,     0,    17,   101,   228,     1,    12,   131,   213,     3,     7,   163,   200,     8,     3,   184,   189,    12, 
    0,   196,   177,    13,     0,   197,   155,     9,     0,   199,   138,     7,     0,   201,   122,     4,     0,   198,   107,     2,     0,   194,    93,     0,    63,     5,   195,   244, 
   64,     3,   219,   236,    59,     3,   222,   178,    52,     3,   235,    74,    44,    23,   240,     1,    30,    63,   236,     0,    19,   102,   229,     0,    11,   141,   222,     1, 
    5,   172,   215,     0,     2,   192,   203,     0,     0,   203,   184,     2,     0,   206,   162,     1,     0,   206,   140,     1,     0,   205,   123,     1,     0,   202,   108,     0, 
    0,   197,    95,     0,     0,   187,    87,     0,    51,    18,   135,   249,    74,     7,   142,   248,    51,    23,   163,   198,    45,    29,   171,   103,    42,    31,   191,    14, 
   26,    70,   215,     6,    15,   112,   215,     3,     3,   160,   209,     9,     1,   182,   202,     1,     0,   194,   184,     0,     0,   199,   160,     0,     0,   202,   139,     0, 
    0,   201,   123,     0,     0,   199,   108,     0,     0,   195,    96,     0,     0,   190,    86,     0,     0,   180,    80,     0,    40,    40,    93,   228,    55,    22,   104,   249, 
   41,    41,   106,   204,    38,    57,   103,   115,    35,    56,   125,    63,    26,    73,   159,    29,     7,   134,   180,    29,     0,   168,   179,    21,     0,   179,   164,     6, 
    0,   188,   145,     0,     0,   192,   130,     0,     0,   193,   114,     0,     0,   191,   102,     0,     0,   188,    92,     0,     0,   185,    83,     0,     0,   181,    76,     0, 
    0,   170,    73,     0,    28,    55,    71,   243,    36,    48,    65,   247,    32,    57,    75,   211,    32,    67,    74,   128,    24,    88,    88,    99,    18,    98,   106,    65, 
    0,   154,   134,    57,     0,   170,   128,    27,     0,   181,   119,    12,     0,   188,   109,     3,     0,   190,    98,     1,     0,   188,    88,     0,     0,   185,    81,     0, 
    0,   181,    75,     0,     0,   178,    70,     0,     0,   172,    66,     0,     0,   161,    62,     0,    10,    82,    67,   250,    22,    77,    57,   250,    23,    78,    56,   241, 
   24,    78,    55,   158,    25,    84,    53,   103,     7,   126,    87,   100,     0,   153,    97,    79,     0,   175,    90,    42,     0,   190,    82,    23,     0,   198,    74,    11, 
    0,   203,    66,     3,     0,   201,    62,     0,     0,   196,    59,     0,     0,   189,    57,     0,     0,   181,    55,     0,     0,   172,    53,     0,     0,   162,    49,     0, 
    1,   110,    60,   250,    12,   116,    50,   250,    14,   118,    47,   248,    15,   124,    46,   226,     6,   137,    60,   178,     3,   146,    68,   132,     1,   148,    75,    97, 
    0,   160,    75,    62,     0,   177,    67,    31,     0,   186,    62,    17,     0,   190,    58,     7,     0,   193,    54,     1,     0,   188,    52,     0,     0,   180,    51,     0, 
    0,   171,    50,     0,     0,   161,    49,     0,     0,   150,    47,     0,     0,   125,    48,   250,     3,   139,    46,   250,     6,   145,    40,   250,     6,   155,    37,   247, 
    5,   166,    40,   216,     2,   169,    47,   159,     0,   155,    55,   109,     0,   148,    59,    77,     0,   162,    55,    47,     0,   179,    50,    24,     0,   184,    48,    13, 
    0,   185,    46,     6,     0,   182,    45,     1,     0,   172,    45,     0,     0,   160,    45,     0,     0,   151,    44,     0,     0,   143,    44,     0,     0,   135,    38,   250, 
    0,   151,    37,   250,     0,   157,    35,   250,     2,   166,    30,   249,     0,   180,    31,   234,     0,   179,    34,   181,     0,   172,    36,   124,     0,   159,    42,    84, 
    0,   162,    41,    56,     0,   182,    38,    33,     0,   185,    36,    19,     0,   180,    35,    10,     0,   178,    35,     4,     0,   170,    36,     0,     0,   157,    36,     0, 
    0,   146,    37,     0,     0,   138,    38,     0,     0,   146,    26,   251,     0,   154,    25,   251,     0,   161,    24,   250,     0,   172,    23,   250,     0,   186,    20,   243, 
    0,   183,    21,   197,     0,   176,    22,   139,     0,   175,    24,    95,     0,   179,    26,    64,     0,   185,    26,    42,     0,   185,    25,    24,     0,   182,    25,    14, 
    0,   178,    25,     6,     0,   168,    26,     1,     0,   152,    28,     0,     0,   141,    29,     0,     0,   133,    32,     0,     0,   147,    17,   251,     0,   153,    17,   251, 
    0,   160,    16,   251,     0,   172,    14,   251,     0,   187,    11,   246,     0,   179,    12,   205,     0,   173,    14,   151,     0,   173,    15,   106,     0,   177,    16,    73, 
    0,   181,    17,    49,     0,   183,    17,    31,     0,   180,    16,    19,     0,   177,    17,    10,     0,   171,    18,     3,     0,   156,    20,     0,     0,   138,    23,     0, 
    0,   127,    26,     0,     0,   148,    11,   251,     0,   150,    10,   251,     0,   158,     9,   251,     0,   169,     7,   251,     0,   179,     4,   242,     0,   172,     5,   205, 
    0,   167,     7,   157,     0,   166,     8,   114,     0,   170,     9,    82,     0,   175,    10,    57,     0,   177,    10,    37,     0,   180,     9,    23,     0,   173,     9,    14, 
    0,   168,    10,     7,     0,   161,    12,     2,     0,   142,    16,     0,     0,   126,    20,     0,     0,   151,     8,   251,     0,   149,     5,   252,     0,   154,     3,   251, 
    0,   162,     1,   247,     0,   165,     1,   229,     0,   160,     1,   195,     0,   158,     2,   155,     0,   158,     3,   119,     0,   161,     3,    90,     0,   165,     4,    65, 
    0,   168,     4,    43,     0,   173,     4,    28,     0,   175,     3,    18,     0,   165,     5,    10,     0,   158,     6,     4,     0,   147,     9,     1,     0,   130,    15,     0, 
    0,   154,     6,   251,     0,   148,     2,   251,     0,   147,     0,   245,     0,   145,     0,   226,     0,   140,     0,   200,     0,   138,     0,   169,     0,   140,     0,   140, 
    0,   142,     0,   115,     0,   146,     0,    93,     0,   151,     0,    69,     0,   156,     0,    51,     0,   160,     0,    34,     0,   163,     0,    22,     0,   162,     0,    13, 
    0,   155,     2,     7,     0,   147,     3,     2,     0,   136,    10,     0,     0,   156,     4,   251,     0,   145,     0,   247,     0,   138,     0,   229,     0,   130,     0,   204, 
    0,   124,     0,   175,     0,   121,     0,   142,     0,   122,     0,   121,     0,   124,     0,   105,     0,   127,     0,    90,     0,   132,     0,    72,     0,   136,     0,    57, 
    0,   140,     0,    41,     0,   144,     0,    28,     0,   146,     0,    19,     0,   146,     0,    11,     0,   142,     1,     4,     0,   142,     6,     0,     0,   158,     2,   251, 
    0,   144,     0,   239,     0,   132,     0,   215,     0,   123,     0,   189,     0,   117,     0,   157,     0,   112,     0,   126,     0,   112,     0,   109,     0,   114,     0,    98, 
    0,   117,     0,    88,     0,   121,     0,    74,     0,   125,     0,    61,     0,   129,     0,    47,     0,   133,     0,    34,     0,   136,     0,    24,     0,   138,     0,    15, 
    0,   139,     0,     8,     0,   150,     4,     0,     0,   162,     0,   251,     0,   155,     0,   235,     0,   149,     0,   217,     0,   142,     0,   196,     0,   136,     0,   168, 
    0,   133,     0,   134,     0,   134,     0,   120,     0,   136,     0,   108,     0,   138,     0,    97,     0,   142,     0,    86,     0,   148,     0,    71,     0,   155,     0,    56, 
    0,   162,     0,    41,     0,   167,     0,    28,     0,   172,     0,    17,     0,   174,     0,     7,     0,   175,     0,     0,    55,     0,   226,   234,    54,     1,   225,   206, 
   49,     0,   233,   171,    44,     0,   240,    99,    41,     0,   246,    28,    35,     6,   248,     0,    28,    23,   246,     0,    15,    56,   238,     1,     7,    88,   222,     7, 
    5,   113,   206,    10,     2,   137,   195,    12,     0,   153,   182,    12,     0,   158,   162,     8,     0,   167,   145,     5,     0,   173,   130,     3,     0,   174,   117,     2, 
    0,   172,   104,     0,    49,     6,   202,   246,    49,     4,   216,   241,    48,     2,   223,   210,    41,     1,   236,   132,    37,     2,   244,    20,    27,    25,   243,     1, 
   17,    53,   240,     0,     7,    86,   234,     1,     2,   116,   225,     0,     0,   139,   207,     2,     0,   152,   188,     1,     0,   160,   166,     1,     0,   168,   144,     1, 
    0,   173,   128,     0,     0,   175,   116,     0,     0,   173,   106,     0,     0,   166,    98,     0,    42,    16,   163,   249,    43,    12,   179,   248,    41,     6,   208,   248, 
   35,    13,   211,   161,    33,    14,   213,    43,    26,    31,   217,     8,    15,    60,   220,     4,     0,   104,   215,    14,     0,   122,   209,     2,     0,   137,   190,     0, 
    0,   148,   168,     0,     0,   157,   145,     0,     0,   166,   128,     0,     0,   169,   115,     0,     0,   170,   105,     0,     0,   166,    95,     0,     0,   157,    89,     0, 
   37,    30,   119,   249,    39,    25,   130,   249,    32,    24,   149,   249,    28,    43,   145,   171,    24,    49,   160,   104,    24,    42,   166,    41,     7,    85,   187,    32, 
    0,   111,   188,    22,     0,   122,   177,     7,     0,   133,   160,     1,     0,   143,   140,     0,     0,   152,   121,     0,     0,   159,   110,     0,     0,   161,   100,     0, 
    0,   160,    91,     0,     0,   157,    83,     0,     0,   147,    80,     0,    20,    53,    95,   241,    28,    46,    90,   250,    26,    44,   100,   250,    22,    58,   101,   181, 
   17,    80,   105,   130,    10,    86,   129,    93,     1,   106,   149,    59,     0,   114,   147,    29,     0,   122,   138,    12,     0,   132,   125,     2,     0,   140,   109,     0, 
    0,   146,   100,     0,     0,   149,    91,     0,     0,   150,    84,     0,     0,   149,    77,     0,     0,   147,    72,     0,     0,   138,    69,     0,     3,    72,    83,   249, 
   15,    66,    73,   250,    16,    65,    75,   245,    15,    70,    79,   195,     4,    95,    94,   159,     0,   114,   104,   125,     0,   112,   107,    82,     0,   115,   104,    41, 
    0,   124,    95,    18,     0,   135,    90,     8,     0,   143,    84,     1,     0,   146,    78,     0,     0,   146,    73,     0,     0,   145,    68,     0,     0,   142,    63,     0, 
    0,   139,    60,     0,     0,   132,    57,     0,     0,    80,    65,   250,     2,    99,    68,   250,     5,    98,    66,   250,     1,   101,    71,   239,     8,    87,    60,   157, 
    1,   111,    76,   128,     0,   107,    74,    87,     0,   116,    74,    58,     0,   134,    70,    31,     0,   148,    65,    16,     0,   158,    59,     6,     0,   163,    55,     1, 
    0,   159,    53,     0,     0,   153,    51,     0,     0,   145,    49,     0,     0,   139,    47,     0,     0,   134,    44,     0,     0,    93,    49,   251,     0,   109,    53,   250, 
    0,   114,    53,   250,     0,   117,    52,   247,     0,   117,    53,   208,     0,   121,    57,   152,     0,   117,    58,   106,     0,   115,    60,    75,     0,   122,    57,    46, 
    0,   137,    52,    24,     0,   145,    50,    11,     0,   149,    47,     4,     0,   148,    45,     0,     0,   143,    45,     0,     0,   136,    44,     0,     0,   130,    43,     0, 
    0,   124,    42,     0,     0,   103,    38,   251,     0,   116,    38,   251,     0,   122,    38,   251,     0,   128,    37,   250,     0,   137,    36,   239,     0,   136,    39,   180, 
    0,   129,    39,   123,     0,   121,    43,    84,     0,   115,    46,    59,     0,   128,    43,    35,     0,   141,    39,    18,     0,   143,    38,     9,     0,   144,    37,     3, 
    0,   139,    37,     0,     0,   130,    38,     0,     0,   124,    39,     0,     0,   119,    39,     0,     0,   113,    28,   251,     0,   118,    27,   251,     0,   124,    26,   251, 
    0,   134,    25,   251,     0,   148,    23,   246,     0,   142,    24,   196,     0,   133,    25,   137,     0,   134,    28,    94,     0,   127,    33,    64,     0,   130,    33,    43, 
    0,   142,    29,    24,     0,   145,    27,    13,     0,   142,    27,     6,     0,   138,    28,     1,     0,   129,    30,     0,     0,   121,    31,     0,     0,   116,    33,     0, 
    0,   117,    18,   252,     0,   120,    18,   252,     0,   127,    18,   251,     0,   139,    16,   251,     0,   152,    14,   246,     0,   144,    15,   203,     0,   135,    16,   148, 
    0,   136,    18,   104,     0,   138,    19,    72,     0,   140,    20,    49,     0,   145,    19,    31,     0,   146,    18,    18,     0,   145,    19,     9,     0,   140,    20,     3, 
    0,   130,    22,     0,     0,   118,    25,     0,     0,   113,    27,     0,     0,   120,    12,   252,     0,   122,    11,   252,     0,   129,    10,   252,     0,   140,     9,   251, 
    0,   148,     7,   241,     0,   141,     8,   203,     0,   135,     9,   154,     0,   134,    10,   112,     0,   138,    11,    82,     0,   142,    11,    57,     0,   146,    12,    38, 
    0,   149,    11,    24,     0,   144,    11,    14,     0,   141,    12,     6,     0,   136,    13,     1,     0,   121,    17,     0,     0,   110,    22,     0,     0,   126,     8,   252, 
    0,   124,     6,   252,     0,   129,     4,   252,     0,   136,     3,   249,     0,   140,     2,   232,     0,   135,     3,   196,     0,   132,     3,   153,     0,   131,     4,   115, 
    0,   134,     5,    89,     0,   138,     5,    65,     0,   141,     5,    44,     0,   146,     6,    30,     0,   149,     5,    19,     0,   140,     6,    10,     0,   135,     7,     4, 
    0,   126,    10,     0,     0,   113,    16,     0,     0,   132,     6,   252,     0,   127,     2,   252,     0,   128,     1,   248,     0,   127,     0,   232,     0,   125,     0,   208, 
    0,   123,     0,   178,     0,   122,     0,   140,     0,   124,     0,   112,     0,   127,     1,    91,     0,   130,     1,    70,     0,   134,     1,    52,     0,   137,     1,    35, 
    0,   141,     1,    23,     0,   142,     1,    14,     0,   134,     2,     7,     0,   129,     3,     1,     0,   118,    11,     0,     0,   138,     4,   252,     0,   127,     0,   248, 
    0,   121,     0,   231,     0,   115,     0,   208,     0,   111,     0,   181,     0,   108,     0,   149,     0,   106,     0,   118,     0,   108,     0,   100,     0,   111,     0,    86, 
    0,   114,     0,    70,     0,   117,     0,    56,     0,   121,     0,    40,     0,   124,     0,    28,     0,   126,     0,    19,     0,   126,     0,    11,     0,   124,     1,     4, 
    0,   124,     7,     0,     0,   141,     2,   252,     0,   127,     0,   239,     0,   117,     0,   216,     0,   110,     0,   192,     0,   105,     0,   163,     0,   100,     0,   130, 
    0,    97,     0,   103,     0,    99,     0,    90,     0,   101,     0,    81,     0,   103,     0,    70,     0,   106,     0,    59,     0,   109,     0,    46,     0,   112,     0,    33, 
    0,   115,     0,    24,     0,   117,     0,    15,     0,   118,     0,     8,     0,   130,     4,     0,     0,   145,     0,   252,     0,   137,     0,   235,     0,   131,     0,   217, 
    0,   126,     0,   199,     0,   123,     0,   175,     0,   120,     0,   141,     0,   117,     0,   110,     0,   119,     0,    98,     0,   121,     0,    90,     0,   123,     0,    82, 
    0,   127,     0,    71,     0,   133,     0,    56,     0,   139,     0,    41,     0,   145,     0,    29,     0,   150,     0,    17,     0,   152,     0,     7,     0,   155,     0,     0, 
   42,     0,   227,   242,    41,     1,   225,   218,    37,     0,   232,   190,    33,     0,   237,   138,    30,     0,   244,    64,    28,     0,   249,    15,    24,     8,   250,     0, 
   18,    21,   248,     0,     6,    51,   238,     4,     0,    80,   218,    13,     0,    96,   201,    12,     0,   109,   187,     9,     0,   119,   170,     7,     0,   130,   155,     4, 
    0,   138,   142,     3,     0,   143,   127,     1,     0,   147,   113,     0,    38,     7,   202,   248,    38,     5,   211,   244,    36,     2,   223,   226,    31,     0,   234,   171, 
   27,     0,   244,    58,    26,     2,   248,     3,    16,    27,   245,     1,     7,    49,   241,     2,     1,    71,   232,     0,     0,    90,   210,     1,     0,   104,   192,     1, 
    0,   117,   172,     1,     0,   127,   153,     1,     0,   134,   138,     0,     0,   139,   124,     0,     0,   141,   111,     0,     0,   138,   105,     0,    32,    16,   176,   249, 
   33,    14,   180,   249,    31,     7,   204,   249,    28,     6,   223,   196,    24,     7,   225,    81,    22,    15,   220,    21,    13,    36,   223,     9,     3,    62,   220,    12, 
    0,    76,   215,     2,     0,    92,   196,     0,     0,   105,   174,     0,     0,   117,   155,     0,     0,   127,   139,     0,     0,   133,   123,     0,     0,   135,   110,     0, 
    0,   136,   101,     0,     0,   130,    97,     0,    24,    32,   138,   249,    25,    29,   144,   249,    24,    23,   163,   249,    21,    21,   186,   223,    17,    31,   189,   142, 
   18,    28,   184,    63,     8,    54,   193,    33,     0,    73,   195,    24,     0,    80,   188,     8,     0,    93,   172,     1,     0,   105,   151,     0,     0,   115,   134,     0, 
    0,   123,   119,     0,     0,   128,   106,     0,     0,   130,    95,     0,     0,   131,    88,     0,     0,   122,    86,     0,    17,    48,   111,   250,    20,    46,   109,   250, 
   17,    44,   120,   250,    13,    44,   139,   229,     6,    69,   146,   176,     5,    70,   152,   113,     4,    68,   160,    55,     0,    76,   161,    34,     0,    84,   152,    14, 
    0,    94,   140,     3,     0,   103,   125,     0,     0,   111,   111,     0,     0,   116,    98,     0,     0,   121,    88,     0,     0,   124,    82,     0,     0,   125,    77,     0, 
    0,   118,    75,     0,     0,    66,    94,   250,     9,    65,    91,   250,     8,    64,    95,   250,     7,    60,   104,   249,     0,    80,   111,   189,     0,    87,   108,   129, 
    0,    81,   114,    87,     0,    75,   119,    48,     0,    87,   113,    23,     0,    95,   105,     9,     0,   101,    96,     1,     0,   106,    86,     0,     0,   110,    80,     0, 
    0,   115,    74,     0,     0,   117,    70,     0,     0,   117,    65,     0,     0,   112,    63,     0,     0,    62,    66,   251,     0,    72,    75,   250,     0,    73,    77,   250, 
    3,    69,    76,   238,     0,    73,    79,   187,     0,    85,    81,   127,     0,    82,    80,    90,     0,    82,    83,    61,     0,    89,    78,    30,     0,    96,    74,    13, 
    0,   105,    72,     4,     0,   111,    68,     0,     0,   112,    64,     0,     0,   113,    60,     0,     0,   112,    56,     0,     0,   111,    54,     0,     0,   107,    52,     0, 
    0,    65,    51,   251,     0,    72,    57,   251,     0,    75,    57,   251,     0,    75,    57,   246,     6,    63,    46,   186,     0,    84,    61,   136,     0,    87,    61,   100, 
    0,    87,    60,    72,     0,    91,    59,    44,     0,   103,    56,    23,     0,   115,    52,    10,     0,   123,    49,     3,     0,   123,    47,     0,     0,   120,    45,     0, 
    0,   116,    44,     0,     0,   112,    42,     0,     0,   109,    39,     0,     0,    75,    40,   252,     0,    86,    40,   251,     0,    89,    39,   251,     0,    92,    39,   251, 
    0,    92,    38,   236,     0,    94,    44,   163,     0,    93,    45,   114,     0,    90,    45,    80,     0,    90,    47,    57,     0,    96,    46,    35,     0,   109,    43,    18, 
    0,   115,    41,     7,     0,   117,    40,     1,     0,   113,    39,     0,     0,   109,    39,     0,     0,   106,    38,     0,     0,   102,    37,     0,     0,    84,    29,   252, 
    0,    92,    28,   252,     0,    95,    27,   252,     0,   100,    27,   252,     0,   105,    25,   245,     0,   105,    28,   193,     0,   100,    30,   135,     0,    99,    30,    92, 
    0,    96,    35,    64,     0,    92,    37,    45,     0,   102,    35,    28,     0,   114,    32,    12,     0,   115,    31,     5,     0,   113,    31,     1,     0,   107,    32,     0, 
    0,   102,    33,     0,     0,    99,    33,     0,     0,    91,    20,   252,     0,    96,    19,   252,     0,    99,    19,   252,     0,   106,    18,   251,     0,   112,    17,   244, 
    0,   110,    18,   201,     0,   104,    18,   149,     0,   104,    20,   102,     0,   107,    22,    72,     0,   100,    25,    51,     0,   102,    25,    34,     0,   116,    22,    18, 
    0,   118,    22,     8,     0,   115,    23,     2,     0,   108,    24,     0,     0,   101,    26,     0,     0,    98,    28,     0,     0,    96,    12,   252,     0,    99,    12,   252, 
    0,   104,    12,   252,     0,   110,    11,   251,     0,   115,    10,   239,     0,   111,    11,   203,     0,   108,    11,   157,     0,   106,    11,   110,     0,   111,    13,    81, 
    0,   113,    14,    56,     0,   115,    14,    39,     0,   119,    14,    24,     0,   118,    13,    13,     0,   117,    14,     5,     0,   112,    16,     1,     0,   101,    19,     0, 
    0,    97,    23,     0,     0,   102,     8,   252,     0,   102,     6,   252,     0,   106,     6,   252,     0,   111,     5,   250,     0,   114,     5,   232,     0,   111,     5,   199, 
    0,   109,     5,   157,     0,   105,     6,   113,     0,   109,     7,    87,     0,   113,     7,    64,     0,   116,     7,    45,     0,   119,     7,    30,     0,   121,     7,    19, 
    0,   116,     7,     9,     0,   115,     8,     3,     0,   106,    12,     0,     0,    98,    17,     0,     0,   110,     6,   252,     0,   106,     3,   252,     0,   108,     1,   250, 
    0,   109,     1,   239,     0,   108,     1,   217,     0,   107,     1,   188,     0,   106,     1,   150,     0,   103,     1,   111,     0,   106,     2,    88,     0,   109,     2,    69, 
    0,   112,     2,    52,     0,   115,     2,    35,     0,   118,     2,    24,     0,   120,     2,    14,     0,   115,     3,     6,     0,   111,     4,     1,     0,   102,    12,     0, 
    0,   117,     4,   252,     0,   109,     1,   249,     0,   105,     0,   235,     0,   100,     0,   213,     0,    97,     0,   189,     0,    96,     0,   159,     0,    95,     0,   126, 
    0,    93,     0,    98,     0,    96,     0,    82,     0,    98,     0,    69,     0,   101,     0,    56,     0,   104,     0,    40,     0,   106,     0,    29,     0,   108,     0,    19, 
    0,   108,     0,    11,     0,   107,     1,     4,     0,   106,     7,     0,     0,   122,     2,   252,     0,   111,     0,   240,     0,   103,     0,   218,     0,    97,     0,   195, 
    0,    92,     0,   168,     0,    90,     0,   137,     0,    87,     0,   107,     0,    85,     0,    86,     0,    87,     0,    74,     0,    88,     0,    67,     0,    91,     0,    58, 
    0,    93,     0,    45,     0,    96,     0,    33,     0,    98,     0,    24,     0,   100,     0,    15,     0,   101,     0,     8,     0,   112,     5,     0,     0,   127,     0,   252, 
    0,   121,     0,   237,     0,   115,     0,   219,     0,   111,     0,   201,     0,   108,     0,   181,     0,   107,     0,   150,     0,   104,     0,   116,     0,   103,     0,    91, 
    0,   105,     0,    82,     0,   106,     0,    76,     0,   108,     0,    69,     0,   112,     0,    56,     0,   118,     0,    41,     0,   123,     0,    29,     0,   128,     0,    18, 
    0,   130,     0,     7,     0,   133,     0,     0,    31,     1,   226,   247,    30,     1,   227,   230,    29,     1,   229,   205,    25,     0,   235,   167,    22,     0,   242,   103, 
   20,     0,   248,    41,    20,     0,   251,     7,    16,    10,   250,     0,    12,    19,   249,     0,     4,    42,   238,     1,     0,    64,   216,     7,     0,    78,   198,     7, 
    0,    91,   184,     6,     0,   101,   168,     4,     0,   110,   154,     2,     0,   118,   140,     1,     0,   124,   127,     0,    28,     9,   199,   249,    27,     7,   209,   247, 
   27,     3,   224,   239,    25,     0,   232,   196,    21,     0,   242,    98,    19,     1,   248,    30,    17,     8,   250,     1,     8,    28,   246,     2,     2,    43,   241,     0, 
    0,    58,   218,     1,     0,    72,   196,     1,     0,    85,   180,     1,     0,    95,   162,     0,     0,   104,   147,     0,     0,   111,   135,     0,     0,   117,   125,     0, 
    0,   117,   119,     0,    24,    18,   177,   249,    24,    18,   180,   249,    23,     9,   205,   249,    23,     4,   222,   216,    18,     3,   230,   114,    17,     7,   227,    45, 
   13,    17,   231,    10,     3,    41,   227,    12,     0,    48,   226,     3,     0,    61,   203,     0,     0,    74,   182,     0,     0,    87,   163,     0,     0,    96,   146,     0, 
    0,   104,   133,     0,     0,   109,   121,     0,     0,   112,   112,     0,     0,   110,   108,     0,    17,    31,   152,   250,    18,    30,   154,   249,    16,    25,   170,   249, 
   16,    14,   202,   240,    11,    23,   202,   171,    11,    23,   198,    95,     6,    37,   200,    43,     0,    51,   200,    27,     0,    53,   196,    10,     0,    63,   183,     1, 
    0,    75,   162,     0,     0,    86,   142,     0,     0,    95,   128,     0,     0,   101,   116,     0,     0,   105,   105,     0,     0,   106,    95,     0,     0,   103,    94,     0, 
    7,    50,   125,   250,    11,    46,   127,   250,     9,    42,   138,   250,     7,    36,   155,   250,     0,    50,   160,   201,     0,    53,   162,   132,     0,    54,   167,    69, 
    0,    54,   168,    36,     0,    57,   164,    17,     0,    65,   154,     4,     0,    74,   135,     0,     0,    84,   119,     0,     0,    91,   107,     0,     0,    96,    95,     0, 
    0,   100,    86,     0,     0,   104,    80,     0,     0,   101,    79,     0,     0,    55,   100,   250,     4,    61,   103,   250,     2,    60,   112,   250,     2,    52,   122,   250, 
    0,    51,   120,   202,     0,    60,   110,   134,     0,    61,   116,    92,     0,    55,   123,    53,     0,    60,   122,    25,     0,    66,   116,    10,     0,    73,   107,     1, 
    0,    80,    95,     0,     0,    88,    86,     0,     0,    94,    80,     0,     0,    98,    74,     0,     0,   100,    70,     0,     0,    99,    68,     0,     0,    51,    72,   251, 
    0,    60,    80,   251,     0,    61,    83,   251,     0,    56,    85,   246,     0,    53,    84,   201,     0,    63,    81,   126,     0,    69,    80,    94,     0,    63,    88,    65, 
    0,    64,    89,    33,     0,    69,    87,    17,     0,    74,    83,     5,     0,    82,    77,     0,     0,    88,    71,     0,     0,    92,    66,     0,     0,    94,    62,     0, 
    0,    95,    59,     0,     0,    93,    57,     0,     0,    49,    51,   252,     0,    55,    57,   251,     0,    56,    59,   251,     1,    54,    58,   243,     1,    50,    58,   202, 
    0,    63,    63,   137,     0,    66,    63,    95,     0,    66,    65,    70,     0,    68,    66,    44,     0,    72,    65,    22,     0,    79,    61,     9,     0,    87,    60,     1, 
    0,    90,    56,     0,     0,    91,    53,     0,     0,    91,    51,     0,     0,    91,    49,     0,     0,    89,    47,     0,     0,    51,    41,   252,     0,    59,    40,   252, 
    0,    62,    40,   252,     0,    62,    40,   251,     0,    57,    39,   227,     0,    70,    47,   158,     0,    68,    48,   103,     0,    69,    48,    78,     0,    72,    50,    59, 
    0,    73,    47,    33,     0,    84,    45,    16,     0,    93,    44,     6,     0,    97,    41,     1,     0,    96,    40,     0,     0,    94,    39,     0,     0,    92,    37,     0, 
    0,    90,    34,     0,     0,    61,    30,   252,     0,    66,    29,   252,     0,    67,    28,   252,     0,    69,    27,   252,     0,    70,    28,   240,     0,    75,    32,   189, 
    0,    73,    36,   125,     0,    73,    36,    88,     0,    74,    36,    64,     0,    74,    38,    44,     0,    80,    37,    27,     0,    89,    35,    12,     0,    93,    34,     4, 
    0,    93,    34,     0,     0,    89,    34,     0,     0,    86,    33,     0,     0,    84,    32,     0,     0,    68,    21,   253,     0,    72,    20,   253,     0,    73,    19,   253, 
    0,    77,    19,   252,     0,    81,    19,   242,     0,    81,    21,   199,     0,    82,    24,   149,     0,    81,    24,   103,     0,    81,    24,    71,     0,    78,    27,    50, 
    0,    75,    29,    35,     0,    85,    28,    20,     0,    93,    26,     7,     0,    94,    26,     1,     0,    90,    26,     0,     0,    85,    27,     0,     0,    83,    28,     0, 
    0,    72,    14,   253,     0,    76,    13,   253,     0,    80,    13,   253,     0,    84,    12,   252,     0,    88,    12,   238,     0,    86,    13,   201,     0,    85,    15,   159, 
    0,    85,    15,   114,     0,    84,    14,    79,     0,    86,    16,    56,     0,    82,    20,    41,     0,    84,    19,    26,     0,    94,    17,    12,     0,    97,    17,     4, 
    0,    93,    19,     0,     0,    85,    21,     0,     0,    83,    23,     0,     0,    79,     8,   253,     0,    81,     7,   253,     0,    85,     7,   253,     0,    89,     6,   251, 
    0,    90,     6,   231,     0,    89,     7,   198,     0,    88,     8,   160,     0,    86,     8,   117,     0,    86,     8,    84,     0,    89,     9,    62,     0,    92,    10,    45, 
    0,    93,    10,    31,     0,    96,    10,    18,     0,    97,     9,     8,     0,    97,    10,     2,     0,    88,    14,     0,     0,    83,    18,     0,     0,    88,     5,   253, 
    0,    87,     3,   253,     0,    88,     2,   252,     0,    90,     2,   243,     0,    89,     2,   219,     0,    88,     2,   191,     0,    87,     3,   155,     0,    86,     3,   116, 
    0,    86,     3,    87,     0,    90,     3,    68,     0,    93,     3,    52,     0,    96,     4,    36,     0,    98,     4,    24,     0,   100,     3,    14,     0,    97,     3,     5, 
    0,    93,     6,     1,     0,    87,    13,     0,     0,    97,     3,   253,     0,    92,     1,   251,     0,    89,     0,   240,     0,    86,     0,   221,     0,    85,     0,   198, 
    0,    83,     0,   170,     0,    82,     0,   137,     0,    82,     0,   105,     0,    81,     0,    82,     0,    84,     0,    67,     0,    87,     0,    56,     0,    90,     0,    41, 
    0,    92,     0,    29,     0,    94,     0,    19,     0,    94,     0,    11,     0,    93,     1,     3,     0,    92,     8,     0,     0,   104,     2,   253,     0,    95,     0,   242, 
    0,    89,     0,   223,     0,    85,     0,   201,     0,    81,     0,   176,     0,    78,     0,   144,     0,    77,     0,   114,     0,    74,     0,    90,     0,    73,     0,    72, 
    0,    75,     0,    63,     0,    76,     0,    56,     0,    79,     0,    45,     0,    82,     0,    33,     0,    84,     0,    24,     0,    85,     0,    15,     0,    87,     0,     7, 
    0,    97,     5,     0,     0,   111,     0,   253,     0,   105,     0,   238,     0,   100,     0,   222,     0,    96,     0,   206,     0,    94,     0,   186,     0,    92,     0,   157, 
    0,    91,     0,   124,     0,    89,     0,    96,     0,    89,     0,    76,     0,    91,     0,    69,     0,    92,     0,    65,     0,    95,     0,    55,     0,    99,     0,    41, 
    0,   104,     0,    29,     0,   107,     0,    18,     0,   110,     0,     7,     0,   113,     0,     0,    22,     3,   222,   249,    22,     1,   227,   240,    23,     1,   227,   218, 
   19,     0,   234,   190,    17,     0,   239,   138,    15,     0,   246,    72,    15,     0,   250,    26,    16,     0,   252,     2,    12,     9,   251,     0,     9,    17,   250,     0, 
    3,    36,   239,     0,     0,    55,   217,     4,     0,    67,   198,     4,     0,    78,   184,     3,     0,    88,   169,     2,     0,    97,   154,     1,     0,   104,   140,     0, 
   20,    11,   202,   249,    20,     9,   207,   249,    20,     4,   221,   245,    20,     1,   228,   215,    15,     0,   239,   128,    12,     2,   245,    62,    14,     1,   250,    14, 
    9,    12,   250,     1,     3,    26,   246,     0,     0,    37,   227,     2,     0,    48,   206,     0,     0,    61,   187,     0,     0,    71,   172,     0,     0,    81,   157,     0, 
    0,    89,   144,     0,     0,    96,   134,     0,     0,    99,   130,     0,    15,    20,   180,   249,    16,    18,   185,   249,    17,    11,   203,   249,    16,     4,   223,   231, 
   12,     4,   229,   140,    11,     6,   228,    75,    10,     9,   234,    24,     4,    23,   236,    11,     0,    31,   232,     3,     0,    37,   211,     0,     0,    51,   190,     0, 
    0,    63,   172,     0,     0,    72,   155,     0,     0,    80,   140,     0,     0,    87,   128,     0,     0,    92,   119,     0,     0,    93,   118,     0,     3,    40,   152,   250, 
    9,    32,   159,   250,     8,    26,   174,   250,    11,    11,   206,   250,     5,    24,   205,   193,     0,    34,   202,   135,     0,    33,   203,    74,     0,    33,   205,    41, 
    0,    35,   202,    12,     0,    39,   192,     1,     0,    52,   173,     0,     0,    64,   152,     0,     0,    72,   135,     0,     0,    79,   122,     0,     0,    84,   111,     0, 
    0,    88,   102,     0,     0,    87,   103,     0,     0,    45,   127,   250,     1,    48,   138,   250,     4,    41,   143,   250,     1,    30,   160,   250,     0,    34,   163,   200, 
    0,    34,   162,   146,     0,    35,   167,    87,     0,    37,   171,    51,     0,    40,   169,    20,     0,    43,   164,     6,     0,    54,   148,     0,     0,    64,   128,     0, 
    0,    70,   113,     0,     0,    75,   102,     0,     0,    80,    93,     0,     0,    84,    87,     0,     0,    83,    88,     0,     0,    44,   102,   251,     0,    49,   109,   251, 
    0,    44,   113,   251,     0,    39,   123,   251,     0,    37,   125,   205,     0,    38,   118,   138,     0,    40,   121,   101,     0,    41,   126,    60,     0,    43,   129,    27, 
    0,    46,   128,    12,     0,    54,   120,     2,     0,    62,   105,     0,     0,    68,    93,     0,     0,    73,    86,     0,     0,    79,    80,     0,     0,    83,    75,     0, 
    0,    84,    74,     0,     0,    42,    77,   252,     0,    45,    82,   251,     0,    44,    86,   251,     0,    40,    89,   244,     0,    41,    88,   198,     0,    41,    87,   138, 
    0,    50,    84,    96,     0,    49,    92,    69,     0,    46,    97,    36,     0,    49,    98,    19,     0,    54,    93,     6,     0,    61,    86,     1,     0,    68,    78,     0, 
    0,    73,    73,     0,     0,    77,    67,     0,     0,    81,    62,     0,     0,    83,    61,     0,     0,    41,    56,   252,     0,    43,    60,   252,     0,    43,    62,   251, 
    0,    41,    64,   243,     0,    43,    65,   201,     0,    44,    65,   146,     0,    49,    65,    93,     0,    52,    67,    73,     0,    50,    71,    49,     0,    48,    76,    28, 
    0,    57,    72,    11,     0,    63,    69,     2,     0,    68,    64,     0,     0,    72,    59,     0,     0,    75,    55,     0,     0,    77,    53,     0,     0,    79,    51,     0, 
    0,    40,    40,   252,     0,    44,    40,   252,     0,    44,    41,   252,     1,    40,    42,   243,     1,    42,    44,   206,     0,    47,    49,   160,     0,    49,    50,   104, 
    0,    53,    52,    76,     0,    52,    54,    56,     0,    52,    55,    35,     0,    60,    53,    16,     0,    66,    51,     5,     0,    70,    50,     0,     0,    72,    47,     0, 
    0,    73,    45,     0,     0,    73,    43,     0,     0,    75,    40,     0,     0,    40,    32,   253,     0,    46,    30,   253,     0,    46,    29,   253,     0,    42,    31,   251, 
    1,    41,    30,   227,     0,    52,    36,   184,     0,    50,    38,   120,     0,    52,    39,    80,     0,    54,    39,    63,     0,    57,    40,    48,     0,    61,    39,    25, 
    0,    70,    38,    11,     0,    75,    36,     3,     0,    76,    35,     0,     0,    75,    33,     0,     0,    73,    32,     0,     0,    73,    29,     0,     0,    48,    22,   253, 
    0,    51,    21,   253,     0,    51,    20,   253,     0,    52,    20,   251,     0,    53,    20,   233,     0,    59,    24,   196,     0,    59,    26,   147,     0,    59,    28,    96, 
    0,    58,    28,    69,     0,    59,    29,    50,     0,    60,    30,    34,     0,    66,    30,    19,     0,    73,    28,     7,     0,    76,    27,     1,     0,    72,    28,     0, 
    0,    70,    28,     0,     0,    69,    27,     0,     0,    52,    15,   253,     0,    56,    14,   253,     0,    57,    14,   253,     0,    59,    13,   251,     0,    61,    14,   230, 
    0,    64,    16,   198,     0,    65,    17,   158,     0,    65,    18,   114,     0,    64,    18,    80,     0,    60,    20,    54,     0,    59,    23,    40,     0,    61,    23,    26, 
    0,    69,    22,    14,     0,    77,    20,     3,     0,    74,    21,     0,     0,    70,    23,     0,     0,    69,    24,     0,     0,    56,     9,   253,     0,    60,     8,   253, 
    0,    63,     8,   253,     0,    66,     8,   250,     0,    68,     9,   226,     0,    68,     9,   196,     0,    69,    10,   160,     0,    68,    10,   119,     0,    67,    11,    85, 
    0,    64,    13,    58,     0,    65,    14,    45,     0,    67,    15,    32,     0,    70,    14,    19,     0,    79,    12,     8,     0,    80,    13,     1,     0,    72,    16,     0, 
    0,    69,    19,     0,     0,    65,     5,   253,     0,    66,     4,   253,     0,    68,     3,   252,     0,    70,     3,   244,     0,    69,     4,   218,     0,    70,     4,   192, 
    0,    69,     5,   158,     0,    69,     5,   121,     0,    69,     5,    91,     0,    70,     5,    66,     0,    73,     5,    51,     0,    77,     5,    37,     0,    79,     6,    24, 
    0,    81,     5,    13,     0,    80,     5,     4,     0,    76,     8,     0,     0,    72,    14,     0,     0,    76,     3,   253,     0,    74,     1,   252,     0,    73,     0,   246, 
    0,    72,     0,   229,     0,    70,     0,   208,     0,    69,     1,   182,     0,    68,     1,   149,     0,    69,     0,   117,     0,    69,     0,    88,     0,    69,     0,    68, 
    0,    72,     0,    55,     0,    76,     0,    42,     0,    78,     0,    29,     0,    80,     0,    19,     0,    81,     0,     9,     0,    79,     1,     2,     0,    77,     9,     0, 
    0,    85,     2,   253,     0,    80,     0,   245,     0,    76,     0,   228,     0,    72,     0,   208,     0,    69,     0,   186,     0,    66,     0,   152,     0,    65,     0,   122, 
    0,    65,     0,    96,     0,    63,     0,    74,     0,    63,     0,    61,     0,    65,     0,    53,     0,    67,     0,    44,     0,    69,     0,    33,     0,    71,     0,    24, 
    0,    72,     0,    15,     0,    73,     0,     7,     0,    82,     5,     0,     0,    93,     0,   253,     0,    90,     0,   241,     0,    86,     0,   227,     0,    83,     0,   211, 
    0,    81,     0,   192,     0,    79,     0,   165,     0,    78,     0,   132,     0,    77,     0,   103,     0,    76,     0,    80,     0,    76,     0,    64,     0,    78,     0,    59, 
    0,    79,     0,    53,     0,    83,     0,    42,     0,    87,     0,    30,     0,    90,     0,    19,     0,    94,     0,     8,     0,    95,     0,     0,    15,     6,   217,   249, 
   15,     3,   225,   247,    16,     1,   227,   227,    13,     0,   233,   203,    12,     0,   237,   163,    10,     0,   243,   103,    11,     0,   249,    47,    12,     0,   252,    16, 
   13,     0,   253,     0,     9,     9,   252,     0,     7,    15,   251,     0,     2,    32,   240,     0,     0,    47,   217,     2,     0,    58,   198,     2,     0,    68,   183,     1, 
    0,    77,   168,     0,     0,    86,   153,     0,    13,    10,   206,   249,    13,    11,   205,   249,    13,     7,   217,   247,    14,     2,   226,   226,     9,     1,   237,   154, 
    7,     2,   242,    91,     6,     5,   245,    39,     7,     5,   248,     8,     4,    14,   243,     1,     0,    25,   232,     2,     0,    31,   214,     1,     0,    41,   199,     0, 
    0,    52,   183,     0,     0,    62,   169,     0,     0,    70,   157,     0,     0,    77,   145,     0,     0,    81,   142,     0,     8,    18,   191,   250,     9,    19,   189,   250, 
   10,    13,   201,   250,    10,     7,   222,   240,     5,    10,   226,   167,     3,    13,   223,   104,     4,    14,   225,    51,     2,    17,   230,    20,     0,    23,   225,     9, 
    0,    25,   214,     1,     0,    32,   199,     0,     0,    43,   180,     0,     0,    54,   164,     0,     0,    63,   150,     0,     0,    69,   136,     0,     0,    73,   127,     0, 
    0,    75,   128,     0,     0,    32,   159,   250,     2,    30,   163,   250,     2,    26,   178,   250,     4,    14,   203,   250,     2,    20,   203,   203,     0,    23,   199,   147, 
    0,    23,   200,    89,     0,    23,   204,    49,     0,    24,   203,    15,     0,    26,   199,     2,     0,    33,   183,     0,     0,    45,   162,     0,     0,    55,   143,     0, 
    0,    63,   129,     0,     0,    67,   118,     0,     0,    71,   110,     0,     0,    71,   113,     0,     0,    33,   127,   251,     0,    36,   135,   251,     0,    33,   145,   250, 
    0,    23,   166,   250,     0,    25,   162,   201,     0,    24,   157,   151,     0,    24,   169,    94,     0,    26,   172,    57,     0,    27,   175,    21,     0,    29,   172,     7, 
    0,    35,   160,     1,     0,    46,   138,     0,     0,    56,   122,     0,     0,    61,   110,     0,     0,    65,   100,     0,     0,    68,    93,     0,     0,    68,    97,     0, 
    0,    33,   101,   251,     0,    35,   107,   251,     0,    33,   113,   251,     0,    26,   122,   251,     0,    26,   120,   203,     0,    26,   125,   147,     0,    29,   119,   105, 
    0,    29,   127,    65,     0,    30,   133,    31,     0,    32,   135,    14,     0,    36,   132,     3,     0,    46,   116,     0,     0,    54,   102,     0,     0,    59,    92,     0, 
    0,    63,    85,     0,     0,    67,    81,     0,     0,    67,    83,     0,     0,    34,    79,   252,     0,    35,    83,   252,     0,    33,    86,   252,     0,    28,    90,   247, 
    0,    29,    90,   201,     0,    29,    91,   144,     0,    32,    91,   102,     0,    34,    99,    74,     0,    34,   104,    41,     0,    34,   105,    21,     0,    37,   104,     8, 
    0,    45,    95,     1,     0,    52,    85,     0,     0,    58,    78,     0,     0,    63,    72,     0,     0,    67,    68,     0,     0,    68,    68,     0,     0,    33,    59,   252, 
    0,    34,    62,   252,     0,    32,    63,   251,     0,    29,    65,   236,     0,    31,    66,   197,     0,    34,    69,   144,     0,    34,    70,   102,     0,    40,    69,    74, 
    0,    39,    75,    53,     0,    34,    80,    32,     0,    39,    80,    13,     0,    45,    77,     3,     0,    52,    70,     0,     0,    58,    64,     0,     0,    62,    59,     0, 
    0,    66,    56,     0,     0,    69,    55,     0,     0,    33,    44,   253,     0,    34,    43,   253,     0,    33,    44,   251,     0,    29,    46,   234,     0,    35,    51,   191, 
    0,    35,    51,   144,     0,    36,    52,   103,     0,    41,    53,    72,     0,    43,    54,    57,     0,    39,    58,    39,     0,    43,    60,    18,     0,    47,    60,     6, 
    0,    52,    57,     1,     0,    57,    52,     0,     0,    61,    49,     0,     0,    63,    46,     0,     0,    66,    44,     0,     0,    31,    31,   253,     0,    34,    31,   253, 
    0,    33,    30,   253,     1,    30,    32,   243,     1,    35,    36,   208,     0,    35,    38,   172,     0,    36,    39,   120,     0,    40,    40,    80,     0,    42,    41,    60, 
    0,    41,    43,    46,     0,    44,    44,    25,     0,    50,    44,    11,     0,    55,    42,     2,     0,    58,    40,     0,     0,    59,    38,     0,     0,    60,    36,     0, 
    0,    62,    34,     0,     0,    31,    23,   253,     0,    35,    22,   253,     0,    35,    21,   253,     0,    35,    21,   251,     0,    37,    22,   226,     0,    41,    25,   190, 
    0,    39,    26,   142,     0,    42,    29,    93,     0,    43,    30,    64,     0,    43,    31,    50,     0,    42,    30,    37,     0,    51,    32,    18,     0,    58,    30,     6, 
    0,    61,    29,     0,     0,    60,    28,     0,     0,    59,    27,     0,     0,    59,    24,     0,     0,    37,    16,   253,     0,    40,    15,   253,     0,    41,    15,   253, 
    0,    42,    15,   252,     0,    42,    15,   231,     0,    48,    18,   200,     0,    47,    19,   159,     0,    48,    20,   114,     0,    48,    22,    76,     0,    45,    23,    54, 
    0,    46,    23,    39,     0,    50,    24,    25,     0,    55,    24,    12,     0,    61,    22,     3,     0,    60,    22,     0,     0,    57,    23,     0,     0,    56,    23,     0, 
    0,    41,    10,   254,     0,    44,     9,   254,     0,    47,     9,   254,     0,    48,     9,   250,     0,    51,    10,   227,     0,    52,    10,   199,     0,    53,    12,   163, 
    0,    53,    11,   121,     0,    53,    13,    87,     0,    50,    16,    59,     0,    48,    17,    43,     0,    50,    17,    31,     0,    52,    17,    19,     0,    58,    17,     9, 
    0,    62,    16,     1,     0,    58,    17,     0,     0,    57,    19,     0,     0,    47,     6,   254,     0,    50,     5,   254,     0,    52,     4,   253,     0,    54,     5,   242, 
    0,    55,     5,   219,     0,    56,     5,   194,     0,    56,     6,   161,     0,    56,     6,   124,     0,    57,     6,    93,     0,    56,     7,    68,     0,    54,     9,    48, 
    0,    55,     9,    37,     0,    57,    10,    25,     0,    58,     9,    14,     0,    65,     8,     4,     0,    61,    10,     0,     0,    59,    14,     0,     0,    56,     4,   254, 
    0,    57,     1,   253,     0,    57,     1,   250,     0,    58,     1,   232,     0,    57,     1,   211,     0,    58,     1,   186,     0,    57,     1,   154,     0,    57,     1,   122, 
    0,    58,     1,    94,     0,    58,     1,    70,     0,    59,     2,    54,     0,    61,     2,    42,     0,    63,     2,    29,     0,    65,     2,    19,     0,    67,     1,     8, 
    0,    65,     2,     1,     0,    63,     9,     0,     0,    65,     2,   253,     0,    63,     0,   246,     0,    61,     0,   230,     0,    60,     0,   209,     0,    59,     0,   188, 
    0,    57,     0,   158,     0,    56,     0,   127,     0,    56,     0,   101,     0,    55,     0,    79,     0,    54,     0,    63,     0,    55,     0,    51,     0,    56,     0,    42, 
    0,    58,     0,    33,     0,    59,     0,    23,     0,    60,     0,    15,     0,    62,     0,     7,     0,    68,     5,     0,     0,    75,     0,   253,     0,    72,     0,   245, 
    0,    70,     0,   233,     0,    69,     0,   219,     0,    67,     0,   201,     0,    66,     0,   175,     0,    64,     0,   139,     0,    64,     0,   109,     0,    64,     0,    85, 
    0,    63,     0,    67,     0,    64,     0,    54,     0,    65,     0,    49,     0,    67,     0,    42,     0,    71,     0,    30,     0,    74,     0,    20,     0,    78,     0,     9, 
    0,    80,     0,     0,     7,     9,   211,   250,     7,     6,   219,   248,     9,     2,   227,   233,     8,     0,   232,   211,     8,     0,   236,   181,     7,     0,   241,   130, 
    8,     0,   247,    72,     9,     0,   250,    32,    10,     0,   252,    11,    10,     1,   253,     0,     7,     9,   252,     0,     6,    13,   251,     0,     1,    28,   238,     0, 
    0,    40,   216,     1,     0,    50,   196,     0,     0,    60,   182,     0,     0,    70,   167,     0,     5,    12,   205,   250,     6,    13,   203,   250,     6,     9,   213,   249, 
    8,     4,   226,   235,     6,     0,   236,   175,     4,     0,   239,   111,     3,     3,   239,    62,     3,     4,   243,    24,     1,    13,   238,    11,     0,    17,   234,     4, 
    0,    21,   222,     1,     0,    26,   209,     1,     0,    35,   195,     0,     0,    45,   180,     0,     0,    54,   168,     0,     0,    62,   158,     0,     0,    66,   156,     0, 
    2,    19,   193,   250,     3,    20,   190,   250,     4,    14,   202,   250,     4,    10,   219,   241,     2,     8,   224,   180,     0,    13,   220,   122,     0,    13,   220,    73, 
    0,    13,   225,    34,     0,    14,   220,    14,     0,    16,   215,     3,     0,    21,   205,     0,     0,    28,   192,     0,     0,    36,   175,     0,     0,    47,   160,     0, 
    0,    56,   147,     0,     0,    60,   138,     0,     0,    63,   142,     0,     0,    23,   166,   250,     0,    24,   167,   250,     1,    20,   181,   250,     1,    13,   197,   247, 
    0,    15,   200,   209,     0,    14,   197,   158,     0,    14,   201,   101,     0,    14,   203,    57,     0,    15,   204,    19,     0,    17,   201,     4,     0,    23,   190,     0, 
    0,    29,   173,     0,     0,    39,   153,     0,     0,    48,   137,     0,     0,    54,   127,     0,     0,    59,   119,     0,     0,    60,   126,     0,     0,    23,   131,   251, 
    0,    25,   135,   251,     0,    21,   146,   251,     0,    15,   162,   251,     0,    15,   157,   201,     0,    15,   157,   155,     0,    15,   177,   102,     0,    16,   181,    63, 
    0,    17,   181,    25,     0,    19,   180,     8,     0,    23,   169,     1,     0,    31,   150,     0,     0,    40,   131,     0,     0,    47,   118,     0,     0,    52,   108,     0, 
    0,    56,   101,     0,     0,    57,   109,     0,     0,    24,   101,   252,     0,    25,   106,   252,     0,    22,   112,   252,     0,    18,   122,   252,     0,    19,   117,   200, 
    0,    14,   128,   156,     0,    20,   121,   109,     0,    20,   131,    73,     0,    21,   139,    35,     0,    21,   140,    15,     0,    24,   139,     4,     0,    31,   127,     0, 
    0,    39,   111,     0,     0,    45,   100,     0,     0,    51,    92,     0,     0,    55,    86,     0,     0,    55,    92,     0,     0,    25,    80,   252,     0,    25,    83,   252, 
    0,    22,    85,   252,     0,    20,    89,   246,     0,    21,    91,   197,     0,    18,    92,   150,     0,    22,    91,   103,     0,    23,   100,    78,     0,    24,   107,    44, 
    0,    24,   109,    23,     0,    25,   109,     9,     0,    30,   105,     1,     0,    37,    94,     0,     0,    44,    84,     0,     0,    50,    77,     0,     0,    54,    73,     0, 
    0,    54,    77,     0,     0,    25,    62,   253,     0,    24,    63,   253,     0,    22,    65,   253,     0,    21,    66,   233,     0,    24,    67,   194,     0,    25,    71,   146, 
    0,    25,    72,   104,     0,    24,    74,    79,     0,    25,    80,    55,     0,    25,    84,    36,     0,    26,    85,    15,     0,    29,    86,     4,     0,    36,    78,     0, 
    0,    43,    70,     0,     0,    49,    64,     0,     0,    53,    60,     0,     0,    54,    63,     0,     0,    25,    47,   253,     0,    24,    48,   253,     0,    23,    48,   249, 
    0,    25,    50,   222,     0,    27,    53,   192,     0,    26,    53,   143,     0,    26,    54,   104,     0,    28,    58,    77,     0,    31,    54,    55,     0,    30,    60,    42, 
    0,    29,    65,    21,     0,    31,    66,     9,     0,    36,    63,     1,     0,    43,    57,     0,     0,    48,    53,     0,     0,    52,    50,     0,     0,    55,    50,     0, 
    0,    25,    34,   253,     0,    23,    35,   253,     0,    23,    35,   250,     0,    23,    36,   230,     0,    29,    40,   197,     0,    26,    39,   166,     0,    27,    41,   112, 
    0,    28,    37,    77,     0,    31,    42,    57,     0,    32,    44,    46,     0,    30,    48,    31,     0,    32,    49,    19,     0,    39,    47,     8,     0,    43,    46,     1, 
    0,    47,    42,     0,     0,    50,    39,     0,     0,    53,    38,     0,     0,    23,    23,   253,     0,    25,    22,   254,     0,    25,    22,   253,     0,    27,    23,   244, 
    0,    31,    26,   215,     0,    27,    28,   179,     0,    26,    30,   131,     0,    28,    32,    93,     0,    30,    31,    61,     0,    32,    34,    47,     0,    32,    36,    36, 
    0,    34,    37,    22,     0,    41,    34,    10,     0,    45,    33,     1,     0,    46,    32,     0,     0,    47,    30,     0,     0,    49,    29,     0,     0,    23,    17,   254, 
    0,    26,    16,   254,     0,    27,    16,   254,     0,    28,    16,   251,     0,    30,    17,   228,     0,    30,    20,   199,     0,    27,    20,   157,     0,    29,    21,   110, 
    0,    31,    22,    71,     0,    31,    23,    50,     0,    33,    24,    39,     0,    35,    24,    30,     0,    42,    24,    12,     0,    47,    24,     2,     0,    48,    23,     0, 
    0,    47,    22,     0,     0,    46,    20,     0,     0,    27,    11,   254,     0,    30,    11,   254,     0,    32,    10,   254,     0,    34,    10,   251,     0,    37,    12,   229, 
    0,    37,    12,   201,     0,    36,    12,   164,     0,    36,    13,   122,     0,    38,    15,    89,     0,    38,    16,    59,     0,    37,    18,    43,     0,    38,    18,    30, 
    0,    41,    18,    17,     0,    45,    18,     7,     0,    48,    17,     1,     0,    46,    18,     0,     0,    46,    18,     0,     0,    34,     7,   254,     0,    35,     6,   254, 
    0,    37,     6,   253,     0,    39,     6,   245,     0,    41,     7,   222,     0,    43,     7,   198,     0,    42,     7,   166,     0,    42,     7,   127,     0,    43,     8,    96, 
    0,    44,     8,    70,     0,    42,    11,    49,     0,    40,    12,    34,     0,    42,    12,    23,     0,    42,    12,    13,     0,    47,    12,     5,     0,    47,    12,     0, 
    0,    47,    14,     0,     0,    41,     4,   254,     0,    42,     2,   253,     0,    42,     2,   250,     0,    44,     2,   232,     0,    45,     2,   211,     0,    46,     2,   190, 
    0,    45,     2,   157,     0,    46,     2,   124,     0,    47,     2,    96,     0,    47,     2,    72,     0,    47,     3,    55,     0,    45,     5,    39,     0,    46,     5,    29, 
    0,    47,     5,    18,     0,    47,     5,     8,     0,    50,     5,     1,     0,    50,    10,     0,     0,    49,     2,   254,     0,    49,     0,   245,     0,    49,     0,   231, 
    0,    48,     0,   209,     0,    48,     0,   187,     0,    47,     0,   161,     0,    46,     0,   129,     0,    46,     0,   104,     0,    46,     0,    83,     0,    46,     0,    66, 
    0,    46,     0,    52,     0,    46,     0,    40,     0,    48,     1,    32,     0,    49,     1,    23,     0,    49,     1,    14,     0,    50,     1,     5,     0,    55,     5,     0, 
    0,    58,     0,   254,     0,    57,     0,   246,     0,    56,     0,   236,     0,    56,     0,   223,     0,    55,     0,   205,     0,    55,     0,   179,     0,    54,     0,   143, 
    0,    53,     0,   113,     0,    53,     0,    89,     0,    53,     0,    69,     0,    53,     0,    56,     0,    53,     0,    45,     0,    55,     0,    40,     0,    57,     0,    31, 
    0,    60,     0,    20,     0,    62,     0,     9,     0,    65,     0,     0,     2,    10,   207,   250,     1,     9,   214,   249,     6,     0,   228,   241,     6,     0,   231,   219, 
    5,     0,   235,   194,     5,     0,   239,   154,     5,     0,   244,   100,     6,     0,   249,    53,     7,     0,   251,    25,     8,     0,   253,     9,     8,     0,   254,     0, 
    6,     7,   253,     0,     4,    11,   252,     0,     1,    25,   237,     0,     0,    35,   214,     0,     0,    45,   195,     0,     0,    55,   181,     0,     2,    10,   201,   250, 
    1,    10,   208,   250,     4,     1,   224,   247,     3,     0,   230,   225,     2,     0,   234,   189,     2,     0,   234,   131,     2,     0,   234,    83,     1,     3,   236,    44, 
    0,     8,   235,    22,     0,    12,   232,     9,     0,    13,   227,     2,     0,    17,   217,     1,     0,    22,   208,     1,     0,    30,   195,     0,     0,    38,   180,     0, 
    0,    47,   170,     0,     0,    52,   170,     0,     0,    14,   191,   250,     1,    12,   197,   250,     0,     8,   212,   248,     3,     0,   222,   227,     1,     3,   222,   189, 
    0,     5,   217,   134,     0,     6,   216,    84,     0,     6,   218,    46,     0,     7,   219,    21,     0,     9,   215,     7,     0,    13,   210,     1,     0,    19,   200,     0, 
    0,    24,   189,     0,     0,    32,   173,     0,     0,    41,   158,     0,     0,    47,   150,     0,     0,    49,   156,     0,     0,    15,   165,   251,     0,    15,   173,   251, 
    0,    12,   189,   250,     0,     8,   197,   246,     0,     7,   197,   212,     0,     7,   195,   166,     0,     7,   201,    93,     0,     7,   203,    53,     0,     8,   204,    24, 
    0,     9,   203,     7,     0,    14,   195,     0,     0,    20,   181,     0,     0,    26,   165,     0,     0,    34,   148,     0,     0,    40,   137,     0,     0,    46,   130,     0, 
    0,    47,   139,     0,     0,    16,   133,   251,     0,    16,   139,   251,     0,    13,   150,   251,     0,     9,   158,   247,     0,     7,   152,   203,     0,     8,   159,   159, 
    0,     8,   180,    95,     0,     9,   183,    59,     0,     9,   183,    28,     0,    10,   184,    10,     0,    14,   177,     1,     0,    21,   157,     0,     0,    27,   141,     0, 
    0,    33,   128,     0,     0,    39,   118,     0,     0,    45,   111,     0,     0,    46,   121,     0,     0,    17,   104,   252,     0,    18,   106,   252,     0,    15,   112,   252, 
    0,    11,   122,   251,     0,    11,   116,   200,     0,     8,   126,   156,     0,    12,   127,   111,     0,    12,   132,    77,     0,    13,   140,    40,     0,    13,   144,    19, 
    0,    15,   144,     6,     0,    20,   135,     1,     0,    26,   122,     0,     0,    32,   109,     0,     0,    38,    99,     0,     0,    43,    93,     0,     0,    43,   103,     0, 
    0,    18,    80,   252,     0,    18,    82,   252,     0,    16,    84,   252,     0,    14,    89,   240,     0,    14,    90,   193,     0,    11,    92,   153,     0,    13,    92,   106, 
    0,    15,   100,    80,     0,    15,   108,    48,     0,    15,   111,    27,     0,    15,   113,    11,     0,    19,   113,     2,     0,    25,   103,     0,     0,    31,    92,     0, 
    0,    37,    84,     0,     0,    42,    79,     0,     0,    42,    87,     0,     0,    19,    63,   253,     0,    17,    63,   253,     0,    16,    65,   253,     0,    16,    65,   226, 
    0,    16,    68,   190,     0,    16,    72,   147,     0,    17,    74,   105,     0,    15,    75,    81,     0,    16,    81,    60,     0,    16,    87,    39,     0,    17,    89,    17, 
    0,    18,    92,     5,     0,    23,    87,     0,     0,    30,    77,     0,     0,    36,    69,     0,     0,    41,    65,     0,     0,    40,    72,     0,     0,    19,    48,   253, 
    0,    18,    49,   253,     0,    17,    49,   248,     0,    20,    51,   217,     0,    21,    54,   188,     0,    18,    55,   144,     0,    19,    56,   107,     0,    20,    60,    79, 
    0,    20,    61,    58,     0,    19,    66,    44,     0,    19,    70,    23,     0,    19,    72,     9,     0,    23,    71,     2,     0,    30,    63,     0,     0,    36,    57,     0, 
    0,    39,    54,     0,     0,    40,    58,     0,     0,    19,    35,   253,     0,    18,    36,   252,     0,    17,    37,   242,     0,    20,    39,   218,     0,    21,    41,   190, 
    0,    19,    40,   148,     0,    20,    44,   109,     0,    21,    44,    78,     0,    22,    47,    59,     0,    25,    47,    47,     0,    23,    50,    34,     0,    22,    52,    22, 
    0,    26,    52,    10,     0,    31,    51,     1,     0,    35,    47,     0,     0,    38,    44,     0,     0,    40,    45,     0,     0,    18,    25,   254,     0,    19,    24,   254, 
    0,    19,    24,   251,     0,    22,    26,   232,     0,    23,    28,   204,     0,    20,    31,   168,     0,    21,    31,   108,     0,    21,    30,    79,     0,    22,    33,    58, 
    0,    25,    37,    45,     0,    26,    38,    34,     0,    25,    39,    25,     0,    28,    39,    14,     0,    31,    39,     4,     0,    34,    36,     0,     0,    37,    33,     0, 
    0,    40,    33,     0,     0,    17,    17,   254,     0,    19,    17,   254,     0,    20,    17,   253,     0,    22,    18,   243,     0,    26,    20,   217,     0,    20,    22,   182, 
    0,    19,    23,   146,     0,    21,    24,   101,     0,    22,    24,    70,     0,    24,    26,    49,     0,    26,    28,    37,     0,    25,    29,    29,     0,    29,    27,    15, 
    0,    32,    27,     5,     0,    35,    26,     0,     0,    36,    24,     0,     0,    38,    24,     0,     0,    17,    13,   254,     0,    20,    12,   254,     0,    21,    11,   254, 
    0,    23,    11,   251,     0,    26,    13,   227,     0,    25,    13,   198,     0,    23,    13,   162,     0,    22,    14,   119,     0,    23,    15,    86,     0,    25,    17,    57, 
    0,    26,    18,    40,     0,    26,    19,    30,     0,    27,    19,    23,     0,    33,    18,     7,     0,    36,    18,     1,     0,    36,    17,     0,     0,    35,    16,     0, 
    0,    22,     8,   254,     0,    24,     7,   254,     0,    25,     6,   254,     0,    26,     6,   251,     0,    30,     8,   227,     0,    29,     8,   202,     0,    28,     8,   170, 
    0,    27,     8,   129,     0,    29,     9,    97,     0,    30,    10,    71,     0,    30,    11,    49,     0,    29,    13,    34,     0,    31,    13,    23,     0,    33,    12,    11, 
    0,    36,    13,     3,     0,    36,    13,     0,     0,    36,    13,     0,     0,    28,     5,   254,     0,    29,     3,   254,     0,    30,     2,   252,     0,    30,     2,   243, 
    0,    32,     3,   217,     0,    32,     3,   196,     0,    32,     3,   166,     0,    32,     3,   127,     0,    34,     3,    98,     0,    35,     4,    74,     0,    35,     4,    57, 
    0,    33,     6,    39,     0,    33,     7,    26,     0,    33,     7,    17,     0,    34,     7,     7,     0,    36,     7,     1,     0,    38,    10,     0,     0,    35,     2,   254, 
    0,    35,     0,   249,     0,    35,     0,   240,     0,    35,     0,   224,     0,    35,     0,   194,     0,    36,     0,   167,     0,    35,     0,   137,     0,    35,     0,   108, 
    0,    36,     0,    87,     0,    37,     0,    69,     0,    37,     0,    55,     0,    37,     1,    42,     0,    37,     1,    30,     0,    38,     1,    22,     0,    38,     1,    12, 
    0,    38,     1,     3,     0,    42,     5,     0,     0,    43,     0,   254,     0,    42,     0,   247,     0,    42,     0,   239,     0,    42,     0,   228,     0,    43,     0,   211, 
    0,    43,     0,   181,     0,    42,     0,   148,     0,    42,     0,   117,     0,    43,     0,    92,     0,    43,     0,    71,     0,    43,     0,    57,     0,    43,     0,    46, 
    0,    43,     0,    37,     0,    45,     0,    31,     0,    47,     0,    21,     0,    49,     0,    10,     0,    50,     0,     0,     0,     9,   207,   250,     0,     7,   213,   250, 
    4,     0,   227,   247,     4,     0,   230,   227,     3,     0,   234,   205,     4,     0,   237,   172,     4,     0,   242,   123,     4,     0,   247,    74,     4,     0,   250,    41, 
    6,     0,   252,    20,     6,     0,   253,     8,     6,     0,   254,     0,     4,     6,   253,     0,     3,     9,   253,     0,     0,    22,   235,     0,     0,    31,   213,     0, 
    0,    40,   194,     0,     0,     9,   200,   250,     0,     6,   207,   250,     2,     0,   221,   249,     1,     0,   225,   228,     0,     0,   225,   195,     0,     1,   224,   144, 
    0,     1,   227,   100,     0,     1,   231,    62,     0,     3,   233,    32,     0,     6,   230,    17,     0,     8,   228,     7,     0,    10,   223,     2,     0,    14,   216,     1, 
    0,    18,   208,     1,     0,    25,   197,     0,     0,    33,   184,     0,     0,    37,   184,     0,     0,    10,   189,   250,     0,     7,   195,   250,     0,     3,   210,   247, 
    0,     1,   214,   223,     0,     0,   212,   190,     0,     0,   207,   138,     0,     0,   211,    93,     0,     1,   214,    60,     0,     2,   216,    31,     0,     4,   215,    13, 
    0,     6,   212,     3,     0,    11,   205,     0,     0,    16,   196,     0,     0,    21,   187,     0,     0,    28,   173,     0,     0,    33,   164,     0,     0,    36,   171,     0, 
    0,    10,   164,   251,     0,     8,   169,   251,     0,     5,   186,   250,     0,     3,   192,   241,     0,     2,   191,   210,     0,     1,   191,   166,     0,     1,   199,    96, 
    0,     1,   200,    61,     0,     2,   202,    32,     0,     3,   203,    13,     0,     6,   200,     2,     0,    13,   188,     0,     0,    18,   175,     0,     0,    23,   162,     0, 
    0,    28,   151,     0,     0,    33,   142,     0,     0,    34,   155,     0,     0,    12,   135,   252,     0,    10,   138,   252,     0,     7,   149,   251,     0,     4,   155,   244, 
    0,     3,   154,   202,     0,     2,   158,   159,     0,     1,   179,    95,     0,     2,   182,    63,     0,     3,   182,    36,     0,     3,   185,    16,     0,     5,   183,     3, 
    0,    11,   168,     0,     0,    17,   152,     0,     0,    22,   139,     0,     0,    27,   129,     0,     0,    33,   121,     0,     0,    34,   136,     0,     0,    13,   106,   252, 
    0,    12,   106,   252,     0,    10,   112,   252,     0,     7,   120,   241,     0,     5,   120,   200,     0,     4,   123,   156,     0,     5,   125,   111,     0,     6,   130,    82, 
    0,     6,   139,    47,     0,     6,   145,    25,     0,     6,   148,    10,     0,     9,   144,     1,     0,    16,   131,     0,     0,    21,   119,     0,     0,    27,   108,     0, 
    0,    32,   101,     0,     0,    33,   116,     0,     0,    13,    82,   253,     0,    12,    82,   253,     0,    10,    86,   251,     0,     9,    90,   234,     0,     8,    92,   197, 
    0,     5,    94,   158,     0,     6,    92,   105,     0,     8,    98,    83,     0,     8,   107,    54,     0,     8,   113,    32,     0,     8,   116,    16,     0,     9,   117,     4, 
    0,    14,   110,     0,     0,    20,   101,     0,     0,    27,    91,     0,     0,    32,    85,     0,     0,    32,    97,     0,     0,    14,    63,   253,     0,    12,    63,   253, 
    0,    10,    64,   253,     0,    11,    65,   224,     0,    10,    68,   192,     0,    10,    71,   149,     0,    10,    73,   107,     0,     9,    76,    83,     0,     9,    82,    64, 
    0,     8,    89,    44,     0,     9,    93,    22,     0,     9,    95,     7,     0,    13,    93,     1,     0,    19,    85,     0,     0,    26,    76,     0,     0,    31,    70,     0, 
    0,    31,    81,     0,     0,    14,    49,   253,     0,    12,    49,   253,     0,    11,    50,   246,     0,    12,    52,   215,     0,    14,    55,   186,     0,    11,    56,   145, 
    0,    12,    58,   109,     0,    12,    61,    81,     0,    12,    62,    61,     0,    10,    69,    47,     0,    10,    74,    26,     0,     9,    76,    11,     0,    12,    77,     1, 
    0,    18,    70,     0,     0,    26,    62,     0,     0,    30,    58,     0,     0,    30,    65,     0,     0,    14,    36,   253,     0,    13,    37,   253,     0,    13,    38,   244, 
    0,    14,    41,   214,     0,    15,    43,   186,     0,    13,    43,   144,     0,    14,    45,   109,     0,    14,    48,    81,     0,    14,    50,    62,     0,    14,    52,    47, 
    0,    13,    55,    34,     0,    12,    58,    22,     0,    13,    60,     6,     0,    19,    57,     1,     0,    25,    51,     0,     0,    29,    48,     0,     0,    30,    53,     0, 
    0,    13,    26,   254,     0,    14,    25,   254,     0,    14,    26,   250,     0,    15,    29,   218,     0,    14,    32,   186,     0,    13,    33,   166,     0,    14,    33,   109, 
    0,    15,    35,    82,     0,    14,    40,    63,     0,    16,    39,    46,     0,    19,    39,    35,     0,    17,    42,    26,     0,    16,    44,    13,     0,    20,    45,     5, 
    0,    25,    41,     0,     0,    29,    38,     0,     0,    29,    42,     0,     0,    13,    19,   254,     0,    14,    18,   254,     0,    15,    18,   253,     0,    17,    21,   235, 
    0,    15,    23,   200,     0,    14,    24,   170,     0,    13,    24,   129,     0,    15,    26,    92,     0,    16,    26,    65,     0,    17,    28,    48,     0,    20,    31,    37, 
    0,    20,    32,    28,     0,    18,    33,    19,     0,    19,    34,    10,     0,    25,    32,     1,     0,    28,    29,     0,     0,    29,    30,     0,     0,    13,    13,   254, 
    0,    14,    12,   254,     0,    15,    12,   254,     0,    17,    13,   247,     0,    19,    14,   217,     0,    17,    15,   189,     0,    15,    15,   154,     0,    14,    18,   112, 
    0,    15,    19,    79,     0,    17,    20,    56,     0,    19,    21,    39,     0,    20,    22,    27,     0,    19,    23,    20,     0,    21,    23,    10,     0,    25,    22,     1, 
    0,    27,    20,     0,     0,    28,    20,     0,     0,    12,     9,   254,     0,    15,     8,   254,     0,    16,     7,   254,     0,    17,     7,   251,     0,    20,     8,   228, 
    0,    19,     9,   201,     0,    17,     9,   170,     0,    13,    10,   130,     0,    15,    11,    94,     0,    16,    11,    68,     0,    18,    12,    46,     0,    19,    14,    31, 
    0,    20,    14,    21,     0,    20,    14,    17,     0,    26,    14,     2,     0,    27,    13,     0,     0,    26,    12,     0,     0,    18,     5,   254,     0,    19,     4,   254, 
    0,    20,     3,   254,     0,    20,     3,   249,     0,    22,     4,   229,     0,    22,     4,   204,     0,    22,     4,   176,     0,    21,     5,   136,     0,    22,     5,   102, 
    0,    22,     5,    77,     0,    24,     6,    58,     0,    24,     7,    39,     0,    23,     8,    25,     0,    24,     8,    17,     0,    25,     8,     6,     0,    27,     8,     1, 
    0,    27,     9,     0,     0,    24,     2,   254,     0,    25,     1,   252,     0,    24,     0,   246,     0,    25,     0,   236,     0,    25,     0,   219,     0,    25,     0,   191, 
    0,    25,     0,   158,     0,    26,     0,   125,     0,    26,     1,    98,     0,    27,     1,    77,     0,    28,     1,    60,     0,    29,     1,    46,     0,    27,     2,    31, 
    0,    29,     2,    21,     0,    29,     2,    11,     0,    29,     2,     2,     0,    31,     5,     0,     0,    30,     0,   254,     0,    30,     0,   248,     0,    30,     0,   241, 
    0,    30,     0,   233,     0,    30,     0,   219,     0,    30,     0,   187,     0,    31,     0,   153,     0,    31,     0,   122,     0,    31,     0,    96,     0,    32,     0,    75, 
    0,    32,     0,    60,     0,    32,     0,    48,     0,    32,     0,    37,     0,    33,     0,    29,     0,    35,     0,    21,     0,    36,     0,    11,     0,    37,     0,     0, 
    0,     6,   210,   250,     0,     5,   213,   250,     2,     0,   224,   248,     2,     0,   230,   231,     1,     0,   233,   211,     2,     0,   236,   184,     2,     0,   240,   144, 
    2,     0,   245,    96,     2,     0,   249,    59,     3,     0,   251,    33,     4,     0,   253,    18,     4,     0,   254,     8,     4,     0,   254,     0,     3,     4,   254,     0, 
    2,     6,   253,     0,     0,    18,   234,     0,     0,    28,   212,     0,     0,     6,   200,   250,     0,     3,   206,   250,     0,     1,   215,   244,     0,     0,   215,   221, 
    0,     0,   215,   195,     0,     0,   213,   148,     0,     0,   218,   109,     0,     0,   223,    76,     0,     1,   227,    46,     0,     1,   230,    25,     0,     3,   229,    13, 
    0,     5,   227,     4,     0,     7,   222,     1,     0,    10,   216,     0,     0,    14,   211,     0,     0,    21,   202,     0,     0,    25,   201,     0,     0,     7,   186,   251, 
    0,     4,   192,   250,     0,     0,   200,   237,     0,     0,   199,   207,     0,     0,   198,   183,     0,     0,   199,   135,     0,     0,   203,    99,     0,     0,   207,    70, 
    0,     0,   210,    43,     0,     0,   213,    21,     0,     2,   213,     9,     0,     5,   210,     1,     0,    10,   203,     0,     0,    14,   196,     0,     0,    17,   189,     0, 
    0,    22,   182,     0,     0,    24,   190,     0,     0,     7,   163,   251,     0,     4,   165,   251,     0,     1,   177,   241,     0,     0,   177,   206,     0,     0,   177,   170, 
    0,     0,   183,   130,     0,     0,   191,    92,     0,     0,   192,    66,     0,     0,   194,    44,     0,     0,   198,    23,     0,     1,   199,     8,     0,     4,   195,     1, 
    0,     9,   186,     0,     0,    13,   177,     0,     0,    17,   167,     0,     0,    22,   159,     0,     0,    24,   175,     0,     0,     7,   136,   252,     0,     5,   138,   252, 
    0,     2,   147,   247,     0,     1,   149,   214,     0,     0,   149,   166,     0,     0,   154,   131,     0,     0,   170,    93,     0,     0,   173,    66,     0,     0,   176,    45, 
    0,     0,   178,    25,     0,     0,   182,    10,     0,     3,   178,     1,     0,     8,   164,     0,     0,    12,   152,     0,     0,    16,   142,     0,     0,    22,   134,     0, 
    0,    23,   155,     0,     0,     8,   108,   252,     0,     7,   109,   252,     0,     4,   116,   249,     0,     3,   119,   220,     0,     2,   121,   180,     0,     0,   120,   145, 
    0,     1,   121,   109,     0,     1,   127,    85,     0,     1,   137,    54,     0,     1,   143,    31,     0,     1,   149,    15,     0,     1,   150,     3,     0,     7,   139,     0, 
    0,    12,   128,     0,     0,    16,   119,     0,     0,    22,   112,     0,     0,    23,   132,     0,     0,     8,    84,   253,     0,     7,    85,   253,     0,     5,    89,   250, 
    0,     5,    91,   223,     0,     3,    94,   189,     0,     1,    95,   153,     0,     1,    92,   106,     0,     2,    98,    85,     0,     2,   106,    59,     0,     2,   113,    38, 
    0,     2,   118,    21,     0,     2,   121,     8,     0,     5,   117,     1,     0,    11,   107,     0,     0,    16,    99,     0,     0,    22,    93,     0,     0,    22,   110,     0, 
    0,     9,    64,   253,     0,     7,    64,   253,     0,     5,    65,   248,     0,     5,    66,   222,     0,     5,    69,   191,     0,     4,    71,   151,     0,     3,    73,   107, 
    0,     3,    77,    84,     0,     3,    82,    65,     0,     2,    89,    49,     0,     3,    95,    26,     0,     3,    98,    12,     0,     4,    98,     1,     0,    10,    90,     0, 
    0,    16,    82,     0,     0,    22,    77,     0,     0,    22,    91,     0,     0,     9,    50,   253,     0,     7,    50,   253,     0,     5,    51,   243,     0,     5,    52,   213, 
    0,     6,    55,   184,     0,     5,    57,   144,     0,     5,    58,   108,     0,     5,    61,    83,     0,     6,    62,    63,     0,     4,    69,    51,     0,     3,    77,    30, 
    0,     3,    79,    16,     0,     3,    80,     3,     0,     9,    75,     0,     0,    15,    68,     0,     0,    21,    63,     0,     0,    21,    74,     0,     0,     9,    38,   253, 
    0,     7,    38,   253,     0,     7,    39,   245,     0,     8,    41,   210,     0,     8,    43,   180,     0,     7,    44,   140,     0,     7,    46,   109,     0,     7,    49,    84, 
    0,     8,    51,    63,     0,     7,    54,    48,     0,     5,    58,    36,     0,     4,    62,    25,     0,     4,    65,     8,     0,     8,    62,     0,     0,    15,    56,     0, 
    0,    21,    52,     0,     0,    21,    60,     0,     0,     9,    27,   254,     0,     9,    27,   254,     0,     9,    27,   250,     0,     8,    31,   213,     0,     8,    33,   170, 
    0,     8,    33,   138,     0,     8,    36,   107,     0,     9,    37,    83,     0,     7,    41,    64,     0,     9,    40,    47,     0,    10,    41,    36,     0,     8,    46,    26, 
    0,     7,    50,    14,     0,     8,    51,     2,     0,    15,    46,     0,     0,    21,    42,     0,     0,    21,    49,     0,     0,     9,    20,   254,     0,    10,    19,   254, 
    0,    10,    20,   251,     0,    11,    23,   224,     0,     9,    25,   187,     0,     8,    26,   160,     0,     8,    26,   124,     0,     9,    28,    89,     0,     9,    30,    64, 
    0,    10,    30,    47,     0,    13,    33,    36,     0,    14,    33,    27,     0,    12,    36,    20,     0,    10,    37,    10,     0,    14,    37,     1,     0,    20,    33,     0, 
    0,    20,    38,     0,     0,     9,    15,   254,     0,    10,    13,   254,     0,    10,    13,   253,     0,    14,    15,   241,     0,    12,    16,   213,     0,    11,    17,   179, 
    0,     8,    17,   146,     0,     8,    20,   102,     0,    11,    21,    65,     0,    12,    22,    48,     0,    13,    23,    37,     0,    15,    25,    26,     0,    16,    25,    19, 
    0,    14,    26,    13,     0,    16,    27,     4,     0,    19,    25,     0,     0,    19,    27,     0,     0,     8,    10,   254,     0,    10,     8,   254,     0,    10,     8,   254, 
    0,    11,     8,   248,     0,    14,    10,   223,     0,    12,    10,   192,     0,     9,    10,   157,     0,     6,    13,   116,     0,     8,    14,    84,     0,    10,    15,    62, 
    0,    12,    15,    44,     0,    14,    17,    30,     0,    15,    17,    20,     0,    13,    18,    15,     0,    16,    18,     5,     0,    18,    16,     0,     0,    19,    17,     0, 
    0,     8,     6,   255,     0,    10,     4,   255,     0,    11,     4,   254,     0,    11,     3,   250,     0,    14,     5,   230,     0,    12,     5,   205,     0,    11,     5,   176, 
    0,    10,     6,   134,     0,    11,     6,   100,     0,    11,     6,    75,     0,    13,     7,    56,     0,    14,     8,    37,     0,    14,     9,    23,     0,    14,     9,    16, 
    0,    14,    10,    12,     0,    18,     9,     0,     0,    17,     8,     0,     0,    14,     3,   255,     0,    15,     1,   254,     0,    15,     1,   251,     0,    15,     0,   245, 
    0,    15,     1,   231,     0,    15,     1,   209,     0,    15,     1,   180,     0,    15,     1,   141,     0,    16,     2,   107,     0,    16,     2,    83,     0,    17,     2,    63, 
    0,    18,     2,    47,     0,    18,     3,    31,     0,    18,     3,    21,     0,    21,     2,    11,     0,    20,     3,     0,     0,    20,     5,     0,     0,    20,     0,   255, 
    0,    20,     0,   249,     0,    20,     0,   243,     0,    20,     0,   236,     0,    20,     0,   227,     0,    20,     0,   205,     0,    21,     0,   169,     0,    21,     0,   136, 
    0,    21,     0,   105,     0,    22,     0,    81,     0,    22,     0,    62,     0,    23,     0,    49,     0,    23,     0,    38,     0,    23,     0,    28,     0,    24,     0,    21, 
    0,    25,     0,    11,     0,    25,     0,     0,     0,     3,   213,   250,     0,     2,   215,   250,     1,     0,   221,   247,     1,     0,   225,   231,     0,     0,   228,   213, 
    0,     0,   232,   191,     1,     0,   237,   160,     0,     0,   241,   117,     1,     0,   246,    79,     1,     0,   249,    49,     2,     0,   252,    29,     2,     0,   253,    17, 
    2,     0,   254,     9,     2,     0,   254,     2,     2,     1,   254,     0,     1,     3,   254,     0,     0,    15,   234,     0,     0,     3,   201,   250,     0,     1,   206,   247, 
    0,     0,   207,   235,     0,     0,   207,   213,     0,     0,   207,   192,     0,     0,   206,   156,     0,     0,   211,   119,     0,     0,   217,    90,     0,     0,   222,    63, 
    0,     0,   227,    37,     0,     1,   229,    22,     0,     1,   230,    12,     0,     2,   229,     4,     0,     5,   224,     1,     0,     7,   220,     1,     0,    10,   216,     0, 
    0,    12,   217,     0,     0,     4,   184,   251,     0,     1,   189,   246,     0,     0,   188,   220,     0,     0,   186,   195,     0,     0,   185,   174,     0,     0,   188,   139, 
    0,     0,   197,   104,     0,     0,   201,    77,     0,     0,   204,    57,     0,     0,   208,    34,     0,     0,   211,    19,     0,     0,   212,     9,     0,     2,   211,     2, 
    0,     5,   206,     1,     0,     8,   202,     0,     0,    10,   199,     0,     0,    12,   207,     0,     0,     3,   161,   251,     0,     1,   163,   248,     0,     0,   163,   223, 
    0,     0,   161,   185,     0,     0,   161,   152,     0,     0,   167,   131,     0,     0,   180,   100,     0,     0,   184,    75,     0,     0,   188,    55,     0,     0,   191,    34, 
    0,     0,   195,    19,     0,     0,   197,     8,     0,     2,   195,     1,     0,     5,   189,     0,     0,     8,   183,     0,     0,    11,   179,     0,     0,    12,   195,     0, 
    0,     3,   136,   252,     0,     2,   138,   249,     0,     0,   139,   230,     0,     0,   136,   191,     0,     0,   137,   142,     0,     0,   139,   118,     0,     1,   145,    98, 
    0,     1,   151,    76,     0,     0,   164,    56,     0,     0,   168,    36,     0,     0,   173,    21,     0,     0,   177,     9,     0,     1,   175,     2,     0,     5,   165,     0, 
    0,     8,   156,     0,     0,    11,   152,     0,     0,    11,   178,     0,     0,     4,   110,   252,     0,     3,   111,   251,     0,     1,   116,   240,     0,     0,   115,   204, 
    0,     0,   116,   159,     0,     0,   114,   128,     0,     0,   113,   106,     0,     0,   118,    89,     0,     0,   128,    61,     0,     0,   134,    41,     0,     0,   140,    26, 
    0,     0,   145,    13,     0,     1,   146,     3,     0,     5,   139,     0,     0,     8,   131,     0,     0,    12,   127,     0,     0,    11,   154,     0,     0,     4,    86,   253, 
    0,     3,    87,   252,     0,     1,    91,   246,     0,     1,    91,   216,     0,     0,    93,   178,     0,     0,    93,   139,     0,     0,    92,   101,     0,     0,    96,    83, 
    0,     0,   103,    61,     0,     0,   107,    45,     0,     0,   113,    29,     0,     0,   117,    17,     0,     1,   119,     6,     0,     4,   114,     1,     0,     8,   108,     0, 
    0,    12,   105,     0,     0,    11,   128,     0,     0,     4,    65,   253,     0,     3,    65,   253,     0,     1,    66,   245,     0,     1,    68,   221,     0,     1,    71,   190, 
    0,     0,    73,   147,     0,     0,    75,   107,     0,     0,    77,    82,     0,     0,    80,    65,     0,     0,    86,    53,     0,     0,    93,    33,     0,     0,    96,    20, 
    0,     0,    98,     8,     0,     3,    95,     1,     0,     8,    89,     0,     0,    12,    86,     0,     0,    11,   105,     0,     0,     5,    51,   254,     0,     3,    51,   252, 
    0,     1,    53,   241,     0,     1,    54,   217,     0,     1,    57,   190,     0,     1,    59,   151,     0,     1,    61,   114,     0,     0,    62,    84,     0,     0,    62,    64, 
    0,     0,    68,    51,     0,     0,    76,    34,     0,     0,    78,    23,     0,     0,    80,    11,     0,     2,    79,     1,     0,     7,    73,     0,     0,    12,    71,     0, 
    0,    11,    85,     0,     0,     5,    39,   254,     0,     3,    39,   253,     0,     2,    40,   243,     0,     2,    43,   215,     0,     2,    45,   188,     0,     1,    46,   150, 
    0,     1,    48,   114,     0,     1,    50,    88,     0,     2,    51,    65,     0,     0,    55,    51,     0,     1,    59,    38,     0,     0,    62,    28,     0,     0,    65,    14, 
    0,     1,    66,     3,     0,     7,    61,     0,     0,    12,    58,     0,     0,    11,    69,     0,     0,     4,    28,   254,     0,     5,    28,   254,     0,     4,    29,   250, 
    0,     3,    32,   219,     0,     3,    35,   185,     0,     2,    36,   144,     0,     3,    38,   106,     0,     3,    39,    85,     0,     1,    41,    65,     0,     3,    42,    49, 
    0,     3,    44,    35,     0,     1,    50,    28,     0,     1,    53,    16,     0,     1,    54,     5,     0,     6,    50,     1,     0,    12,    47,     0,     0,    11,    56,     0, 
    0,     5,    21,   254,     0,     5,    21,   254,     0,     5,    21,   252,     0,     4,    24,   228,     0,     4,    26,   196,     0,     3,    28,   158,     0,     3,    29,   121, 
    0,     3,    30,    91,     0,     3,    30,    65,     0,     1,    32,    49,     0,     6,    33,    36,     0,     4,    36,    28,     0,     3,    40,    19,     0,     2,    42,    11, 
    0,     5,    40,     1,     0,    11,    38,     0,     0,    11,    44,     0,     0,     5,    15,   254,     0,     5,    14,   254,     0,     5,    14,   253,     0,     8,    16,   239, 
    0,     7,    18,   211,     0,     6,    19,   172,     0,     2,    19,   136,     0,     2,    22,    97,     0,     4,    23,    67,     0,     3,    24,    51,     0,     6,    25,    37, 
    0,     7,    27,    27,     0,    10,    27,    18,     0,     7,    30,    13,     0,     6,    30,     4,     0,    10,    30,     0,     0,    10,    34,     0,     0,     4,    10,   255, 
    0,     5,     9,   254,     0,     5,     9,   253,     0,     7,    10,   243,     0,     7,    11,   220,     0,     6,    12,   190,     0,     3,    12,   145,     0,     1,    15,   105, 
    0,     2,    16,    77,     0,     4,    17,    56,     0,     5,    18,    40,     0,     7,    19,    31,     0,     9,    19,    20,     0,     8,    21,    14,     0,     5,    22,     6, 
    0,     7,    22,     1,     0,    10,    24,     0,     0,     4,     6,   255,     0,     5,     4,   254,     0,     5,     4,   253,     0,     5,     4,   247,     0,     8,     6,   227, 
    0,     6,     6,   201,     0,     5,     7,   160,     0,     4,     7,   121,     0,     4,     8,    89,     0,     3,    10,    67,     0,     5,    11,    49,     0,     6,    11,    35, 
    0,     8,    12,    23,     0,     8,    13,    14,     0,     6,    15,     4,     0,     8,    14,     0,     0,     9,    14,     0,     0,     4,     3,   255,     0,     6,     1,   254, 
    0,     6,     1,   253,     0,     6,     1,   250,     0,     6,     1,   235,     0,     6,     2,   211,     0,     6,     2,   182,     0,     6,     2,   138,     0,     5,     2,   103, 
    0,     3,     3,    78,     0,     4,     3,    58,     0,     6,     4,    42,     0,     7,     4,    27,     0,     8,     5,    18,     0,    10,     4,    10,     0,     7,     5,     6, 
    0,     8,     4,     0,     0,    10,     0,   255,     0,    10,     0,   250,     0,    10,     0,   246,     0,    10,     0,   241,     0,    10,     0,   235,     0,    10,     0,   219, 
    0,    10,     0,   191,     0,    10,     0,   154,     0,    10,     0,   116,     0,    10,     0,    88,     0,    11,     0,    66,     0,    12,     0,    50,     0,    13,     0,    37, 
    0,    12,     0,    27,     0,    12,     0,    18,     0,    12,     0,    10,     0,    13,     0,     0,     0,     0,   216,   250,     0,     0,   216,   247,     0,     0,   217,   239, 
    0,     0,   218,   227,     0,     0,   221,   211,     0,     0,   224,   191,     0,     0,   228,   165,     0,     0,   233,   134,     0,     0,   239,   100,     0,     0,   244,    68, 
    0,     0,   248,    44,     0,     0,   250,    28,     0,     0,   252,    18,     0,     0,   254,    10,     0,     0,   254,     5,     0,     0,   255,     2,     0,     0,   255,     0, 
    0,     0,   203,   251,     0,     0,   203,   227,     0,     0,   203,   218,     0,     0,   203,   204,     0,     0,   205,   188,     0,     0,   207,   164,     0,     0,   210,   138, 
    0,     0,   217,   113,     0,     0,   223,    89,     0,     0,   228,    61,     0,     0,   233,    38,     0,     0,   236,    26,     0,     0,   238,    17,     0,     0,   239,    10, 
    0,     0,   240,     5,     0,     0,   240,     2,     0,     0,   240,     0,     0,     0,   185,   251,     0,     0,   187,   230,     0,     0,   186,   202,     0,     0,   186,   187, 
    0,     0,   187,   165,     0,     0,   194,   138,     0,     0,   198,   117,     0,     0,   203,    98,     0,     0,   207,    78,     0,     0,   212,    55,     0,     0,   217,    35, 
    0,     0,   220,    24,     0,     0,   222,    16,     0,     0,   223,     9,     0,     0,   224,     5,     0,     0,   224,     3,     0,     0,   225,     0,     0,     0,   161,   252, 
    0,     0,   162,   233,     0,     0,   163,   207,     0,     0,   165,   171,     0,     0,   167,   148,     0,     0,   176,   125,     0,     0,   187,   113,     0,     0,   190,    95, 
    0,     0,   194,    72,     0,     0,   197,    51,     0,     0,   202,    33,     0,     0,   206,    22,     0,     0,   208,    14,     0,     0,   209,     8,     0,     0,   210,     4, 
    0,     0,   210,     2,     0,     0,   211,     0,     0,     0,   136,   252,     0,     0,   138,   236,     0,     0,   139,   211,     0,     0,   139,   178,     0,     0,   144,   135, 
    0,     0,   145,   111,     0,     0,   164,   109,     0,     0,   172,    98,     0,     0,   175,    77,     0,     0,   179,    53,     0,     0,   184,    35,     0,     0,   189,    22, 
    0,     0,   193,    13,     0,     0,   194,     7,     0,     0,   195,     3,     0,     0,   196,     1,     0,     0,   196,     0,     0,     0,   111,   253,     0,     0,   114,   239, 
    0,     0,   115,   217,     0,     0,   117,   188,     0,     0,   120,   147,     0,     0,   124,   105,     0,     0,   128,    95,     0,     0,   131,    85,     0,     0,   136,    72, 
    0,     0,   143,    55,     0,     0,   154,    40,     0,     0,   163,    26,     0,     0,   170,    15,     0,     0,   174,     7,     0,     0,   176,     3,     0,     0,   177,     1, 
    0,     0,   177,     0,     0,     0,    87,   253,     0,     0,    90,   243,     0,     0,    92,   225,     0,     0,    95,   198,     0,     0,    99,   163,     0,     0,   101,   118, 
    0,     0,   104,    86,     0,     0,   106,    78,     0,     0,   109,    69,     0,     0,   115,    57,     0,     0,   123,    43,     0,     0,   130,    30,     0,     0,   137,    19, 
    0,     0,   142,     9,     0,     0,   145,     4,     0,     0,   147,     2,     0,     0,   150,     0,     0,     0,    67,   254,     0,     0,    68,   248,     0,     0,    71,   233, 
    0,     0,    74,   208,     0,     0,    78,   177,     0,     0,    82,   134,     0,     0,    85,    98,     0,     0,    87,    75,     0,     0,    90,    67,     0,     0,    94,    58, 
    0,     0,    99,    45,     0,     0,   104,    33,     0,     0,   109,    22,     0,     0,   114,    12,     0,     0,   118,     5,     0,     0,   120,     2,     0,     0,   123,     0, 
    0,     0,    52,   254,     0,     0,    53,   250,     0,     0,    56,   237,     0,     0,    58,   215,     0,     0,    61,   188,     0,     0,    64,   147,     0,     0,    67,   110, 
    0,     0,    70,    84,     0,     0,    72,    63,     0,     0,    76,    56,     0,     0,    80,    46,     0,     0,    85,    34,     0,     0,    89,    25,     0,     0,    93,    15, 
    0,     0,    96,     7,     0,     0,    98,     2,     0,     0,   100,     0,     0,     0,    40,   254,     0,     0,    40,   251,     0,     0,    42,   241,     0,     0,    45,   219, 
    0,     0,    49,   193,     0,     0,    52,   156,     0,     0,    54,   118,     0,     0,    56,    88,     0,     0,    58,    66,     0,     0,    62,    50,     0,     0,    64,    44, 
    0,     0,    67,    36,     0,     0,    71,    25,     0,     0,    74,    16,     0,     0,    77,     8,     0,     0,    79,     3,     0,     0,    81,     0,     0,     0,    30,   254, 
    0,     0,    30,   254,     0,     0,    31,   248,     0,     0,    34,   224,     0,     0,    38,   195,     0,     0,    41,   152,     0,     0,    41,   103,     0,     0,    42,    83, 
    0,     0,    46,    68,     0,     0,    46,    49,     0,     0,    52,    40,     0,     0,    54,    35,     0,     0,    57,    26,     0,     0,    60,    18,     0,     0,    62,    10, 
    0,     0,    64,     3,     0,     0,    66,     0,     0,     0,    22,   255,     0,     0,    22,   252,     0,     0,    23,   250,     0,     0,    24,   238,     0,     0,    28,   205, 
    0,     0,    31,   158,     0,     0,    33,   115,     0,     0,    34,    88,     0,     0,    36,    67,     0,     0,    37,    51,     0,     0,    37,    38,     0,     0,    42,    32, 
    0,     0,    45,    27,     0,     0,    47,    21,     0,     0,    49,    11,     0,     0,    51,     4,     0,     0,    53,     0,     0,     0,    16,   255,     0,     0,    15,   250, 
    0,     0,    16,   246,     0,     0,    17,   238,     0,     0,    19,   213,     0,     0,    22,   177,     0,     0,    24,   123,     0,     0,    26,    91,     0,     0,    27,    67, 
    0,     0,    29,    51,     0,     0,    29,    41,     0,     0,    30,    33,     0,     0,    33,    25,     0,     0,    36,    20,     0,     0,    38,    11,     0,     0,    39,     5, 
    0,     0,    41,     0,     0,     0,    10,   255,     0,     0,    10,   250,     0,     0,    10,   245,     0,     0,    11,   237,     0,     0,    12,   216,     0,     0,    14,   182, 
    0,     0,    16,   122,     0,     0,    18,    86,     0,     0,    19,    67,     0,     0,    20,    50,     0,     0,    21,    41,     0,     0,    22,    35,     0,     0,    23,    27, 
    0,     0,    26,    20,     0,     0,    28,    13,     0,     0,    29,     8,     0,     0,    30,     0,     0,     0,     6,   255,     0,     0,     6,   250,     0,     0,     6,   246, 
    0,     0,     6,   241,     0,     0,     7,   225,     0,     0,     8,   198,     0,     0,     9,   153,     0,     0,    11,   101,     0,     0,    12,    73,     0,     0,    13,    52, 
    0,     0,    14,    39,     0,     0,    14,    33,     0,     0,    15,    29,     0,     0,    16,    23,     0,     0,    18,    14,     0,     0,    19,     8,     0,     0,    20,     0, 
    0,     0,     2,   255,     0,     0,     2,   251,     0,     0,     2,   247,     0,     0,     2,   243,     0,     0,     3,   235,     0,     0,     4,   211,     0,     0,     4,   174, 
    0,     0,     5,   114,     0,     0,     6,    81,     0,     0,     7,    55,     0,     0,     8,    42,     0,     0,     7,    34,     0,     0,     8,    26,     0,     0,     8,    21, 
    0,     0,     8,    16,     0,     0,     9,     7,     0,     0,    10,     0,     0,     0,     0,   255,     0,     0,     0,   255,     0,     0,     0,   255,     0,     0,     0,   255, 
    0,     0,     0,   248,     0,     0,     0,   225,     0,     0,     0,   191,     0,     0,     0,   151,     0,     0,     0,   114,     0,     0,     0,    87,     0,     0,     0,    66, 
    0,     0,     0,    49,     0,     0,     0,    35,     0,     0,     0,    23,     0,     0,     0,    14,     0,     0,     0,     7,     0,     0,     0,     0
};

// Photo Best (Vail)
unsigned char ucMapDJ4100_KCMY_Photo_BestV_12x12x1[] =
{
  200,   110,    60,    64,   177,   141,    74,    53,   155,   171,    87,    41,   133,   199,    99,    31,   112,   227,   111,    21,   102,   232,   109,    21,    83,   244,   112,    19, 
   64,   247,   114,    21,    45,   247,   114,    24,    27,   247,   115,    25,    17,   247,   112,    21,    12,   248,   107,    15,     8,   248,   104,    11,     6,   248,   102,     8, 
    3,   248,   100,     5,     1,   248,    99,     2,     0,   248,    98,     0,   178,   136,    53,   100,   176,   144,    53,    56,   152,   175,    96,    39,   135,   197,   102,    31, 
  113,   226,   115,    21,   102,   231,   114,    21,    84,   242,   114,    19,    65,   247,   118,    20,    47,   247,   117,    23,    29,   247,   117,    24,    18,   247,   114,    22, 
   13,   247,   110,    16,     9,   248,   106,    11,     5,   248,   103,     7,     2,   247,   101,     3,     1,   245,   100,     1,     0,   243,   100,     0,   155,   162,    47,   135, 
  153,   168,    46,   119,   152,   177,    46,    58,   127,   210,    74,    33,   102,   233,   103,    22,    83,   240,   118,    19,    69,   246,   120,    19,    54,   246,   120,    21, 
   37,   247,   120,    23,    22,   247,   119,    23,    15,   247,   113,    17,    10,   247,   109,    12,     6,   247,   105,     8,     3,   246,   103,     3,     1,   244,   102,     1, 
    0,   240,   102,     0,     0,   237,   101,     0,   118,   186,    40,   197,   118,   202,    37,   181,   122,   205,    37,   120,   103,   238,    33,    51,    90,   243,    67,    29, 
   73,   238,    97,    30,    56,   241,   112,    28,    37,   243,   118,    26,    21,   245,   120,    23,    13,   246,   114,    15,     7,   246,   109,     9,     4,   245,   106,     5, 
    2,   242,   105,     3,     1,   239,   105,     1,     0,   236,   104,     0,     0,   233,   103,     0,     0,   229,   101,     0,    92,   197,    38,   230,    93,   211,    35,   216, 
   96,   211,    37,   168,    92,   224,    37,   110,    82,   231,    43,    58,    68,   231,    68,    46,    49,   233,    93,    44,    31,   235,   105,    38,    17,   237,   109,    31, 
   11,   237,   105,    19,     4,   236,   106,    14,     1,   235,   106,    10,     0,   232,   105,     7,     0,   230,   104,     3,     0,   226,   102,     1,     0,   222,   100,     0, 
    0,   218,    99,     0,    72,   203,    39,   229,    70,   213,    37,   223,    71,   211,    42,   191,    70,   211,    45,   152,    64,   216,    49,   108,    55,   219,    61,    73, 
   39,   225,    78,    62,    24,   225,    92,    54,    14,   227,    97,    41,     9,   226,    97,    28,     4,   224,    99,    22,     3,   222,    99,    16,     0,   220,   100,    13, 
    0,   218,    99,     9,     0,   214,    98,     5,     0,   211,    96,     3,     0,   208,    94,     0,    49,   204,    42,   229,    47,   210,    41,   226,    44,   212,    47,   207, 
   44,   208,    52,   177,    43,   207,    55,   144,    38,   211,    60,   109,    24,   215,    76,    84,    13,   218,    84,    70,     9,   219,    86,    54,     6,   218,    86,    36, 
    2,   215,    89,    27,     0,   212,    92,    24,     0,   209,    93,    19,     0,   207,    93,    14,     0,   204,    91,     9,     0,   202,    89,     4,     0,   200,    87,     0, 
   24,   202,    46,   230,    22,   207,    45,   227,    19,   207,    50,   214,    17,   204,    57,   190,    19,   199,    61,   161,    18,   200,    65,   135,    12,   205,    69,   105, 
    1,   211,    82,    87,     0,   211,    79,    69,     0,   211,    77,    50,     0,   211,    77,    34,     0,   209,    79,    23,     0,   204,    83,    19,     0,   199,    84,    15, 
    0,   195,    84,    10,     0,   193,    82,     5,     0,   190,    80,     0,     4,   201,    43,   231,     3,   205,    41,   229,     2,   206,    43,   217,     0,   201,    51,   195, 
    0,   197,    59,   175,     0,   195,    63,   155,     0,   198,    64,   128,     0,   203,    63,    96,     0,   208,    60,    64,     0,   207,    60,    49,     0,   207,    61,    36, 
    0,   207,    63,    25,     0,   204,    68,    18,     0,   198,    73,    14,     0,   191,    75,    10,     0,   186,    74,     5,     0,   181,    73,     0,     1,   202,    27,   234, 
    0,   205,    23,   232,     0,   203,    25,   219,     0,   198,    32,   197,     0,   195,    38,   177,     0,   194,    43,   157,     0,   195,    45,   135,     0,   198,    44,   108, 
    0,   201,    44,    79,     0,   207,    38,    44,     0,   206,    43,    35,     0,   205,    49,    29,     0,   203,    53,    20,     0,   199,    57,    13,     0,   192,    62,     9, 
    0,   184,    64,     4,     0,   177,    65,     0,     0,   201,    18,   234,     0,   203,    15,   233,     0,   203,    14,   224,     0,   198,    19,   203,     0,   194,    24,   183, 
    0,   192,    29,   162,     0,   192,    32,   143,     0,   193,    32,   120,     0,   195,    32,    95,     0,   200,    29,    65,     0,   206,    24,    31,     0,   204,    32,    26, 
    0,   202,    38,    21,     0,   199,    42,    14,     0,   194,    46,     9,     0,   187,    51,     4,     0,   179,    54,     0,     0,   199,    14,   235,     0,   201,    12,   234, 
    0,   203,    10,   228,     0,   200,    12,   211,     0,   195,    16,   192,     0,   192,    20,   173,     0,   191,    23,   153,     0,   191,    24,   133,     0,   193,    23,   110, 
    0,   196,    22,    84,     0,   200,    19,    54,     0,   204,    17,    22,     0,   202,    24,    19,     0,   198,    29,    14,     0,   195,    32,     9,     0,   189,    36,     4, 
    0,   182,    41,     0,     0,   198,    11,   235,     0,   199,     9,   234,     0,   200,     7,   230,     0,   199,     8,   216,     0,   196,    11,   199,     0,   193,    13,   182, 
    0,   191,    16,   163,     0,   191,    19,   145,     0,   192,    18,   124,     0,   194,    16,   101,     0,   197,    14,    74,     0,   200,    13,    46,     0,   204,    12,    17, 
    0,   199,    18,    13,     0,   194,    21,     9,     0,   189,    24,     4,     0,   184,    27,     0,     0,   196,     8,   234,     0,   197,     6,   234,     0,   198,     5,   230, 
    0,   197,     6,   219,     0,   195,     7,   204,     0,   192,     9,   188,     0,   191,    11,   172,     0,   190,    13,   155,     0,   191,    14,   136,     0,   193,    13,   115, 
    0,   195,    11,    92,     0,   197,    10,    67,     0,   200,     9,    40,     0,   203,     8,    12,     0,   196,    12,     8,     0,   189,    14,     4,     0,   184,    16,     0, 
    0,   194,     5,   234,     0,   195,     4,   234,     0,   195,     3,   230,     0,   195,     4,   221,     0,   194,     5,   209,     0,   191,     6,   194,     0,   190,     7,   179, 
    0,   190,     9,   163,     0,   190,    10,   145,     0,   191,    10,   126,     0,   193,     8,   105,     0,   195,     7,    83,     0,   197,     6,    60,     0,   199,     5,    35, 
    0,   202,     5,     8,     0,   193,     8,     4,     0,   185,     9,     0,     0,   193,     3,   234,     0,   193,     2,   233,     0,   193,     1,   230,     0,   192,     2,   223, 
    0,   192,     2,   212,     0,   191,     3,   199,     0,   189,     3,   185,     0,   189,     4,   170,     0,   189,     5,   153,     0,   190,     5,   136,     0,   191,     5,   116, 
    0,   193,     4,    96,     0,   194,     3,    75,     0,   196,     3,    53,     0,   198,     2,    29,     0,   201,     2,     4,     0,   191,     4,     0,     0,   191,     0,   234, 
    0,   191,     0,   232,     0,   191,     0,   229,     0,   190,     0,   223,     0,   190,     0,   215,     0,   189,     0,   203,     0,   188,     0,   190,     0,   188,     0,   176, 
    0,   189,     0,   160,     0,   190,     0,   144,     0,   190,     0,   126,     0,   191,     0,   107,     0,   192,     0,    88,     0,   193,     0,    68,     0,   194,     0,    47, 
    0,   196,     0,    25,     0,   200,     0,     0,   182,    96,    89,    88,   165,   101,   121,    50,   143,   140,   144,    36,    95,   201,   190,    13,    48,   225,   196,     9, 
   35,   233,   189,    10,    52,   223,   164,    26,    39,   221,   151,    32,    22,   228,   146,    25,    13,   231,   137,    16,     6,   234,   131,    12,     3,   238,   126,     9, 
    3,   240,   118,     4,     2,   241,   113,     2,     1,   242,   109,     1,     0,   243,   106,     0,     0,   244,   103,     0,   172,   110,    60,   114,   177,   112,    61,    66, 
  144,   173,    91,    41,   110,   220,   123,    22,    90,   227,   137,    20,    72,   238,   136,    19,    61,   241,   126,    22,    45,   242,   124,    24,    28,   243,   124,    24, 
   17,   244,   119,    19,     8,   245,   112,    11,     4,   245,   107,     4,     1,   242,   106,     1,     1,   239,   105,     1,     0,   237,   105,     0,     0,   235,   105,     0, 
    0,   238,   100,     0,   143,   149,    50,   160,   152,   162,    47,   142,   147,   177,    45,    85,   120,   207,    79,    35,    96,   224,   105,    27,    73,   238,   115,    25, 
   57,   243,   119,    23,    42,   245,   119,    24,    27,   246,   119,    24,    16,   246,   114,    19,     8,   246,   108,    10,     3,   246,   104,     3,     1,   243,   104,     1, 
    0,   238,   104,     0,     0,   234,   105,     0,     0,   231,   105,     0,     0,   233,   102,     0,   114,   173,    43,   208,   114,   193,    39,   202,   112,   209,    36,   167, 
  117,   201,    41,    79,    96,   220,    60,    38,    72,   227,    98,    38,    51,   231,   115,    35,    34,   235,   120,    32,    21,   238,   120,    26,    12,   240,   113,    17, 
    4,   241,   109,    10,     1,   241,   105,     2,     0,   237,   105,     0,     0,   232,   105,     0,     0,   228,   105,     0,     0,   225,   104,     0,     0,   225,   102,     0, 
   92,   181,    42,   233,    91,   198,    38,   228,    88,   216,    35,   209,    96,   197,    43,   133,    89,   202,    48,    81,    72,   218,    65,    53,    48,   222,    95,    52, 
   30,   225,   107,    45,    17,   229,   110,    35,    10,   230,   106,    21,     1,   232,   106,    13,     0,   232,   104,     3,     0,   228,   103,     1,     0,   223,   103,     0, 
    0,   219,   102,     0,     0,   217,   101,     0,     0,   216,    99,     0,    70,   195,    42,   231,    68,   202,    40,   229,    64,   216,    38,   221,    66,   208,    46,   175, 
   62,   206,    52,   132,    58,   211,    58,    91,    42,   214,    78,    72,    24,   214,    95,    63,    15,   217,    99,    49,     9,   221,    97,    32,     3,   223,    96,    21, 
    0,   223,    96,    10,     0,   221,    95,     3,     0,   216,    95,     1,     0,   212,    95,     0,     0,   209,    95,     0,     0,   207,    94,     0,    46,   197,    44,   231, 
   45,   203,    43,   229,    42,   211,    42,   224,    39,   208,    51,   197,    39,   204,    56,   161,    38,   203,    61,   127,    29,   205,    72,    98,    14,   207,    86,    83, 
    8,   209,    90,    65,     5,   210,    89,    46,     3,   211,    88,    30,     0,   211,    88,    20,     0,   211,    87,    10,     0,   209,    86,     4,     0,   206,    87,     1, 
    0,   202,    87,     0,     0,   199,    88,     0,    22,   197,    48,   231,    20,   201,    47,   230,    18,   206,    47,   226,    14,   205,    54,   205,    12,   198,    62,   178, 
   14,   196,    66,   149,     8,   198,    74,   125,     5,   201,    78,   100,     2,   204,    80,    80,     0,   205,    79,    60,     0,   206,    76,    39,     0,   204,    78,    25, 
    0,   202,    79,    15,     0,   200,    79,     8,     0,   198,    79,     3,     0,   194,    79,     1,     0,   190,    81,     0,     4,   198,    42,   232,     4,   201,    41,   232, 
    3,   203,    39,   227,     0,   203,    45,   208,     0,   196,    54,   185,     0,   193,    60,   163,     0,   194,    64,   140,     0,   196,    65,   111,     0,   198,    64,    85, 
    0,   200,    62,    65,     0,   201,    61,    45,     0,   202,    62,    29,     0,   199,    65,    17,     0,   195,    68,    10,     0,   191,    70,     5,     0,   186,    71,     1, 
    0,   180,    73,     0,     0,   199,    25,   235,     0,   200,    25,   233,     0,   200,    25,   224,     0,   196,    30,   205,     0,   193,    37,   185,     0,   191,    42,   165, 
    0,   191,    46,   144,     0,   192,    47,   119,     0,   193,    49,    94,     0,   196,    47,    70,     0,   198,    46,    51,     0,   199,    48,    36,     0,   199,    49,    23, 
    0,   195,    53,    12,     0,   189,    58,     6,     0,   182,    61,     2,     0,   175,    64,     0,     0,   198,    17,   235,     0,   195,    13,   228,     0,   195,    14,   220, 
    0,   192,    18,   206,     0,   188,    23,   188,     0,   187,    27,   168,     0,   186,    31,   148,     0,   187,    33,   128,     0,   188,    34,   104,     0,   190,    34,    80, 
    0,   194,    31,    56,     0,   196,    32,    39,     0,   196,    35,    28,     0,   195,    37,    17,     0,   191,    41,     8,     0,   184,    47,     3,     0,   174,    53,     0, 
    0,   197,    13,   235,     0,   191,     7,   225,     0,   190,     7,   217,     0,   189,     9,   206,     0,   185,    12,   191,     0,   184,    15,   174,     0,   183,    19,   154, 
    0,   183,    21,   135,     0,   183,    23,   114,     0,   186,    22,    91,     0,   188,    21,    68,     0,   192,    20,    44,     0,   193,    23,    31,     0,   192,    25,    21, 
    0,   190,    28,    12,     0,   186,    32,     5,     0,   178,    39,     0,     0,   195,    10,   235,     0,   187,     3,   223,     0,   186,     2,   216,     0,   185,     3,   206, 
    0,   183,     6,   194,     0,   183,     7,   179,     0,   182,    10,   161,     0,   181,    13,   143,     0,   181,    14,   124,     0,   183,    14,   102,     0,   185,    13,    80, 
    0,   188,    12,    56,     0,   191,    12,    34,     0,   189,    15,    23,     0,   187,    17,    15,     0,   184,    20,     7,     0,   180,    26,     0,     0,   194,     7,   235, 
    0,   184,     1,   220,     0,   182,     1,   213,     0,   181,     1,   206,     0,   181,     2,   195,     0,   181,     3,   183,     0,   180,     4,   167,     0,   179,     6,   150, 
    0,   180,     8,   133,     0,   180,     8,   113,     0,   183,     7,    91,     0,   184,     6,    69,     0,   187,     6,    46,     0,   188,     6,    25,     0,   185,     9,    15, 
    0,   182,    10,     8,     0,   178,    14,     0,     0,   192,     5,   235,     0,   181,     1,   218,     0,   178,     0,   212,     0,   178,     0,   205,     0,   178,     0,   196, 
    0,   178,     1,   185,     0,   178,     1,   171,     0,   178,     2,   156,     0,   178,     4,   140,     0,   179,     4,   122,     0,   181,     4,   102,     0,   183,     3,    82, 
    0,   184,     2,    60,     0,   186,     2,    38,     0,   187,     3,    18,     0,   182,     5,     8,     0,   178,     7,     0,     0,   191,     2,   234,     0,   179,     0,   218, 
    0,   177,     0,   212,     0,   177,     0,   206,     0,   176,     0,   198,     0,   177,     0,   188,     0,   177,     0,   175,     0,   177,     0,   161,     0,   178,     1,   146, 
    0,   178,     1,   130,     0,   180,     1,   111,     0,   181,     1,    93,     0,   182,     0,    73,     0,   183,     0,    52,     0,   185,     0,    31,     0,   186,     1,    11, 
    0,   181,     5,     0,     0,   189,     0,   234,     0,   180,     0,   217,     0,   180,     0,   214,     0,   180,     0,   208,     0,   179,     0,   201,     0,   180,     0,   191, 
    0,   180,     0,   179,     0,   180,     0,   166,     0,   180,     0,   152,     0,   181,     0,   136,     0,   182,     0,   119,     0,   183,     0,   101,     0,   183,     0,    84, 
    0,   184,     0,    65,     0,   185,     0,    43,     0,   187,     0,    22,     0,   189,     0,     0,   165,    82,   118,   113,   155,    74,   140,    88,   136,    86,   173,    40, 
  111,   121,   191,    29,    83,   172,   190,    25,    61,   196,   183,    30,    48,   195,   172,    43,    25,   203,   164,    47,    13,   208,   156,    34,     4,   215,   150,    25, 
    4,   219,   141,    14,     0,   224,   137,    12,     0,   229,   131,     7,     1,   232,   123,     3,     1,   235,   117,     1,     0,   236,   113,     0,     0,   238,   109,     0, 
  161,    86,    94,   131,   155,    90,   103,   109,   138,   107,   133,    48,   106,   160,   164,    30,    81,   195,   163,    31,    55,   209,   161,    40,    36,   213,   155,    39, 
   23,   217,   150,    33,    13,   222,   143,    22,     4,   226,   137,    13,     0,   228,   131,     5,     0,   228,   125,     1,     0,   227,   120,     0,     0,   226,   116,     0, 
    0,   225,   113,     0,     0,   226,   110,     0,     0,   232,   107,     0,   146,   108,    60,   163,   146,   112,    60,   147,   144,   114,    62,    68,   114,   169,   101,    45, 
   89,   193,   114,    41,    64,   211,   124,    43,    44,   224,   128,    37,    29,   231,   127,    31,    18,   235,   122,    25,    10,   237,   115,    14,     2,   238,   112,     7, 
    1,   237,   108,     1,     0,   232,   107,     0,     0,   227,   106,     0,     0,   224,   106,     0,     0,   221,   105,     0,     0,   225,   102,     0,   114,   141,    52,   212, 
  114,   154,    49,   203,   115,   162,    49,   159,   116,   160,    54,    84,    98,   178,    77,    52,    67,   202,   108,    52,    45,   213,   121,    49,    30,   222,   122,    41, 
   18,   227,   120,    32,    11,   230,   114,    21,     3,   232,   110,    14,     1,   233,   106,     3,     0,   228,   105,     0,     0,   223,   105,     0,     0,   219,   104,     0, 
    0,   216,   104,     0,     0,   218,   102,     0,    90,   156,    49,   238,    90,   171,    45,   233,    88,   184,    45,   208,    93,   173,    51,   135,    92,   170,    59,    85, 
   72,   186,    82,    66,    44,   204,   106,    63,    26,   210,   115,    55,    15,   214,   117,    42,     9,   215,   113,    28,     1,   218,   111,    19,     0,   220,   107,     6, 
    0,   218,   104,     0,     0,   213,   104,     0,     0,   211,   103,     0,     0,   209,   102,     0,     0,   211,   100,     0,    68,   179,    47,   234,    66,   187,    45,   232, 
   62,   198,    45,   222,    62,   193,    55,   176,    63,   185,    64,   131,    61,   184,    70,    96,    39,   198,    89,    81,    22,   204,   101,    69,    13,   206,   104,    53, 
    7,   210,   102,    38,     0,   212,   102,    25,     0,   213,    99,    10,     0,   211,    97,     1,     0,   208,    97,     0,     0,   205,    97,     0,     0,   203,    96,     0, 
    0,   204,    95,     0,    44,   187,    48,   233,    42,   193,    46,   231,    40,   200,    46,   227,    35,   200,    57,   198,    35,   194,    64,   163,    35,   192,    69,   131, 
   28,   195,    77,   103,    14,   200,    90,    86,     8,   202,    92,    67,     4,   203,    93,    50,     2,   204,    91,    33,     0,   206,    89,    18,     0,   206,    86,     6, 
    0,   204,    86,     1,     0,   200,    87,     0,     0,   198,    88,     0,     0,   196,    88,     0,    20,   191,    51,   232,    18,   195,    50,   231,    16,   200,    48,   228, 
   13,   198,    55,   206,     9,   193,    66,   179,     8,   191,    72,   154,     3,   192,    81,   135,     0,   195,    85,   110,     0,   198,    83,    85,     0,   199,    80,    63, 
    0,   200,    79,    41,     0,   199,    79,    25,     0,   198,    78,    13,     0,   197,    77,     4,     0,   194,    78,     1,     0,   191,    79,     0,     0,   188,    81,     0, 
    5,   193,    43,   234,     4,   196,    41,   233,     3,   200,    40,   226,     0,   199,    46,   208,     0,   192,    54,   185,     0,   190,    61,   164,     0,   189,    65,   143, 
    0,   191,    67,   115,     0,   193,    65,    89,     0,   195,    65,    69,     0,   195,    64,    49,     0,   196,    64,    31,     0,   194,    66,    17,     0,   190,    68,     8, 
    0,   187,    69,     2,     0,   183,    71,     0,     0,   179,    74,     0,     0,   194,    26,   236,     0,   195,    26,   231,     0,   194,    28,   219,     0,   193,    33,   205, 
    0,   189,    39,   187,     0,   188,    44,   167,     0,   188,    47,   145,     0,   188,    49,   122,     0,   188,    52,    98,     0,   190,    51,    76,     0,   191,    49,    56, 
    0,   193,    49,    39,     0,   192,    50,    23,     0,   189,    53,    11,     0,   184,    57,     4,     0,   179,    60,     1,     0,   172,    64,     0,     0,   193,    16,   236, 
    0,   191,    14,   227,     0,   188,    18,   215,     0,   185,    22,   202,     0,   183,    25,   187,     0,   183,    29,   169,     0,   182,    33,   150,     0,   183,    35,   129, 
    0,   183,    37,   107,     0,   185,    37,    84,     0,   187,    35,    63,     0,   189,    35,    45,     0,   190,    35,    31,     0,   189,    37,    18,     0,   186,    41,     8, 
    0,   180,    46,     2,     0,   170,    52,     0,     0,   193,    12,   235,     0,   186,     7,   224,     0,   183,     8,   211,     0,   181,    10,   201,     0,   179,    13,   189, 
    0,   179,    16,   173,     0,   178,    19,   154,     0,   177,    22,   135,     0,   178,    24,   115,     0,   179,    25,    94,     0,   182,    24,    72,     0,   185,    23,    51, 
    0,   186,    23,    36,     0,   186,    25,    23,     0,   185,    27,    13,     0,   181,    31,     5,     0,   172,    39,     0,     0,   192,     9,   235,     0,   183,     2,   221, 
    0,   178,     2,   208,     0,   176,     3,   199,     0,   176,     4,   189,     0,   176,     6,   176,     0,   175,     8,   159,     0,   175,    11,   141,     0,   175,    13,   123, 
    0,   176,    14,   102,     0,   178,    14,    81,     0,   180,    13,    60,     0,   183,    12,    39,     0,   182,    15,    27,     0,   180,    16,    16,     0,   178,    18,     7, 
    0,   174,    25,     0,     0,   191,     7,   235,     0,   179,     1,   217,     0,   173,     0,   203,     0,   172,     0,   196,     0,   172,     0,   188,     0,   173,     1,   177, 
    0,   173,     2,   163,     0,   172,     4,   147,     0,   173,     5,   130,     0,   173,     6,   111,     0,   175,     6,    91,     0,   176,     6,    70,     0,   178,     6,    49, 
    0,   180,     5,    29,     0,   177,     8,    18,     0,   175,     9,     9,     0,   173,    14,     0,     0,   190,     4,   235,     0,   176,     0,   215,     0,   168,     0,   199, 
    0,   167,     0,   193,     0,   168,     0,   186,     0,   169,     0,   176,     0,   169,     0,   164,     0,   169,     0,   151,     0,   170,     1,   135,     0,   171,     2,   118, 
    0,   172,     2,    99,     0,   173,     1,    80,     0,   174,     1,    60,     0,   176,     1,    39,     0,   176,     1,    20,     0,   173,     3,    10,     0,   171,     7,     0, 
    0,   188,     2,   235,     0,   174,     0,   214,     0,   166,     0,   197,     0,   164,     0,   191,     0,   165,     0,   184,     0,   166,     0,   176,     0,   166,     0,   165, 
    0,   166,     0,   152,     0,   167,     0,   138,     0,   168,     0,   123,     0,   169,     0,   106,     0,   170,     0,    89,     0,   170,     0,    71,     0,   171,     0,    51, 
    0,   172,     0,    31,     0,   172,     1,    13,     0,   171,     5,     0,     0,   187,     0,   235,     0,   178,     0,   217,     0,   169,     0,   199,     0,   169,     0,   195, 
    0,   169,     0,   188,     0,   170,     0,   180,     0,   170,     0,   169,     0,   170,     0,   158,     0,   171,     0,   144,     0,   171,     0,   129,     0,   173,     0,   113, 
    0,   174,     0,    96,     0,   174,     0,    80,     0,   175,     0,    61,     0,   175,     0,    40,     0,   176,     0,    19,     0,   178,     0,     0,   136,    61,   156,   163, 
  130,    56,   173,   146,   122,    53,   193,    74,    96,    60,   228,    34,    83,   112,   204,    36,    64,   150,   184,    43,    43,   167,   179,    48,    23,   180,   171,    48, 
    8,   190,   166,    39,     1,   198,   160,    30,     0,   202,   152,    19,     0,   207,   145,    14,     0,   212,   138,    10,     0,   217,   132,     6,     0,   222,   127,     3, 
    0,   226,   121,     1,     0,   228,   117,     0,   136,    69,   127,   170,   134,    73,   133,   149,   128,    73,   149,    89,   102,    84,   190,    41,    78,   140,   179,    41, 
   51,   172,   171,    52,    28,   185,   167,    53,    12,   196,   164,    44,     3,   202,   157,    32,     0,   205,   150,    15,     0,   208,   141,     3,     0,   209,   134,     1, 
    0,   211,   128,     1,     0,   212,   124,     1,     0,   214,   120,     0,     0,   217,   117,     0,     0,   221,   113,     0,   132,    80,    87,   181,   131,    83,    92,   160, 
  124,    93,    99,   113,   108,   104,   131,    55,    80,   144,   146,    56,    48,   181,   153,    66,    22,   194,   155,    60,    12,   200,   151,    44,     5,   204,   144,    33, 
    0,   208,   139,    19,     0,   210,   131,     4,     0,   211,   125,     0,     0,   210,   121,     0,     0,   209,   117,     0,     0,   209,   114,     0,     0,   209,   112,     0, 
    0,   215,   109,     0,   103,    98,    63,   240,   111,    99,    65,   203,   115,   108,    66,   145,   114,   116,    68,    72,    86,   153,   101,    67,    57,   182,   121,    71, 
   33,   195,   128,    64,    20,   204,   130,    51,    13,   210,   125,    37,     5,   215,   120,    26,     0,   219,   114,    13,     0,   220,   109,     2,     0,   216,   107,     0, 
    0,   212,   106,     0,     0,   209,   105,     0,     0,   207,   104,     0,     0,   211,   101,     0,    87,   129,    57,   243,    87,   134,    57,   227,    89,   140,    59,   186, 
   89,   147,    63,   138,    87,   145,    71,    91,    64,   168,    97,    81,    35,   188,   116,    76,    19,   197,   123,    63,    13,   203,   119,    46,     5,   207,   116,    35, 
    0,   210,   112,    23,     0,   211,   106,     8,     0,   210,   104,     1,     0,   207,   102,     0,     0,   204,   102,     0,     0,   202,   101,     0,     0,   204,   100,     0, 
   66,   162,    52,   237,    64,   168,    51,   234,    62,   172,    54,   215,    61,   174,    64,   177,    60,   166,    76,   135,    57,   162,    84,   105,    36,   180,   101,    92, 
   19,   193,   109,    74,    12,   197,   109,    56,     5,   199,   108,    41,     1,   202,   105,    27,     0,   203,   102,    11,     0,   202,   100,     1,     0,   199,    99,     0, 
    0,   197,    98,     0,     0,   196,    98,     0,     0,   197,    97,     0,    42,   174,    53,   235,    40,   180,    52,   234,    38,   184,    52,   224,    34,   184,    63,   195, 
   29,   182,    75,   165,    31,   175,    83,   135,    25,   177,    89,   112,    12,   189,    95,    90,     7,   193,    97,    70,     4,   194,    96,    51,     0,   197,    94,    34, 
    0,   198,    91,    17,     0,   198,    89,     4,     0,   195,    89,     0,     0,   192,    90,     0,     0,   190,    90,     0,     0,   191,    90,     0,    18,   181,    55,   234, 
   16,   185,    54,   233,    15,   189,    53,   226,    13,   187,    59,   203,     5,   185,    73,   179,     6,   183,    77,   156,     9,   183,    78,   130,     3,   186,    85,   108, 
    0,   190,    86,    86,     0,   191,    84,    64,     0,   191,    82,    43,     0,   191,    80,    25,     0,   192,    79,    10,     0,   191,    78,     2,     0,   188,    80,     0, 
    0,   185,    81,     0,     0,   183,    82,     0,     5,   185,    45,   236,     5,   189,    42,   234,     3,   192,    44,   224,     0,   191,    50,   205,     0,   184,    58,   185, 
    0,   183,    64,   165,     0,   183,    67,   143,     0,   184,    69,   117,     0,   186,    69,    91,     0,   188,    68,    71,     0,   189,    66,    50,     0,   188,    67,    32, 
    0,   186,    67,    17,     0,   184,    68,     6,     0,   181,    70,     1,     0,   178,    72,     0,     0,   176,    74,     0,     0,   186,    27,   237,     0,   187,    28,   231, 
    0,   188,    33,   218,     0,   185,    37,   203,     0,   182,    42,   187,     0,   182,    47,   167,     0,   182,    50,   146,     0,   182,    52,   123,     0,   181,    55,    99, 
    0,   183,    54,    78,     0,   184,    53,    59,     0,   185,    53,    41,     0,   184,    53,    24,     0,   181,    55,    11,     0,   178,    58,     3,     0,   173,    60,     0, 
    0,   168,    64,     0,     0,   186,    16,   236,     0,   184,    16,   228,     0,   181,    21,   213,     0,   178,    26,   199,     0,   177,    29,   186,     0,   178,    32,   169, 
    0,   177,    35,   150,     0,   178,    37,   130,     0,   177,    40,   109,     0,   179,    41,    87,     0,   181,    39,    67,     0,   182,    38,    49,     0,   183,    38,    33, 
    0,   181,    40,    18,     0,   178,    42,     7,     0,   173,    46,     1,     0,   165,    52,     0,     0,   187,    12,   236,     0,   181,     8,   224,     0,   178,     9,   210, 
    0,   173,    13,   197,     0,   173,    15,   186,     0,   173,    18,   171,     0,   172,    21,   154,     0,   171,    24,   136,     0,   172,    26,   116,     0,   173,    27,    96, 
    0,   175,    27,    75,     0,   178,    26,    56,     0,   179,    25,    39,     0,   179,    25,    25,     0,   178,    27,    13,     0,   174,    30,     4,     0,   165,    39,     0, 
    0,   187,     9,   236,     0,   178,     3,   221,     0,   173,     3,   207,     0,   169,     4,   195,     0,   169,     5,   186,     0,   169,     6,   173,     0,   168,     9,   158, 
    0,   168,    11,   141,     0,   169,    13,   122,     0,   170,    14,   103,     0,   171,    15,    83,     0,   172,    14,    63,     0,   175,    13,    43,     0,   175,    14,    29, 
    0,   174,    15,    17,     0,   172,    17,     7,     0,   167,    25,     0,     0,   186,     6,   235,     0,   175,     1,   217,     0,   168,     0,   202,     0,   164,     0,   190, 
    0,   164,     0,   182,     0,   165,     1,   172,     0,   165,     1,   160,     0,   165,     3,   145,     0,   165,     4,   128,     0,   166,     5,   109,     0,   167,     5,    91, 
    0,   168,     5,    71,     0,   169,     5,    51,     0,   171,     4,    32,     0,   168,     6,    19,     0,   168,     7,     9,     0,   165,    14,     0,     0,   186,     3,   235, 
    0,   172,     0,   215,     0,   164,     0,   197,     0,   158,     0,   183,     0,   158,     0,   175,     0,   158,     0,   166,     0,   159,     0,   156,     0,   159,     0,   144, 
    0,   160,     0,   129,     0,   161,     0,   113,     0,   162,     1,    96,     0,   163,     0,    79,     0,   163,     0,    60,     0,   164,     0,    40,     0,   164,     1,    23, 
    0,   163,     2,    11,     0,   162,     7,     0,     0,   185,     1,   235,     0,   171,     0,   214,     0,   161,     0,   195,     0,   154,     0,   178,     0,   154,     0,   170, 
    0,   154,     0,   163,     0,   154,     0,   154,     0,   155,     0,   143,     0,   155,     0,   130,     0,   156,     0,   115,     0,   157,     0,   100,     0,   157,     0,    85, 
    0,   157,     0,    69,     0,   158,     0,    50,     0,   158,     0,    32,     0,   159,     1,    15,     0,   160,     5,     0,     0,   184,     0,   233,     0,   175,     0,   217, 
    0,   166,     0,   199,     0,   158,     0,   182,     0,   159,     0,   176,     0,   159,     0,   169,     0,   160,     0,   159,     0,   160,     0,   149,     0,   160,     0,   136, 
    0,   161,     0,   122,     0,   161,     0,   106,     0,   162,     0,    91,     0,   162,     0,    76,     0,   162,     0,    58,     0,   163,     0,    37,     0,   163,     0,    17, 
    0,   166,     0,     0,    99,    35,   205,   222,    97,    35,   211,   213,   102,    45,   202,   142,    90,    49,   216,    71,    76,    74,   213,    48,    58,   115,   197,    51, 
   39,   141,   188,    53,    22,   158,   178,    50,    10,   168,   173,    38,     2,   178,   167,    29,     0,   184,   159,    20,     0,   190,   152,    14,     0,   195,   146,    10, 
    0,   201,   141,     7,     0,   205,   135,     4,     0,   210,   131,     2,     0,   214,   126,     0,   104,    46,   172,   219,   103,    49,   174,   202,   103,    58,   173,   156, 
   94,    62,   188,    67,    75,   103,   185,    52,    50,   139,   179,    58,    29,   157,   174,    57,    14,   170,   171,    45,     1,   182,   166,    34,     0,   186,   157,    14, 
    0,   190,   149,     3,     0,   194,   141,     1,     0,   197,   136,     1,     0,   200,   131,     1,     0,   202,   126,     0,     0,   205,   123,     0,     0,   209,   121,     0, 
  108,    62,   128,   206,   108,    69,   125,   187,   108,    78,   124,   151,    98,    83,   142,    89,    77,   107,   156,    64,    49,   144,   163,    69,    24,   163,   164,    63, 
   11,   175,   162,    50,     0,   185,   156,    38,     0,   188,   149,    17,     0,   191,   142,     2,     0,   194,   135,     0,     0,   195,   130,     0,     0,   197,   125,     0, 
    0,   198,   121,     0,     0,   200,   118,     0,     0,   204,   117,     0,    96,    71,    86,   236,    99,    78,    88,   204,   101,    91,    91,   153,    93,   102,   104,   117, 
   80,   114,   120,    78,    47,   149,   144,    84,    18,   172,   149,    76,     6,   182,   148,    59,     2,   187,   143,    40,     0,   190,   137,    23,     0,   193,   131,     6, 
    0,   195,   125,     1,     0,   195,   120,     0,     0,   195,   116,     0,     0,   195,   113,     0,     0,   195,   111,     0,     0,   199,   109,     0,    80,    97,    69,   250, 
   82,   107,    69,   211,    84,   111,    73,   161,    82,   118,    78,   133,    76,   128,    87,    96,    45,   154,   118,   102,    21,   174,   126,    88,    13,   185,   126,    68, 
    7,   192,   123,    50,     0,   197,   119,    37,     0,   199,   113,    19,     0,   201,   108,     6,     0,   200,   105,     0,     0,   197,   103,     0,     0,   195,   102,     0, 
    0,   193,   101,     0,     0,   196,    98,     0,    63,   135,    62,   243,    62,   141,    61,   236,    62,   141,    68,   196,    58,   142,    77,   167,    50,   148,    89,   143, 
   42,   151,    99,   119,    24,   166,   111,   102,    13,   180,   116,    79,     9,   186,   114,    59,     3,   190,   111,    43,     0,   193,   107,    28,     0,   194,   103,    12, 
    0,   194,   100,     1,     0,   192,    98,     0,     0,   189,    98,     0,     0,   187,    97,     0,     0,   190,    96,     0,    39,   156,    60,   239,    37,   162,    59,   237, 
   36,   163,    62,   219,    32,   163,    71,   189,    25,   165,    83,   166,    21,   162,    93,   142,    16,   160,   100,   121,     8,   172,   104,    98,     6,   182,   102,    72, 
    2,   185,   101,    53,     0,   185,    99,    35,     0,   187,    96,    18,     0,   187,    93,     4,     0,   185,    92,     0,     0,   183,    92,     0,     0,   181,    92,     0, 
    0,   183,    92,     0,    16,   167,    60,   238,    16,   172,    57,   235,    16,   172,    58,   222,    13,   171,    66,   199,     6,   173,    76,   177,     2,   172,    84,   156, 
    1,   168,    91,   135,     0,   169,    94,   114,     0,   177,    91,    87,     0,   179,    89,    65,     0,   181,    86,    43,     0,   181,    84,    25,     0,   182,    82,     9, 
    0,   182,    81,     1,     0,   178,    82,     0,     0,   176,    83,     0,     0,   176,    84,     0,     4,   174,    48,   239,     4,   178,    47,   235,     2,   181,    49,   219, 
    1,   176,    55,   201,     0,   174,    62,   182,     0,   174,    67,   162,     0,   174,    71,   142,     0,   173,    73,   118,     0,   176,    74,    93,     0,   179,    72,    72, 
    0,   180,    70,    51,     0,   178,    71,    33,     0,   177,    70,    16,     0,   177,    70,     4,     0,   174,    71,     0,     0,   171,    73,     0,     0,   170,    74,     0, 
    0,   175,    30,   239,     0,   177,    32,   231,     0,   178,    37,   216,     0,   174,    43,   201,     0,   173,    46,   185,     0,   173,    50,   166,     0,   173,    53,   147, 
    0,   173,    56,   125,     0,   174,    58,   100,     0,   176,    57,    79,     0,   177,    55,    60,     0,   176,    56,    41,     0,   175,    56,    24,     0,   173,    57,    10, 
    0,   170,    59,     1,     0,   166,    61,     0,     0,   164,    64,     0,     0,   176,    17,   237,     0,   175,    18,   226,     0,   172,    24,   212,     0,   169,    30,   198, 
    0,   170,    31,   185,     0,   170,    34,   169,     0,   170,    37,   151,     0,   170,    40,   131,     0,   170,    42,   110,     0,   171,    43,    88,     0,   173,    41,    69, 
    0,   173,    40,    50,     0,   173,    41,    33,     0,   172,    41,    18,     0,   169,    43,     5,     0,   164,    47,     0,     0,   158,    53,     0,     0,   178,    11,   237, 
    0,   173,     9,   223,     0,   170,    12,   209,     0,   166,    16,   196,     0,   166,    18,   184,     0,   165,    20,   170,     0,   164,    23,   154,     0,   165,    25,   136, 
    0,   165,    27,   117,     0,   166,    28,    97,     0,   168,    28,    77,     0,   170,    28,    58,     0,   170,    27,    40,     0,   171,    26,    25,     0,   169,    28,    12, 
    0,   165,    31,     2,     0,   156,    40,     0,     0,   179,     8,   236,     0,   171,     4,   220,     0,   167,     4,   206,     0,   163,     6,   194,     0,   162,     7,   182, 
    0,   161,     8,   170,     0,   161,    11,   156,     0,   161,    12,   140,     0,   161,    14,   122,     0,   163,    15,   103,     0,   163,    16,    84,     0,   164,    15,    66, 
    0,   166,    15,    46,     0,   166,    14,    31,     0,   165,    15,    17,     0,   163,    17,     6,     0,   157,    26,     0,     0,   180,     5,   236,     0,   169,     1,   217, 
    0,   163,     1,   203,     0,   159,     0,   190,     0,   156,     1,   176,     0,   156,     1,   166,     0,   157,     1,   155,     0,   157,     2,   142,     0,   157,     4,   125, 
    0,   158,     4,   107,     0,   159,     5,    90,     0,   159,     5,    72,     0,   160,     5,    52,     0,   162,     4,    34,     0,   159,     6,    21,     0,   159,     7,     9, 
    0,   156,    15,     0,     0,   180,     3,   235,     0,   167,     0,   214,     0,   160,     0,   198,     0,   153,     0,   181,     0,   148,     0,   166,     0,   148,     0,   158, 
    0,   149,     0,   148,     0,   149,     0,   137,     0,   150,     0,   124,     0,   150,     0,   109,     0,   151,     0,    93,     0,   152,     0,    78,     0,   152,     0,    60, 
    0,   153,     0,    41,     0,   153,     0,    24,     0,   153,     1,    12,     0,   153,     7,     0,     0,   180,     1,   234,     0,   167,     0,   213,     0,   157,     0,   194, 
    0,   149,     0,   176,     0,   143,     0,   160,     0,   142,     0,   152,     0,   143,     0,   144,     0,   143,     0,   134,     0,   144,     0,   122,     0,   144,     0,   109, 
    0,   144,     0,    95,     0,   145,     0,    82,     0,   145,     0,    67,     0,   145,     0,    49,     0,   145,     0,    32,     0,   146,     0,    16,     0,   149,     5,     0, 
    0,   179,     0,   233,     0,   171,     0,   217,     0,   163,     0,   200,     0,   155,     0,   182,     0,   147,     0,   164,     0,   147,     0,   157,     0,   148,     0,   149, 
    0,   148,     0,   139,     0,   148,     0,   127,     0,   148,     0,   114,     0,   149,     0,   101,     0,   149,     0,    88,     0,   149,     0,    73,     0,   149,     0,    55, 
    0,   149,     0,    35,     0,   150,     0,    15,     0,   153,     0,     0,    85,    37,   202,   225,    81,    37,   208,   221,    78,    43,   208,   189,    70,    50,   212,   123, 
   63,    62,   212,    79,    45,    85,   207,    68,    31,   113,   196,    64,    18,   133,   186,    56,    10,   145,   179,    39,     1,   158,   172,    29,     0,   166,   165,    21, 
    0,   173,   160,    15,     0,   179,   153,    11,     0,   185,   148,     7,     0,   190,   143,     5,     0,   194,   138,     2,     0,   199,   134,     0,    87,    45,   175,   229, 
   84,    45,   184,   219,    80,    56,   185,   189,    75,    63,   187,   123,    67,    76,   189,    73,    45,   107,   188,    70,    27,   131,   182,    64,    15,   146,   177,    50, 
    2,   161,   171,    36,     0,   166,   165,    15,     0,   170,   156,     3,     0,   175,   148,     1,     0,   180,   142,     1,     0,   185,   137,     1,     0,   189,   134,     0, 
    0,   193,   131,     0,     0,   196,   130,     0,    89,    59,   140,   216,    86,    61,   145,   209,    89,    78,   136,   155,    78,    83,   152,   128,    68,    90,   162,    86, 
   46,   116,   170,    78,    24,   140,   171,    70,    12,   152,   167,    55,     2,   164,   162,    39,     0,   168,   157,    17,     0,   171,   149,     2,     0,   176,   141,     0, 
    0,   180,   135,     0,     0,   183,   131,     0,     0,   186,   127,     0,     0,   188,   124,     0,     0,   192,   124,     0,    84,    69,   113,   224,    82,    71,   120,   211, 
   82,    87,   117,   161,    75,    99,   121,   137,    65,   103,   138,   108,    47,   119,   150,    95,    20,   146,   157,    79,    10,   156,   155,    61,     1,   166,   152,    45, 
    0,   168,   147,    22,     0,   172,   140,     5,     0,   175,   134,     0,     0,   178,   129,     0,     0,   180,   124,     0,     0,   182,   121,     0,     0,   183,   118,     0, 
    0,   187,   117,     0,    74,    82,    86,   232,    73,    87,    90,   209,    70,   100,    96,   167,    65,   110,   103,   144,    51,   122,   118,   132,    40,   128,   128,   111, 
   14,   149,   140,    93,     6,   160,   139,    72,     0,   167,   136,    51,     0,   171,   132,    28,     0,   174,   127,    12,     0,   176,   122,     2,     0,   178,   118,     0, 
    0,   178,   114,     0,     0,   178,   111,     0,     0,   178,   109,     0,     0,   183,   107,     0,    52,   104,    76,   250,    54,   107,    78,   233,    51,   116,    85,   193, 
   44,   125,    96,   159,    37,   134,   103,   144,    26,   143,   110,   124,     9,   153,   120,   110,     6,   165,   120,    83,     3,   174,   117,    63,     0,   179,   113,    44, 
    0,   181,   108,    24,     0,   183,   104,     9,     0,   184,   101,     1,     0,   182,    98,     0,     0,   179,    97,     0,     0,   177,    96,     0,     0,   181,    93,     0, 
   31,   133,    72,   244,    31,   137,    70,   240,    31,   140,    74,   218,    26,   141,    85,   182,    20,   146,    92,   162,    13,   149,   100,   144,     7,   149,   106,   125, 
    3,   156,   108,   101,     1,   166,   108,    77,     2,   172,   104,    54,     0,   174,   101,    35,     0,   176,    98,    18,     0,   178,    94,     4,     0,   176,    93,     0, 
    0,   174,    91,     0,     0,   172,    91,     0,     0,   174,    90,     0,    13,   150,    65,   242,    13,   154,    63,   238,    15,   153,    64,   222,    13,   152,    71,   195, 
    7,   156,    80,   175,     0,   159,    88,   156,     0,   154,    94,   134,     0,   151,    97,   115,     0,   159,    96,    91,     0,   168,    92,    65,     0,   169,    89,    43, 
    0,   170,    87,    25,     0,   172,    85,     9,     0,   171,    84,     1,     0,   168,    84,     0,     0,   166,    83,     0,     0,   167,    84,     0,     2,   159,    53,   242, 
    2,   163,    52,   234,     0,   164,    54,   217,     0,   161,    62,   200,     0,   162,    66,   181,     0,   162,    70,   161,     0,   162,    74,   140,     0,   155,    79,   118, 
    0,   157,    80,    97,     0,   165,    76,    72,     0,   167,    75,    52,     0,   167,    74,    32,     0,   168,    73,    16,     0,   168,    72,     3,     0,   165,    73,     0, 
    0,   162,    74,     0,     0,   162,    74,     0,     0,   160,    34,   238,     0,   163,    35,   228,     0,   163,    41,   217,     0,   160,    47,   200,     0,   161,    50,   184, 
    0,   163,    53,   167,     0,   165,    57,   147,     0,   164,    59,   125,     0,   162,    61,   102,     0,   165,    60,    80,     0,   167,    58,    60,     0,   166,    58,    41, 
    0,   165,    59,    23,     0,   164,    59,     8,     0,   161,    61,     1,     0,   158,    63,     0,     0,   157,    65,     0,     0,   162,    20,   235,     0,   163,    20,   224, 
    0,   159,    27,   212,     0,   158,    33,   198,     0,   160,    35,   184,     0,   160,    37,   169,     0,   160,    40,   151,     0,   161,    42,   132,     0,   161,    44,   110, 
    0,   162,    45,    89,     0,   164,    44,    69,     0,   163,    43,    50,     0,   163,    43,    33,     0,   161,    44,    17,     0,   159,    45,     4,     0,   155,    49,     0, 
    0,   151,    54,     0,     0,   166,    12,   236,     0,   163,    10,   221,     0,   159,    15,   209,     0,   157,    19,   196,     0,   157,    21,   184,     0,   156,    22,   170, 
    0,   156,    25,   153,     0,   157,    26,   136,     0,   157,    28,   117,     0,   158,    30,    97,     0,   159,    30,    77,     0,   161,    29,    59,     0,   160,    29,    41, 
    0,   160,    28,    25,     0,   158,    30,    10,     0,   153,    34,     1,     0,   147,    42,     0,     0,   170,     7,   236,     0,   163,     4,   218,     0,   158,     6,   206, 
    0,   155,     8,   194,     0,   154,     9,   182,     0,   154,    10,   169,     0,   153,    11,   155,     0,   153,    13,   139,     0,   154,    15,   121,     0,   155,    16,   102, 
    0,   155,    16,    84,     0,   156,    16,    66,     0,   157,    16,    48,     0,   156,    16,    32,     0,   155,    16,    17,     0,   152,    19,     5,     0,   145,    29,     0, 
    0,   172,     5,   236,     0,   162,     1,   216,     0,   156,     1,   203,     0,   153,     1,   191,     0,   150,     1,   177,     0,   148,     1,   163,     0,   149,     1,   152, 
    0,   149,     3,   138,     0,   149,     4,   123,     0,   150,     5,   105,     0,   150,     5,    89,     0,   150,     6,    72,     0,   151,     6,    54,     0,   151,     6,    36, 
    0,   150,     7,    21,     0,   150,     7,     9,     0,   145,    16,     0,     0,   173,     3,   235,     0,   161,     0,   213,     0,   154,     0,   198,     0,   148,     0,   182, 
    0,   143,     0,   166,     0,   139,     0,   152,     0,   139,     0,   142,     0,   140,     0,   132,     0,   140,     0,   120,     0,   141,     0,   105,     0,   142,     0,    91, 
    0,   142,     1,    76,     0,   143,     0,    60,     0,   143,     0,    41,     0,   143,     1,    26,     0,   143,     1,    12,     0,   142,     8,     0,     0,   173,     1,   233, 
    0,   161,     0,   212,     0,   152,     0,   194,     0,   145,     0,   176,     0,   138,     0,   159,     0,   132,     0,   144,     0,   131,     0,   135,     0,   132,     0,   126, 
    0,   132,     0,   115,     0,   132,     0,   103,     0,   132,     0,    91,     0,   133,     0,    79,     0,   133,     0,    65,     0,   133,     0,    47,     0,   133,     0,    31, 
    0,   134,     0,    17,     0,   138,     5,     0,     0,   173,     0,   232,     0,   166,     0,   217,     0,   158,     0,   200,     0,   150,     0,   182,     0,   143,     0,   164, 
    0,   134,     0,   145,     0,   134,     0,   138,     0,   135,     0,   129,     0,   135,     0,   118,     0,   135,     0,   108,     0,   135,     0,    96,     0,   135,     0,    84, 
    0,   135,     0,    71,     0,   135,     0,    53,     0,   135,     0,    32,     0,   137,     0,    14,     0,   140,     0,     0,    67,    41,   198,   227,    62,    40,   206,   224, 
   54,    47,   209,   210,    50,    53,   208,   160,    43,    61,   211,   113,    31,    77,   208,    87,    16,    95,   202,    81,    11,   108,   192,    64,     8,   121,   184,    43, 
    1,   135,   177,    29,     0,   145,   171,    20,     0,   155,   166,    14,     0,   163,   161,    11,     0,   169,   155,     8,     0,   174,   149,     5,     0,   179,   145,     2, 
    0,   183,   141,     0,    69,    47,   177,   229,    65,    49,   181,   225,    58,    60,   181,   202,    49,    69,   187,   166,    45,    75,   191,   113,    32,    94,   187,    92, 
   18,   110,   187,    76,    11,   122,   182,    56,     2,   137,   174,    39,     0,   144,   170,    18,     0,   151,   163,     3,     0,   158,   155,     1,     0,   163,   148,     1, 
    0,   168,   142,     1,     0,   172,   139,     0,     0,   177,   137,     0,     0,   180,   136,     0,    70,    59,   157,   218,    66,    62,   157,   212,    60,    73,   158,   188, 
   47,    85,   167,   167,    44,    87,   173,   121,    32,   101,   174,    97,    17,   118,   176,    79,    11,   129,   172,    59,     4,   140,   166,    40,     0,   147,   163,    20, 
    0,   153,   156,     2,     0,   159,   147,     0,     0,   163,   140,     0,     0,   167,   135,     0,     0,   171,   132,     0,     0,   174,   130,     0,     0,   177,   131,     0, 
   65,    71,   133,   214,    62,    74,   135,   206,    58,    83,   140,   184,    52,    99,   140,   158,    42,   104,   150,   138,    34,   107,   158,   112,    16,   125,   163,    87, 
    9,   135,   160,    66,     0,   147,   155,    51,     0,   149,   152,    25,     0,   154,   147,     4,     0,   158,   139,     0,     0,   162,   132,     0,     0,   165,   128,     0, 
    0,   168,   125,     0,     0,   170,   122,     0,     0,   173,   123,     0,    60,    82,   113,   212,    59,    86,   115,   197,    53,    94,   120,   183,    46,   109,   124,   159, 
   36,   120,   129,   148,    27,   120,   138,   123,    12,   131,   146,    98,     6,   138,   146,    75,     2,   145,   142,    55,     0,   150,   140,    30,     0,   153,   135,    10, 
    0,   157,   129,     1,     0,   160,   124,     0,     0,   162,   120,     0,     0,   164,   116,     0,     0,   165,   114,     0,     0,   169,   114,     0,    41,    94,    93,   231, 
   39,   101,    97,   209,    34,   108,   104,   192,    29,   118,   111,   168,    24,   125,   115,   150,    12,   132,   122,   135,     6,   135,   128,   113,     3,   139,   129,    85, 
    0,   149,   125,    64,     0,   152,   122,    38,     0,   155,   119,    16,     0,   158,   116,     3,     0,   161,   111,     0,     0,   161,   108,     0,     0,   161,   105,     0, 
    0,   161,   103,     0,     0,   165,   102,     0,    20,   114,    83,   250,    22,   119,    81,   235,    20,   122,    87,   214,    16,   125,    96,   179,    14,   130,   101,   153, 
    7,   134,   105,   140,     0,   140,   110,   122,     1,   142,   110,   101,     0,   152,   108,    76,     0,   157,   104,    53,     0,   160,   101,    32,     0,   164,    98,    14, 
    0,   166,    94,     2,     0,   165,    92,     0,     0,   163,    90,     0,     0,   161,    89,     0,     0,   165,    85,     0,     6,   134,    73,   247,     8,   136,    72,   239, 
   10,   135,    72,   220,     7,   135,    79,   194,     3,   139,    88,   168,     2,   139,    91,   149,     0,   141,    94,   131,     0,   140,    97,   113,     0,   143,    97,    89, 
    0,   152,    94,    65,     0,   155,    91,    43,     0,   157,    89,    24,     0,   159,    86,     8,     0,   159,    84,     1,     0,   157,    83,     0,     0,   156,    82,     0, 
    0,   157,    81,     0,     0,   141,    57,   245,     0,   146,    58,   234,     1,   145,    60,   220,     0,   145,    66,   200,     0,   147,    71,   182,     0,   148,    74,   160, 
    0,   148,    76,   139,     0,   143,    82,   118,     0,   140,    84,    99,     0,   146,    82,    77,     0,   152,    78,    53,     0,   154,    77,    32,     0,   156,    75,    15, 
    0,   156,    74,     2,     0,   153,    74,     0,     0,   151,    74,     0,     0,   151,    74,     0,     0,   143,    38,   239,     0,   148,    40,   227,     0,   147,    44,   216, 
    0,   146,    50,   200,     0,   149,    54,   186,     0,   152,    57,   168,     0,   152,    60,   148,     0,   151,    62,   126,     0,   143,    67,   104,     0,   144,    67,    84, 
    0,   152,    63,    61,     0,   154,    62,    40,     0,   154,    62,    22,     0,   153,    62,     8,     0,   151,    63,     1,     0,   148,    64,     0,     0,   147,    65,     0, 
    0,   146,    24,   235,     0,   148,    25,   222,     0,   147,    30,   211,     0,   146,    35,   198,     0,   148,    38,   185,     0,   149,    40,   170,     0,   150,    43,   152, 
    0,   150,    44,   132,     0,   149,    46,   110,     0,   149,    49,    89,     0,   151,    48,    70,     0,   152,    46,    50,     0,   152,    47,    32,     0,   151,    48,    15, 
    0,   148,    48,     3,     0,   144,    51,     0,     0,   141,    55,     0,     0,   151,    15,   234,     0,   150,    14,   219,     0,   148,    18,   208,     0,   146,    22,   196, 
    0,   147,    24,   184,     0,   146,    26,   170,     0,   146,    26,   153,     0,   147,    28,   135,     0,   147,    30,   116,     0,   147,    31,    96,     0,   149,    32,    77, 
    0,   150,    32,    59,     0,   150,    31,    40,     0,   149,    32,    24,     0,   146,    33,     9,     0,   143,    36,     1,     0,   136,    43,     0,     0,   156,     9,   234, 
    0,   152,     6,   217,     0,   148,     9,   205,     0,   146,    10,   195,     0,   145,    12,   182,     0,   144,    12,   169,     0,   144,    13,   154,     0,   144,    15,   137, 
    0,   145,    16,   120,     0,   145,    17,   101,     0,   146,    18,    84,     0,   146,    18,    66,     0,   147,    18,    47,     0,   146,    18,    31,     0,   145,    19,    16, 
    0,   142,    21,     4,     0,   134,    31,     0,     0,   160,     5,   234,     0,   153,     2,   215,     0,   148,     3,   203,     0,   145,     2,   192,     0,   143,     2,   179, 
    0,   141,     2,   164,     0,   140,     3,   150,     0,   139,     4,   136,     0,   140,     6,   121,     0,   140,     6,   104,     0,   141,     7,    88,     0,   141,     7,    72, 
    0,   141,     7,    53,     0,   142,     7,    36,     0,   140,     8,    21,     0,   140,     8,     9,     0,   133,    18,     0,     0,   163,     3,   233,     0,   153,     0,   212, 
    0,   147,     0,   198,     0,   142,     0,   184,     0,   137,     0,   168,     0,   132,     0,   153,     0,   130,     0,   139,     0,   130,     0,   128,     0,   131,     0,   116, 
    0,   131,     0,   102,     0,   132,     1,    89,     0,   133,     1,    75,     0,   133,     1,    59,     0,   133,     1,    41,     0,   133,     1,    26,     0,   133,     1,    13, 
    0,   130,     9,     0,     0,   165,     1,   232,     0,   154,     0,   211,     0,   146,     0,   194,     0,   139,     0,   177,     0,   132,     0,   160,     0,   125,     0,   143, 
    0,   120,     0,   126,     0,   119,     0,   116,     0,   120,     0,   107,     0,   120,     0,    97,     0,   121,     0,    87,     0,   121,     0,    76,     0,   121,     0,    62, 
    0,   121,     0,    46,     0,   121,     0,    31,     0,   122,     0,    17,     0,   124,     5,     0,     0,   166,     0,   231,     0,   159,     0,   216,     0,   152,     0,   200, 
    0,   145,     0,   183,     0,   138,     0,   165,     0,   129,     0,   146,     0,   118,     0,   124,     0,   119,     0,   116,     0,   119,     0,   106,     0,   119,     0,    98, 
    0,   119,     0,    89,     0,   119,     0,    79,     0,   120,     0,    67,     0,   119,     0,    50,     0,   120,     0,    30,     0,   121,     0,    12,     0,   122,     0,     0, 
   45,    44,   196,   229,    40,    44,   202,   227,    33,    50,   205,   215,    27,    56,   204,   181,    24,    60,   207,   139,    12,    78,   204,   113,     0,    91,   199,    98, 
    0,    90,   198,    76,     1,    96,   189,    50,     0,   107,   182,    29,     0,   121,   177,    16,     0,   133,   172,    12,     0,   144,   167,     9,     0,   152,   162,     7, 
    0,   158,   157,     4,     0,   164,   153,     2,     0,   168,   148,     0,    48,    51,   179,   230,    45,    51,   182,   227,    37,    61,   184,   208,    26,    71,   187,   184, 
   25,    72,   191,   138,    15,    86,   191,   110,     2,   100,   188,    93,     0,   103,   185,    70,     1,   110,   179,    41,     0,   118,   174,    19,     0,   127,   168,     3, 
    0,   137,   161,     1,     0,   146,   155,     1,     0,   152,   149,     1,     0,   157,   145,     0,     0,   162,   142,     0,     0,   164,   142,     0,    46,    64,   158,   221, 
   42,    66,   160,   216,    34,    77,   162,   195,    23,    84,   171,   181,    21,    83,   178,   142,    16,    92,   180,   113,     3,   107,   179,    95,     4,   108,   177,    69, 
    3,   116,   172,    44,     0,   124,   167,    23,     0,   131,   162,     4,     0,   139,   154,     0,     0,   146,   146,     0,     0,   152,   141,     0,     0,   156,   136,     0, 
    0,   159,   134,     0,     0,   161,   135,     0,    39,    75,   143,   213,    36,    78,   145,   207,    31,    84,   147,   193,    22,    92,   152,   177,    16,    99,   159,   158, 
   15,   100,   164,   129,     4,   114,   166,   103,     1,   116,   164,    79,     0,   123,   160,    52,     0,   127,   157,    28,     0,   133,   153,     8,     0,   140,   145,     1, 
    0,   146,   138,     0,     0,   150,   132,     0,     0,   153,   127,     0,     0,   156,   125,     0,     0,   158,   127,     0,    30,    85,   129,   212,    30,    88,   130,   204, 
   28,    91,   133,   191,    20,    99,   137,   175,    16,   114,   137,   154,    11,   112,   145,   134,     3,   118,   150,   110,     1,   120,   151,    85,     1,   124,   147,    58, 
    0,   130,   144,    36,     0,   134,   141,    14,     0,   140,   135,     1,     0,   144,   128,     0,     0,   147,   122,     0,     0,   150,   119,     0,     0,   152,   116,     0, 
    0,   156,   117,     0,    22,    92,   112,   227,    19,    96,   115,   208,    19,    99,   119,   193,    18,   104,   124,   179,     9,   116,   125,   155,     0,   125,   129,   142, 
    0,   123,   132,   122,     0,   121,   136,    96,     0,   127,   132,    68,     0,   132,   130,    43,     0,   135,   127,    19,     0,   139,   122,     2,     0,   142,   117,     0, 
    0,   144,   112,     0,     0,   146,   109,     0,     0,   147,   107,     0,     0,   152,   106,     0,    10,   102,    93,   246,     9,   107,    99,   220,    11,   105,   101,   199, 
   10,   107,   104,   180,     6,   115,   109,   156,     0,   122,   112,   140,     0,   124,   114,   125,     0,   123,   117,   104,     0,   129,   115,    75,     0,   132,   111,    51, 
    0,   136,   109,    27,     0,   140,   107,     7,     0,   142,   103,     1,     0,   143,   100,     0,     0,   143,    97,     0,     0,   144,    95,     0,     0,   147,    93,     0, 
    0,   112,    79,   250,     0,   111,    83,   239,     1,   111,    87,   220,     5,   110,    86,   194,     1,   115,    93,   166,     0,   120,    95,   142,     0,   123,    96,   128, 
    0,   129,    97,   107,     0,   129,    98,    86,     0,   134,    94,    63,     0,   139,    91,    41,     0,   143,    89,    21,     0,   146,    86,     6,     0,   147,    84,     0, 
    0,   146,    82,     0,     0,   145,    80,     0,     0,   147,    76,     0,     0,   118,    59,   246,     0,   122,    61,   234,     0,   123,    65,   220,     0,   123,    69,   200, 
    0,   126,    74,   181,     0,   127,    79,   153,     0,   128,    81,   134,     0,   128,    83,   116,     0,   127,    85,    97,     0,   130,    83,    76,     0,   136,    80,    53, 
    0,   139,    78,    32,     0,   141,    77,    14,     0,   142,    76,     2,     0,   140,    75,     0,     0,   139,    73,     0,     0,   140,    72,     0,     0,   123,    42,   240, 
    0,   128,    44,   228,     0,   129,    49,   214,     0,   129,    54,   199,     0,   133,    57,   185,     0,   136,    61,   167,     0,   136,    63,   146,     0,   134,    65,   125, 
    0,   128,    69,   104,     0,   125,    72,    85,     0,   131,    69,    65,     0,   137,    66,    41,     0,   139,    65,    21,     0,   140,    65,     7,     0,   138,    64,     1, 
    0,   136,    64,     0,     0,   134,    64,     0,     0,   127,    29,   235,     0,   131,    30,   222,     0,   132,    35,   209,     0,   133,    38,   197,     0,   135,    41,   185, 
    0,   138,    44,   170,     0,   138,    46,   153,     0,   138,    47,   132,     0,   136,    50,   111,     0,   130,    55,    90,     0,   130,    55,    72,     0,   137,    51,    50, 
    0,   139,    51,    30,     0,   138,    52,    13,     0,   137,    52,     2,     0,   133,    53,     0,     0,   130,    55,     0,     0,   134,    18,   233,     0,   135,    18,   217, 
    0,   134,    22,   206,     0,   134,    25,   196,     0,   135,    27,   184,     0,   135,    29,   169,     0,   135,    30,   153,     0,   135,    31,   135,     0,   135,    32,   116, 
    0,   135,    34,    96,     0,   135,    36,    77,     0,   137,    35,    59,     0,   138,    34,    39,     0,   137,    35,    23,     0,   135,    36,     8,     0,   131,    38,     1, 
    0,   125,    44,     0,     0,   140,    10,   233,     0,   139,     9,   214,     0,   136,    11,   203,     0,   135,    13,   194,     0,   134,    14,   182,     0,   134,    16,   168, 
    0,   134,    16,   153,     0,   133,    17,   136,     0,   133,    18,   118,     0,   133,    19,   100,     0,   134,    20,    83,     0,   135,    21,    65,     0,   135,    21,    47, 
    0,   136,    21,    30,     0,   135,    21,    15,     0,   131,    23,     3,     0,   121,    32,     0,     0,   146,     6,   232,     0,   141,     3,   213,     0,   137,     4,   202, 
    0,   135,     4,   192,     0,   133,     4,   179,     0,   131,     5,   165,     0,   130,     5,   150,     0,   129,     6,   134,     0,   130,     7,   119,     0,   130,     8,   102, 
    0,   130,     8,    87,     0,   131,     9,    71,     0,   131,     9,    53,     0,   132,     9,    36,     0,   131,     9,    21,     0,   129,    10,     8,     0,   119,    20,     0, 
    0,   150,     3,   231,     0,   144,     1,   211,     0,   138,     0,   199,     0,   133,     0,   186,     0,   129,     0,   170,     0,   125,     0,   154,     0,   122,     0,   139, 
    0,   121,     0,   125,     0,   121,     1,   113,     0,   122,     1,   100,     0,   123,     1,    88,     0,   124,     1,    74,     0,   124,     1,    58,     0,   124,     1,    41, 
    0,   124,     1,    25,     0,   123,     1,    12,     0,   116,     9,     0,     0,   154,     1,   231,     0,   146,     0,   210,     0,   138,     0,   194,     0,   131,     0,   178, 
    0,   125,     0,   161,     0,   118,     0,   143,     0,   112,     0,   125,     0,   108,     0,   109,     0,   108,     0,   100,     0,   109,     0,    92,     0,   109,     0,    83, 
    0,   110,     0,    73,     0,   110,     0,    60,     0,   110,     0,    44,     0,   109,     0,    30,     0,   109,     0,    17,     0,   109,     4,     0,     0,   157,     0,   230, 
    0,   151,     0,   216,     0,   144,     0,   201,     0,   138,     0,   184,     0,   131,     0,   166,     0,   122,     0,   146,     0,   112,     0,   124,     0,   101,     0,   102, 
    0,   102,     0,    94,     0,   102,     0,    88,     0,   102,     0,    81,     0,   102,     0,    73,     0,   103,     0,    61,     0,   102,     0,    46,     0,   102,     0,    28, 
    0,   103,     0,    11,     0,   104,     0,     0,    21,    48,   196,   230,    18,    48,   200,   228,    11,    53,   202,   217,     6,    59,   201,   192,     2,    64,   201,   165, 
    0,    70,   199,   129,     0,    70,   198,    97,     0,    70,   198,    73,     0,    69,   196,    52,     0,    81,   188,    30,     0,    95,   183,    14,     0,   110,   179,     7, 
    0,   123,   173,     7,     0,   133,   168,     6,     0,   141,   164,     4,     0,   148,   160,     2,     0,   154,   155,     0,    26,    54,   181,   231,    24,    55,   183,   229, 
   18,    62,   182,   209,     3,    74,   186,   191,     0,    77,   190,   163,     0,    82,   189,   128,     0,    82,   188,    95,     0,    84,   186,    71,     0,    86,   183,    47, 
    0,    94,   178,    23,     0,   103,   173,     3,     0,   115,   165,     1,     0,   126,   159,     1,     0,   134,   155,     1,     0,   141,   151,     0,     0,   147,   148,     0, 
    0,   150,   149,     0,    26,    64,   164,   221,    24,    66,   165,   216,    19,    73,   166,   199,     7,    79,   172,   185,     4,    79,   180,   157,     2,    85,   181,   130, 
    0,    89,   179,    99,     0,    91,   178,    76,     0,    94,   175,    51,     0,    99,   171,    25,     0,   107,   166,     4,     0,   118,   158,     0,     0,   127,   152,     0, 
    0,   134,   147,     0,     0,   140,   142,     0,     0,   144,   139,     0,     0,   147,   141,     0,    22,    72,   150,   215,    20,    74,   150,   209,    17,    78,   153,   196, 
    6,    86,   160,   183,     0,    91,   164,   167,     0,    92,   167,   144,     0,    95,   168,   108,     0,    96,   167,    81,     0,    98,   165,    56,     0,   104,   162,    31, 
    0,   111,   157,     9,     0,   120,   151,     1,     0,   128,   144,     0,     0,   134,   138,     0,     0,   139,   133,     0,     0,   142,   130,     0,     0,   144,   133,     0, 
   17,    79,   136,   212,    16,    81,   136,   206,    13,    85,   138,   193,     5,    92,   144,   181,     1,    96,   146,   165,     0,    98,   150,   146,     0,    99,   153,   114, 
    0,   101,   154,    88,     0,   103,   152,    63,     0,   108,   150,    38,     0,   114,   146,    16,     0,   121,   141,     1,     0,   128,   134,     0,     0,   132,   128,     0, 
    0,   136,   122,     0,     0,   139,   119,     0,     0,   142,   120,     0,    11,    82,   121,   226,    12,    87,   124,   205,     9,    91,   127,   190,     5,    96,   129,   178, 
    0,   100,   132,   162,     0,   109,   131,   144,     0,   107,   134,   124,     0,   103,   138,   100,     0,   107,   138,    70,     0,   112,   136,    46,     0,   117,   133,    23, 
    0,   121,   129,     4,     0,   126,   123,     0,     0,   130,   116,     0,     0,   132,   111,     0,     0,   135,   109,     0,     0,   139,   109,     0,     1,    89,   103,   243, 
    1,    94,   109,   213,     2,    96,   110,   190,     2,    98,   113,   178,     0,   102,   116,   162,     0,   109,   115,   139,     0,   113,   114,   127,     0,   110,   119,   107, 
    0,   111,   121,    77,     0,   113,   120,    54,     0,   118,   118,    31,     0,   121,   115,     9,     0,   124,   109,     1,     0,   126,   104,     0,     0,   128,   101,     0, 
    0,   130,    98,     0,     0,   134,    97,     0,     0,    91,    80,   247,     3,    91,    84,   217,     0,    95,    91,   202,     0,    97,    95,   187,     0,   100,    98,   167, 
    0,   106,   100,   143,     0,   109,   100,   126,     0,   111,   102,   109,     0,   112,   104,    86,     0,   113,   102,    63,     0,   118,    98,    39,     0,   122,    96,    17, 
    0,   124,    94,     2,     0,   126,    91,     0,     0,   127,    88,     0,     0,   127,    85,     0,     0,   130,    83,     0,     0,    91,    61,   247,     0,    97,    65,   231, 
    0,   100,    69,   214,     0,   100,    73,   198,     0,   103,    76,   178,     0,   106,    81,   150,     0,   110,    83,   127,     0,   111,    84,   112,     0,   114,    85,    94, 
    0,   113,    84,    74,     0,   120,    81,    51,     0,   124,    79,    29,     0,   127,    77,    11,     0,   129,    75,     1,     0,   129,    73,     0,     0,   128,    71,     0, 
    0,   130,    67,     0,     0,    99,    45,   241,     0,   105,    48,   228,     0,   106,    53,   213,     0,   107,    57,   199,     0,   109,    60,   183,     0,   111,    64,   163, 
    0,   113,    68,   137,     0,   113,    69,   120,     0,   112,    71,   102,     0,   111,    73,    83,     0,   115,    70,    64,     0,   121,    68,    40,     0,   124,    67,    20, 
    0,   126,    66,     5,     0,   125,    65,     0,     0,   122,    64,     0,     0,   121,    62,     0,     0,   106,    32,   235,     0,   111,    34,   222,     0,   112,    39,   209, 
    0,   114,    42,   197,     0,   116,    44,   185,     0,   119,    48,   170,     0,   121,    50,   151,     0,   120,    51,   131,     0,   119,    53,   110,     0,   113,    57,    89, 
    0,   110,    59,    73,     0,   116,    57,    54,     0,   123,    54,    29,     0,   124,    54,    11,     0,   124,    53,     1,     0,   120,    54,     0,     0,   116,    54,     0, 
    0,   115,    21,   232,     0,   116,    22,   218,     0,   117,    25,   205,     0,   118,    28,   196,     0,   119,    30,   184,     0,   121,    32,   170,     0,   122,    34,   154, 
    0,   122,    35,   135,     0,   121,    36,   114,     0,   119,    38,    95,     0,   114,    43,    78,     0,   115,    43,    62,     0,   122,    39,    39,     0,   124,    39,    20, 
    0,   122,    40,     6,     0,   118,    41,     1,     0,   112,    43,     0,     0,   123,    13,   232,     0,   123,    11,   214,     0,   122,    13,   203,     0,   121,    15,   194, 
    0,   120,    17,   182,     0,   121,    18,   169,     0,   120,    19,   153,     0,   120,    20,   136,     0,   120,    21,   116,     0,   119,    23,    98,     0,   119,    24,    82, 
    0,   120,    25,    65,     0,   122,    24,    47,     0,   124,    24,    29,     0,   123,    24,    14,     0,   118,    26,     2,     0,   107,    33,     0,     0,   130,     7,   230, 
    0,   128,     4,   211,     0,   125,     5,   201,     0,   123,     6,   191,     0,   121,     6,   180,     0,   119,     7,   165,     0,   118,     7,   150,     0,   118,     8,   134, 
    0,   118,     8,   117,     0,   119,     9,   101,     0,   119,    10,    86,     0,   120,    10,    70,     0,   120,    11,    52,     0,   121,    11,    36,     0,   121,    11,    20, 
    0,   118,    12,     7,     0,   104,    21,     0,     0,   136,     4,   229,     0,   131,     1,   210,     0,   127,     1,   198,     0,   123,     0,   186,     0,   119,     0,   172, 
    0,   115,     1,   156,     0,   113,     1,   141,     0,   112,     1,   126,     0,   112,     1,   111,     0,   113,     1,    98,     0,   113,     1,    87,     0,   115,     1,    73, 
    0,   115,     1,    57,     0,   114,     2,    40,     0,   115,     1,    25,     0,   113,     2,    11,     0,   102,    10,     0,     0,   141,     2,   229,     0,   135,     0,   209, 
    0,   128,     0,   193,     0,   122,     0,   177,     0,   115,     0,   161,     0,   109,     0,   143,     0,   104,     0,   126,     0,   100,     0,   109,     0,    98,     0,    96, 
    0,    98,     0,    88,     0,    99,     0,    80,     0,   100,     0,    70,     0,   100,     0,    58,     0,   100,     0,    43,     0,    99,     0,    29,     0,    98,     0,    17, 
    0,    94,     4,     0,     0,   146,     0,   229,     0,   140,     0,   216,     0,   135,     0,   201,     0,   129,     0,   185,     0,   122,     0,   166,     0,   113,     0,   146, 
    0,   104,     0,   125,     0,    95,     0,   102,     0,    87,     0,    84,     0,    85,     0,    77,     0,    85,     0,    71,     0,    85,     0,    64,     0,    86,     0,    55, 
    0,    86,     0,    43,     0,    86,     0,    27,     0,    86,     0,    11,     0,    88,     0,     0,     5,    45,   197,   232,     4,    42,   201,   230,     1,    44,   203,   218, 
    0,    48,   199,   197,     0,    49,   197,   170,     0,    51,   197,   136,     0,    52,   198,   102,     0,    52,   198,    75,     0,    52,   196,    52,     0,    54,   196,    36, 
    0,    70,   191,    19,     0,    86,   186,     6,     0,   100,   180,     2,     0,   113,   174,     3,     0,   123,   169,     3,     0,   131,   165,     2,     0,   138,   161,     0, 
    8,    51,   184,   235,     6,    52,   184,   231,     0,    59,   186,   210,     0,    59,   183,   192,     0,    58,   188,   163,     0,    60,   188,   133,     0,    63,   188,    99, 
    0,    66,   187,    74,     0,    68,   184,    50,     0,    71,   182,    29,     0,    80,   177,     9,     0,    93,   170,     1,     0,   105,   164,     0,     0,   115,   159,     0, 
    0,   124,   156,     0,     0,   131,   153,     0,     0,   135,   154,     0,     8,    55,   174,   235,     7,    60,   169,   219,     2,    70,   166,   199,     0,    68,   172,   186, 
    0,    64,   180,   161,     0,    66,   181,   135,     0,    69,   180,   102,     0,    72,   179,    78,     0,    75,   176,    54,     0,    78,   174,    32,     0,    84,   170,    10, 
    0,    96,   162,     1,     0,   107,   155,     0,     0,   116,   151,     0,     0,   123,   147,     0,     0,   129,   145,     0,     0,   132,   147,     0,     5,    60,   161,   230, 
    6,    64,   153,   214,     0,    73,   157,   197,     0,    74,   159,   183,     0,    75,   164,   168,     0,    76,   167,   148,     0,    78,   168,   120,     0,    77,   168,    91, 
    0,    80,   167,    61,     0,    83,   165,    37,     0,    89,   162,    14,     0,    98,   155,     1,     0,   109,   148,     0,     0,   117,   142,     0,     0,   122,   138,     0, 
    0,   127,   135,     0,     0,   129,   138,     0,     4,    66,   144,   228,     3,    71,   142,   210,     0,    77,   144,   194,     0,    79,   145,   180,     0,    82,   148,   165, 
    0,    83,   151,   150,     0,    83,   153,   126,     0,    83,   154,    98,     0,    86,   155,    66,     0,    88,   154,    42,     0,    93,   151,    19,     0,   100,   146,     2, 
    0,   109,   139,     0,     0,   116,   133,     0,     0,   121,   128,     0,     0,   125,   124,     0,     0,   127,   126,     0,     0,    72,   129,   233,     0,    78,   131,   209, 
    1,    82,   132,   192,     0,    83,   132,   179,     0,    85,   135,   165,     0,    88,   136,   148,     0,    87,   137,   130,     0,    87,   140,   103,     0,    91,   141,    72, 
    0,    92,   140,    49,     0,    97,   138,    25,     0,   102,   135,     6,     0,   109,   129,     0,     0,   114,   122,     0,     0,   118,   116,     0,     0,   122,   112,     0, 
    0,   125,   113,     0,     0,    72,   107,   240,     0,    79,   112,   207,     0,    84,   114,   187,     0,    86,   117,   176,     0,    88,   119,   161,     0,    90,   121,   143, 
    0,    97,   117,   128,     0,    94,   121,   109,     0,    94,   125,    79,     0,    94,   126,    57,     0,    99,   124,    34,     0,   104,   121,    14,     0,   108,   116,     1, 
    0,   112,   110,     0,     0,   115,   104,     0,     0,   118,   100,     0,     0,   122,    99,     0,     0,    75,    85,   238,     0,    78,    92,   210,     0,    82,    96,   195, 
    0,    83,   101,   181,     0,    87,   103,   164,     0,    89,   104,   144,     0,    95,   103,   125,     0,    98,   103,   111,     0,    96,   107,    91,     0,    93,   110,    68, 
    0,    99,   107,    42,     0,   104,   105,    20,     0,   106,   101,     2,     0,   109,    96,     0,     0,   112,    91,     0,     0,   114,    88,     0,     0,   117,    86,     0, 
    0,    76,    65,   242,     0,    80,    69,   225,     0,    82,    73,   207,     0,    82,    80,   190,     0,    84,    84,   171,     0,    88,    86,   151,     0,    93,    87,   128, 
    0,    95,    88,   110,     0,    95,    89,    93,     0,    94,    91,    74,     0,   100,    87,    50,     0,   104,    85,    27,     0,   106,    83,     7,     0,   109,    81,     0, 
    0,   110,    78,     0,     0,   110,    76,     0,     0,   112,    72,     0,     0,    76,    48,   242,     0,    82,    51,   227,     0,    83,    56,   212,     0,    82,    62,   197, 
    0,    85,    65,   179,     0,    88,    69,   160,     0,    93,    71,   134,     0,    94,    73,   113,     0,    95,    72,    98,     0,    97,    71,    82,     0,    99,    71,    61, 
    0,   105,    68,    37,     0,   109,    67,    17,     0,   111,    65,     3,     0,   111,    63,     0,     0,   110,    62,     0,     0,   112,    58,     0,     0,    85,    35,   236, 
    0,    89,    37,   223,     0,    91,    41,   210,     0,    93,    44,   197,     0,    95,    47,   184,     0,    95,    51,   168,     0,    98,    54,   147,     0,    99,    56,   122, 
    0,    98,    57,   105,     0,    97,    58,    88,     0,    96,    60,    71,     0,   101,    58,    52,     0,   106,    56,    28,     0,   109,    55,    10,     0,   108,    54,     1, 
    0,   106,    54,     0,     0,   104,    52,     0,     0,    94,    24,   231,     0,    96,    26,   217,     0,    97,    28,   206,     0,   100,    30,   195,     0,   101,    32,   184, 
    0,   103,    35,   171,     0,   104,    37,   154,     0,   105,    38,   134,     0,   103,    40,   112,     0,    98,    44,    92,     0,    95,    48,    77,     0,    96,    48,    62, 
    0,   102,    44,    42,     0,   108,    42,    19,     0,   107,    42,     4,     0,   104,    42,     0,     0,   100,    43,     0,     0,   104,    15,   229,     0,   104,    15,   214, 
    0,   104,    16,   204,     0,   104,    17,   193,     0,   105,    19,   183,     0,   106,    21,   170,     0,   106,    22,   154,     0,   106,    24,   136,     0,   105,    25,   116, 
    0,   100,    29,    94,     0,    99,    31,    79,     0,   100,    32,    65,     0,   102,    31,    49,     0,   109,    27,    28,     0,   109,    27,    11,     0,   104,    29,     1, 
    0,    96,    33,     0,     0,   112,     8,   229,     0,   111,     6,   213,     0,   110,     7,   202,     0,   109,     7,   192,     0,   107,     8,   180,     0,   106,     9,   166, 
    0,   105,    10,   151,     0,   105,    11,   135,     0,   105,    11,   118,     0,   105,    11,    99,     0,   105,    13,    84,     0,   105,    14,    69,     0,   105,    14,    52, 
    0,   107,    14,    35,     0,   109,    13,    19,     0,   105,    15,     5,     0,    93,    22,     0,     0,   119,     4,   228,     0,   117,     2,   209,     0,   114,     1,   199, 
    0,   111,     1,   187,     0,   107,     1,   173,     0,   104,     1,   159,     0,   102,     1,   145,     0,   102,     1,   129,     0,   102,     1,   113,     0,   102,     1,    97, 
    0,   102,     2,    85,     0,   103,     2,    72,     0,   103,     3,    56,     0,   103,     3,    39,     0,   103,     3,    24,     0,   102,     4,    10,     0,    90,    12,     0, 
    0,   126,     2,   227,     0,   122,     0,   207,     0,   117,     0,   191,     0,   111,     0,   176,     0,   105,     0,   160,     0,    99,     0,   144,     0,    95,     0,   127, 
    0,    92,     0,   111,     0,    90,     0,    96,     0,    89,     0,    85,     0,    89,     0,    76,     0,    90,     0,    67,     0,    90,     0,    56,     0,    90,     0,    43, 
    0,    90,     0,    29,     0,    89,     1,    16,     0,    84,     5,     0,     0,   133,     0,   228,     0,   128,     0,   215,     0,   123,     0,   200,     0,   117,     0,   185, 
    0,   111,     0,   167,     0,   104,     0,   146,     0,    96,     0,   125,     0,    87,     0,   103,     0,    78,     0,    83,     0,    77,     0,    73,     0,    77,     0,    67, 
    0,    77,     0,    61,     0,    77,     0,    53,     0,    77,     0,    42,     0,    77,     0,    28,     0,    77,     0,    11,     0,    77,     0,     0,     2,    32,   197,   235, 
    1,    30,   200,   233,     1,    29,   201,   221,     0,    34,   198,   200,     0,    35,   196,   175,     0,    37,   196,   145,     0,    38,   196,   111,     0,    39,   199,    83, 
    0,    40,   200,    59,     0,    41,   199,    39,     0,    43,   200,    26,     0,    61,   193,    12,     0,    77,   187,     3,     0,    92,   180,     0,     0,   103,   174,     0, 
    0,   114,   170,     1,     0,   122,   166,     0,     1,    35,   190,   236,     2,    39,   185,   234,     0,    44,   182,   212,     0,    45,   182,   194,     0,    42,   186,   164, 
    0,    44,   187,   139,     0,    46,   186,   106,     0,    48,   187,    79,     0,    50,   185,    55,     0,    53,   184,    35,     0,    56,   182,    16,     0,    69,   176,     3, 
    0,    84,   169,     0,     0,    96,   163,     0,     0,   105,   160,     0,     0,   114,   157,     0,     0,   119,   159,     0,     1,    39,   182,   238,     1,    46,   173,   225, 
    0,    57,   165,   199,     0,    53,   170,   187,     0,    49,   178,   161,     0,    50,   179,   140,     0,    51,   178,   109,     0,    55,   179,    82,     0,    57,   176,    58, 
    0,    60,   175,    37,     0,    63,   173,    17,     0,    73,   168,     2,     0,    86,   160,     0,     0,    97,   154,     0,     0,   106,   150,     0,     0,   112,   149,     0, 
    0,   116,   152,     0,     1,    43,   168,   239,     0,    52,   160,   222,     0,    59,   153,   195,     0,    59,   158,   184,     0,    62,   162,   167,     0,    62,   164,   149, 
    0,    63,   165,   127,     0,    61,   167,    99,     0,    64,   167,    66,     0,    67,   166,    43,     0,    69,   165,    21,     0,    76,   159,     2,     0,    88,   151,     0, 
    0,    99,   145,     0,     0,   105,   142,     0,     0,   111,   140,     0,     0,   113,   143,     0,     0,    48,   151,   239,     0,    56,   145,   217,     0,    64,   143,   195, 
    0,    65,   145,   182,     0,    68,   149,   164,     0,    71,   150,   149,     0,    72,   150,   132,     0,    68,   154,   104,     0,    71,   156,    69,     0,    72,   155,    46, 
    0,    74,   154,    24,     0,    79,   150,     3,     0,    90,   142,     0,     0,    98,   136,     0,     0,   104,   132,     0,     0,   109,   129,     0,     0,   112,   132,     0, 
    0,    52,   132,   238,     0,    61,   131,   211,     0,    67,   131,   191,     0,    68,   133,   181,     0,    72,   138,   164,     0,    74,   138,   147,     0,    75,   138,   130, 
    0,    72,   141,   108,     0,    75,   143,    75,     0,    76,   143,    51,     0,    77,   142,    28,     0,    82,   139,     8,     0,    90,   133,     1,     0,    97,   126,     0, 
    0,   103,   121,     0,     0,   108,   117,     0,     0,   110,   119,     0,     0,    56,   111,   239,     0,    64,   115,   206,     0,    71,   118,   186,     0,    73,   119,   175, 
    0,    74,   121,   161,     0,    76,   123,   145,     0,    76,   122,   129,     0,    75,   125,   111,     0,    77,   128,    81,     0,    78,   129,    60,     0,    79,   128,    37, 
    0,    84,   126,    15,     0,    89,   121,     2,     0,    96,   115,     0,     0,   101,   109,     0,     0,   105,   104,     0,     0,   108,   104,     0,     0,    59,    90,   237, 
    0,    64,    97,   208,     0,    68,   100,   192,     0,    71,   104,   177,     0,    75,   105,   159,     0,    76,   106,   143,     0,    77,   106,   128,     0,    83,   104,   113, 
    0,    81,   108,    93,     0,    77,   112,    71,     0,    81,   111,    45,     0,    86,   109,    23,     0,    89,   106,     5,     0,    94,   101,     0,     0,    98,    95,     0, 
    0,   101,    91,     0,     0,   104,    88,     0,     0,    61,    71,   238,     0,    66,    75,   215,     0,    68,    80,   201,     0,    70,    86,   182,     0,    75,    88,   158, 
    0,    76,    89,   143,     0,    78,    89,   128,     0,    82,    89,   109,     0,    84,    89,    96,     0,    81,    93,    76,     0,    83,    93,    51,     0,    86,    92,    29, 
    0,    89,    90,     9,     0,    92,    86,     1,     0,    95,    81,     0,     0,    97,    78,     0,     0,    98,    75,     0,     0,    63,    52,   238,     0,    67,    57,   220, 
    0,    69,    61,   206,     0,    68,    68,   190,     0,    71,    72,   172,     0,    74,    74,   154,     0,    76,    75,   135,     0,    79,    75,   113,     0,    81,    75,    96, 
    0,    81,    75,    79,     0,    83,    75,    60,     0,    86,    74,    37,     0,    90,    70,    17,     0,    92,    70,     2,     0,    94,    68,     0,     0,    94,    65,     0, 
    0,    95,    63,     0,     0,    62,    37,   236,     0,    69,    41,   222,     0,    72,    45,   209,     0,    74,    47,   196,     0,    77,    50,   180,     0,    78,    54,   163, 
    0,    80,    56,   145,     0,    81,    58,   120,     0,    82,    60,    99,     0,    81,    60,    85,     0,    82,    58,    71,     0,    85,    58,    49,     0,    91,    56,    25, 
    0,    94,    55,     7,     0,    94,    53,     0,     0,    94,    51,     0,     0,    95,    48,     0,     0,    73,    26,   232,     0,    76,    28,   218,     0,    78,    31,   207, 
    0,    82,    32,   196,     0,    84,    35,   183,     0,    83,    39,   169,     0,    85,    40,   153,     0,    85,    42,   133,     0,    84,    45,   108,     0,    82,    48,    89, 
    0,    81,    48,    75,     0,    83,    48,    59,     0,    87,    46,    39,     0,    92,    43,    17,     0,    93,    43,     2,     0,    90,    43,     0,     0,    88,    42,     0, 
    0,    84,    17,   228,     0,    85,    18,   213,     0,    86,    19,   204,     0,    87,    20,   194,     0,    88,    22,   183,     0,    89,    24,   170,     0,    90,    25,   155, 
    0,    91,    27,   138,     0,    90,    29,   116,     0,    86,    32,    94,     0,    82,    35,    77,     0,    82,    36,    64,     0,    84,    35,    49,     0,    88,    32,    30, 
    0,    92,    30,     9,     0,    90,    31,     1,     0,    85,    33,     0,     0,    93,    10,   226,     0,    93,     9,   212,     0,    93,     9,   202,     0,    92,     9,   192, 
    0,    92,    10,   180,     0,    92,    12,   166,     0,    92,    13,   152,     0,    92,    14,   136,     0,    92,    14,   118,     0,    91,    15,    99,     0,    86,    19,    80, 
    0,    86,    20,    66,     0,    85,    21,    52,     0,    87,    20,    36,     0,    94,    16,    17,     0,    92,    17,     3,     0,    82,    23,     0,     0,   101,     5,   226, 
    0,   100,     3,   210,     0,    98,     2,   200,     0,    96,     1,   189,     0,    94,     2,   176,     0,    92,     2,   161,     0,    91,     3,   145,     0,    90,     3,   130, 
    0,    90,     3,   115,     0,    90,     3,    98,     0,    89,     4,    82,     0,    89,     5,    69,     0,    89,     6,    55,     0,    89,     6,    39,     0,    91,     5,    23, 
    0,    91,     5,     9,     0,    79,    13,     0,     0,   109,     2,   225,     0,   107,     0,   207,     0,   102,     0,   192,     0,    98,     0,   177,     0,    94,     0,   161, 
    0,    90,     0,   145,     0,    86,     0,   129,     0,    84,     0,   113,     0,    82,     0,    99,     0,    80,     0,    85,     0,    80,     0,    75,     0,    81,     0,    65, 
    0,    82,     0,    55,     0,    82,     0,    42,     0,    82,     0,    29,     0,    81,     1,    15,     0,    75,     5,     0,     0,   117,     0,   226,     0,   114,     0,   213, 
    0,   109,     0,   199,     0,   104,     0,   184,     0,    99,     0,   167,     0,    93,     0,   147,     0,    87,     0,   126,     0,    79,     0,   105,     0,    71,     0,    85, 
    0,    69,     0,    74,     0,    69,     0,    65,     0,    69,     0,    59,     0,    69,     0,    51,     0,    69,     0,    41,     0,    69,     0,    28,     0,    69,     0,    13, 
    0,    69,     0,     0,     0,    24,   197,   236,     0,    22,   200,   234,     0,    20,   202,   225,     0,    23,   199,   204,     0,    25,   197,   179,     0,    26,   196,   152, 
    0,    28,   196,   124,     0,    28,   200,    93,     0,    29,   202,    66,     0,    31,   202,    46,     0,    32,   203,    29,     0,    33,   203,    18,     0,    53,   195,     8, 
    0,    70,   188,     2,     0,    85,   181,     0,     0,    96,   175,     0,     0,   106,   171,     0,     0,    25,   191,   237,     0,    26,   184,   234,     0,    28,   182,   218, 
    0,    28,   182,   197,     0,    26,   186,   167,     0,    28,   186,   145,     0,    30,   187,   118,     0,    32,   188,    87,     0,    35,   187,    61,     0,    37,   185,    40, 
    0,    40,   185,    23,     0,    44,   182,     8,     0,    59,   175,     1,     0,    75,   169,     0,     0,    87,   164,     0,     0,    97,   162,     0,     0,   102,   163,     0, 
    0,    27,   182,   238,     0,    30,   173,   230,     0,    35,   168,   207,     0,    34,   171,   190,     0,    31,   176,   163,     0,    33,   177,   144,     0,    34,   178,   119, 
    0,    37,   178,    89,     0,    41,   177,    63,     0,    43,   175,    42,     0,    45,   175,    24,     0,    49,   172,     7,     0,    63,   165,     1,     0,    78,   159,     0, 
    0,    89,   154,     0,     0,    95,   152,     0,     0,    99,   156,     0,     0,    29,   170,   239,     0,    33,   161,   226,     0,    39,   157,   203,     0,    42,   157,   186, 
    0,    43,   159,   167,     0,    43,   161,   152,     0,    43,   164,   132,     0,    42,   167,   104,     0,    47,   167,    70,     0,    49,   165,    46,     0,    51,   165,    26, 
    0,    54,   163,     7,     0,    68,   155,     0,     0,    80,   149,     0,     0,    88,   145,     0,     0,    94,   142,     0,     0,    97,   147,     0,     0,    33,   153,   239, 
    0,    37,   148,   223,     0,    43,   146,   200,     0,    47,   146,   182,     0,    52,   147,   161,     0,    51,   149,   150,     0,    50,   152,   133,     0,    49,   155,   109, 
    0,    53,   157,    74,     0,    54,   155,    50,     0,    56,   155,    29,     0,    59,   153,     8,     0,    70,   146,     1,     0,    79,   139,     0,     0,    87,   135,     0, 
    0,    93,   132,     0,     0,    95,   137,     0,     0,    37,   135,   238,     0,    43,   133,   214,     0,    50,   132,   194,     0,    53,   134,   179,     0,    55,   136,   160, 
    0,    56,   138,   148,     0,    56,   139,   133,     0,    54,   142,   114,     0,    57,   145,    79,     0,    59,   144,    56,     0,    61,   143,    33,     0,    63,   142,    12, 
    0,    70,   137,     1,     0,    79,   129,     0,     0,    86,   124,     0,     0,    92,   120,     0,     0,    94,   124,     0,     0,    42,   116,   237,     0,    49,   116,   205, 
    0,    56,   118,   186,     0,    58,   121,   176,     0,    59,   123,   161,     0,    60,   125,   144,     0,    60,   123,   129,     0,    57,   127,   113,     0,    60,   131,    85, 
    0,    62,   131,    64,     0,    63,   130,    41,     0,    65,   129,    18,     0,    69,   125,     2,     0,    78,   118,     0,     0,    85,   111,     0,     0,    90,   107,     0, 
    0,    92,   109,     0,     0,    45,    95,   236,     0,    51,   100,   204,     0,    56,   103,   187,     0,    58,   105,   173,     0,    61,   106,   158,     0,    62,   107,   143, 
    0,    63,   108,   129,     0,    61,   109,   113,     0,    62,   112,    95,     0,    62,   114,    75,     0,    64,   114,    48,     0,    67,   113,    26,     0,    70,   111,     6, 
    0,    77,   105,     0,     0,    83,    98,     0,     0,    88,    93,     0,     0,    89,    92,     0,     0,    48,    77,   234,     0,    52,    84,   205,     0,    56,    86,   189, 
    0,    58,    89,   174,     0,    61,    90,   156,     0,    63,    91,   142,     0,    64,    91,   128,     0,    65,    92,   112,     0,    72,    90,    94,     0,    68,    94,    78, 
    0,    66,    96,    53,     0,    68,    96,    34,     0,    71,    94,    13,     0,    76,    90,     1,     0,    82,    85,     0,     0,    85,    80,     0,     0,    85,    77,     0, 
    0,    50,    59,   233,     0,    52,    67,   209,     0,    54,    70,   196,     0,    56,    73,   183,     0,    58,    76,   167,     0,    61,    78,   147,     0,    63,    77,   131, 
    0,    65,    78,   114,     0,    70,    77,    94,     0,    69,    76,    81,     0,    67,    79,    64,     0,    68,    79,    48,     0,    73,    76,    29,     0,    76,    75,     3, 
    0,    79,    71,     0,     0,    81,    67,     0,     0,    82,    65,     0,     0,    51,    42,   233,     0,    55,    46,   215,     0,    58,    49,   204,     0,    61,    51,   192, 
    0,    62,    55,   176,     0,    59,    61,   159,     0,    61,    63,   139,     0,    63,    64,   120,     0,    67,    64,    97,     0,    68,    63,    83,     0,    67,    63,    68, 
    0,    67,    63,    53,     0,    73,    60,    33,     0,    76,    58,     8,     0,    78,    57,     0,     0,    79,    55,     0,     0,    79,    53,     0,     0,    49,    29,   231, 
    0,    57,    32,   216,     0,    60,    34,   206,     0,    64,    35,   195,     0,    65,    37,   182,     0,    60,    43,   166,     0,    61,    45,   148,     0,    63,    47,   130, 
    0,    65,    49,   105,     0,    66,    49,    86,     0,    67,    48,    74,     0,    70,    46,    60,     0,    72,    46,    37,     0,    76,    44,    14,     0,    78,    42,     1, 
    0,    78,    41,     0,     0,    78,    38,     0,     0,    62,    19,   229,     0,    66,    21,   214,     0,    68,    21,   205,     0,    70,    22,   195,     0,    71,    24,   183, 
    0,    72,    26,   170,     0,    73,    28,   155,     0,    73,    30,   138,     0,    73,    31,   117,     0,    72,    34,    93,     0,    69,    36,    76,     0,    69,    36,    63, 
    0,    70,    35,    46,     0,    73,    34,    27,     0,    77,    32,     7,     0,    76,    32,     0,     0,    73,    32,     0,     0,    73,    11,   225,     0,    74,    12,   211, 
    0,    75,    12,   202,     0,    76,    12,   193,     0,    77,    13,   181,     0,    77,    14,   167,     0,    77,    15,   153,     0,    77,    17,   138,     0,    77,    17,   120, 
    0,    77,    18,    99,     0,    72,    22,    79,     0,    68,    24,    64,     0,    68,    25,    51,     0,    69,    24,    36,     0,    74,    22,    18,     0,    76,    20,     2, 
    0,    70,    24,     0,     0,    83,     6,   224,     0,    82,     5,   209,     0,    82,     4,   201,     0,    81,     4,   191,     0,    80,     4,   178,     0,    79,     5,   162, 
    0,    78,     5,   147,     0,    78,     6,   132,     0,    78,     6,   116,     0,    77,     6,    99,     0,    75,     7,    82,     0,    72,    10,    66,     0,    72,    12,    53, 
    0,    71,    12,    40,     0,    73,    11,    25,     0,    77,     8,     8,     0,    68,    14,     0,     0,    91,     2,   223,     0,    90,     1,   208,     0,    88,     0,   196, 
    0,    85,     0,   182,     0,    82,     0,   166,     0,    79,     0,   149,     0,    76,     0,   133,     0,    74,     0,   117,     0,    73,     0,   102,     0,    71,     0,    88, 
    0,    71,     1,    76,     0,    71,     1,    64,     0,    71,     1,    53,     0,    72,     1,    41,     0,    72,     1,    28,     0,    72,     1,    14,     0,    65,     5,     0, 
    0,   100,     0,   224,     0,    97,     0,   213,     0,    94,     0,   200,     0,    91,     0,   186,     0,    87,     0,   170,     0,    82,     0,   150,     0,    77,     0,   129, 
    0,    70,     0,   106,     0,    63,     0,    86,     0,    61,     0,    75,     0,    61,     0,    66,     0,    60,     0,    58,     0,    60,     0,    51,     0,    60,     0,    41, 
    0,    60,     0,    29,     0,    60,     0,    14,     0,    60,     0,     0,     0,    16,   196,   235,     0,    14,   199,   235,     0,    12,   202,   230,     0,    14,   199,   207, 
    0,    15,   197,   184,     0,    17,   196,   159,     0,    19,   197,   131,     0,    19,   199,   103,     0,    20,   202,    75,     0,    22,   203,    53,     0,    23,   205,    35, 
    0,    24,   205,    20,     0,    25,   205,    12,     0,    45,   196,     4,     0,    62,   188,     0,     0,    78,   182,     0,     0,    90,   176,     0,     0,    17,   190,   236, 
    0,    15,   185,   224,     0,    14,   184,   210,     0,    13,   185,   190,     0,    13,   186,   168,     0,    15,   186,   150,     0,    17,   188,   125,     0,    18,   189,    95, 
    0,    21,   189,    68,     0,    24,   187,    47,     0,    27,   187,    29,     0,    29,   185,    14,     0,    34,   183,     3,     0,    51,   176,     0,     0,    68,   170,     0, 
    0,    79,   166,     0,     0,    86,   168,     0,     0,    19,   182,   237,     0,    17,   176,   223,     0,    18,   173,   202,     0,    17,   174,   185,     0,    17,   176,   164, 
    0,    18,   176,   147,     0,    20,   178,   124,     0,    21,   180,    96,     0,    26,   178,    69,     0,    29,   176,    48,     0,    31,   176,    29,     0,    33,   174,    13, 
    0,    39,   172,     2,     0,    55,   164,     0,     0,    70,   158,     0,     0,    78,   156,     0,     0,    83,   160,     0,     0,    20,   170,   238,     0,    19,   164,   222, 
    0,    22,   161,   202,     0,    25,   158,   188,     0,    27,   158,   169,     0,    26,   161,   152,     0,    25,   165,   128,     0,    26,   169,   101,     0,    31,   167,    72, 
    0,    34,   166,    50,     0,    35,   166,    28,     0,    38,   164,    10,     0,    45,   160,     1,     0,    60,   153,     0,     0,    70,   148,     0,     0,    77,   146,     0, 
    0,    81,   151,     0,     0,    22,   154,   239,     0,    22,   151,   224,     0,    26,   149,   203,     0,    31,   148,   186,     0,    36,   146,   163,     0,    33,   148,   150, 
    0,    30,   154,   129,     0,    31,   156,   106,     0,    35,   156,    76,     0,    38,   155,    54,     0,    40,   154,    32,     0,    42,   154,    12,     0,    48,   150,     1, 
    0,    59,   143,     0,     0,    69,   138,     0,     0,    76,   135,     0,     0,    78,   140,     0,     0,    26,   137,   236,     0,    28,   134,   217,     0,    32,   134,   197, 
    0,    37,   136,   181,     0,    40,   135,   161,     0,    39,   136,   147,     0,    38,   138,   133,     0,    37,   141,   116,     0,    39,   145,    84,     0,    42,   144,    60, 
    0,    43,   142,    38,     0,    45,   142,    18,     0,    48,   140,     2,     0,    58,   133,     0,     0,    68,   127,     0,     0,    76,   123,     0,     0,    77,   128,     0, 
    0,    29,   119,   235,     0,    35,   118,   205,     0,    42,   119,   185,     0,    42,   120,   175,     0,    43,   123,   161,     0,    44,   124,   143,     0,    45,   122,   130, 
    0,    42,   127,   115,     0,    42,   131,    90,     0,    45,   131,    67,     0,    46,   130,    44,     0,    47,   129,    24,     0,    49,   128,     5,     0,    58,   122,     0, 
    0,    68,   114,     0,     0,    74,   110,     0,     0,    75,   113,     0,     0,    33,    98,   234,     0,    39,   103,   201,     0,    44,   103,   180,     0,    45,   105,   171, 
    0,    46,   107,   158,     0,    48,   107,   143,     0,    49,   109,   130,     0,    46,   110,   114,     0,    45,   113,    98,     0,    45,   115,    78,     0,    47,   115,    51, 
    0,    48,   114,    29,     0,    50,   114,     9,     0,    57,   109,     1,     0,    67,   101,     0,     0,    73,    95,     0,     0,    73,    96,     0,     0,    35,    81,   233, 
    0,    40,    87,   198,     0,    46,    88,   175,     0,    46,    90,   167,     0,    47,    92,   155,     0,    48,    92,   142,     0,    50,    93,   128,     0,    50,    94,   113, 
    0,    50,    94,    97,     0,    49,    97,    80,     0,    49,    98,    56,     0,    50,    98,    36,     0,    52,    98,    16,     0,    57,    95,     1,     0,    66,    88,     0, 
    0,    71,    83,     0,     0,    70,    81,     0,     0,    38,    64,   229,     0,    40,    72,   202,     0,    43,    75,   188,     0,    44,    76,   177,     0,    45,    78,   164, 
    0,    47,    79,   145,     0,    50,    80,   128,     0,    51,    80,   114,     0,    52,    80,    96,     0,    57,    77,    82,     0,    54,    80,    67,     0,    53,    81,    52, 
    0,    57,    80,    31,     0,    58,    80,     5,     0,    64,    75,     0,     0,    69,    70,     0,     0,    68,    68,     0,     0,    40,    47,   228,     0,    43,    52,   211, 
    0,    45,    54,   201,     0,    46,    57,   190,     0,    46,    60,   175,     0,    45,    65,   153,     0,    49,    67,   128,     0,    51,    67,   112,     0,    53,    67,    96, 
    0,    56,    64,    81,     0,    57,    63,    70,     0,    55,    65,    56,     0,    59,    63,    40,     0,    59,    63,    18,     0,    63,    61,     2,     0,    66,    57,     0, 
    0,    65,    56,     0,     0,    39,    32,   228,     0,    44,    36,   211,     0,    47,    37,   202,     0,    48,    38,   192,     0,    49,    42,   179,     0,    44,    49,   162, 
    0,    46,    51,   142,     0,    48,    52,   125,     0,    50,    52,   104,     0,    53,    52,    84,     0,    54,    50,    71,     0,    54,    50,    55,     0,    56,    50,    40, 
    0,    58,    48,    21,     0,    61,    46,     3,     0,    63,    44,     0,     0,    63,    43,     0,     0,    39,    22,   227,     0,    45,    24,   212,     0,    48,    24,   204, 
    0,    50,    24,   195,     0,    52,    26,   183,     0,    52,    28,   168,     0,    53,    30,   152,     0,    53,    32,   135,     0,    53,    34,   115,     0,    55,    35,    92, 
    0,    55,    35,    75,     0,    54,    35,    61,     0,    55,    34,    48,     0,    57,    34,    24,     0,    61,    33,     4,     0,    62,    31,     0,     0,    63,    29,     0, 
    0,    52,    13,   225,     0,    54,    14,   212,     0,    56,    13,   204,     0,    58,    13,   195,     0,    59,    14,   184,     0,    59,    16,   169,     0,    59,    17,   154, 
    0,    59,    19,   139,     0,    59,    20,   121,     0,    60,    21,   100,     0,    58,    23,    79,     0,    55,    25,    63,     0,    54,    25,    49,     0,    56,    25,    33, 
    0,    59,    23,    15,     0,    61,    22,     2,     0,    58,    22,     0,     0,    63,     7,   223,     0,    64,     6,   209,     0,    65,     5,   201,     0,    65,     5,   192, 
    0,    64,     6,   180,     0,    64,     7,   165,     0,    63,     7,   149,     0,    63,     8,   135,     0,    64,     8,   119,     0,    64,     8,   100,     0,    62,     9,    83, 
    0,    58,    13,    66,     0,    55,    15,    50,     0,    55,    15,    38,     0,    56,    14,    25,     0,    59,    12,     9,     0,    56,    14,     0,     0,    73,     3,   222, 
    0,    73,     1,   209,     0,    71,     1,   199,     0,    70,     0,   188,     0,    68,     0,   174,     0,    66,     1,   158,     0,    65,     1,   140,     0,    63,     1,   123, 
    0,    62,     1,   107,     0,    61,     1,    93,     0,    61,     1,    80,     0,    60,     1,    66,     0,    58,     4,    52,     0,    58,     4,    40,     0,    57,     4,    28, 
    0,    58,     4,    14,     0,    54,     6,     0,     0,    82,     0,   222,     0,    80,     0,   213,     0,    78,     0,   202,     0,    76,     0,   190,     0,    73,     0,   175, 
    0,    70,     0,   156,     0,    66,     0,   134,     0,    60,     0,   110,     0,    53,     0,    88,     0,    52,     0,    77,     0,    51,     0,    67,     0,    51,     0,    59, 
    0,    50,     0,    51,     0,    50,     0,    41,     0,    51,     0,    30,     0,    51,     0,    16,     0,    50,     0,     0,     0,    10,   194,   235,     0,     8,   196,   234, 
    0,     6,   200,   230,     0,     6,   198,   210,     0,     7,   196,   187,     0,     9,   196,   164,     0,    10,   197,   138,     0,    12,   199,   114,     0,    13,   201,    87, 
    0,    14,   203,    61,     0,    15,   205,    41,     0,    16,   206,    26,     0,    17,   207,    13,     0,    17,   207,     6,     0,    38,   198,     2,     0,    56,   189,     0, 
    0,    71,   182,     0,     0,    11,   189,   236,     0,     7,   184,   222,     0,     6,   183,   209,     0,     5,   184,   190,     0,     4,   185,   169,     0,     6,   185,   152, 
    0,     8,   186,   130,     0,     8,   190,   105,     0,    11,   190,    77,     0,    13,   189,    53,     0,    16,   188,    36,     0,    18,   188,    20,     0,    20,   187,     8, 
    0,    26,   184,     2,     0,    42,   177,     0,     0,    59,   172,     0,     0,    68,   174,     0,     0,    12,   181,   237,     0,     9,   175,   221,     0,     8,   172,   201, 
    0,     8,   173,   185,     0,     7,   174,   165,     0,     8,   175,   149,     0,    10,   176,   130,     0,     9,   182,   106,     0,    12,   181,    77,     0,    16,   178,    53, 
    0,    19,   177,    35,     0,    21,   176,    17,     0,    23,   175,     4,     0,    33,   170,     0,     0,    47,   164,     0,     0,    59,   161,     0,     0,    65,   166,     0, 
    0,    13,   169,   238,     0,    11,   164,   221,     0,    11,   161,   202,     0,    13,   159,   189,     0,    13,   159,   171,     0,    13,   161,   154,     0,    13,   165,   130, 
    0,    12,   170,   107,     0,    15,   169,    79,     0,    19,   167,    55,     0,    21,   166,    34,     0,    23,   166,    14,     0,    27,   163,     2,     0,    38,   158,     0, 
    0,    48,   153,     0,     0,    58,   150,     0,     0,    63,   156,     0,     0,    14,   155,   239,     0,    13,   152,   223,     0,    14,   150,   203,     0,    16,   147,   189, 
    0,    18,   147,   169,     0,    16,   149,   153,     0,    15,   154,   130,     0,    16,   156,   110,     0,    18,   156,    83,     0,    22,   155,    59,     0,    24,   154,    38, 
    0,    25,   154,    17,     0,    28,   153,     3,     0,    37,   147,     0,     0,    47,   142,     0,     0,    58,   139,     0,     0,    61,   145,     0,     0,    17,   138,   236, 
    0,    17,   135,   221,     0,    19,   135,   202,     0,    20,   135,   186,     0,    21,   137,   168,     0,    22,   138,   151,     0,    23,   138,   134,     0,    21,   140,   118, 
    0,    22,   144,    89,     0,    25,   144,    64,     0,    27,   142,    44,     0,    28,   142,    24,     0,    29,   141,     7,     0,    37,   136,     1,     0,    47,   130,     0, 
    0,    57,   126,     0,     0,    58,   132,     0,     0,    19,   121,   232,     0,    22,   119,   211,     0,    23,   120,   195,     0,    24,   122,   182,     0,    25,   124,   167, 
    0,    28,   125,   147,     0,    31,   122,   130,     0,    27,   126,   116,     0,    26,   131,    93,     0,    28,   131,    70,     0,    29,   130,    49,     0,    30,   129,    29, 
    0,    31,   129,    11,     0,    37,   126,     1,     0,    48,   118,     0,     0,    57,   112,     0,     0,    57,   117,     0,     0,    22,   101,   231,     0,    25,   104,   203, 
    0,    29,   106,   186,     0,    29,   107,   176,     0,    30,   109,   162,     0,    31,   110,   146,     0,    35,   111,   131,     0,    33,   110,   115,     0,    31,   113,    99, 
    0,    30,   115,    82,     0,    31,   116,    55,     0,    31,   115,    33,     0,    32,   115,    14,     0,    37,   113,     1,     0,    48,   105,     0,     0,    56,    98,     0, 
    0,    54,   100,     0,     0,    24,    84,   231,     0,    28,    89,   197,     0,    33,    90,   175,     0,    34,    91,   167,     0,    34,    93,   157,     0,    34,    94,   143, 
    0,    36,    95,   129,     0,    36,    95,   113,     0,    37,    95,    97,     0,    33,    98,    83,     0,    33,   100,    59,     0,    33,   100,    39,     0,    34,   100,    19, 
    0,    37,    99,     2,     0,    48,    92,     0,     0,    55,    86,     0,     0,    52,    85,     0,     0,    26,    68,   227,     0,    28,    74,   202,     0,    30,    77,   187, 
    0,    31,    79,   173,     0,    34,    79,   160,     0,    35,    81,   145,     0,    37,    82,   128,     0,    38,    82,   113,     0,    38,    81,    96,     0,    37,    82,    84, 
    0,    36,    83,    67,     0,    34,    85,    51,     0,    37,    85,    26,     0,    39,    84,     6,     0,    47,    79,     0,     0,    53,    73,     0,     0,    51,    73,     0, 
    0,    29,    52,   224,     0,    31,    56,   210,     0,    31,    59,   200,     0,    30,    64,   182,     0,    33,    66,   165,     0,    35,    66,   146,     0,    36,    68,   128, 
    0,    38,    69,   112,     0,    40,    69,    96,     0,    40,    68,    82,     0,    45,    65,    69,     0,    41,    68,    55,     0,    42,    68,    37,     0,    42,    67,    20, 
    0,    46,    65,     3,     0,    52,    61,     0,     0,    49,    60,     0,     0,    30,    37,   223,     0,    32,    40,   210,     0,    33,    41,   202,     0,    30,    46,   189, 
    0,    31,    50,   174,     0,    32,    52,   157,     0,    34,    54,   138,     0,    34,    56,   120,     0,    38,    55,    98,     0,    40,    56,    84,     0,    43,    53,    70, 
    0,    42,    53,    57,     0,    40,    54,    43,     0,    40,    54,    29,     0,    45,    51,     9,     0,    50,    47,     1,     0,    48,    47,     0,     0,    30,    23,   223, 
    0,    32,    26,   209,     0,    34,    26,   201,     0,    35,    27,   192,     0,    36,    29,   180,     0,    37,    32,   166,     0,    37,    35,   148,     0,    34,    40,   130, 
    0,    35,    41,   109,     0,    38,    41,    91,     0,    41,    39,    72,     0,    40,    39,    58,     0,    39,    39,    42,     0,    40,    39,    28,     0,    45,    35,    11, 
    0,    48,    34,     1,     0,    46,    33,     0,     0,    29,    15,   223,     0,    34,    16,   210,     0,    37,    15,   203,     0,    39,    15,   195,     0,    39,    16,   184, 
    0,    39,    18,   170,     0,    39,    20,   154,     0,    34,    24,   138,     0,    35,    25,   119,     0,    38,    24,   100,     0,    40,    24,    79,     0,    40,    25,    62, 
    0,    40,    25,    48,     0,    41,    24,    36,     0,    44,    23,    14,     0,    46,    23,     2,     0,    47,    20,     0,     0,    41,     8,   222,     0,    43,     8,   210, 
    0,    45,     6,   203,     0,    45,     6,   196,     0,    45,     7,   185,     0,    45,     8,   171,     0,    45,     9,   154,     0,    45,    10,   139,     0,    45,    10,   122, 
    0,    46,    11,   103,     0,    47,    11,    84,     0,    45,    13,    65,     0,    42,    15,    50,     0,    42,    16,    37,     0,    44,    15,    22,     0,    46,    14,     7, 
    0,    44,    14,     0,     0,    52,     3,   220,     0,    53,     2,   209,     0,    53,     1,   201,     0,    52,     1,   192,     0,    51,     1,   181,     0,    50,     1,   166, 
    0,    49,     1,   148,     0,    48,     1,   131,     0,    48,     1,   113,     0,    48,     1,    97,     0,    49,     1,    83,     0,    49,     2,    69,     0,    45,     5,    53, 
    0,    45,     5,    39,     0,    46,     5,    27,     0,    46,     5,    13,     0,    43,     6,     0,     0,    63,     0,   220,     0,    61,     0,   212,     0,    60,     0,   203, 
    0,    59,     0,   192,     0,    57,     0,   179,     0,    55,     0,   161,     0,    52,     0,   139,     0,    47,     0,   114,     0,    42,     0,    91,     0,    42,     0,    79, 
    0,    41,     0,    69,     0,    41,     0,    60,     0,    40,     0,    52,     0,    40,     0,    43,     0,    41,     0,    31,     0,    41,     0,    17,     0,    40,     0,     0, 
    0,     6,   192,   235,     0,     4,   194,   233,     0,     3,   195,   226,     0,     3,   195,   209,     0,     4,   194,   189,     0,     4,   195,   168,     0,     4,   197,   145, 
    0,     6,   198,   122,     0,     7,   200,    96,     0,     8,   202,    70,     0,     9,   204,    49,     0,    10,   206,    32,     0,    10,   207,    17,     0,    10,   209,     7, 
    0,    11,   209,     3,     0,    31,   199,     0,     0,    49,   190,     0,     0,     6,   187,   235,     0,     2,   181,   222,     0,     1,   181,   208,     0,     1,   181,   190, 
    0,     1,   183,   170,     0,     1,   184,   154,     0,     1,   185,   134,     0,     2,   190,   111,     0,     3,   190,    87,     0,     6,   190,    61,     0,     8,   189,    42, 
    0,     9,   189,    26,     0,    11,   189,    13,     0,    13,   188,     4,     0,    19,   185,     1,     0,    35,   180,     0,     0,    45,   182,     0,     0,     6,   180,   236, 
    0,     4,   173,   220,     0,     2,   170,   199,     0,     2,   171,   184,     0,     1,   173,   166,     0,     1,   174,   149,     0,     2,   175,   132,     0,     2,   181,   111, 
    0,     3,   182,    86,     0,     6,   180,    60,     0,     9,   178,    40,     0,    11,   177,    23,     0,    12,   177,     8,     0,    17,   174,     1,     0,    26,   170,     0, 
    0,    35,   168,     0,     0,    42,   173,     0,     0,     7,   169,   237,     0,     5,   163,   220,     0,     4,   161,   200,     0,     3,   160,   182,     0,     3,   161,   164, 
    0,     3,   163,   148,     0,     3,   164,   131,     0,     3,   168,   112,     0,     4,   171,    89,     0,     7,   169,    63,     0,     9,   167,    41,     0,    10,   166,    22, 
    0,    12,   166,     7,     0,    17,   163,     1,     0,    26,   158,     0,     0,    36,   156,     0,     0,    40,   162,     0,     0,     8,   155,   237,     0,     6,   152,   222, 
    0,     6,   151,   202,     0,     5,   151,   185,     0,     4,   151,   164,     0,     4,   152,   147,     0,     5,   154,   130,     0,     5,   155,   113,     0,     5,   158,    91, 
    0,     8,   156,    66,     0,    10,   154,    45,     0,    11,   154,    25,     0,    12,   154,     8,     0,    16,   152,     1,     0,    26,   146,     0,     0,    36,   144,     0, 
    0,    39,   150,     0,     0,     9,   139,   235,     0,     8,   138,   222,     0,     8,   138,   203,     0,     8,   139,   187,     0,     7,   139,   168,     0,     8,   138,   153, 
    0,     9,   137,   136,     0,     8,   140,   120,     0,     8,   143,    94,     0,    10,   143,    70,     0,    12,   142,    49,     0,    12,   142,    29,     0,    13,   142,    10, 
    0,    17,   140,     1,     0,    28,   134,     0,     0,    37,   130,     0,     0,    37,   137,     0,     0,    12,   121,   231,     0,    11,   121,   217,     0,    11,   123,   202, 
    0,    10,   125,   187,     0,    10,   127,   170,     0,    13,   126,   152,     0,    17,   122,   131,     0,    13,   125,   117,     0,    11,   130,    95,     0,    12,   130,    76, 
    0,    13,   130,    54,     0,    14,   130,    34,     0,    15,   130,    14,     0,    18,   128,     1,     0,    29,   121,     0,     0,    38,   116,     0,     0,    36,   122,     0, 
    0,    14,   103,   228,     0,    14,   105,   206,     0,    15,   106,   191,     0,    15,   108,   180,     0,    15,   111,   167,     0,    18,   113,   148,     0,    21,   111,   132, 
    0,    19,   110,   115,     0,    17,   113,   100,     0,    15,   115,    85,     0,    15,   116,    60,     0,    16,   116,    39,     0,    16,   117,    18,     0,    18,   115,     2, 
    0,    30,   108,     0,     0,    38,   102,     0,     0,    35,   105,     0,     0,    15,    86,   227,     0,    17,    90,   198,     0,    20,    92,   176,     0,    21,    93,   168, 
    0,    21,    94,   159,     0,    21,    95,   146,     0,    22,    96,   131,     0,    23,    97,   115,     0,    23,    95,    97,     0,    19,    99,    85,     0,    17,   101,    64, 
    0,    17,   102,    44,     0,    18,   102,    23,     0,    20,   101,     5,     0,    30,    95,     0,     0,    38,    89,     0,     0,    34,    88,     0,     0,    16,    71,   225, 
    0,    17,    76,   202,     0,    19,    79,   187,     0,    20,    81,   170,     0,    23,    81,   155,     0,    23,    82,   144,     0,    24,    82,   129,     0,    25,    83,   113, 
    0,    25,    83,    97,     0,    23,    83,    84,     0,    21,    85,    70,     0,    19,    87,    53,     0,    20,    88,    28,     0,    21,    87,     8,     0,    29,    82,     1, 
    0,    38,    76,     0,     0,    33,    76,     0,     0,    17,    56,   222,     0,    19,    59,   210,     0,    20,    61,   200,     0,    20,    67,   176,     0,    24,    68,   151, 
    0,    24,    69,   141,     0,    24,    70,   129,     0,    26,    71,   112,     0,    27,    71,    96,     0,    27,    70,    83,     0,    26,    69,    70,     0,    23,    72,    54, 
    0,    22,    73,    34,     0,    23,    73,    14,     0,    29,    69,     2,     0,    37,    64,     0,     0,    33,    65,     0,     0,    19,    41,   220,     0,    21,    43,   210, 
    0,    21,    45,   202,     0,    19,    51,   185,     0,    20,    54,   166,     0,    21,    56,   151,     0,    22,    57,   136,     0,    23,    58,   117,     0,    26,    57,    96, 
    0,    28,    58,    83,     0,    28,    57,    69,     0,    31,    54,    56,     0,    27,    56,    42,     0,    26,    57,    28,     0,    30,    55,    10,     0,    35,    51,     1, 
    0,    32,    52,     0,     0,    19,    28,   220,     0,    21,    29,   210,     0,    22,    30,   203,     0,    22,    32,   193,     0,    23,    34,   180,     0,    23,    38,   166, 
    0,    23,    40,   147,     0,    22,    43,   124,     0,    25,    44,    98,     0,    27,    43,    84,     0,    28,    44,    71,     0,    30,    41,    55,     0,    29,    41,    45, 
    0,    28,    42,    31,     0,    32,    40,    17,     0,    32,    39,     2,     0,    31,    39,     0,     0,    20,    17,   219,     0,    22,    17,   207,     0,    23,    17,   200, 
    0,    24,    18,   191,     0,    24,    20,   180,     0,    24,    22,   167,     0,    24,    24,   151,     0,    20,    29,   133,     0,    23,    30,   112,     0,    24,    30,    95, 
    0,    26,    29,    78,     0,    28,    28,    59,     0,    29,    27,    44,     0,    28,    28,    30,     0,    30,    27,    17,     0,    31,    26,     2,     0,    31,    25,     0, 
    0,    19,    10,   219,     0,    23,     9,   209,     0,    25,     8,   202,     0,    26,     8,   194,     0,    26,     8,   184,     0,    26,     9,   171,     0,    26,    11,   155, 
    0,    27,    12,   139,     0,    27,    12,   122,     0,    27,    13,   104,     0,    28,    13,    86,     0,    29,    14,    64,     0,    28,    15,    47,     0,    28,    15,    35, 
    0,    27,    15,    24,     0,    31,    14,     2,     0,    32,    13,     0,     0,    31,     4,   219,     0,    32,     3,   210,     0,    32,     2,   203,     0,    32,     1,   196, 
    0,    32,     1,   186,     0,    31,     2,   172,     0,    31,     2,   155,     0,    31,     3,   137,     0,    30,     3,   119,     0,    30,     4,   103,     0,    32,     4,    87, 
    0,    33,     4,    70,     0,    31,     6,    53,     0,    31,     6,    39,     0,    34,     6,    25,     0,    33,     6,     9,     0,    31,     7,     0,     0,    42,     0,   218, 
    0,    41,     0,   211,     0,    40,     0,   203,     0,    39,     0,   194,     0,    39,     0,   182,     0,    37,     0,   166,     0,    36,     0,   146,     0,    33,     0,   122, 
    0,    30,     0,    99,     0,    30,     0,    85,     0,    30,     0,    74,     0,    30,     0,    63,     0,    29,     0,    54,     0,    29,     0,    45,     0,    30,     0,    35, 
    0,    30,     0,    19,     0,    30,     0,     0,     0,     3,   190,   235,     0,     2,   191,   232,     0,     1,   192,   223,     0,     1,   191,   208,     0,     2,   191,   190, 
    0,     2,   193,   172,     0,     2,   194,   151,     0,     2,   196,   130,     0,     2,   198,   107,     0,     4,   200,    81,     0,     4,   203,    58,     0,     4,   205,    39, 
    0,     5,   207,    23,     0,     5,   208,    11,     0,     5,   210,     3,     0,     5,   210,     1,     0,    25,   199,     0,     0,     2,   185,   235,     0,     0,   179,   219, 
    0,     0,   178,   206,     0,     0,   178,   190,     0,     0,   180,   173,     0,     0,   181,   156,     0,     0,   183,   140,     0,     0,   187,   118,     0,     0,   189,    96, 
    0,     1,   190,    71,     0,     2,   190,    50,     0,     3,   191,    33,     0,     4,   191,    18,     0,     5,   192,     8,     0,     7,   191,     2,     0,    14,   188,     1, 
    0,    20,   190,     0,     0,     2,   178,   235,     0,     1,   172,   218,     0,     0,   167,   196,     0,     0,   168,   182,     0,     0,   169,   165,     0,     0,   171,   151, 
    0,     0,   172,   135,     0,     0,   177,   115,     0,     0,   180,    95,     0,     1,   180,    72,     0,     1,   180,    50,     0,     3,   179,    33,     0,     3,   179,    18, 
    0,     4,   179,     7,     0,     7,   178,     2,     0,    14,   174,     1,     0,    17,   180,     0,     0,     3,   168,   235,     0,     1,   163,   219,     0,     0,   160,   197, 
    0,     0,   159,   177,     0,     0,   159,   161,     0,     0,   161,   147,     0,     0,   162,   131,     0,     0,   165,   115,     0,     0,   169,    97,     0,     1,   169,    74, 
    0,     1,   168,    51,     0,     1,   168,    32,     0,     2,   167,    17,     0,     3,   167,     6,     0,     7,   165,     2,     0,    16,   161,     1,     0,    15,   170,     0, 
    0,     3,   155,   234,     0,     2,   153,   220,     0,     1,   151,   200,     0,     0,   150,   181,     0,     0,   150,   160,     0,     0,   150,   145,     0,     0,   152,   130, 
    0,     0,   153,   115,     0,     0,   156,    97,     0,     1,   157,    76,     0,     1,   156,    54,     0,     1,   155,    33,     0,     1,   155,    16,     0,     2,   155,     4, 
    0,     8,   152,     2,     0,    17,   148,     1,     0,    13,   157,     0,     0,     4,   140,   232,     0,     3,   139,   220,     0,     2,   139,   202,     0,     1,   139,   186, 
    0,     0,   139,   165,     0,     1,   137,   151,     0,     1,   138,   136,     0,     1,   139,   121,     0,     1,   142,    98,     0,     1,   142,    79,     0,     1,   142,    58, 
    0,     1,   142,    37,     0,     1,   143,    16,     0,     3,   144,     3,     0,    10,   139,     1,     0,    19,   135,     1,     0,    13,   144,     0,     0,     5,   123,   229, 
    0,     4,   123,   218,     0,     3,   125,   203,     0,     2,   126,   188,     0,     1,   127,   170,     0,     2,   126,   153,     0,     2,   126,   134,     0,     1,   126,   118, 
    0,     1,   128,    97,     0,     1,   129,    82,     0,     1,   129,    62,     0,     1,   130,    41,     0,     2,   130,    20,     0,     4,   131,     3,     0,    12,   125,     1, 
    0,    21,   120,     1,     0,    13,   128,     0,     0,     6,   105,   227,     0,     5,   106,   210,     0,     5,   107,   197,     0,     5,   110,   185,     0,     4,   112,   170, 
    0,     4,   113,   153,     0,     5,   114,   135,     0,     4,   112,   117,     0,     4,   112,   100,     0,     3,   113,    88,     0,     2,   115,    66,     0,     2,   116,    46, 
    0,     3,   115,    24,     0,     5,   116,     6,     0,    13,   110,     1,     0,    21,   104,     1,     0,    14,   110,     0,     0,     7,    88,   225,     0,     7,    91,   204, 
    0,     7,    93,   190,     0,     7,    95,   178,     0,     7,    97,   166,     0,     7,    98,   152,     0,     7,    99,   135,     0,     8,    99,   117,     0,    10,    95,    97, 
    0,     6,    99,    85,     0,     4,   101,    67,     0,     4,   102,    50,     0,     4,   102,    29,     0,     6,   102,     9,     0,    14,    97,     2,     0,    22,    91,     1, 
    0,    15,    92,     0,     0,     8,    73,   224,     0,     7,    78,   206,     0,     8,    79,   194,     0,     8,    82,   179,     0,     8,    85,   164,     0,     9,    85,   150, 
    0,    10,    85,   134,     0,    11,    86,   116,     0,    13,    84,    97,     0,    10,    84,    84,     0,     8,    86,    71,     0,     6,    88,    57,     0,     6,    89,    34, 
    0,     7,    88,    13,     0,    13,    84,     2,     0,    21,    79,     1,     0,    15,    80,     0,     0,     8,    58,   221,     0,     9,    62,   211,     0,     9,    64,   201, 
    0,     8,    69,   182,     0,     9,    72,   162,     0,    11,    71,   145,     0,    12,    71,   129,     0,    14,    71,   112,     0,    15,    72,    97,     0,    15,    71,    82, 
    0,    14,    70,    70,     0,    10,    74,    56,     0,     8,    76,    36,     0,     8,    76,    17,     0,    12,    73,     3,     0,    21,    67,     1,     0,    16,    68,     0, 
    0,     9,    44,   219,     0,    11,    46,   211,     0,    11,    48,   202,     0,     8,    53,   187,     0,     8,    58,   169,     0,     9,    59,   151,     0,    11,    60,   135, 
    0,    11,    60,   117,     0,    16,    59,    97,     0,    16,    60,    83,     0,    16,    58,    70,     0,    13,    59,    56,     0,    12,    61,    41,     0,     9,    62,    27, 
    0,    12,    60,     6,     0,    20,    55,     1,     0,    16,    55,     0,     0,     9,    31,   218,     0,    11,    31,   210,     0,    12,    33,   203,     0,    11,    36,   193, 
    0,    12,    39,   181,     0,    12,    42,   164,     0,    12,    44,   145,     0,    11,    47,   121,     0,    15,    46,    98,     0,    16,    45,    83,     0,    18,    46,    71, 
    0,    18,    44,    55,     0,    20,    42,    41,     0,    16,    44,    30,     0,    16,    45,    14,     0,    17,    44,     2,     0,    15,    44,     0,     0,     9,    19,   217, 
    0,    11,    19,   209,     0,    12,    20,   202,     0,    11,    22,   194,     0,    11,    24,   183,     0,    12,    26,   169,     0,    12,    29,   151,     0,     9,    33,   130, 
    0,    12,    33,   107,     0,    13,    33,    88,     0,    16,    33,    73,     0,    17,    32,    58,     0,    20,    30,    42,     0,    16,    31,    30,     0,    13,    34,    18, 
    0,    13,    34,     4,     0,    15,    32,     0,     0,     9,    11,   217,     0,    12,    10,   206,     0,    12,    10,   197,     0,    12,    11,   189,     0,    12,    12,   178, 
    0,    12,    14,   166,     0,    12,    15,   151,     0,    12,    16,   137,     0,    13,    17,   119,     0,    11,    21,    99,     0,    13,    20,    81,     0,    14,    19,    63, 
    0,    15,    19,    44,     0,    16,    18,    31,     0,    14,    21,    13,     0,    13,    21,     2,     0,    15,    19,     0,     0,     9,     5,   217,     0,    13,     3,   208, 
    0,    13,     3,   200,     0,    13,     3,   192,     0,    13,     3,   183,     0,    13,     4,   170,     0,    13,     4,   156,     0,    14,     4,   141,     0,    13,     5,   124, 
    0,     9,     9,   106,     0,    11,     8,    88,     0,    13,     7,    71,     0,    14,     7,    50,     0,    14,     7,    37,     0,    17,     5,    25,     0,    13,     7,    12, 
    0,    16,     6,     0,     0,    21,     0,   217,     0,    20,     0,   211,     0,    18,     0,   204,     0,    18,     0,   197,     0,    17,     0,   187,     0,    17,     0,   174, 
    0,    16,     0,   158,     0,    15,     0,   139,     0,    14,     0,   117,     0,    15,     0,    98,     0,    16,     0,    84,     0,    16,     0,    70,     0,    16,     0,    55, 
    0,    16,     0,    44,     0,    17,     0,    33,     0,    15,     0,    17,     0,    15,     0,     0,     0,     0,   189,   235,     0,     0,   189,   229,     0,     0,   188,   219, 
    0,     0,   188,   206,     0,     0,   188,   190,     0,     0,   190,   174,     0,     0,   191,   157,     0,     0,   193,   138,     0,     0,   195,   116,     0,     0,   198,    92, 
    0,     0,   201,    68,     0,     0,   203,    48,     0,     0,   205,    31,     0,     0,   207,    17,     0,     0,   209,     7,     0,     0,   210,     1,     0,     0,   210,     0, 
    0,     0,   183,   234,     0,     0,   179,   211,     0,     0,   178,   201,     0,     0,   179,   190,     0,     0,   180,   178,     0,     0,   181,   164,     0,     0,   182,   150, 
    0,     0,   185,   131,     0,     0,   189,   112,     0,     0,   190,    88,     0,     0,   192,    65,     0,     0,   193,    48,     0,     0,   195,    34,     0,     0,   196,    21, 
    0,     0,   197,    14,     0,     0,   198,     9,     0,     0,   199,     0,     0,     0,   176,   233,     0,     0,   173,   212,     0,     0,   169,   191,     0,     0,   169,   180, 
    0,     0,   171,   167,     0,     0,   172,   156,     0,     0,   173,   143,     0,     0,   176,   127,     0,     0,   181,   108,     0,     0,   182,    86,     0,     0,   183,    64, 
    0,     0,   184,    49,     0,     0,   184,    36,     0,     0,   185,    25,     0,     0,   186,    19,     0,     0,   186,    14,     0,     0,   187,     0,     0,     0,   166,   232, 
    0,     0,   164,   213,     0,     0,   162,   193,     0,     0,   160,   173,     0,     0,   161,   160,     0,     0,   162,   149,     0,     0,   163,   138,     0,     0,   165,   123, 
    0,     0,   170,   106,     0,     0,   172,    87,     0,     0,   172,    67,     0,     0,   172,    50,     0,     0,   172,    36,     0,     0,   173,    26,     0,     0,   173,    20, 
    0,     0,   173,    15,     0,     0,   174,     0,     0,     0,   155,   231,     0,     0,   154,   213,     0,     0,   153,   195,     0,     0,   152,   177,     0,     0,   151,   156, 
    0,     0,   152,   144,     0,     0,   153,   132,     0,     0,   154,   119,     0,     0,   157,   106,     0,     0,   159,    90,     0,     0,   159,    71,     0,     0,   159,    52, 
    0,     0,   159,    35,     0,     0,   159,    25,     0,     0,   159,    19,     0,     0,   159,    15,     0,     0,   160,     0,     0,     0,   140,   229,     0,     0,   142,   214, 
    0,     0,   142,   198,     0,     0,   142,   182,     0,     0,   141,   162,     0,     0,   140,   140,     0,     0,   141,   128,     0,     0,   141,   117,     0,     0,   142,   105, 
    0,     0,   143,    92,     0,     0,   144,    75,     0,     0,   143,    56,     0,     0,   144,    37,     0,     0,   145,    24,     0,     0,   145,    17,     0,     0,   145,    14, 
    0,     0,   147,     0,     0,     0,   124,   227,     0,     0,   126,   215,     0,     0,   128,   201,     0,     0,   129,   186,     0,     0,   130,   167,     0,     0,   129,   147, 
    0,     0,   127,   125,     0,     0,   127,   113,     0,     0,   127,   102,     0,     0,   128,    92,     0,     0,   128,    77,     0,     0,   129,    60,     0,     0,   130,    41, 
    0,     0,   130,    25,     0,     0,   130,    16,     0,     0,   130,    12,     0,     0,   131,     0,     0,     0,   106,   225,     0,     0,   109,   215,     0,     0,   111,   202, 
    0,     0,   114,   189,     0,     0,   116,   170,     0,     0,   117,   152,     0,     0,   116,   130,     0,     0,   112,   111,     0,     0,   112,   100,     0,     0,   112,    90, 
    0,     0,   112,    77,     0,     0,   113,    61,     0,     0,   113,    44,     0,     0,   113,    27,     0,     0,   113,    15,     0,     0,   112,     9,     0,     0,   113,     0, 
    0,     0,    90,   223,     0,     0,    93,   213,     0,     0,    95,   202,     0,     0,    98,   190,     0,     0,   102,   172,     0,     0,   103,   155,     0,     0,   103,   135, 
    0,     0,   100,   115,     0,     0,    96,    94,     0,     0,    96,    85,     0,     0,    97,    74,     0,     0,    97,    61,     0,     0,    97,    46,     0,     0,    97,    29, 
    0,     0,    96,    16,     0,     0,    95,     8,     0,     0,    96,     0,     0,     0,    76,   222,     0,     0,    79,   212,     0,     0,    80,   202,     0,     0,    85,   189, 
    0,     0,    89,   170,     0,     0,    89,   152,     0,     0,    87,   131,     0,     0,    84,   112,     0,     0,    85,    94,     0,     0,    85,    81,     0,     0,    84,    72, 
    0,     0,    85,    62,     0,     0,    86,    46,     0,     0,    86,    31,     0,     0,    85,    17,     0,     0,    84,     8,     0,     0,    83,     0,     0,     0,    61,   220, 
    0,     0,    64,   211,     0,     0,    66,   202,     0,     0,    71,   190,     0,     0,    75,   170,     0,     0,    76,   147,     0,     0,    70,   118,     0,     0,    69,   103, 
    0,     0,    72,    94,     0,     0,    70,    78,     0,     0,    69,    65,     0,     0,    73,    59,     0,     0,    75,    46,     0,     0,    75,    32,     0,     0,    74,    18, 
    0,     0,    72,     8,     0,     0,    71,     0,     0,     0,    46,   219,     0,     0,    48,   211,     0,     0,    50,   202,     0,     0,    54,   192,     0,     0,    60,   175, 
    0,     0,    64,   152,     0,     0,    64,   132,     0,     0,    63,   110,     0,     0,    61,    93,     0,     0,    59,    78,     0,     0,    58,    65,     0,     0,    58,    55, 
    0,     0,    61,    46,     0,     0,    62,    35,     0,     0,    62,    19,     0,     0,    60,     8,     0,     0,    59,     0,     0,     0,    33,   217,     0,     0,    34,   211, 
    0,     0,    35,   204,     0,     0,    38,   195,     0,     0,    43,   181,     0,     0,    48,   162,     0,     0,    50,   141,     0,     0,    51,   117,     0,     0,    51,    96, 
    0,     0,    49,    79,     0,     0,    47,    66,     0,     0,    44,    51,     0,     0,    42,    40,     0,     0,    48,    33,     0,     0,    49,    20,     0,     0,    49,     9, 
    0,     0,    48,     0,     0,     0,    21,   217,     0,     0,    21,   211,     0,     0,    22,   205,     0,     0,    24,   196,     0,     0,    28,   185,     0,     0,    31,   170, 
    0,     0,    34,   149,     0,     0,    37,   125,     0,     0,    38,   103,     0,     0,    38,    85,     0,     0,    35,    67,     0,     0,    34,    54,     0,     0,    31,    40, 
    0,     0,    32,    31,     0,     0,    36,    24,     0,     0,    37,    14,     0,     0,    36,     0,     0,     0,    11,   216,     0,     0,    11,   211,     0,     0,    12,   204, 
    0,     0,    13,   195,     0,     0,    16,   185,     0,     0,    18,   171,     0,     0,    21,   155,     0,     0,    23,   137,     0,     0,    24,   115,     0,     0,    26,    90, 
    0,     0,    25,    74,     0,     0,    24,    58,     0,     0,    23,    43,     0,     0,    21,    32,     0,     0,    23,    25,     0,     0,    25,    15,     0,     0,    24,     0, 
    0,     0,     4,   216,     0,     0,     5,   205,     0,     0,     7,   194,     0,     0,     8,   184,     0,     0,     9,   174,     0,     0,    11,   160,     0,     0,    12,   148, 
    0,     0,    12,   136,     0,     0,    13,   116,     0,     0,    15,    90,     0,     0,    15,    76,     0,     0,    14,    64,     0,     0,    14,    50,     0,     0,    13,    37, 
    0,     0,    12,    23,     0,     0,    12,    13,     0,     0,    12,     0,     0,     0,     0,   216,     0,     0,     0,   209,     0,     0,     0,   203,     0,     0,     0,   196, 
    0,     0,     0,   186,     0,     0,     0,   174,     0,     0,     0,   160,     0,     0,     0,   146,     0,     0,     0,   130,     0,     0,     0,   112,     0,     0,     0,    93, 
    0,     0,     0,    75,     0,     0,     0,    58,     0,     0,     0,    43,     0,     0,     0,    29,     0,     0,     0,    15,     0,     0,     0,     0
};

// Photo Best (Archie)
unsigned char ucMapDJ4100_KCMY_Photo_BestA_12x12x1[] =
{
    0,   228,   219,   240,     0,   229,   215,   224,     0,   229,   211,   207,     0,   234,   204,   190,     0,   239,   194,   171,     0,   244,   186,   154,     0,   246,   177,   135, 
    0,   248,   165,   110,     0,   249,   153,    81,     0,   251,   141,    50,     0,   250,   131,    23,     0,   246,   126,     7,     0,   241,   126,     2,     0,   237,   128,     2, 
    0,   232,   129,     2,     0,   228,   130,     1,     0,   224,   130,     0,     0,   221,   200,   240,     0,   234,   197,   218,     0,   237,   201,   198,     0,   237,   194,   177, 
    0,   242,   188,   158,     0,   245,   182,   143,     0,   246,   173,   126,     0,   248,   163,   105,     0,   249,   152,    77,     0,   251,   141,    49,     0,   251,   130,    22, 
    0,   247,   124,     4,     0,   238,   126,     0,     0,   231,   128,     0,     0,   225,   130,     0,     0,   221,   131,     0,     0,   218,   130,     0,     0,   214,   180,   239, 
    0,   225,   178,   227,     0,   241,   175,   197,     0,   241,   178,   173,     0,   245,   173,   146,     0,   246,   169,   124,     0,   247,   163,   104,     0,   247,   155,    82, 
    0,   248,   146,    58,     0,   249,   137,    34,     0,   247,   129,    13,     0,   240,   127,     3,     0,   230,   130,     2,     0,   224,   131,     1,     0,   218,   131,     1, 
    0,   215,   130,     0,     0,   214,   128,     0,     0,   214,   157,   239,     0,   219,   155,   225,     0,   228,   156,   203,     0,   239,   155,   175,     0,   243,   154,   146, 
    0,   241,   152,   119,     0,   240,   149,    95,     0,   236,   146,    75,     0,   233,   143,    53,     0,   231,   139,    33,     0,   227,   136,    18,     0,   221,   134,    10, 
    0,   216,   133,     7,     0,   214,   131,     4,     0,   212,   129,     2,     0,   211,   127,     1,     0,   210,   124,     0,     0,   212,   132,   241,     0,   216,   129,   232, 
    0,   219,   133,   209,     0,   224,   136,   184,     0,   233,   133,   153,     0,   231,   134,   125,     0,   229,   135,    99,     0,   222,   136,    79,     0,   218,   136,    60, 
    0,   216,   134,    42,     0,   214,   132,    27,     0,   211,   130,    18,     0,   209,   128,    12,     0,   208,   126,     8,     0,   206,   124,     5,     0,   205,   121,     2, 
    0,   204,   118,     0,     0,   211,   108,   243,     0,   216,   104,   237,     0,   216,   108,   216,     0,   218,   115,   193,     0,   221,   116,   165,     0,   224,   115,   132, 
    0,   220,   119,   108,     0,   216,   121,    84,     0,   214,   122,    63,     0,   211,   122,    46,     0,   208,   122,    33,     0,   206,   120,    24,     0,   204,   119,    17, 
    0,   202,   118,    12,     0,   200,   116,     7,     0,   199,   113,     3,     0,   197,   111,     0,     0,   211,    85,   245,     0,   216,    80,   241,     0,   216,    84,   224, 
    0,   215,    91,   200,     0,   213,    99,   175,     0,   214,   101,   146,     0,   215,   100,   114,     0,   214,   102,    91,     0,   212,   103,    68,     0,   208,   106,    49, 
    0,   205,   108,    35,     0,   201,   109,    26,     0,   199,   110,    21,     0,   197,   109,    15,     0,   194,   107,    10,     0,   192,   104,     5,     0,   190,   102,     0, 
    0,   210,    62,   246,     0,   214,    57,   243,     0,   214,    62,   228,     0,   212,    70,   207,     0,   210,    78,   183,     0,   210,    82,   157,     0,   210,    84,   128, 
    0,   210,    85,    97,     0,   210,    84,    75,     0,   207,    86,    54,     0,   202,    91,    39,     0,   198,    95,    28,     0,   194,    98,    21,     0,   191,    99,    16, 
    0,   188,    97,    11,     0,   185,    95,     5,     0,   182,    92,     0,     0,   207,    39,   247,     0,   209,    37,   244,     0,   208,    42,   230,     0,   207,    51,   210, 
    0,   205,    58,   188,     0,   204,    65,   165,     0,   204,    68,   140,     0,   205,    68,   110,     0,   206,    67,    78,     0,   204,    68,    59,     0,   200,    73,    43, 
    0,   196,    79,    31,     0,   191,    84,    23,     0,   187,    86,    16,     0,   183,    86,    11,     0,   178,    85,     5,     0,   174,    82,     0,     0,   203,    21,   245, 
    0,   204,    21,   240,     0,   203,    25,   228,     0,   201,    33,   210,     0,   200,    38,   191,     0,   198,    46,   170,     0,   198,    51,   148,     0,   198,    53,   123, 
    0,   199,    52,    93,     0,   202,    49,    61,     0,   198,    55,    46,     0,   194,    62,    35,     0,   189,    68,    26,     0,   184,    73,    18,     0,   179,    75,    11, 
    0,   173,    74,     5,     0,   167,    72,     0,     0,   198,    12,   240,     0,   197,    12,   234,     0,   196,    15,   224,     0,   194,    22,   209,     0,   194,    26,   192, 
    0,   192,    31,   174,     0,   191,    36,   154,     0,   191,    39,   133,     0,   191,    40,   107,     0,   194,    39,    78,     0,   198,    37,    48,     0,   192,    45,    37, 
    0,   188,    52,    28,     0,   183,    58,    20,     0,   177,    61,    13,     0,   170,    63,     6,     0,   163,    63,     0,     0,   195,     9,   237,     0,   194,     9,   232, 
    0,   193,    11,   223,     0,   191,    16,   210,     0,   189,    18,   195,     0,   188,    21,   178,     0,   186,    25,   159,     0,   185,    28,   141,     0,   185,    31,   119, 
    0,   187,    32,    94,     0,   189,    30,    67,     0,   193,    29,    39,     0,   188,    37,    30,     0,   182,    42,    21,     0,   176,    47,    13,     0,   169,    50,     6, 
    0,   162,    53,     0,     0,   192,     7,   235,     0,   191,     7,   231,     0,   190,     9,   224,     0,   189,    12,   212,     0,   187,    14,   199,     0,   185,    15,   183, 
    0,   183,    18,   166,     0,   182,    20,   148,     0,   181,    23,   130,     0,   181,    25,   108,     0,   183,    24,    83,     0,   185,    23,    57,     0,   187,    23,    31, 
    0,   183,    29,    22,     0,   177,    33,    14,     0,   170,    37,     7,     0,   162,    40,     0,     0,   189,     5,   233,     0,   189,     5,   229,     0,   188,     6,   223, 
    0,   186,     8,   214,     0,   185,    10,   202,     0,   183,    11,   188,     0,   182,    12,   172,     0,   180,    14,   155,     0,   178,    16,   138,     0,   178,    18,   118, 
    0,   178,    18,    96,     0,   178,    17,    73,     0,   180,    17,    48,     0,   181,    17,    23,     0,   176,    21,    15,     0,   170,    24,     7,     0,   163,    27,     0, 
    0,   187,     3,   230,     0,   186,     4,   228,     0,   185,     4,   223,     0,   184,     5,   215,     0,   183,     7,   204,     0,   181,     7,   192,     0,   180,     8,   177, 
    0,   178,     9,   162,     0,   176,    10,   145,     0,   175,    11,   127,     0,   175,    12,   107,     0,   174,    11,    86,     0,   174,    11,    63,     0,   175,    11,    39, 
    0,   175,    11,    15,     0,   169,    13,     7,     0,   163,    15,     0,     0,   184,     2,   228,     0,   184,     2,   226,     0,   183,     2,   222,     0,   182,     2,   215, 
    0,   181,     4,   206,     0,   180,     4,   195,     0,   178,     4,   182,     0,   177,     4,   167,     0,   175,     5,   152,     0,   174,     5,   135,     0,   173,     6,   116, 
    0,   172,     6,    97,     0,   171,     5,    76,     0,   170,     5,    54,     0,   169,     5,    31,     0,   168,     5,     6,     0,   162,     6,     0,     0,   181,     0,   226, 
    0,   181,     0,   224,     0,   180,     0,   220,     0,   180,     0,   215,     0,   179,     0,   207,     0,   178,     0,   197,     0,   177,     0,   186,     0,   175,     0,   172, 
    0,   174,     0,   158,     0,   173,     0,   142,     0,   172,     0,   125,     0,   170,     0,   107,     0,   169,     0,    88,     0,   167,     0,    68,     0,   166,     0,    46, 
    0,   164,     0,    23,     0,   162,     0,     0,     0,   215,   215,   240,     0,   214,   226,   217,     0,   218,   218,   196,     0,   218,   217,   188,     0,   222,   209,   164, 
    0,   223,   199,   124,     0,   225,   187,    96,     0,   227,   176,    74,     0,   231,   167,    49,     0,   233,   158,    27,     0,   230,   149,    11,     0,   224,   145,     3, 
    0,   223,   142,     1,     0,   223,   140,     1,     0,   221,   137,     0,     0,   221,   135,     0,     0,   220,   134,     0,     0,   210,   198,   243,     0,   217,   205,   226, 
    0,   225,   198,   189,     0,   234,   186,   161,     0,   239,   180,   142,     0,   241,   174,   123,     0,   243,   166,   103,     0,   246,   156,    79,     0,   247,   145,    56, 
    0,   248,   135,    33,     0,   247,   126,    13,     0,   242,   121,     1,     0,   233,   125,     0,     0,   226,   127,     0,     0,   220,   128,     0,     0,   217,   129,     0, 
    0,   215,   130,     0,     0,   208,   179,   241,     0,   217,   174,   236,     0,   224,   178,   203,     0,   229,   176,   168,     0,   238,   171,   135,     0,   245,   163,   110, 
    0,   249,   154,    89,     0,   250,   145,    68,     0,   251,   136,    46,     0,   252,   126,    25,     0,   250,   119,     8,     0,   242,   119,     1,     0,   230,   124,     0, 
    0,   220,   126,     0,     0,   215,   127,     0,     0,   213,   126,     0,     0,   211,   128,     0,     0,   207,   155,   242,     0,   213,   151,   236,     0,   217,   153,   211, 
    0,   221,   160,   183,     0,   224,   157,   150,     0,   234,   150,   113,     0,   241,   143,    80,     0,   245,   135,    50,     0,   249,   126,    24,     0,   247,   119,     7, 
    0,   239,   121,     2,     0,   227,   124,     1,     0,   218,   126,     1,     0,   213,   126,     0,     0,   211,   124,     0,     0,   209,   124,     0,     0,   207,   125,     0, 
    0,   205,   132,   244,     0,   211,   127,   240,     0,   215,   126,   221,     0,   215,   136,   192,     0,   217,   139,   163,     0,   223,   136,   128,     0,   228,   133,    94, 
    0,   232,   127,    63,     0,   235,   120,    34,     0,   236,   113,    10,     0,   226,   118,     3,     0,   216,   122,     1,     0,   211,   122,     1,     0,   208,   120,     1, 
    0,   206,   119,     0,     0,   204,   118,     0,     0,   202,   119,     0,     0,   206,   108,   245,     0,   210,   104,   243,     0,   215,   101,   231,     0,   215,   109,   202, 
    0,   215,   115,   174,     0,   216,   118,   143,     0,   216,   118,   112,     0,   217,   117,    81,     0,   218,   115,    52,     0,   220,   111,    27,     0,   218,   109,     9, 
    0,   212,   111,     3,     0,   208,   111,     1,     0,   204,   111,     1,     0,   201,   111,     1,     0,   199,   110,     0,     0,   196,   111,     0,     0,   206,    86,   246, 
    0,   209,    83,   245,     0,   214,    80,   235,     0,   213,    86,   211,     0,   212,    94,   184,     0,   212,    98,   155,     0,   212,    99,   126,     0,   213,    99,    97, 
    0,   213,    98,    68,     0,   212,    98,    41,     0,   211,    98,    20,     0,   208,    98,     6,     0,   204,    99,     2,     0,   200,   100,     1,     0,   196,   101,     1, 
    0,   193,   101,     0,     0,   189,   103,     0,     0,   205,    64,   247,     0,   207,    61,   246,     0,   211,    58,   239,     0,   209,    67,   217,     0,   208,    74,   192, 
    0,   208,    79,   165,     0,   208,    81,   137,     0,   209,    81,   109,     0,   210,    81,    82,     0,   209,    80,    55,     0,   207,    83,    32,     0,   204,    85,    14, 
    0,   200,    86,     4,     0,   195,    89,     1,     0,   190,    90,     1,     0,   187,    91,     0,     0,   182,    93,     0,     0,   203,    41,   247,     0,   204,    39,   247, 
    0,   207,    36,   242,     0,   206,    44,   221,     0,   205,    52,   198,     0,   204,    60,   173,     0,   204,    63,   148,     0,   204,    64,   120,     0,   205,    64,    92, 
    0,   205,    64,    67,     0,   203,    65,    44,     0,   200,    69,    25,     0,   196,    74,    10,     0,   190,    77,     3,     0,   185,    79,     1,     0,   179,    80,     0, 
    0,   172,    82,     0,     0,   199,    21,   246,     0,   201,    20,   246,     0,   203,    18,   241,     0,   202,    25,   223,     0,   201,    32,   201,     0,   199,    39,   179, 
    0,   199,    44,   156,     0,   199,    47,   131,     0,   200,    47,   103,     0,   201,    46,    76,     0,   201,    48,    54,     0,   198,    52,    34,     0,   193,    57,    18, 
    0,   188,    63,     8,     0,   181,    68,     2,     0,   173,    70,     0,     0,   164,    71,     0,     0,   194,    12,   240,     0,   197,     5,   243,     0,   198,     6,   237, 
    0,   197,    11,   222,     0,   195,    19,   203,     0,   194,    24,   183,     0,   193,    28,   162,     0,   193,    32,   140,     0,   193,    34,   114,     0,   194,    33,    88, 
    0,   196,    31,    62,     0,   196,    35,    43,     0,   192,    40,    27,     0,   186,    47,    14,     0,   179,    53,     5,     0,   170,    58,     1,     0,   159,    63,     0, 
    0,   191,     9,   237,     0,   191,     2,   235,     0,   191,     1,   230,     0,   191,     3,   219,     0,   190,     8,   203,     0,   188,    12,   186,     0,   187,    16,   166, 
    0,   187,    19,   146,     0,   186,    22,   124,     0,   187,    23,    99,     0,   188,    22,    74,     0,   190,    21,    50,     0,   190,    26,    34,     0,   186,    31,    20, 
    0,   179,    37,     9,     0,   170,    44,     3,     0,   157,    51,     0,     0,   189,     7,   235,     0,   185,     1,   228,     0,   185,     1,   223,     0,   185,     1,   214, 
    0,   185,     2,   203,     0,   184,     5,   188,     0,   182,     7,   170,     0,   181,    10,   151,     0,   181,    12,   132,     0,   180,    14,   110,     0,   181,    14,    86, 
    0,   182,    14,    62,     0,   184,    14,    39,     0,   183,    19,    25,     0,   179,    23,    14,     0,   171,    29,     5,     0,   158,    38,     0,     0,   187,     5,   233, 
    0,   181,     1,   223,     0,   180,     1,   218,     0,   180,     1,   210,     0,   179,     1,   201,     0,   179,     1,   188,     0,   178,     2,   173,     0,   177,     4,   156, 
    0,   176,     5,   138,     0,   175,     7,   118,     0,   175,     8,    97,     0,   175,     7,    74,     0,   176,     7,    51,     0,   176,     8,    29,     0,   174,    12,    17, 
    0,   169,    16,     7,     0,   159,    25,     0,     0,   184,     3,   231,     0,   177,     1,   220,     0,   176,     0,   214,     0,   176,     0,   208,     0,   175,     1,   199, 
    0,   174,     1,   188,     0,   174,     1,   175,     0,   173,     1,   159,     0,   172,     1,   143,     0,   170,     2,   125,     0,   170,     3,   105,     0,   169,     3,    85, 
    0,   169,     3,    63,     0,   169,     3,    41,     0,   168,     3,    20,     0,   165,     7,     9,     0,   157,    14,     0,     0,   182,     2,   229,     0,   175,     0,   218, 
    0,   173,     0,   212,     0,   173,     0,   207,     0,   172,     0,   199,     0,   171,     0,   189,     0,   170,     0,   176,     0,   169,     0,   162,     0,   168,     0,   147, 
    0,   166,     1,   130,     0,   165,     1,   112,     0,   164,     1,    94,     0,   163,     1,    75,     0,   162,     1,    53,     0,   161,     1,    32,     0,   160,     1,    13, 
    0,   155,     5,     0,     0,   180,     0,   226,     0,   175,     0,   215,     0,   175,     0,   213,     0,   174,     0,   208,     0,   173,     0,   200,     0,   172,     0,   191, 
    0,   171,     0,   179,     0,   169,     0,   166,     0,   168,     0,   151,     0,   166,     0,   136,     0,   165,     0,   119,     0,   163,     0,   102,     0,   161,     0,    84, 
    0,   160,     0,    65,     0,   158,     0,    43,     0,   157,     0,    22,     0,   155,     0,     0,     0,   201,   212,   240,     0,   198,   225,   232,     0,   199,   233,   194, 
    0,   203,   226,   177,     0,   205,   218,   148,     0,   203,   211,   106,     0,   204,   200,    82,     0,   206,   188,    63,     0,   210,   178,    44,     0,   213,   169,    26, 
    0,   213,   159,    13,     0,   212,   153,     5,     0,   213,   149,     3,     0,   214,   146,     3,     0,   215,   143,     2,     0,   215,   140,     1,     0,   215,   138,     0, 
    0,   197,   194,   246,     0,   204,   219,   238,     0,   199,   218,   185,     0,   206,   207,   152,     0,   209,   198,   118,     0,   213,   187,    86,     0,   220,   177,    53, 
    0,   228,   168,    22,     0,   230,   158,    11,     0,   227,   150,     5,     0,   222,   145,     2,     0,   218,   141,     0,     0,   215,   139,     0,     0,   213,   136,     0, 
    0,   212,   134,     0,     0,   212,   133,     0,     0,   211,   134,     0,     0,   192,   176,   247,     0,   196,   177,   237,     0,   197,   181,   202,     0,   203,   176,   166, 
    0,   213,   170,   132,     0,   227,   163,    99,     0,   237,   151,    66,     0,   243,   141,    39,     0,   245,   131,    20,     0,   244,   123,     5,     0,   237,   123,     1, 
    0,   228,   126,     0,     0,   218,   128,     0,     0,   213,   127,     0,     0,   211,   126,     0,     0,   209,   125,     0,     0,   208,   127,     0,     0,   195,   154,   246, 
    0,   199,   152,   241,     0,   200,   156,   213,     0,   202,   162,   184,     0,   205,   160,   150,     0,   212,   156,   115,     0,   218,   149,    81,     0,   228,   140,    49, 
    0,   238,   129,    20,     0,   238,   122,     2,     0,   229,   124,     0,     0,   219,   125,     0,     0,   213,   125,     0,     0,   210,   123,     0,     0,   207,   122,     0, 
    0,   205,   122,     0,     0,   204,   124,     0,     0,   196,   133,   247,     0,   201,   129,   244,     0,   202,   131,   225,     0,   202,   138,   194,     0,   203,   144,   166, 
    0,   207,   142,   133,     0,   211,   138,    97,     0,   214,   134,    66,     0,   218,   129,    36,     0,   219,   124,    10,     0,   215,   123,     1,     0,   210,   123,     0, 
    0,   207,   121,     0,     0,   204,   120,     0,     0,   202,   118,     0,     0,   200,   118,     0,     0,   199,   120,     0,     0,   198,   110,   247,     0,   202,   107,   246, 
    0,   204,   106,   234,     0,   203,   113,   204,     0,   202,   121,   175,     0,   204,   123,   146,     0,   207,   121,   114,     0,   209,   120,    82,     0,   211,   118,    52, 
    0,   212,   114,    25,     0,   212,   111,     4,     0,   207,   111,     0,     0,   203,   112,     0,     0,   200,   111,     0,     0,   197,   111,     0,     0,   195,   110,     0, 
    0,   193,   112,     0,     0,   198,    88,   247,     0,   201,    85,   246,     0,   205,    84,   237,     0,   204,    90,   213,     0,   203,    96,   186,     0,   204,   100,   157, 
    0,   205,   101,   128,     0,   206,   101,    98,     0,   207,   100,    68,     0,   207,   100,    41,     0,   207,    99,    17,     0,   205,    97,     2,     0,   200,    99,     0, 
    0,   196,   100,     0,     0,   193,   101,     0,     0,   190,   101,     0,     0,   187,   103,     0,     0,   198,    66,   248,     0,   201,    64,   247,     0,   204,    61,   240, 
    0,   203,    69,   219,     0,   202,    75,   194,     0,   202,    79,   167,     0,   203,    81,   139,     0,   204,    82,   111,     0,   204,    82,    84,     0,   203,    82,    56, 
    0,   202,    84,    32,     0,   200,    84,    11,     0,   196,    85,     1,     0,   191,    88,     0,     0,   187,    90,     0,     0,   184,    91,     0,     0,   179,    93,     0, 
    0,   197,    44,   248,     0,   199,    40,   248,     0,   202,    38,   243,     0,   202,    45,   223,     0,   201,    53,   200,     0,   199,    60,   175,     0,   199,    64,   150, 
    0,   200,    65,   122,     0,   200,    65,    96,     0,   200,    65,    70,     0,   199,    66,    45,     0,   197,    68,    24,     0,   193,    72,     7,     0,   187,    75,     1, 
    0,   181,    78,     0,     0,   176,    79,     0,     0,   169,    82,     0,     0,   193,    24,   247,     0,   196,    21,   247,     0,   199,    20,   242,     0,   199,    26,   226, 
    0,   197,    34,   204,     0,   196,    39,   182,     0,   196,    45,   159,     0,   196,    47,   134,     0,   196,    48,   106,     0,   197,    48,    81,     0,   198,    47,    56, 
    0,   195,    51,    35,     0,   191,    55,    16,     0,   185,    61,     4,     0,   177,    66,     0,     0,   168,    69,     0,     0,   160,    70,     0,     0,   189,    13,   241, 
    0,   193,     5,   245,     0,   195,     7,   239,     0,   194,    11,   225,     0,   193,    20,   206,     0,   192,    24,   186,     0,   191,    28,   165,     0,   191,    32,   142, 
    0,   191,    34,   117,     0,   192,    34,    91,     0,   193,    32,    66,     0,   194,    33,    45,     0,   191,    37,    26,     0,   184,    44,    11,     0,   176,    50,     2, 
    0,   165,    56,     0,     0,   155,    61,     0,     0,   187,    10,   238,     0,   187,     1,   236,     0,   188,     0,   231,     0,   189,     2,   222,     0,   188,     7,   206, 
    0,   187,    11,   188,     0,   186,    15,   169,     0,   185,    18,   148,     0,   185,    20,   126,     0,   185,    21,   101,     0,   186,    21,    77,     0,   187,    20,    53, 
    0,   188,    23,    35,     0,   185,    28,    19,     0,   177,    34,     7,     0,   166,    41,     1,     0,   152,    50,     0,     0,   185,     7,   236,     0,   181,     1,   228, 
    0,   180,     0,   220,     0,   181,     0,   212,     0,   181,     1,   202,     0,   181,     2,   188,     0,   180,     5,   171,     0,   180,     7,   153,     0,   179,     9,   133, 
    0,   178,    11,   111,     0,   178,    11,    87,     0,   179,    11,    64,     0,   180,    11,    41,     0,   179,    15,    25,     0,   175,    19,    13,     0,   168,    25,     3, 
    0,   152,    37,     0,     0,   183,     5,   233,     0,   177,     0,   222,     0,   174,     0,   212,     0,   174,     0,   205,     0,   174,     0,   197,     0,   174,     0,   185, 
    0,   174,     0,   171,     0,   173,     1,   155,     0,   173,     2,   137,     0,   172,     3,   117,     0,   171,     4,    96,     0,   171,     4,    74,     0,   172,     4,    52, 
    0,   172,     4,    30,     0,   169,     8,    17,     0,   165,    12,     6,     0,   153,    24,     0,     0,   182,     3,   231,     0,   173,     0,   218,     0,   169,     0,   206, 
    0,   168,     0,   200,     0,   168,     0,   192,     0,   167,     0,   182,     0,   167,     0,   169,     0,   166,     0,   155,     0,   165,     0,   138,     0,   164,     0,   121, 
    0,   163,     0,   103,     0,   163,     0,    84,     0,   163,     0,    63,     0,   162,     0,    41,     0,   161,     1,    22,     0,   159,     4,     9,     0,   151,    13,     0, 
    0,   180,     2,   229,     0,   171,     0,   215,     0,   165,     0,   202,     0,   164,     0,   195,     0,   163,     0,   188,     0,   162,     0,   179,     0,   161,     0,   167, 
    0,   160,     0,   154,     0,   159,     0,   139,     0,   157,     0,   124,     0,   156,     0,   107,     0,   155,     0,    90,     0,   154,     0,    72,     0,   154,     0,    52, 
    0,   153,     0,    32,     0,   151,     1,    14,     0,   148,     5,     0,     0,   177,     0,   227,     0,   173,     0,   216,     0,   167,     0,   203,     0,   167,     0,   198, 
    0,   166,     0,   192,     0,   165,     0,   183,     0,   164,     0,   172,     0,   163,     0,   159,     0,   161,     0,   145,     0,   159,     0,   130,     0,   157,     0,   113, 
    0,   155,     0,    97,     0,   154,     0,    80,     0,   152,     0,    61,     0,   151,     0,    40,     0,   149,     0,    20,     0,   147,     0,     0,     0,   185,   211,   239, 
    0,   178,   224,   219,     0,   177,   239,   188,     0,   178,   240,   155,     0,   178,   229,   123,     0,   180,   219,    91,     0,   185,   207,    72,     0,   189,   196,    55, 
    0,   194,   185,    40,     0,   197,   176,    25,     0,   199,   167,    13,     0,   201,   160,     7,     0,   204,   155,     5,     0,   207,   151,     4,     0,   208,   147,     2, 
    0,   210,   144,     1,     0,   210,   141,     0,     0,   184,   193,   245,     0,   181,   207,   230,     0,   178,   216,   196,     0,   178,   222,   156,     0,   183,   212,   112, 
    0,   189,   202,    78,     0,   193,   194,    44,     0,   198,   184,    14,     0,   202,   173,     4,     0,   204,   164,     2,     0,   204,   156,     1,     0,   204,   150,     1, 
    0,   204,   145,     0,     0,   205,   141,     0,     0,   206,   139,     0,     0,   207,   137,     0,     0,   207,   137,     0,     0,   180,   177,   247,     0,   182,   183,   235, 
    0,   181,   184,   204,     0,   180,   191,   171,     0,   187,   187,   130,     0,   193,   181,    93,     0,   198,   172,    58,     0,   203,   164,    24,     0,   206,   153,     5, 
    0,   208,   145,     0,     0,   207,   142,     0,     0,   206,   140,     0,     0,   204,   137,     0,     0,   203,   134,     0,     0,   203,   132,     0,     0,   203,   130,     0, 
    0,   203,   132,     0,     0,   176,   158,   252,     0,   179,   159,   240,     0,   183,   163,   214,     0,   182,   162,   184,     0,   188,   160,   148,     0,   195,   156,   114, 
    0,   202,   150,    81,     0,   208,   144,    47,     0,   213,   136,    19,     0,   216,   130,     2,     0,   212,   128,     0,     0,   209,   127,     0,     0,   206,   125,     0, 
    0,   204,   123,     0,     0,   201,   121,     0,     0,   200,   120,     0,     0,   200,   122,     0,     0,   180,   135,   250,     0,   186,   134,   246,     0,   187,   139,   223, 
    0,   187,   142,   194,     0,   189,   146,   165,     0,   193,   145,   133,     0,   198,   141,    98,     0,   202,   136,    65,     0,   206,   132,    35,     0,   209,   126,    10, 
    0,   208,   123,     1,     0,   205,   121,     0,     0,   203,   119,     0,     0,   200,   118,     0,     0,   197,   116,     0,     0,   196,   116,     0,     0,   194,   119,     0, 
    0,   186,   112,   249,     0,   190,   110,   248,     0,   191,   112,   233,     0,   190,   120,   205,     0,   190,   125,   176,     0,   191,   129,   148,     0,   196,   128,   117, 
    0,   199,   124,    82,     0,   202,   121,    52,     0,   203,   118,    24,     0,   203,   114,     3,     0,   200,   114,     0,     0,   196,   113,     0,     0,   194,   112,     0, 
    0,   191,   111,     0,     0,   190,   111,     0,     0,   189,   113,     0,     0,   187,    91,   249,     0,   190,    88,   248,     0,   193,    88,   239,     0,   193,    95,   214, 
    0,   192,   100,   187,     0,   191,   106,   158,     0,   193,   108,   130,     0,   196,   106,    99,     0,   198,   105,    68,     0,   199,   104,    39,     0,   200,   101,    15, 
    0,   198,   100,     2,     0,   194,   101,     0,     0,   190,   102,     0,     0,   187,   102,     0,     0,   185,   102,     0,     0,   182,   105,     0,     0,   188,    70,   249, 
    0,   192,    66,   248,     0,   195,    65,   240,     0,   194,    72,   219,     0,   193,    77,   195,     0,   193,    82,   168,     0,   194,    85,   141,     0,   195,    86,   113, 
    0,   195,    86,    85,     0,   195,    87,    56,     0,   195,    87,    30,     0,   194,    85,     8,     0,   190,    87,     1,     0,   186,    89,     0,     0,   182,    90,     0, 
    0,   179,    91,     0,     0,   175,    94,     0,     0,   188,    48,   249,     0,   191,    44,   248,     0,   194,    43,   242,     0,   194,    50,   223,     0,   193,    57,   200, 
    0,   191,    62,   176,     0,   192,    66,   150,     0,   193,    68,   124,     0,   193,    68,    98,     0,   193,    68,    71,     0,   192,    69,    45,     0,   190,    71,    21, 
    0,   187,    73,     4,     0,   181,    75,     0,     0,   175,    78,     0,     0,   170,    79,     0,     0,   165,    82,     0,     0,   186,    27,   247,     0,   190,    23,   247, 
    0,   192,    24,   241,     0,   192,    31,   225,     0,   192,    38,   205,     0,   191,    42,   183,     0,   190,    47,   159,     0,   190,    50,   134,     0,   190,    51,   108, 
    0,   191,    50,    83,     0,   191,    49,    57,     0,   189,    53,    34,     0,   185,    56,    14,     0,   179,    61,     2,     0,   170,    66,     0,     0,   162,    68,     0, 
    0,   155,    70,     0,     0,   182,    15,   242,     0,   188,     8,   245,     0,   189,    10,   238,     0,   189,    14,   225,     0,   188,    22,   207,     0,   188,    25,   187, 
    0,   187,    30,   166,     0,   187,    33,   144,     0,   186,    35,   119,     0,   187,    35,    93,     0,   188,    34,    68,     0,   189,    34,    45,     0,   186,    38,    25, 
    0,   179,    43,     9,     0,   170,    49,     1,     0,   159,    56,     0,     0,   149,    61,     0,     0,   181,    11,   239,     0,   183,     1,   237,     0,   184,     1,   232, 
    0,   185,     3,   222,     0,   184,     9,   207,     0,   183,    12,   190,     0,   183,    15,   171,     0,   182,    18,   150,     0,   182,    20,   128,     0,   182,    21,   103, 
    0,   182,    21,    79,     0,   183,    20,    55,     0,   184,    23,    35,     0,   180,    26,    18,     0,   172,    32,     5,     0,   159,    40,     0,     0,   146,    49,     0, 
    0,   180,     8,   236,     0,   177,     1,   228,     0,   176,     0,   220,     0,   177,     0,   212,     0,   177,     1,   202,     0,   177,     2,   189,     0,   177,     5,   172, 
    0,   176,     7,   154,     0,   176,     8,   134,     0,   175,    10,   111,     0,   175,    10,    88,     0,   175,    10,    65,     0,   176,    10,    42,     0,   174,    13,    25, 
    0,   171,    17,    11,     0,   162,    23,     2,     0,   146,    36,     0,     0,   179,     6,   234,     0,   173,     0,   222,     0,   170,     0,   212,     0,   168,     0,   201, 
    0,   167,     0,   193,     0,   168,     0,   182,     0,   168,     0,   169,     0,   168,     1,   154,     0,   168,     1,   137,     0,   168,     1,   117,     0,   167,     2,    96, 
    0,   167,     2,    74,     0,   167,     2,    52,     0,   166,     2,    31,     0,   164,     5,    16,     0,   160,    10,     5,     0,   146,    23,     0,     0,   178,     4,   232, 
    0,   169,     0,   217,     0,   164,     0,   205,     0,   160,     0,   192,     0,   159,     0,   184,     0,   159,     0,   174,     0,   159,     0,   163,     0,   158,     0,   149, 
    0,   157,     0,   134,     0,   156,     0,   117,     0,   156,     0,   100,     0,   155,     0,    82,     0,   155,     0,    62,     0,   155,     0,    41,     0,   153,     0,    23, 
    0,   152,     3,     9,     0,   144,    12,     0,     0,   176,     2,   229,     0,   167,     0,   215,     0,   160,     0,   200,     0,   155,     0,   186,     0,   154,     0,   178, 
    0,   153,     0,   170,     0,   152,     0,   159,     0,   151,     0,   147,     0,   150,     0,   133,     0,   148,     0,   118,     0,   147,     0,   102,     0,   146,     0,    87, 
    0,   145,     0,    70,     0,   145,     0,    50,     0,   143,     0,    32,     0,   142,     1,    15,     0,   140,     5,     0,     0,   175,     0,   227,     0,   170,     0,   216, 
    0,   164,     0,   203,     0,   159,     0,   189,     0,   159,     0,   183,     0,   158,     0,   175,     0,   157,     0,   164,     0,   155,     0,   152,     0,   154,     0,   139, 
    0,   151,     0,   124,     0,   149,     0,   108,     0,   147,     0,    93,     0,   146,     0,    76,     0,   144,     0,    58,     0,   143,     0,    38,     0,   140,     0,    19, 
    0,   138,     0,     0,     0,   164,   213,   238,     0,   155,   229,   214,     0,   151,   244,   184,     0,   150,   252,   144,     0,   148,   242,   111,     0,   151,   230,    79, 
    0,   161,   215,    59,     0,   169,   202,    44,     0,   177,   191,    34,     0,   182,   182,    21,     0,   185,   174,    11,     0,   189,   167,     7,     0,   193,   161,     6, 
    0,   197,   157,     5,     0,   200,   153,     3,     0,   202,   149,     2,     0,   203,   145,     0,     0,   164,   195,   245,     0,   159,   203,   228,     0,   159,   213,   199, 
    0,   157,   226,   163,     0,   157,   222,   112,     0,   163,   212,    75,     0,   170,   202,    41,     0,   175,   192,    11,     0,   181,   180,     3,     0,   186,   171,     2, 
    0,   189,   163,     1,     0,   191,   156,     1,     0,   193,   151,     1,     0,   195,   147,     0,     0,   197,   143,     0,     0,   199,   141,     0,     0,   200,   141,     0, 
    0,   165,   180,   244,     0,   165,   182,   238,     0,   168,   185,   204,     0,   163,   192,   177,     0,   163,   195,   133,     0,   168,   192,    94,     0,   173,   187,    56, 
    0,   178,   180,    20,     0,   182,   170,     2,     0,   186,   162,     0,     0,   188,   156,     0,     0,   190,   150,     0,     0,   191,   144,     0,     0,   192,   140,     0, 
    0,   193,   137,     0,     0,   195,   135,     0,     0,   195,   136,     0,     0,   162,   162,   248,     0,   164,   163,   236,     0,   168,   167,   210,     0,   165,   166,   185, 
    0,   166,   172,   150,     0,   170,   170,   112,     0,   176,   165,    76,     0,   182,   160,    41,     0,   185,   153,    10,     0,   188,   146,     1,     0,   190,   141,     0, 
    0,   191,   136,     0,     0,   191,   132,     0,     0,   190,   129,     0,     0,   190,   126,     0,     0,   190,   125,     0,     0,   191,   127,     0,     0,   157,   139,   254, 
    0,   165,   138,   244,     0,   167,   144,   218,     0,   167,   145,   194,     0,   168,   147,   168,     0,   174,   146,   132,     0,   182,   141,    96,     0,   189,   136,    63, 
    0,   195,   132,    31,     0,   198,   125,     7,     0,   198,   121,     0,     0,   197,   119,     0,     0,   194,   118,     0,     0,   192,   116,     0,     0,   190,   115,     0, 
    0,   189,   114,     0,     0,   189,   116,     0,     0,   166,   116,   252,     0,   170,   114,   249,     0,   172,   119,   230,     0,   172,   126,   203,     0,   174,   129,   177, 
    0,   177,   133,   148,     0,   181,   132,   117,     0,   186,   127,    82,     0,   190,   125,    49,     0,   193,   120,    20,     0,   195,   115,     3,     0,   193,   114,     0, 
    0,   190,   112,     0,     0,   188,   111,     0,     0,   186,   110,     0,     0,   184,   109,     0,     0,   183,   112,     0,     0,   170,    95,   251,     0,   176,    91,   250, 
    0,   177,    93,   238,     0,   178,   102,   212,     0,   178,   106,   188,     0,   178,   111,   160,     0,   179,   115,   132,     0,   184,   114,   102,     0,   187,   111,    68, 
    0,   189,   108,    38,     0,   191,   104,    13,     0,   188,   103,     1,     0,   185,   104,     0,     0,   182,   104,     0,     0,   178,   103,     0,     0,   176,   102,     0, 
    0,   175,   105,     0,     0,   173,    74,   250,     0,   178,    70,   249,     0,   181,    71,   241,     0,   181,    78,   219,     0,   180,    83,   196,     0,   180,    86,   169, 
    0,   179,    91,   142,     0,   181,    94,   115,     0,   183,    91,    84,     0,   186,    91,    55,     0,   187,    90,    28,     0,   186,    88,     6,     0,   182,    89,     0, 
    0,   177,    91,     0,     0,   173,    91,     0,     0,   169,    91,     0,     0,   167,    94,     0,     0,   175,    52,   249,     0,   180,    48,   248,     0,   183,    49,   241, 
    0,   183,    56,   223,     0,   181,    63,   201,     0,   181,    65,   177,     0,   182,    69,   151,     0,   182,    72,   124,     0,   183,    72,    98,     0,   183,    72,    71, 
    0,   183,    73,    43,     0,   182,    74,    19,     0,   179,    74,     3,     0,   173,    76,     0,     0,   167,    78,     0,     0,   162,    79,     0,     0,   158,    83,     0, 
    0,   175,    32,   248,     0,   180,    27,   247,     0,   182,    30,   240,     0,   183,    37,   224,     0,   183,    43,   204,     0,   182,    45,   183,     0,   181,    50,   160, 
    0,   182,    53,   134,     0,   182,    55,   109,     0,   182,    54,    83,     0,   182,    55,    58,     0,   180,    56,    33,     0,   176,    58,    13,     0,   170,    62,     2, 
    0,   161,    66,     0,     0,   155,    67,     0,     0,   149,    70,     0,     0,   173,    18,   243,     0,   179,    12,   244,     0,   180,    15,   237,     0,   181,    19,   224, 
    0,   181,    25,   207,     0,   181,    29,   188,     0,   180,    33,   167,     0,   180,    36,   144,     0,   180,    38,   119,     0,   180,    38,    94,     0,   181,    37,    70, 
    0,   181,    38,    46,     0,   177,    40,    25,     0,   171,    44,     7,     0,   161,    50,     1,     0,   151,    55,     0,     0,   143,    59,     0,     0,   173,    12,   239, 
    0,   176,     3,   238,     0,   177,     3,   232,     0,   177,     6,   222,     0,   177,    11,   206,     0,   177,    14,   190,     0,   177,    18,   171,     0,   176,    20,   151, 
    0,   176,    22,   128,     0,   175,    23,   104,     0,   175,    22,    79,     0,   176,    22,    56,     0,   177,    24,    35,     0,   173,    27,    17,     0,   164,    31,     3, 
    0,   151,    40,     0,     0,   140,    48,     0,     0,   174,     9,   237,     0,   172,     1,   229,     0,   171,     0,   222,     0,   171,     0,   214,     0,   172,     1,   203, 
    0,   172,     3,   189,     0,   171,     6,   172,     0,   171,     8,   154,     0,   170,     9,   134,     0,   169,    10,   112,     0,   169,    11,    89,     0,   169,    10,    66, 
    0,   170,    10,    43,     0,   169,    12,    25,     0,   165,    16,    10,     0,   154,    23,     1,     0,   139,    35,     0,     0,   174,     6,   234,     0,   168,     1,   222, 
    0,   165,     0,   212,     0,   162,     0,   201,     0,   161,     0,   190,     0,   161,     0,   179,     0,   161,     0,   167,     0,   162,     1,   152,     0,   162,     1,   135, 
    0,   162,     1,   116,     0,   161,     1,    96,     0,   161,     1,    74,     0,   161,     1,    52,     0,   160,     1,    31,     0,   158,     4,    16,     0,   154,     9,     4, 
    0,   139,    22,     0,     0,   173,     4,   232,     0,   165,     0,   217,     0,   160,     0,   204,     0,   155,     0,   191,     0,   151,     0,   177,     0,   151,     0,   168, 
    0,   150,     0,   157,     0,   150,     0,   145,     0,   150,     0,   131,     0,   149,     0,   115,     0,   148,     0,    98,     0,   147,     0,    80,     0,   147,     0,    61, 
    0,   147,     0,    41,     0,   145,     0,    23,     0,   144,     2,    10,     0,   136,    12,     0,     0,   172,     2,   230,     0,   163,     0,   214,     0,   156,     0,   200, 
    0,   150,     0,   184,     0,   145,     0,   170,     0,   144,     0,   161,     0,   143,     0,   151,     0,   142,     0,   140,     0,   141,     0,   127,     0,   139,     0,   113, 
    0,   138,     0,    99,     0,   137,     0,    83,     0,   136,     0,    67,     0,   135,     0,    49,     0,   134,     0,    32,     0,   133,     1,    16,     0,   132,     5,     0, 
    0,   171,     0,   228,     0,   166,     0,   216,     0,   160,     0,   203,     0,   155,     0,   189,     0,   149,     0,   174,     0,   149,     0,   166,     0,   148,     0,   157, 
    0,   147,     0,   145,     0,   145,     0,   132,     0,   143,     0,   119,     0,   141,     0,   104,     0,   138,     0,    89,     0,   137,     0,    73,     0,   135,     0,    55, 
    0,   134,     0,    35,     0,   131,     0,    17,     0,   129,     0,     0,     0,   137,   213,   240,     0,   125,   230,   212,     0,   121,   243,   183,     0,   121,   251,   140, 
    0,   121,   245,   101,     0,   121,   239,    70,     0,   130,   224,    44,     0,   143,   210,    27,     0,   156,   198,    23,     0,   165,   189,    15,     0,   171,   180,     9, 
    0,   177,   173,     6,     0,   181,   168,     6,     0,   185,   163,     5,     0,   189,   158,     4,     0,   192,   155,     2,     0,   194,   151,     0,     0,   143,   193,   246, 
    0,   135,   202,   231,     0,   133,   214,   201,     0,   133,   224,   168,     0,   133,   224,   118,     0,   135,   218,    77,     0,   141,   210,    37,     0,   151,   199,     7, 
    0,   161,   187,     2,     0,   168,   177,     1,     0,   173,   169,     1,     0,   176,   162,     1,     0,   180,   156,     1,     0,   183,   152,     1,     0,   186,   149,     0, 
    0,   188,   146,     0,     0,   190,   146,     0,     0,   148,   179,   245,     0,   142,   183,   242,     0,   147,   188,   205,     0,   144,   193,   182,     0,   142,   199,   142, 
    0,   143,   197,   101,     0,   149,   194,    57,     0,   156,   188,    20,     0,   163,   178,     2,     0,   168,   169,     0,     0,   172,   161,     0,     0,   175,   155,     0, 
    0,   177,   149,     0,     0,   180,   145,     0,     0,   182,   142,     0,     0,   184,   139,     0,     0,   186,   140,     0,     0,   146,   160,   246,     0,   145,   164,   237, 
    0,   150,   170,   213,     0,   149,   170,   187,     0,   146,   177,   159,     0,   144,   179,   123,     0,   152,   175,    79,     0,   159,   171,    42,     0,   163,   165,     9, 
    0,   167,   158,     0,     0,   170,   151,     0,     0,   173,   146,     0,     0,   175,   141,     0,     0,   177,   137,     0,     0,   178,   133,     0,     0,   179,   131,     0, 
    0,   181,   133,     0,     0,   143,   141,   244,     0,   144,   141,   237,     0,   149,   147,   214,     0,   151,   150,   190,     0,   150,   154,   169,     0,   149,   157,   137, 
    0,   156,   152,    95,     0,   161,   150,    60,     0,   166,   146,    26,     0,   170,   140,     4,     0,   173,   135,     0,     0,   174,   131,     0,     0,   175,   127,     0, 
    0,   175,   124,     0,     0,   175,   121,     0,     0,   175,   119,     0,     0,   177,   122,     0,     0,   139,   120,   254,     0,   143,   120,   249,     0,   146,   125,   225, 
    0,   148,   130,   198,     0,   150,   132,   176,     0,   153,   132,   152,     0,   159,   130,   114,     0,   166,   126,    79,     0,   175,   124,    47,     0,   181,   118,    18, 
    0,   183,   113,     2,     0,   182,   111,     0,     0,   181,   109,     0,     0,   179,   108,     0,     0,   176,   106,     0,     0,   174,   106,     0,     0,   175,   107,     0, 
    0,   148,    98,   253,     0,   153,    96,   252,     0,   155,    99,   240,     0,   156,   108,   210,     0,   157,   112,   186,     0,   159,   114,   161,     0,   161,   117,   132, 
    0,   165,   115,   100,     0,   170,   113,    67,     0,   175,   111,    35,     0,   178,   108,     9,     0,   177,   105,     0,     0,   174,   103,     0,     0,   172,   102,     0, 
    0,   168,   100,     0,     0,   166,    99,     0,     0,   166,   102,     0,     0,   154,    78,   252,     0,   159,    75,   251,     0,   162,    76,   242,     0,   163,    83,   220, 
    0,   164,    89,   196,     0,   163,    91,   171,     0,   162,    94,   142,     0,   163,    99,   116,     0,   167,    97,    86,     0,   172,    96,    54,     0,   173,    94,    25, 
    0,   174,    91,     4,     0,   169,    91,     0,     0,   164,    91,     0,     0,   160,    91,     0,     0,   158,    90,     0,     0,   157,    93,     0,     0,   158,    57,   250, 
    0,   164,    53,   249,     0,   166,    55,   242,     0,   167,    62,   223,     0,   167,    68,   202,     0,   168,    70,   179,     0,   168,    72,   152,     0,   166,    77,   125, 
    0,   166,    76,    98,     0,   169,    75,    69,     0,   169,    77,    42,     0,   170,    76,    17,     0,   168,    75,     2,     0,   161,    77,     0,     0,   155,    78,     0, 
    0,   152,    79,     0,     0,   150,    81,     0,     0,   161,    37,   249,     0,   167,    33,   248,     0,   169,    36,   239,     0,   169,    43,   224,     0,   170,    48,   203, 
    0,   169,    51,   183,     0,   170,    54,   160,     0,   170,    57,   135,     0,   170,    58,   109,     0,   169,    57,    82,     0,   169,    59,    56,     0,   167,    60,    31, 
    0,   164,    61,    11,     0,   159,    64,     1,     0,   151,    65,     0,     0,   146,    66,     0,     0,   143,    69,     0,     0,   161,    21,   245,     0,   168,    16,   244, 
    0,   169,    20,   236,     0,   170,    25,   223,     0,   170,    31,   206,     0,   170,    33,   187,     0,   169,    36,   165,     0,   169,    39,   143,     0,   169,    41,   118, 
    0,   168,    41,    93,     0,   168,    41,    69,     0,   167,    43,    45,     0,   164,    43,    23,     0,   159,    46,     5,     0,   150,    51,     0,     0,   142,    55,     0, 
    0,   137,    58,     0,     0,   163,    14,   241,     0,   167,     6,   238,     0,   168,     7,   232,     0,   168,    10,   221,     0,   168,    15,   206,     0,   168,    18,   189, 
    0,   167,    21,   170,     0,   167,    23,   150,     0,   166,    25,   127,     0,   166,    25,   103,     0,   165,    25,    79,     0,   165,    25,    56,     0,   166,    27,    35, 
    0,   162,    29,    16,     0,   154,    33,     2,     0,   141,    40,     0,     0,   133,    46,     0,     0,   165,    10,   238,     0,   165,     1,   231,     0,   164,     1,   224, 
    0,   164,     1,   215,     0,   164,     3,   203,     0,   163,     4,   188,     0,   163,     7,   171,     0,   163,     9,   153,     0,   163,    10,   133,     0,   162,    11,   111, 
    0,   161,    11,    88,     0,   161,    11,    66,     0,   162,    11,    44,     0,   161,    13,    25,     0,   155,    16,     9,     0,   144,    23,     1,     0,   132,    34,     0, 
    0,   166,     7,   235,     0,   162,     1,   222,     0,   159,     0,   213,     0,   157,     0,   203,     0,   155,     0,   190,     0,   154,     0,   177,     0,   154,     0,   165, 
    0,   154,     1,   150,     0,   155,     1,   133,     0,   154,     1,   115,     0,   154,     1,    95,     0,   154,     1,    74,     0,   153,     1,    52,     0,   153,     1,    32, 
    0,   150,     4,    15,     0,   145,     8,     3,     0,   132,    22,     0,     0,   167,     4,   233,     0,   160,     0,   217,     0,   154,     0,   205,     0,   149,     0,   191, 
    0,   145,     0,   177,     0,   143,     0,   164,     0,   142,     0,   153,     0,   142,     0,   141,     0,   142,     0,   128,     0,   141,     0,   113,     0,   140,     0,    96, 
    0,   140,     0,    79,     0,   139,     0,    60,     0,   139,     0,    41,     0,   137,     0,    24,     0,   136,     2,    10,     0,   129,    11,     0,     0,   167,     2,   231, 
    0,   158,     0,   214,     0,   151,     0,   199,     0,   145,     0,   184,     0,   139,     0,   168,     0,   134,     0,   153,     0,   133,     0,   143,     0,   133,     0,   133, 
    0,   132,     0,   122,     0,   130,     0,   109,     0,   129,     0,    95,     0,   128,     0,    81,     0,   127,     0,    65,     0,   126,     0,    47,     0,   125,     0,    31, 
    0,   123,     1,    16,     0,   123,     5,     0,     0,   166,     0,   228,     0,   161,     0,   217,     0,   155,     0,   204,     0,   150,     0,   189,     0,   145,     0,   174, 
    0,   139,     0,   157,     0,   138,     0,   149,     0,   137,     0,   138,     0,   136,     0,   126,     0,   133,     0,   114,     0,   131,     0,   101,     0,   129,     0,    87, 
    0,   127,     0,    71,     0,   126,     0,    53,     0,   125,     0,    33,     0,   122,     0,    16,     0,   119,     0,     0,     0,   108,   214,   242,     0,    97,   232,   212, 
    0,    93,   243,   185,     0,    93,   248,   148,     0,    97,   246,   104,     0,    98,   238,    66,     0,    98,   233,    35,     0,   111,   218,    11,     0,   130,   204,    10, 
    0,   144,   195,     8,     0,   155,   187,     6,     0,   163,   180,     4,     0,   169,   175,     4,     0,   173,   169,     4,     0,   177,   164,     4,     0,   180,   160,     2, 
    0,   183,   156,     0,     0,   121,   193,   248,     0,   113,   203,   235,     0,   111,   211,   205,     0,   110,   218,   177,     0,   112,   220,   128,     0,   112,   218,    85, 
    0,   114,   214,    42,     0,   123,   205,     6,     0,   138,   193,     1,     0,   149,   183,     1,     0,   157,   174,     1,     0,   162,   167,     0,     0,   166,   161,     0, 
    0,   170,   157,     0,     0,   173,   153,     0,     0,   176,   151,     0,     0,   179,   151,     0,     0,   127,   177,   251,     0,   123,   183,   244,     0,   126,   190,   206, 
    0,   122,   194,   186,     0,   121,   198,   148,     0,   121,   200,   110,     0,   123,   197,    66,     0,   130,   193,    24,     0,   141,   185,     2,     0,   150,   175,     0, 
    0,   156,   167,     0,     0,   161,   159,     0,     0,   164,   153,     0,     0,   166,   149,     0,     0,   169,   145,     0,     0,   171,   143,     0,     0,   174,   145,     0, 
    0,   128,   158,   251,     0,   128,   158,   250,     0,   130,   169,   213,     0,   131,   173,   188,     0,   130,   177,   164,     0,   126,   183,   132,     0,   129,   180,    85, 
    0,   135,   176,    45,     0,   142,   172,    12,     0,   149,   165,     1,     0,   155,   157,     0,     0,   158,   150,     0,     0,   160,   144,     0,     0,   162,   140,     0, 
    0,   165,   136,     0,     0,   167,   134,     0,     0,   169,   136,     0,     0,   130,   145,   233,     0,   131,   144,   231,     0,   132,   149,   210,     0,   136,   151,   189, 
    0,   138,   156,   168,     0,   133,   161,   144,     0,   134,   161,   101,     0,   138,   158,    63,     0,   143,   155,    27,     0,   148,   151,     3,     0,   153,   144,     0, 
    0,   155,   139,     0,     0,   157,   134,     0,     0,   159,   130,     0,     0,   161,   126,     0,     0,   162,   124,     0,     0,   164,   127,     0,     0,   124,   125,   244, 
    0,   127,   124,   237,     0,   130,   128,   217,     0,   134,   132,   193,     0,   137,   135,   172,     0,   135,   138,   153,     0,   136,   140,   116,     0,   140,   137,    79, 
    0,   146,   135,    45,     0,   150,   131,    14,     0,   154,   127,     1,     0,   155,   123,     0,     0,   157,   119,     0,     0,   157,   115,     0,     0,   157,   113,     0, 
    0,   157,   111,     0,     0,   159,   114,     0,     0,   124,   102,   254,     0,   129,   101,   250,     0,   131,   104,   235,     0,   134,   111,   207,     0,   136,   115,   180, 
    0,   137,   117,   159,     0,   138,   113,   132,     0,   143,   113,    96,     0,   150,   112,    65,     0,   156,   109,    33,     0,   161,   106,     6,     0,   162,   103,     0, 
    0,   161,   101,     0,     0,   159,    99,     0,     0,   157,    97,     0,     0,   155,    96,     0,     0,   158,    96,     0,     0,   132,    81,   253,     0,   136,    79,   252, 
    0,   138,    81,   242,     0,   141,    88,   219,     0,   141,    94,   193,     0,   142,    97,   169,     0,   144,    95,   141,     0,   145,    97,   112,     0,   148,    97,    83, 
    0,   152,    97,    52,     0,   155,    95,    23,     0,   157,    90,     3,     0,   155,    90,     0,     0,   152,    90,     0,     0,   149,    89,     0,     0,   148,    88,     0, 
    0,   148,    90,     0,     0,   138,    61,   251,     0,   144,    58,   251,     0,   146,    60,   243,     0,   148,    68,   223,     0,   149,    74,   202,     0,   151,    76,   179, 
    0,   151,    75,   153,     0,   149,    80,   125,     0,   148,    81,    98,     0,   150,    81,    70,     0,   152,    80,    40,     0,   154,    77,    16,     0,   152,    76,     2, 
    0,   147,    77,     0,     0,   144,    76,     0,     0,   142,    77,     0,     0,   142,    80,     0,     0,   143,    41,   250,     0,   149,    38,   249,     0,   151,    41,   239, 
    0,   152,    48,   223,     0,   154,    54,   203,     0,   156,    57,   184,     0,   156,    59,   162,     0,   155,    61,   137,     0,   153,    64,   109,     0,   152,    64,    83, 
    0,   153,    63,    56,     0,   152,    62,    30,     0,   151,    63,     9,     0,   146,    64,     1,     0,   141,    63,     0,     0,   137,    63,     0,     0,   136,    65,     0, 
    0,   146,    24,   248,     0,   152,    21,   246,     0,   154,    25,   236,     0,   156,    31,   221,     0,   156,    36,   204,     0,   156,    39,   186,     0,   156,    42,   166, 
    0,   156,    43,   143,     0,   155,    45,   119,     0,   154,    45,    93,     0,   154,    45,    69,     0,   153,    46,    44,     0,   151,    46,    20,     0,   147,    49,     4, 
    0,   139,    52,     0,     0,   133,    53,     0,     0,   130,    55,     0,     0,   149,    15,   243,     0,   154,     9,   240,     0,   156,    11,   232,     0,   156,    16,   220, 
    0,   156,    20,   205,     0,   156,    22,   188,     0,   155,    24,   169,     0,   155,    26,   148,     0,   154,    28,   126,     0,   154,    28,   102,     0,   152,    28,    79, 
    0,   152,    29,    55,     0,   151,    31,    33,     0,   148,    31,    14,     0,   141,    35,     2,     0,   131,    39,     0,     0,   125,    45,     0,     0,   153,    10,   240, 
    0,   155,     2,   233,     0,   155,     2,   225,     0,   155,     4,   216,     0,   154,     7,   203,     0,   154,     8,   187,     0,   153,     9,   170,     0,   153,    11,   151, 
    0,   152,    12,   131,     0,   151,    13,   109,     0,   150,    13,    87,     0,   150,    14,    66,     0,   149,    14,    43,     0,   148,    17,    24,     0,   143,    19,     7, 
    0,   134,    24,     1,     0,   122,    34,     0,     0,   156,     7,   237,     0,   154,     1,   224,     0,   152,     0,   215,     0,   150,     0,   205,     0,   148,     1,   193, 
    0,   147,     1,   179,     0,   146,     1,   165,     0,   146,     1,   149,     0,   146,     1,   132,     0,   145,     2,   113,     0,   145,     2,    93,     0,   144,     3,    73, 
    0,   144,     3,    52,     0,   143,     3,    31,     0,   141,     6,    14,     0,   136,     9,     2,     0,   122,    22,     0,     0,   158,     5,   234,     0,   153,     0,   217, 
    0,   148,     0,   205,     0,   143,     0,   192,     0,   139,     0,   178,     0,   136,     0,   164,     0,   134,     0,   150,     0,   133,     0,   138,     0,   133,     0,   125, 
    0,   132,     0,   110,     0,   132,     0,    94,     0,   131,     0,    77,     0,   131,     0,    59,     0,   130,     0,    40,     0,   129,     0,    23,     0,   127,     3,     9, 
    0,   120,    12,     0,     0,   160,     2,   232,     0,   152,     0,   214,     0,   145,     0,   199,     0,   139,     0,   184,     0,   133,     0,   168,     0,   128,     0,   151, 
    0,   124,     0,   137,     0,   123,     0,   127,     0,   122,     0,   116,     0,   121,     0,   105,     0,   120,     0,    92,     0,   119,     0,    78,     0,   118,     0,    63, 
    0,   117,     0,    46,     0,   116,     0,    30,     0,   114,     1,    15,     0,   114,     5,     0,     0,   160,     0,   229,     0,   155,     0,   218,     0,   149,     0,   205, 
    0,   144,     0,   190,     0,   139,     0,   174,     0,   133,     0,   157,     0,   127,     0,   139,     0,   126,     0,   130,     0,   125,     0,   119,     0,   123,     0,   109, 
    0,   121,     0,    97,     0,   119,     0,    84,     0,   117,     0,    69,     0,   116,     0,    51,     0,   114,     0,    32,     0,   112,     0,    15,     0,   109,     0,     0, 
    0,    79,   219,   242,     0,    70,   235,   210,     0,    67,   244,   183,     0,    67,   248,   151,     0,    69,   245,   109,     0,    74,   242,    66,     0,    77,   234,    32, 
    0,    81,   227,     9,     0,   101,   212,     2,     0,   120,   201,     2,     0,   135,   194,     2,     0,   146,   187,     2,     0,   154,   182,     2,     0,   161,   176,     3, 
    0,   165,   171,     2,     0,   169,   166,     2,     0,   172,   162,     0,     0,    97,   194,   248,     0,    90,   202,   239,     0,    90,   207,   209,     0,    88,   215,   182, 
    0,    89,   219,   138,     0,    93,   216,   100,     0,    94,   214,    55,     0,    97,   210,    12,     0,   112,   198,     1,     0,   128,   187,     0,     0,   139,   179,     0, 
    0,   147,   173,     0,     0,   153,   167,     0,     0,   157,   162,     0,     0,   161,   158,     0,     0,   165,   155,     0,     0,   167,   156,     0,     0,   103,   179,   250, 
    0,    99,   181,   247,     0,   104,   189,   208,     0,   101,   194,   189,     0,   100,   199,   155,     0,   102,   200,   118,     0,   103,   199,    78,     0,   106,   195,    37, 
    0,   116,   189,     4,     0,   129,   179,     0,     0,   139,   171,     0,     0,   145,   164,     0,     0,   150,   158,     0,     0,   154,   153,     0,     0,   157,   149,     0, 
    0,   159,   147,     0,     0,   162,   149,     0,     0,   108,   158,   252,     0,   106,   160,   249,     0,   110,   171,   217,     0,   108,   175,   190,     0,   108,   178,   168, 
    0,   108,   182,   138,     0,   109,   184,    94,     0,   111,   181,    53,     0,   119,   177,    15,     0,   129,   169,     1,     0,   137,   161,     0,     0,   143,   154,     0, 
    0,   147,   149,     0,     0,   150,   144,     0,     0,   152,   139,     0,     0,   154,   137,     0,     0,   157,   140,     0,     0,   111,   149,   234,     0,   113,   148,   232, 
    0,   115,   151,   217,     0,   116,   154,   192,     0,   119,   157,   169,     0,   116,   161,   147,     0,   114,   167,   110,     0,   116,   164,    71,     0,   121,   160,    31, 
    0,   129,   155,     3,     0,   136,   148,     0,     0,   140,   142,     0,     0,   143,   137,     0,     0,   146,   133,     0,     0,   148,   128,     0,     0,   150,   126,     0, 
    0,   152,   129,     0,     0,   108,   128,   245,     0,   113,   128,   234,     0,   115,   133,   214,     0,   117,   135,   193,     0,   121,   135,   172,     0,   121,   140,   153, 
    0,   117,   145,   127,     0,   116,   146,    90,     0,   124,   143,    48,     0,   129,   138,    14,     0,   134,   133,     1,     0,   137,   128,     0,     0,   140,   124,     0, 
    0,   142,   120,     0,     0,   143,   116,     0,     0,   144,   114,     0,     0,   146,   117,     0,     0,   109,   105,   254,     0,   110,   108,   241,     0,   113,   113,   219, 
    0,   116,   117,   198,     0,   120,   118,   175,     0,   122,   118,   153,     0,   121,   120,   132,     0,   120,   123,   101,     0,   128,   123,    63,     0,   133,   120,    29, 
    0,   136,   115,     4,     0,   138,   112,     0,     0,   139,   108,     0,     0,   140,   105,     0,     0,   140,   102,     0,     0,   140,   100,     0,     0,   142,   102,     0, 
    0,   108,    85,   254,     0,   109,    87,   251,     0,   112,    90,   236,     0,   115,    96,   214,     0,   119,   100,   189,     0,   121,   101,   162,     0,   123,    99,   140, 
    0,   125,    96,   115,     0,   131,   100,    80,     0,   136,    98,    48,     0,   140,    94,    20,     0,   143,    90,     3,     0,   142,    89,     0,     0,   141,    87,     0, 
    0,   140,    85,     0,     0,   139,    83,     0,     0,   142,    82,     0,     0,   116,    66,   253,     0,   120,    63,   252,     0,   123,    65,   243,     0,   125,    73,   223, 
    0,   127,    79,   200,     0,   129,    81,   174,     0,   130,    81,   150,     0,   132,    82,   124,     0,   132,    84,    96,     0,   134,    84,    67,     0,   137,    81,    38, 
    0,   140,    77,    13,     0,   139,    75,     1,     0,   136,    76,     0,     0,   135,    74,     0,     0,   133,    73,     0,     0,   134,    75,     0,     0,   123,    46,   251, 
    0,   128,    43,   250,     0,   130,    46,   241,     0,   132,    53,   224,     0,   135,    59,   204,     0,   138,    62,   184,     0,   138,    64,   162,     0,   138,    65,   136, 
    0,   136,    67,   108,     0,   135,    69,    82,     0,   136,    68,    56,     0,   137,    65,    28,     0,   137,    62,     7,     0,   134,    61,     0,     0,   130,    60,     0, 
    0,   128,    60,     0,     0,   127,    64,     0,     0,   128,    28,   250,     0,   134,    26,   247,     0,   136,    30,   236,     0,   138,    36,   220,     0,   140,    40,   203, 
    0,   141,    44,   186,     0,   142,    47,   167,     0,   141,    48,   145,     0,   141,    49,   120,     0,   138,    51,    94,     0,   138,    52,    69,     0,   139,    50,    42, 
    0,   137,    48,    18,     0,   134,    49,     2,     0,   128,    51,     0,     0,   123,    53,     0,     0,   121,    54,     0,     0,   133,    17,   245,     0,   138,    13,   242, 
    0,   141,    15,   232,     0,   142,    21,   218,     0,   142,    24,   203,     0,   142,    27,   186,     0,   142,    29,   168,     0,   141,    30,   147,     0,   140,    31,   125, 
    0,   140,    32,   101,     0,   139,    32,    78,     0,   139,    33,    54,     0,   138,    34,    32,     0,   135,    34,    12,     0,   128,    36,     1,     0,   120,    40,     0, 
    0,   115,    45,     0,     0,   139,    11,   241,     0,   141,     4,   235,     0,   142,     5,   227,     0,   143,     8,   215,     0,   143,    11,   202,     0,   142,    12,   186, 
    0,   141,    13,   169,     0,   140,    14,   150,     0,   139,    16,   129,     0,   139,    16,   108,     0,   138,    17,    86,     0,   137,    17,    64,     0,   137,    18,    42, 
    0,   135,    21,    23,     0,   132,    20,     6,     0,   122,    26,     0,     0,   111,    34,     0,     0,   144,     8,   239,     0,   143,     1,   227,     0,   142,     0,   218, 
    0,   141,     1,   208,     0,   140,     1,   196,     0,   139,     1,   182,     0,   137,     2,   166,     0,   136,     2,   149,     0,   135,     3,   131,     0,   135,     4,   111, 
    0,   134,     5,    91,     0,   133,     5,    72,     0,   133,     6,    51,     0,   132,     6,    31,     0,   131,     8,    14,     0,   124,    11,     2,     0,   111,    23,     0, 
    0,   148,     5,   236,     0,   144,     0,   219,     0,   140,     0,   207,     0,   136,     0,   193,     0,   132,     0,   179,     0,   129,     0,   165,     0,   126,     0,   150, 
    0,   124,     0,   135,     0,   124,     0,   122,     0,   123,     0,   107,     0,   123,     0,    92,     0,   123,     0,    75,     0,   122,     0,    57,     0,   122,     0,    39, 
    0,   120,     0,    22,     0,   119,     3,     8,     0,   110,    12,     0,     0,   151,     2,   233,     0,   145,     0,   215,     0,   138,     0,   200,     0,   132,     0,   184, 
    0,   126,     0,   167,     0,   121,     0,   151,     0,   116,     0,   136,     0,   113,     0,   122,     0,   112,     0,   111,     0,   112,     0,   100,     0,   111,     0,    89, 
    0,   110,     0,    76,     0,   109,     0,    61,     0,   108,     0,    44,     0,   107,     0,    29,     0,   105,     1,    15,     0,   104,     5,     0,     0,   153,     0,   231, 
    0,   148,     0,   219,     0,   143,     0,   207,     0,   137,     0,   191,     0,   132,     0,   174,     0,   126,     0,   156,     0,   120,     0,   138,     0,   114,     0,   121, 
    0,   113,     0,   111,     0,   112,     0,   102,     0,   110,     0,    93,     0,   108,     0,    81,     0,   106,     0,    67,     0,   105,     0,    50,     0,   104,     0,    31, 
    0,   101,     0,    14,     0,    99,     0,     0,     0,    49,   227,   241,     0,    41,   239,   213,     0,    41,   245,   184,     0,    42,   247,   157,     0,    46,   244,   125, 
    0,    54,   240,    83,     0,    61,   236,    45,     0,    65,   230,    15,     0,    72,   224,     0,     0,    94,   210,     0,     0,   113,   200,     0,     0,   127,   193,     0, 
    0,   137,   187,     0,     0,   146,   182,     1,     0,   153,   177,     1,     0,   158,   172,     1,     0,   162,   167,     0,     0,    73,   197,   248,     0,    68,   202,   240, 
    0,    70,   204,   212,     0,    68,   211,   186,     0,    67,   219,   147,     0,    73,   214,   111,     0,    77,   214,    72,     0,    76,   213,    23,     0,    85,   204,     1, 
    0,   103,   192,     0,     0,   118,   183,     0,     0,   129,   176,     0,     0,   138,   171,     0,     0,   144,   167,     0,     0,   149,   163,     0,     0,   153,   160,     0, 
    0,   157,   161,     0,     0,    80,   180,   250,     0,    81,   183,   246,     0,    83,   192,   214,     0,    81,   194,   191,     0,    79,   200,   158,     0,    82,   201,   126, 
    0,    84,   201,    89,     0,    85,   198,    47,     0,    90,   195,     9,     0,   105,   184,     0,     0,   119,   174,     0,     0,   128,   166,     0,     0,   135,   160,     0, 
    0,   141,   157,     0,     0,   145,   154,     0,     0,   148,   151,     0,     0,   151,   154,     0,     0,    88,   160,   252,     0,    86,   161,   251,     0,    89,   172,   217, 
    0,    90,   180,   193,     0,    89,   181,   171,     0,    89,   184,   145,     0,    91,   186,   104,     0,    91,   185,    65,     0,    94,   181,    25,     0,   106,   174,     2, 
    0,   118,   164,     0,     0,   127,   156,     0,     0,   133,   150,     0,     0,   137,   146,     0,     0,   140,   142,     0,     0,   143,   140,     0,     0,   146,   144,     0, 
    0,    90,   148,   248,     0,    94,   147,   242,     0,    95,   151,   222,     0,    96,   157,   195,     0,    98,   159,   171,     0,    97,   163,   151,     0,    97,   168,   116, 
    0,    96,   169,    80,     0,    98,   166,    39,     0,   106,   161,     5,     0,   117,   152,     0,     0,   124,   144,     0,     0,   129,   138,     0,     0,   133,   133,     0, 
    0,   136,   130,     0,     0,   138,   128,     0,     0,   141,   132,     0,     0,    91,   131,   248,     0,    96,   134,   230,     0,    99,   138,   213,     0,   101,   138,   195, 
    0,   102,   140,   174,     0,   104,   140,   152,     0,   103,   144,   128,     0,    99,   148,    97,     0,   103,   148,    54,     0,   109,   144,    18,     0,   116,   138,     1, 
    0,   122,   131,     0,     0,   127,   125,     0,     0,   130,   121,     0,     0,   132,   117,     0,     0,   135,   115,     0,     0,   137,   118,     0,     0,    94,   107,   254, 
    0,    96,   113,   235,     0,   101,   118,   210,     0,   103,   121,   193,     0,   105,   124,   176,     0,   107,   120,   152,     0,   109,   123,   132,     0,   104,   127,   107, 
    0,   107,   129,    67,     0,   112,   127,    31,     0,   116,   123,     4,     0,   121,   117,     0,     0,   125,   112,     0,     0,   127,   108,     0,     0,   129,   104,     0, 
    0,   130,   102,     0,     0,   132,   104,     0,     0,    93,    88,   255,     0,    94,    93,   243,     0,    97,    98,   224,     0,   100,   102,   205,     0,   103,   104,   183, 
    0,   107,   103,   157,     0,   109,   102,   135,     0,   108,   106,   115,     0,   111,   108,    81,     0,   115,   109,    47,     0,   119,   104,    16,     0,   123,   100,     2, 
    0,   124,    96,     0,     0,   125,    92,     0,     0,   126,    89,     0,     0,   126,    87,     0,     0,   128,    88,     0,     0,    91,    70,   254,     0,    97,    68,   251, 
    0,   100,    72,   240,     0,   103,    78,   220,     0,   105,    82,   197,     0,   109,    84,   171,     0,   111,    84,   144,     0,   112,    85,   124,     0,   113,    86,   101, 
    0,   118,    87,    65,     0,   123,    82,    34,     0,   126,    77,     9,     0,   127,    74,     1,     0,   126,    72,     0,     0,   125,    70,     0,     0,   124,    69,     0, 
    0,   126,    67,     0,     0,   100,    51,   253,     0,   105,    48,   252,     0,   108,    50,   243,     0,   110,    58,   225,     0,   113,    64,   203,     0,   115,    67,   181, 
    0,   116,    68,   155,     0,   117,    69,   132,     0,   118,    70,   108,     0,   120,    71,    80,     0,   121,    70,    53,     0,   123,    65,    25,     0,   124,    60,     4, 
    0,   122,    61,     0,     0,   119,    61,     0,     0,   118,    61,     0,     0,   118,    62,     0,     0,   108,    32,   251,     0,   112,    31,   249,     0,   115,    34,   238, 
    0,   118,    40,   222,     0,   121,    45,   204,     0,   123,    48,   186,     0,   124,    51,   165,     0,   124,    52,   143,     0,   124,    53,   119,     0,   122,    54,    92, 
    0,   122,    57,    68,     0,   122,    54,    42,     0,   122,    50,    16,     0,   120,    50,     2,     0,   116,    51,     0,     0,   113,    51,     0,     0,   112,    53,     0, 
    0,   114,    18,   247,     0,   120,    16,   244,     0,   123,    19,   234,     0,   125,    25,   219,     0,   126,    29,   203,     0,   127,    32,   186,     0,   127,    33,   167, 
    0,   126,    34,   147,     0,   125,    35,   125,     0,   124,    36,   101,     0,   122,    38,    78,     0,   123,    40,    55,     0,   124,    37,    30,     0,   121,    36,     9, 
    0,   115,    38,     1,     0,   109,    41,     0,     0,   106,    45,     0,     0,   123,    12,   243,     0,   125,     6,   238,     0,   128,     7,   229,     0,   129,    12,   216, 
    0,   129,    14,   201,     0,   129,    16,   186,     0,   128,    17,   168,     0,   126,    19,   149,     0,   125,    20,   129,     0,   125,    20,   108,     0,   124,    21,    86, 
    0,   123,    21,    63,     0,   124,    22,    41,     0,   123,    23,    20,     0,   119,    22,     4,     0,   110,    28,     0,     0,   101,    34,     0,     0,   130,     8,   240, 
    0,   130,     1,   231,     0,   130,     1,   221,     0,   130,     2,   210,     0,   129,     3,   197,     0,   128,     3,   183,     0,   126,     4,   166,     0,   124,     5,   148, 
    0,   123,     5,   129,     0,   123,     6,   110,     0,   122,     7,    91,     0,   122,     8,    71,     0,   121,     8,    49,     0,   121,     8,    29,     0,   120,    11,    13, 
    0,   112,    13,     1,     0,   100,    24,     0,     0,   136,     5,   238,     0,   134,     0,   221,     0,   131,     0,   208,     0,   127,     0,   194,     0,   123,     0,   180, 
    0,   120,     0,   166,     0,   118,     0,   151,     0,   115,     0,   136,     0,   114,     0,   120,     0,   114,     0,   105,     0,   114,     1,    90,     0,   113,     1,    74, 
    0,   113,     1,    55,     0,   113,     1,    37,     0,   111,     1,    20,     0,   110,     4,     7,     0,    99,    13,     0,     0,   141,     3,   235,     0,   136,     0,   216, 
    0,   130,     0,   199,     0,   124,     0,   183,     0,   118,     0,   167,     0,   113,     0,   151,     0,   109,     0,   136,     0,   105,     0,   121,     0,   103,     0,   107, 
    0,   102,     0,    96,     0,   101,     0,    85,     0,   101,     0,    72,     0,   100,     0,    58,     0,    99,     0,    42,     0,    98,     0,    27,     0,    96,     1,    14, 
    0,    94,     5,     0,     0,   144,     0,   232,     0,   139,     0,   221,     0,   135,     0,   208,     0,   129,     0,   192,     0,   124,     0,   173,     0,   118,     0,   155, 
    0,   112,     0,   137,     0,   106,     0,   120,     0,   101,     0,   103,     0,    99,     0,    95,     0,    98,     0,    86,     0,    96,     0,    76,     0,    95,     0,    63, 
    0,    93,     0,    47,     0,    92,     0,    30,     0,    90,     0,    13,     0,    88,     0,     0,     0,    25,   228,   235,     0,    19,   238,   213,     0,    18,   244,   183, 
    0,    21,   246,   158,     0,    26,   243,   133,     0,    34,   241,    97,     0,    44,   240,    55,     0,    51,   235,    22,     0,    57,   230,     3,     0,    67,   222,     0, 
    0,    89,   210,     0,     0,   107,   200,     0,     0,   120,   193,     0,     0,   130,   187,     0,     0,   138,   182,     0,     0,   145,   177,     0,     0,   151,   173,     0, 
    0,    51,   200,   246,     0,    48,   202,   241,     0,    50,   203,   213,     0,    48,   211,   188,     0,    45,   220,   151,     0,    51,   216,   121,     0,    58,   212,    84, 
    0,    62,   211,    45,     0,    64,   208,     8,     0,    77,   198,     0,     0,    95,   188,     0,     0,   110,   180,     0,     0,   121,   174,     0,     0,   129,   169,     0, 
    0,   136,   166,     0,     0,   142,   165,     0,     0,   146,   166,     0,     0,    61,   182,   250,     0,    60,   182,   248,     0,    65,   189,   216,     0,    61,   192,   193, 
    0,    58,   200,   160,     0,    61,   201,   133,     0,    66,   200,    97,     0,    68,   198,    61,     0,    69,   196,    21,     0,    79,   189,     2,     0,    96,   178,     0, 
    0,   109,   169,     0,     0,   119,   163,     0,     0,   126,   158,     0,     0,   132,   155,     0,     0,   136,   154,     0,     0,   140,   157,     0,     0,    68,   163,   251, 
    0,    67,   165,   251,     0,    72,   175,   220,     0,    71,   181,   195,     0,    70,   182,   172,     0,    71,   184,   151,     0,    72,   185,   120,     0,    71,   187,    86, 
    0,    74,   184,    35,     0,    80,   179,     4,     0,    96,   168,     0,     0,   108,   159,     0,     0,   117,   152,     0,     0,   123,   147,     0,     0,   127,   143,     0, 
    0,   131,   141,     0,     0,   134,   147,     0,     0,    73,   145,   251,     0,    75,   143,   252,     0,    77,   157,   226,     0,    78,   163,   201,     0,    81,   163,   173, 
    0,    80,   166,   155,     0,    80,   167,   128,     0,    79,   170,    98,     0,    81,   168,    48,     0,    83,   165,    11,     0,    96,   157,     1,     0,   107,   148,     0, 
    0,   115,   141,     0,     0,   119,   135,     0,     0,   124,   131,     0,     0,   127,   129,     0,     0,   129,   134,     0,     0,    74,   130,   252,     0,    78,   137,   240, 
    0,    83,   138,   216,     0,    85,   141,   204,     0,    85,   146,   181,     0,    85,   144,   152,     0,    86,   147,   133,     0,    84,   149,   105,     0,    85,   151,    61, 
    0,    87,   149,    24,     0,    96,   143,     2,     0,   106,   136,     0,     0,   112,   129,     0,     0,   117,   124,     0,     0,   121,   119,     0,     0,   124,   117,     0, 
    0,   126,   120,     0,     0,    77,   109,   254,     0,    81,   117,   235,     0,    85,   124,   212,     0,    87,   126,   196,     0,    88,   126,   180,     0,    89,   128,   158, 
    0,    93,   126,   133,     0,    90,   129,   111,     0,    88,   133,    74,     0,    89,   132,    37,     0,    95,   128,     5,     0,   105,   122,     0,     0,   111,   116,     0, 
    0,   115,   111,     0,     0,   118,   107,     0,     0,   121,   104,     0,     0,   123,   106,     0,     0,    78,    89,   254,     0,    81,    96,   238,     0,    85,   102,   220, 
    0,    88,   106,   204,     0,    90,   108,   183,     0,    91,   110,   160,     0,    94,   108,   140,     0,    94,   109,   116,     0,    90,   113,    89,     0,    89,   116,    56, 
    0,    98,   111,    18,     0,   105,   107,     1,     0,   109,   102,     0,     0,   112,    98,     0,     0,   114,    94,     0,     0,   116,    91,     0,     0,   118,    91,     0, 
    0,    76,    72,   255,     0,    81,    73,   248,     0,    84,    77,   234,     0,    84,    86,   214,     0,    88,    90,   191,     0,    91,    91,   169,     0,    94,    90,   143, 
    0,    97,    91,   122,     0,    93,    93,    98,     0,    93,    95,    68,     0,   101,    91,    31,     0,   105,    88,     6,     0,   108,    84,     0,     0,   109,    81,     0, 
    0,   110,    77,     0,     0,   110,    75,     0,     0,   112,    74,     0,     0,    75,    56,   254,     0,    82,    53,   252,     0,    84,    56,   241,     0,    83,    65,   223, 
    0,    87,    70,   201,     0,    90,    71,   179,     0,    93,    71,   152,     0,    96,    73,   129,     0,    98,    74,   109,     0,    99,    74,    87,     0,   104,    71,    49, 
    0,   107,    66,    19,     0,   109,    64,     2,     0,   109,    62,     0,     0,   108,    61,     0,     0,   107,    59,     0,     0,   109,    57,     0,     0,    84,    38,   253, 
    0,    89,    36,   251,     0,    92,    38,   240,     0,    95,    44,   224,     0,    99,    49,   205,     0,   101,    53,   185,     0,   102,    54,   162,     0,   103,    56,   138, 
    0,   103,    57,   116,     0,   104,    59,    93,     0,   105,    61,    66,     0,   106,    55,    38,     0,   108,    51,    13,     0,   107,    49,     1,     0,   104,    51,     0, 
    0,   101,    51,     0,     0,   101,    52,     0,     0,    93,    22,   250,     0,    98,    20,   247,     0,   102,    23,   237,     0,   104,    29,   220,     0,   106,    33,   204, 
    0,   108,    36,   187,     0,   109,    37,   167,     0,   109,    38,   145,     0,   108,    40,   124,     0,   106,    42,   101,     0,   105,    43,    77,     0,   107,    46,    54, 
    0,   107,    41,    29,     0,   107,    38,     6,     0,   102,    40,     0,     0,    98,    41,     0,     0,    96,    43,     0,     0,   103,    12,   245,     0,   107,     8,   241, 
    0,   110,    10,   232,     0,   111,    16,   217,     0,   112,    18,   202,     0,   113,    20,   185,     0,   113,    21,   168,     0,   112,    22,   148,     0,   110,    23,   128, 
    0,   108,    26,   106,     0,   107,    26,    85,     0,   107,    27,    63,     0,   109,    28,    41,     0,   110,    26,    18,     0,   105,    26,     2,     0,    97,    30,     0, 
    0,    91,    34,     0,     0,   114,     8,   242,     0,   115,     2,   234,     0,   115,     2,   225,     0,   116,     5,   212,     0,   115,     6,   198,     0,   115,     6,   182, 
    0,   113,     8,   165,     0,   112,     8,   147,     0,   111,     9,   129,     0,   110,    10,   110,     0,   110,    10,    91,     0,   109,    10,    70,     0,   109,    11,    48, 
    0,   109,    11,    28,     0,   108,    13,    10,     0,    99,    16,     1,     0,    88,    25,     0,     0,   122,     5,   239,     0,   121,     1,   225,     0,   119,     0,   211, 
    0,   116,     0,   196,     0,   113,     0,   182,     0,   111,     0,   168,     0,   108,     1,   153,     0,   106,     1,   138,     0,   105,     1,   122,     0,   104,     1,   105, 
    0,   104,     1,    90,     0,   104,     1,    73,     0,   104,     1,    54,     0,   103,     1,    35,     0,   102,     1,    18,     0,   100,     4,     4,     0,    87,    14,     0, 
    0,   129,     3,   236,     0,   125,     0,   217,     0,   120,     0,   200,     0,   115,     0,   183,     0,   109,     0,   166,     0,   104,     0,   151,     0,   100,     0,   136, 
    0,    97,     0,   121,     0,    94,     0,   106,     0,    92,     0,    93,     0,    91,     0,    82,     0,    91,     0,    69,     0,    90,     0,    55,     0,    90,     0,    40, 
    0,    88,     0,    26,     0,    87,     1,    13,     0,    83,     6,     0,     0,   134,     0,   234,     0,   130,     0,   221,     0,   125,     0,   208,     0,   120,     0,   192, 
    0,   115,     0,   173,     0,   109,     0,   155,     0,   103,     0,   137,     0,    97,     0,   119,     0,    92,     0,   102,     0,    86,     0,    85,     0,    85,     0,    78, 
    0,    84,     0,    69,     0,    83,     0,    58,     0,    81,     0,    44,     0,    80,     0,    28,     0,    78,     0,    13,     0,    76,     0,     0,     0,    14,   224,   227, 
    0,     9,   231,   211,     0,     7,   239,   184,     0,     8,   242,   160,     0,    12,   243,   137,     0,    18,   243,   107,     0,    27,   243,    65,     0,    37,   240,    29, 
    0,    45,   235,     8,     0,    53,   227,     0,     0,    63,   222,     0,     0,    83,   210,     0,     0,   100,   200,     0,     0,   113,   193,     0,     0,   124,   187,     0, 
    0,   132,   182,     0,     0,   139,   178,     0,     0,    28,   202,   240,     0,    29,   202,   239,     0,    32,   202,   213,     0,    30,   210,   191,     0,    26,   220,   154, 
    0,    31,   217,   128,     0,    39,   214,    94,     0,    46,   212,    57,     0,    49,   209,    25,     0,    56,   204,     3,     0,    70,   194,     0,     0,    87,   185,     0, 
    0,   102,   178,     0,     0,   113,   173,     0,     0,   121,   169,     0,     0,   128,   167,     0,     0,   133,   169,     0,     0,    37,   186,   246,     0,    42,   183,   246, 
    0,    47,   186,   216,     0,    42,   192,   194,     0,    39,   202,   162,     0,    42,   202,   137,     0,    45,   200,   106,     0,    50,   198,    69,     0,    53,   196,    33, 
    0,    57,   193,     4,     0,    71,   183,     0,     0,    88,   173,     0,     0,   101,   166,     0,     0,   111,   161,     0,     0,   118,   158,     0,     0,   123,   156,     0, 
    0,   128,   160,     0,     0,    48,   167,   249,     0,    50,   166,   247,     0,    53,   171,   221,     0,    52,   178,   195,     0,    51,   180,   173,     0,    53,   182,   153, 
    0,    55,   183,   127,     0,    55,   185,    95,     0,    58,   184,    44,     0,    60,   182,     8,     0,    72,   172,     0,     0,    88,   162,     0,     0,   100,   155,     0, 
    0,   108,   150,     0,     0,   114,   146,     0,     0,   118,   144,     0,     0,   122,   149,     0,     0,    57,   146,   251,     0,    57,   147,   249,     0,    58,   156,   228, 
    0,    61,   164,   202,     0,    62,   164,   174,     0,    64,   166,   155,     0,    66,   166,   134,     0,    63,   169,   104,     0,    65,   169,    57,     0,    66,   167,    19, 
    0,    74,   161,     1,     0,    88,   151,     0,     0,    98,   143,     0,     0,   105,   138,     0,     0,   110,   134,     0,     0,   114,   132,     0,     0,   117,   137,     0, 
    0,    59,   130,   252,     0,    61,   132,   246,     0,    66,   142,   227,     0,    67,   148,   209,     0,    67,   151,   186,     0,    69,   149,   154,     0,    70,   150,   135, 
    0,    68,   152,   109,     0,    70,   154,    67,     0,    70,   152,    30,     0,    75,   148,     3,     0,    88,   139,     0,     0,    96,   131,     0,     0,   103,   126,     0, 
    0,   108,   122,     0,     0,   112,   119,     0,     0,   114,   124,     0,     0,    60,   113,   253,     0,    64,   118,   237,     0,    70,   127,   213,     0,    72,   129,   201, 
    0,    74,   130,   185,     0,    74,   135,   163,     0,    74,   131,   134,     0,    72,   133,   114,     0,    73,   136,    79,     0,    72,   137,    45,     0,    74,   134,    11, 
    0,    86,   125,     1,     0,    95,   119,     0,     0,   101,   113,     0,     0,   105,   109,     0,     0,   109,   106,     0,     0,   111,   110,     0,     0,    63,    92,   254, 
    0,    66,    98,   238,     0,    70,   105,   219,     0,    72,   112,   202,     0,    75,   115,   182,     0,    77,   115,   163,     0,    78,   116,   141,     0,    79,   111,   116, 
    0,    76,   114,    94,     0,    72,   120,    65,     0,    76,   116,    24,     0,    84,   111,     2,     0,    93,   105,     0,     0,    98,   100,     0,     0,   102,    95,     0, 
    0,   105,    92,     0,     0,   107,    94,     0,     0,    63,    74,   254,     0,    67,    76,   243,     0,    71,    82,   227,     0,    72,    90,   206,     0,    78,    91,   180, 
    0,    80,    94,   164,     0,    80,    93,   139,     0,    82,    95,   123,     0,    81,    94,    97,     0,    77,    99,    74,     0,    79,    97,    35,     0,    84,    93,     6, 
    0,    90,    89,     0,     0,    95,    84,     0,     0,    97,    80,     0,     0,    98,    76,     0,     0,   100,    76,     0,     0,    61,    58,   254,     0,    66,    59,   246, 
    0,    69,    63,   233,     0,    69,    71,   214,     0,    72,    74,   194,     0,    75,    76,   176,     0,    77,    77,   152,     0,    82,    78,   128,     0,    83,    78,   106, 
    0,    80,    82,    84,     0,    82,    80,    49,     0,    84,    75,    18,     0,    89,    72,     2,     0,    91,    68,     0,     0,    92,    65,     0,     0,    92,    63,     0, 
    0,    93,    62,     0,     0,    59,    43,   254,     0,    67,    41,   250,     0,    71,    43,   238,     0,    74,    49,   221,     0,    78,    52,   203,     0,    79,    55,   183, 
    0,    80,    57,   161,     0,    83,    59,   136,     0,    85,    61,   113,     0,    84,    62,    94,     0,    84,    63,    74,     0,    88,    56,    34,     0,    92,    53,     9, 
    0,    92,    51,     0,     0,    91,    50,     0,     0,    91,    49,     0,     0,    91,    46,     0,     0,    70,    26,   253,     0,    75,    24,   250,     0,    80,    26,   240, 
    0,    83,    33,   222,     0,    85,    37,   205,     0,    86,    40,   187,     0,    88,    41,   167,     0,    89,    42,   145,     0,    89,    45,   121,     0,    87,    47,   100, 
    0,    88,    46,    78,     0,    90,    47,    51,     0,    91,    42,    24,     0,    92,    40,     4,     0,    90,    40,     0,     0,    87,    40,     0,     0,    84,    40,     0, 
    0,    80,    13,   249,     0,    85,    12,   245,     0,    89,    14,   234,     0,    91,    20,   219,     0,    93,    23,   203,     0,    94,    25,   187,     0,    95,    25,   168, 
    0,    95,    26,   148,     0,    94,    27,   127,     0,    91,    30,   105,     0,    90,    30,    83,     0,    90,    30,    61,     0,    92,    32,    39,     0,    93,    29,    17, 
    0,    90,    29,     2,     0,    85,    31,     0,     0,    80,    33,     0,     0,    93,     8,   245,     0,    96,     3,   237,     0,    97,     4,   228,     0,    98,     8,   215, 
    0,    99,     9,   200,     0,    99,    10,   183,     0,    98,    11,   165,     0,    97,    12,   147,     0,    97,    12,   129,     0,    96,    13,   110,     0,    94,    15,    89, 
    0,    93,    15,    69,     0,    93,    16,    48,     0,    95,    17,    28,     0,    94,    16,     8,     0,    86,    19,     1,     0,    76,    25,     0,     0,   105,     5,   241, 
    0,   105,     1,   229,     0,   104,     0,   217,     0,   102,     1,   203,     0,   101,     1,   188,     0,   100,     1,   173,     0,    98,     1,   157,     0,    96,     1,   141, 
    0,    95,     1,   125,     0,    94,     1,   108,     0,    93,     2,    90,     0,    93,     2,    73,     0,    93,     3,    54,     0,    92,     3,    34,     0,    93,     3,    16, 
    0,    88,     6,     3,     0,    74,    15,     0,     0,   115,     2,   238,     0,   112,     0,   221,     0,   108,     0,   204,     0,   104,     0,   186,     0,    99,     0,   168, 
    0,    95,     0,   151,     0,    92,     0,   136,     0,    88,     0,   122,     0,    86,     0,   107,     0,    83,     0,    93,     0,    82,     0,    79,     0,    81,     0,    67, 
    0,    81,     0,    53,     0,    80,     0,    38,     0,    79,     0,    24,     0,    78,     1,    12,     0,    70,     6,     0,     0,   121,     0,   236,     0,   118,     0,   224, 
    0,   114,     0,   211,     0,   110,     0,   193,     0,   105,     0,   174,     0,    99,     0,   155,     0,    94,     0,   136,     0,    88,     0,   119,     0,    83,     0,   100, 
    0,    77,     0,    84,     0,    72,     0,    69,     0,    70,     0,    61,     0,    69,     0,    52,     0,    68,     0,    40,     0,    67,     0,    27,     0,    65,     0,    13, 
    0,    64,     0,     0,     0,     9,   222,   219,     0,     6,   228,   209,     0,     5,   233,   189,     0,     5,   238,   166,     0,     8,   240,   145,     0,    12,   241,   119, 
    0,    17,   242,    83,     0,    27,   241,    44,     0,    35,   238,    17,     0,    43,   233,     4,     0,    51,   226,     0,     0,    58,   221,     0,     0,    78,   210,     0, 
    0,    94,   200,     0,     0,   107,   193,     0,     0,   117,   187,     0,     0,   126,   181,     0,     0,    17,   200,   229,     0,    15,   202,   234,     0,    15,   204,   214, 
    0,    15,   210,   193,     0,    12,   218,   158,     0,    16,   218,   131,     0,    23,   215,   106,     0,    30,   212,    68,     0,    36,   211,    35,     0,    41,   208,     9, 
    0,    51,   200,     1,     0,    64,   192,     0,     0,    80,   183,     0,     0,    95,   177,     0,     0,   105,   173,     0,     0,   114,   171,     0,     0,   120,   173,     0, 
    0,    24,   185,   238,     0,    24,   184,   243,     0,    24,   190,   219,     0,    23,   196,   195,     0,    21,   203,   165,     0,    24,   203,   140,     0,    27,   201,   115, 
    0,    33,   200,    79,     0,    38,   198,    41,     0,    42,   195,    11,     0,    52,   188,     1,     0,    65,   179,     0,     0,    81,   170,     0,     0,    94,   164,     0, 
    0,   103,   161,     0,     0,   109,   159,     0,     0,   115,   164,     0,     0,    33,   168,   245,     0,    33,   167,   246,     0,    33,   173,   225,     0,    32,   180,   198, 
    0,    33,   182,   175,     0,    35,   184,   156,     0,    35,   185,   133,     0,    37,   185,   101,     0,    42,   184,    53,     0,    45,   182,    19,     0,    54,   176,     1, 
    0,    67,   166,     0,     0,    81,   158,     0,     0,    92,   152,     0,     0,    99,   148,     0,     0,   105,   147,     0,     0,   109,   153,     0,     0,    42,   148,   249, 
    0,    40,   149,   249,     0,    39,   156,   231,     0,    41,   165,   205,     0,    43,   165,   175,     0,    43,   166,   157,     0,    44,   169,   136,     0,    44,   171,   109, 
    0,    48,   171,    64,     0,    50,   170,    28,     0,    55,   164,     2,     0,    68,   154,     0,     0,    81,   145,     0,     0,    90,   139,     0,     0,    96,   135,     0, 
    0,   101,   133,     0,     0,   104,   140,     0,     0,    46,   131,   251,     0,    46,   131,   248,     0,    47,   136,   232,     0,    48,   149,   210,     0,    48,   155,   188, 
    0,    50,   152,   156,     0,    50,   153,   138,     0,    50,   156,   114,     0,    52,   155,    73,     0,    53,   155,    38,     0,    55,   152,     5,     0,    68,   143,     0, 
    0,    79,   133,     0,     0,    87,   127,     0,     0,    94,   122,     0,     0,    99,   120,     0,     0,   100,   126,     0,     0,    46,   115,   252,     0,    49,   119,   238, 
    0,    53,   128,   218,     0,    54,   133,   208,     0,    55,   137,   192,     0,    57,   140,   166,     0,    56,   135,   136,     0,    55,   138,   117,     0,    56,   138,    83, 
    0,    57,   140,    51,     0,    57,   138,    17,     0,    65,   131,     1,     0,    77,   121,     0,     0,    85,   114,     0,     0,    91,   109,     0,     0,    96,   107,     0, 
    0,    97,   111,     0,     0,    48,    97,   253,     0,    51,   103,   235,     0,    55,   114,   214,     0,    57,   116,   199,     0,    60,   118,   183,     0,    62,   117,   167, 
    0,    61,   119,   142,     0,    61,   116,   119,     0,    59,   117,    97,     0,    57,   120,    71,     0,    58,   121,    31,     0,    61,   117,     4,     0,    73,   108,     0, 
    0,    82,   101,     0,     0,    88,    95,     0,     0,    92,    92,     0,     0,    93,    95,     0,     0,    51,    77,   253,     0,    53,    83,   235,     0,    57,    90,   217, 
    0,    60,    93,   202,     0,    62,    95,   182,     0,    63,    98,   162,     0,    66,    98,   143,     0,    66,   100,   125,     0,    66,    97,    98,     0,    62,   100,    78, 
    0,    60,   103,    43,     0,    61,    99,    12,     0,    71,    92,     1,     0,    79,    86,     0,     0,    84,    81,     0,     0,    86,    78,     0,     0,    87,    78,     0, 
    0,    50,    61,   253,     0,    50,    68,   235,     0,    54,    73,   219,     0,    57,    76,   207,     0,    60,    78,   191,     0,    64,    79,   173,     0,    66,    81,   151, 
    0,    68,    82,   129,     0,    69,    82,   106,     0,    66,    83,    85,     0,    62,    87,    60,     0,    60,    84,    30,     0,    68,    78,     4,     0,    76,    72,     0, 
    0,    79,    68,     0,     0,    80,    65,     0,     0,    81,    64,     0,     0,    47,    45,   254,     0,    52,    46,   244,     0,    55,    49,   231,     0,    59,    54,   214, 
    0,    61,    57,   200,     0,    60,    63,   183,     0,    63,    65,   158,     0,    66,    66,   136,     0,    69,    67,   111,     0,    69,    67,    90,     0,    65,    68,    67, 
    0,    64,    66,    39,     0,    71,    61,    10,     0,    74,    57,     1,     0,    76,    55,     0,     0,    76,    52,     0,     0,    76,    51,     0,     0,    44,    31,   254, 
    0,    53,    29,   249,     0,    57,    32,   237,     0,    61,    37,   219,     0,    63,    39,   203,     0,    60,    43,   187,     0,    62,    47,   166,     0,    65,    48,   145, 
    0,    67,    49,   120,     0,    70,    51,    98,     0,    70,    50,    78,     0,    70,    48,    59,     0,    73,    43,    21,     0,    76,    41,     2,     0,    76,    39,     0, 
    0,    76,    38,     0,     0,    75,    37,     0,     0,    55,    16,   253,     0,    62,    15,   249,     0,    67,    17,   239,     0,    70,    22,   222,     0,    72,    25,   204, 
    0,    73,    27,   188,     0,    74,    29,   169,     0,    74,    30,   149,     0,    74,    31,   127,     0,    74,    33,   104,     0,    72,    33,    83,     0,    73,    32,    61, 
    0,    76,    33,    36,     0,    76,    31,    13,     0,    76,    30,     1,     0,    73,    30,     0,     0,    69,    31,     0,     0,    70,     9,   249,     0,    73,     5,   243, 
    0,    76,     7,   232,     0,    79,    11,   218,     0,    79,    13,   202,     0,    80,    14,   185,     0,    80,    15,   168,     0,    80,    16,   149,     0,    81,    16,   129, 
    0,    80,    17,   109,     0,    78,    19,    88,     0,    75,    19,    67,     0,    76,    19,    46,     0,    78,    21,    26,     0,    78,    19,     7,     0,    72,    21,     0, 
    0,    64,    24,     0,     0,    84,     5,   245,     0,    85,     1,   235,     0,    86,     1,   224,     0,    85,     2,   211,     0,    85,     3,   196,     0,    84,     3,   179, 
    0,    83,     4,   160,     0,    83,     4,   142,     0,    83,     4,   126,     0,    82,     4,   109,     0,    80,     5,    91,     0,    79,     6,    72,     0,    78,     7,    53, 
    0,    78,     7,    33,     0,    79,     7,    15,     0,    74,     9,     2,     0,    62,    16,     0,     0,    96,     2,   241,     0,    95,     0,   225,     0,    93,     0,   211, 
    0,    90,     0,   194,     0,    87,     0,   176,     0,    84,     0,   157,     0,    81,     0,   139,     0,    79,     0,   123,     0,    76,     0,   108,     0,    74,     0,    94, 
    0,    72,     0,    79,     0,    71,     0,    65,     0,    71,     1,    52,     0,    70,     1,    36,     0,    69,     0,    22,     0,    68,     2,    10,     0,    58,     7,     0, 
    0,   106,     0,   238,     0,   103,     0,   227,     0,   100,     0,   215,     0,    97,     0,   199,     0,    93,     0,   178,     0,    88,     0,   157,     0,    83,     0,   137, 
    0,    78,     0,   118,     0,    72,     0,    98,     0,    67,     0,    82,     0,    61,     0,    66,     0,    58,     0,    55,     0,    57,     0,    46,     0,    56,     0,    36, 
    0,    55,     0,    25,     0,    54,     0,    13,     0,    53,     0,     0,     0,     6,   221,   212,     0,     5,   224,   207,     0,     5,   228,   194,     0,     5,   232,   172, 
    0,     6,   235,   153,     0,     9,   236,   132,     0,    13,   238,   104,     0,    20,   239,    66,     0,    28,   238,    34,     0,    35,   235,    13,     0,    41,   231,     3, 
    0,    48,   225,     0,     0,    53,   221,     0,     0,    72,   210,     0,     0,    88,   200,     0,     0,   101,   193,     0,     0,   111,   186,     0,     0,    12,   199,   220, 
    0,     4,   206,   216,     0,     2,   210,   201,     0,     3,   213,   182,     0,     5,   215,   162,     0,     8,   215,   138,     0,    12,   214,   115,     0,    18,   213,    82, 
    0,    24,   212,    46,     0,    30,   210,    19,     0,    36,   205,     3,     0,    47,   198,     0,     0,    57,   190,     0,     0,    74,   183,     0,     0,    88,   178,     0, 
    0,    99,   175,     0,     0,   106,   177,     0,     0,    16,   183,   229,     0,     8,   190,   228,     0,     6,   198,   205,     0,     6,   201,   183,     0,     8,   202,   165, 
    0,    10,   203,   144,     0,    13,   203,   119,     0,    18,   201,    88,     0,    24,   199,    52,     0,    29,   197,    21,     0,    36,   192,     2,     0,    48,   184,     0, 
    0,    59,   176,     0,     0,    74,   168,     0,     0,    87,   163,     0,     0,    94,   162,     0,     0,   100,   167,     0,     0,    22,   167,   237,     0,    17,   171,   238, 
    0,    14,   179,   217,     0,    15,   182,   197,     0,    17,   182,   177,     0,    17,   186,   158,     0,    18,   189,   126,     0,    21,   188,    97,     0,    27,   185,    60, 
    0,    31,   185,    28,     0,    37,   180,     3,     0,    50,   171,     0,     0,    61,   162,     0,     0,    75,   155,     0,     0,    83,   151,     0,     0,    90,   149,     0, 
    0,    95,   156,     0,     0,    28,   150,   244,     0,    24,   152,   246,     0,    22,   158,   228,     0,    24,   163,   203,     0,    25,   163,   174,     0,    24,   169,   158, 
    0,    24,   174,   131,     0,    26,   173,   106,     0,    31,   171,    70,     0,    34,   171,    37,     0,    37,   168,     7,     0,    50,   158,     0,     0,    62,   149,     0, 
    0,    73,   142,     0,     0,    81,   137,     0,     0,    87,   135,     0,     0,    90,   143,     0,     0,    34,   131,   249,     0,    32,   131,   248,     0,    31,   137,   231, 
    0,    30,   146,   206,     0,    30,   153,   185,     0,    31,   152,   156,     0,    31,   155,   139,     0,    31,   156,   118,     0,    34,   156,    79,     0,    37,   156,    47, 
    0,    38,   156,    15,     0,    48,   147,     1,     0,    60,   138,     0,     0,    70,   129,     0,     0,    79,   123,     0,     0,    85,   121,     0,     0,    86,   128,     0, 
    0,    34,   116,   251,     0,    35,   119,   239,     0,    38,   124,   221,     0,    39,   129,   208,     0,    37,   138,   190,     0,    37,   142,   166,     0,    38,   137,   137, 
    0,    37,   139,   119,     0,    38,   140,    88,     0,    39,   140,    57,     0,    40,   141,    26,     0,    44,   136,     3,     0,    56,   127,     0,     0,    67,   117,     0, 
    0,    76,   109,     0,     0,    82,   106,     0,     0,    82,   112,     0,     0,    34,   100,   251,     0,    37,   106,   231,     0,    41,   113,   211,     0,    41,   117,   201, 
    0,    43,   119,   188,     0,    45,   122,   171,     0,    44,   124,   145,     0,    43,   120,   119,     0,    42,   121,   100,     0,    41,   122,    74,     0,    43,   125,    37, 
    0,    42,   122,     7,     0,    53,   113,     0,     0,    65,   102,     0,     0,    73,    95,     0,     0,    78,    91,     0,     0,    78,    95,     0,     0,    38,    80,   252, 
    0,    40,    89,   228,     0,    45,    94,   209,     0,    45,    98,   197,     0,    46,    99,   180,     0,    47,   102,   165,     0,    50,   100,   147,     0,    49,   103,   126, 
    0,    48,   100,   101,     0,    45,   102,    80,     0,    45,   105,    48,     0,    44,   104,    18,     0,    50,    97,     1,     0,    62,    89,     0,     0,    69,    83,     0, 
    0,    73,    78,     0,     0,    73,    79,     0,     0,    40,    62,   253,     0,    40,    71,   231,     0,    43,    76,   215,     0,    45,    78,   204,     0,    46,    81,   190, 
    0,    49,    83,   171,     0,    50,    85,   146,     0,    53,    86,   129,     0,    52,    86,   106,     0,    53,    83,    84,     0,    48,    85,    63,     0,    46,    89,    38, 
    0,    49,    83,     7,     0,    59,    76,     0,     0,    66,    70,     0,     0,    69,    66,     0,     0,    68,    66,     0,     0,    37,    47,   253,     0,    41,    52,   237, 
    0,    43,    55,   224,     0,    45,    59,   209,     0,    46,    62,   196,     0,    47,    66,   174,     0,    53,    68,   146,     0,    54,    69,   131,     0,    54,    70,   106, 
    0,    56,    69,    87,     0,    53,    67,    65,     0,    50,    71,    45,     0,    53,    67,    16,     0,    58,    62,     1,     0,    63,    58,     0,     0,    65,    54,     0, 
    0,    64,    54,     0,     0,    33,    33,   255,     0,    39,    35,   242,     0,    43,    37,   229,     0,    45,    41,   213,     0,    47,    43,   198,     0,    45,    50,   183, 
    0,    48,    52,   162,     0,    50,    53,   141,     0,    52,    54,   118,     0,    55,    54,    94,     0,    55,    52,    74,     0,    51,    54,    51,     0,    53,    52,    23, 
    0,    57,    48,     3,     0,    61,    44,     0,     0,    61,    42,     0,     0,    60,    41,     0,     0,    31,    21,   255,     0,    40,    19,   247,     0,    45,    21,   237, 
    0,    48,    25,   220,     0,    50,    27,   202,     0,    51,    30,   187,     0,    53,    32,   169,     0,    53,    34,   149,     0,    54,    35,   127,     0,    56,    36,   103, 
    0,    57,    35,    80,     0,    55,    35,    62,     0,    54,    35,    45,     0,    58,    32,    10,     0,    60,    30,     1,     0,    60,    29,     0,     0,    58,    28,     0, 
    0,    45,    11,   253,     0,    49,     8,   247,     0,    54,     9,   238,     0,    57,    13,   223,     0,    58,    15,   207,     0,    59,    16,   190,     0,    60,    18,   172, 
    0,    59,    20,   153,     0,    61,    21,   131,     0,    61,    21,   110,     0,    60,    22,    88,     0,    59,    22,    67,     0,    60,    21,    46,     0,    62,    22,    23, 
    0,    62,    21,     4,     0,    58,    22,     0,     0,    54,    23,     0,     0,    61,     5,   250,     0,    62,     1,   241,     0,    64,     1,   231,     0,    65,     4,   216, 
    0,    65,     5,   201,     0,    66,     6,   185,     0,    66,     7,   165,     0,    66,     7,   146,     0,    67,     7,   128,     0,    66,     8,   109,     0,    65,     8,    91, 
    0,    63,     9,    71,     0,    62,    10,    51,     0,    63,     9,    32,     0,    64,    11,    14,     0,    59,    12,     2,     0,    51,    16,     0,     0,    75,     2,   245, 
    0,    75,     0,   231,     0,    74,     0,   219,     0,    72,     0,   202,     0,    71,     0,   186,     0,    70,     0,   168,     0,    68,     1,   148,     0,    67,     1,   128, 
    0,    65,     1,   110,     0,    63,     1,    95,     0,    62,     1,    80,     0,    61,     1,    66,     0,    60,     1,    51,     0,    60,     1,    36,     0,    59,     1,    21, 
    0,    58,     3,     8,     0,    48,     7,     0,     0,    88,     0,   241,     0,    85,     0,   232,     0,    83,     0,   221,     0,    81,     0,   206,     0,    78,     0,   186, 
    0,    75,     0,   164,     0,    71,     0,   141,     0,    66,     0,   119,     0,    61,     0,    96,     0,    55,     0,    78,     0,    51,     0,    65,     0,    48,     0,    53, 
    0,    47,     0,    45,     0,    47,     0,    35,     0,    47,     0,    25,     0,    46,     0,    13,     0,    43,     0,     0,     0,     4,   219,   208,     0,     4,   221,   205, 
    0,     4,   223,   195,     0,     4,   227,   176,     0,     5,   230,   159,     0,     8,   231,   141,     0,    11,   233,   119,     0,    15,   235,    88,     0,    22,   235,    54, 
    0,    29,   234,    28,     0,    34,   232,    11,     0,    39,   228,     3,     0,    44,   224,     0,     0,    48,   221,     0,     0,    67,   210,     0,     0,    82,   200,     0, 
    0,    95,   192,     0,     0,     9,   199,   214,     0,     1,   204,   208,     0,     0,   207,   196,     0,     0,   209,   180,     0,     1,   211,   165,     0,     3,   212,   146, 
    0,     6,   213,   122,     0,     9,   213,    96,     0,    15,   213,    61,     0,    20,   211,    31,     0,    25,   209,    10,     0,    34,   203,     1,     0,    43,   197,     0, 
    0,    52,   191,     0,     0,    67,   184,     0,     0,    81,   180,     0,     0,    89,   182,     0,     0,    10,   183,   221,     0,     2,   190,   218,     0,     1,   196,   199, 
    0,     0,   199,   179,     0,     1,   200,   165,     0,     2,   201,   148,     0,     4,   202,   123,     0,     7,   202,    98,     0,    12,   201,    64,     0,    17,   199,    31, 
    0,    23,   196,     7,     0,    35,   189,     0,     0,    45,   181,     0,     0,    54,   175,     0,     0,    68,   168,     0,     0,    78,   165,     0,     0,    84,   172,     0, 
    0,    15,   167,   229,     0,     7,   171,   229,     0,     4,   180,   210,     0,     3,   183,   194,     0,     3,   184,   176,     0,     5,   186,   159,     0,     5,   190,   129, 
    0,     7,   190,   103,     0,    12,   188,    71,     0,    17,   186,    37,     0,    22,   184,     9,     0,    35,   175,     0,     0,    46,   167,     0,     0,    55,   160,     0, 
    0,    66,   155,     0,     0,    74,   151,     0,     0,    79,   159,     0,     0,    19,   151,   236,     0,    14,   153,   238,     0,    10,   160,   221,     0,     9,   164,   202, 
    0,     8,   167,   176,     0,     8,   171,   158,     0,     9,   175,   133,     0,    10,   175,   110,     0,    13,   172,    79,     0,    18,   171,    47,     0,    22,   171,    17, 
    0,    31,   163,     1,     0,    44,   154,     0,     0,    53,   147,     0,     0,    63,   141,     0,     0,    72,   137,     0,     0,    75,   146,     0,     0,    24,   132,   244, 
    0,    20,   132,   246,     0,    17,   138,   230,     0,    15,   146,   207,     0,    14,   151,   182,     0,    14,   153,   158,     0,    15,   154,   139,     0,    15,   155,   120, 
    0,    17,   155,    86,     0,    20,   155,    55,     0,    23,   156,    25,     0,    27,   151,     3,     0,    41,   143,     0,     0,    51,   135,     0,     0,    61,   127,     0, 
    0,    70,   122,     0,     0,    71,   131,     0,     0,    25,   116,   248,     0,    23,   117,   242,     0,    23,   121,   229,     0,    22,   129,   210,     0,    20,   135,   189, 
    0,    19,   141,   165,     0,    21,   137,   137,     0,    20,   139,   120,     0,    20,   140,    91,     0,    22,   140,    63,     0,    23,   141,    34,     0,    24,   140,     6, 
    0,    37,   132,     0,     0,    48,   123,     0,     0,    59,   112,     0,     0,    67,   106,     0,     0,    67,   115,     0,     0,    25,   102,   247,     0,    24,   106,   231, 
    0,    25,   111,   214,     0,    26,   113,   203,     0,    27,   117,   192,     0,    27,   122,   171,     0,    26,   124,   144,     0,    27,   122,   120,     0,    25,   123,   101, 
    0,    25,   124,    79,     0,    26,   124,    44,     0,    26,   126,    15,     0,    34,   118,     1,     0,    46,   107,     0,     0,    57,    97,     0,     0,    64,    91,     0, 
    0,    63,    95,     0,     0,    26,    85,   250,     0,    26,    92,   226,     0,    28,    97,   204,     0,    29,    99,   195,     0,    30,   101,   182,     0,    32,   102,   167, 
    0,    32,   103,   150,     0,    32,   106,   126,     0,    32,   102,   100,     0,    29,   104,    83,     0,    29,   105,    52,     0,    28,   109,    25,     0,    31,   102,     2, 
    0,    44,    92,     0,     0,    54,    85,     0,     0,    60,    79,     0,     0,    58,    80,     0,     0,    29,    65,   252,     0,    28,    73,   230,     0,    30,    78,   213, 
    0,    32,    82,   201,     0,    32,    85,   187,     0,    33,    86,   165,     0,    35,    87,   147,     0,    37,    87,   131,     0,    36,    88,   106,     0,    36,    87,    85, 
    0,    33,    88,    64,     0,    29,    91,    42,     0,    31,    89,     9,     0,    42,    80,     0,     0,    52,    72,     0,     0,    57,    67,     0,     0,    55,    67,     0, 
    0,    29,    49,   253,     0,    32,    53,   236,     0,    33,    57,   223,     0,    30,    64,   205,     0,    33,    67,   189,     0,    36,    69,   169,     0,    38,    69,   143, 
    0,    38,    72,   130,     0,    39,    71,   106,     0,    40,    72,    87,     0,    40,    69,    65,     0,    35,    72,    47,     0,    35,    73,    20,     0,    39,    68,     2, 
    0,    49,    60,     0,     0,    54,    56,     0,     0,    52,    56,     0,     0,    26,    36,   254,     0,    29,    39,   238,     0,    31,    43,   223,     0,    28,    49,   207, 
    0,    30,    52,   190,     0,    33,    54,   174,     0,    35,    55,   156,     0,    37,    55,   134,     0,    40,    56,   115,     0,    41,    57,    92,     0,    43,    54,    72, 
    0,    38,    55,    52,     0,    37,    58,    31,     0,    35,    56,     9,     0,    46,    48,     1,     0,    50,    44,     0,     0,    47,    44,     0,     0,    24,    24,   255, 
    0,    28,    24,   239,     0,    31,    27,   224,     0,    33,    31,   211,     0,    35,    33,   195,     0,    36,    36,   181,     0,    37,    37,   164,     0,    34,    41,   146, 
    0,    36,    42,   123,     0,    39,    41,    99,     0,    42,    39,    76,     0,    40,    39,    57,     0,    38,    42,    36,     0,    37,    41,    13,     0,    44,    36,     1, 
    0,    46,    33,     0,     0,    44,    33,     0,     0,    21,    14,   255,     0,    28,    12,   244,     0,    33,    13,   234,     0,    36,    15,   220,     0,    37,    18,   205, 
    0,    38,    20,   188,     0,    39,    22,   171,     0,    35,    26,   155,     0,    37,    27,   132,     0,    39,    26,   108,     0,    41,    26,    85,     0,    42,    24,    64, 
    0,    42,    24,    46,     0,    39,    25,    33,     0,    44,    21,     4,     0,    44,    21,     0,     0,    43,    21,     0,     0,    37,     7,   253,     0,    39,     3,   245, 
    0,    41,     3,   237,     0,    42,     5,   224,     0,    43,     7,   209,     0,    44,     8,   194,     0,    45,     9,   174,     0,    45,    11,   154,     0,    46,    11,   133, 
    0,    46,    12,   112,     0,    47,    12,    91,     0,    46,    12,    71,     0,    46,    12,    51,     0,    48,    12,    33,     0,    49,    14,    13,     0,    45,    13,     1, 
    0,    40,    15,     0,     0,    52,     3,   249,     0,    52,     0,   238,     0,    51,     0,   227,     0,    51,     0,   215,     0,    51,     1,   199,     0,    51,     1,   183, 
    0,    50,     1,   163,     0,    50,     1,   141,     0,    50,     1,   121,     0,    49,     1,   101,     0,    49,     1,    84,     0,    49,     1,    69,     0,    48,     2,    53, 
    0,    49,     1,    36,     0,    50,     2,    20,     0,    49,     4,     5,     0,    39,     8,     0,     0,    67,     0,   244,     0,    64,     0,   236,     0,    62,     0,   228, 
    0,    61,     0,   215,     0,    60,     0,   195,     0,    58,     0,   174,     0,    55,     0,   149,     0,    52,     0,   123,     0,    47,     0,    95,     0,    43,     0,    76, 
    0,    41,     0,    64,     0,    39,     0,    53,     0,    38,     0,    45,     0,    38,     0,    36,     0,    38,     0,    26,     0,    38,     0,    14,     0,    35,     0,     0, 
    0,     3,   216,   204,     0,     3,   217,   202,     0,     3,   219,   195,     0,     4,   222,   180,     0,     5,   224,   164,     0,     7,   226,   149,     0,    10,   227,   130, 
    0,    13,   229,   107,     0,    18,   231,    76,     0,    24,   231,    48,     0,    29,   231,    26,     0,    33,   229,    11,     0,    37,   226,     4,     0,    40,   222,     0, 
    0,    44,   220,     0,     0,    61,   209,     0,     0,    76,   200,     0,     0,     6,   199,   209,     0,     1,   201,   203,     0,     0,   203,   194,     0,     0,   206,   178, 
    0,     0,   207,   166,     0,     1,   209,   151,     0,     2,   211,   130,     0,     4,   211,   106,     0,     8,   212,    75,     0,    14,   212,    44,     0,    18,   211,    20, 
    0,    23,   208,     4,     0,    32,   202,     1,     0,    39,   197,     0,     0,    46,   192,     0,     0,    61,   187,     0,     0,    71,   189,     0,     0,     7,   183,   215, 
    0,     1,   188,   209,     0,     0,   192,   194,     0,     0,   195,   175,     0,     0,   197,   162,     0,     0,   198,   148,     0,     0,   199,   130,     0,     1,   200,   105, 
    0,     3,   201,    76,     0,     8,   200,    41,     0,    12,   199,    16,     0,    20,   194,     2,     0,    32,   187,     0,     0,    40,   180,     0,     0,    47,   175,     0, 
    0,    57,   172,     0,     0,    65,   178,     0,     0,    10,   168,   222,     0,     3,   172,   220,     0,     0,   178,   202,     0,     0,   182,   178,     0,     0,   184,   160, 
    0,     0,   186,   148,     0,     0,   187,   131,     0,     0,   188,   109,     0,     1,   188,    83,     0,     5,   187,    50,     0,     9,   186,    20,     0,    16,   181,     2, 
    0,    29,   173,     0,     0,    38,   166,     0,     0,    45,   161,     0,     0,    55,   157,     0,     0,    61,   166,     0,     0,    12,   152,   227,     0,     6,   155,   229, 
    0,     2,   161,   212,     0,     1,   166,   188,     0,     1,   170,   162,     0,     1,   172,   147,     0,     1,   173,   132,     0,     1,   174,   113,     0,     1,   173,    88, 
    0,     4,   172,    58,     0,     7,   171,    27,     0,    12,   168,     4,     0,    26,   159,     0,     0,    36,   153,     0,     0,    43,   147,     0,     0,    54,   143,     0, 
    0,    57,   152,     0,     0,    15,   134,   234,     0,    11,   135,   237,     0,     7,   141,   222,     0,     4,   149,   199,     0,     2,   154,   173,     0,     1,   154,   152, 
    0,     2,   154,   137,     0,     2,   155,   121,     0,     3,   156,    92,     0,     5,   155,    63,     0,     7,   155,    34,     0,    10,   154,     8,     0,    22,   146,     0, 
    0,    33,   139,     0,     0,    42,   133,     0,     0,    52,   127,     0,     0,    54,   137,     0,     0,    17,   117,   241,     0,    15,   116,   242,     0,    12,   121,   230, 
    0,     9,   130,   209,     0,     7,   136,   184,     0,     5,   137,   161,     0,     5,   136,   137,     0,     5,   138,   119,     0,     6,   139,    93,     0,     7,   139,    70, 
    0,     8,   138,    42,     0,    10,   139,    15,     0,    18,   133,     1,     0,    31,   125,     0,     0,    41,   116,     0,     0,    51,   109,     0,     0,    50,   119,     0, 
    0,    16,   104,   241,     0,    14,   105,   231,     0,    13,   109,   218,     0,    13,   112,   206,     0,    12,   116,   191,     0,    10,   121,   170,     0,    10,   126,   145, 
    0,    10,   122,   118,     0,    10,   122,   101,     0,    10,   123,    82,     0,    11,   123,    50,     0,    11,   124,    24,     0,    16,   120,     3,     0,    30,   109,     0, 
    0,    40,   100,     0,     0,    49,    93,     0,     0,    47,    98,     0,     0,    17,    89,   244,     0,    14,    94,   224,     0,    15,    97,   204,     0,    15,    98,   194, 
    0,    15,   100,   183,     0,    17,   102,   170,     0,    16,   104,   150,     0,    16,   106,   126,     0,    16,   104,   101,     0,    14,   106,    84,     0,    14,   106,    57, 
    0,    13,   107,    33,     0,    14,   107,     6,     0,    28,    95,     0,     0,    39,    87,     0,     0,    46,    80,     0,     0,    44,    81,     0,     0,    18,    69,   248, 
    0,    16,    76,   230,     0,    17,    81,   213,     0,    18,    85,   195,     0,    18,    86,   179,     0,    19,    88,   163,     0,    20,    88,   148,     0,    22,    88,   132, 
    0,    21,    89,   105,     0,    20,    90,    85,     0,    18,    90,    67,     0,    15,    92,    46,     0,    16,    94,    15,     0,    25,    83,     1,     0,    37,    75,     0, 
    0,    44,    69,     0,     0,    42,    69,     0,     0,    20,    51,   251,     0,    22,    53,   240,     0,    21,    59,   225,     0,    19,    67,   200,     0,    22,    70,   182, 
    0,    23,    72,   165,     0,    22,    74,   146,     0,    24,    74,   130,     0,    25,    74,   112,     0,    25,    74,    87,     0,    24,    73,    67,     0,    20,    75,    48, 
    0,    18,    78,    23,     0,    21,    73,     3,     0,    34,    64,     0,     0,    42,    58,     0,     0,    39,    58,     0,     0,    19,    38,   252,     0,    20,    41,   235, 
    0,    21,    46,   220,     0,    18,    52,   202,     0,    20,    55,   185,     0,    22,    57,   172,     0,    23,    58,   155,     0,    25,    58,   133,     0,    26,    59,   110, 
    0,    27,    59,    91,     0,    27,    58,    72,     0,    27,    57,    51,     0,    22,    60,    33,     0,    20,    62,    13,     0,    32,    52,     1,     0,    39,    47,     0, 
    0,    36,    47,     0,     0,    17,    27,   253,     0,    19,    29,   235,     0,    20,    33,   219,     0,    21,    36,   204,     0,    22,    38,   191,     0,    23,    41,   177, 
    0,    24,    43,   162,     0,    22,    45,   139,     0,    27,    44,   112,     0,    28,    43,    92,     0,    29,    44,    74,     0,    29,    42,    54,     0,    27,    43,    38, 
    0,    24,    46,    19,     0,    30,    40,     2,     0,    34,    36,     0,     0,    31,    36,     0,     0,    16,    16,   255,     0,    18,    18,   233,     0,    20,    21,   218, 
    0,    22,    23,   204,     0,    23,    25,   192,     0,    24,    26,   178,     0,    24,    28,   163,     0,    20,    31,   146,     0,    23,    31,   124,     0,    24,    31,   101, 
    0,    26,    30,    80,     0,    28,    28,    59,     0,    29,    28,    42,     0,    25,    32,    25,     0,    28,    29,     4,     0,    31,    25,     0,     0,    29,    25,     0, 
    0,    14,     9,   255,     0,    19,     7,   242,     0,    21,     7,   231,     0,    23,     8,   220,     0,    24,    11,   206,     0,    25,    12,   190,     0,    26,    13,   170, 
    0,    26,    14,   152,     0,    28,    14,   133,     0,    28,    15,   112,     0,    29,    15,    90,     0,    30,    14,    68,     0,    30,    15,    48,     0,    30,    16,    33, 
    0,    27,    17,    22,     0,    31,    14,     0,     0,    29,    13,     0,     0,    29,     3,   253,     0,    30,     1,   244,     0,    29,     0,   235,     0,    28,     1,   225, 
    0,    28,     2,   211,     0,    29,     2,   195,     0,    30,     2,   176,     0,    30,     3,   153,     0,    31,     3,   132,     0,    31,     4,   110,     0,    32,     4,    91, 
    0,    33,     3,    72,     0,    33,     4,    54,     0,    33,     4,    37,     0,    38,     3,    20,     0,    36,     4,     0,     0,    29,     8,     0,     0,    45,     0,   248, 
    0,    42,     0,   241,     0,    40,     0,   234,     0,    39,     0,   224,     0,    38,     0,   206,     0,    37,     0,   185,     0,    36,     0,   161,     0,    35,     0,   134, 
    0,    32,     0,   101,     0,    30,     0,    81,     0,    29,     0,    66,     0,    28,     0,    55,     0,    28,     0,    46,     0,    28,     0,    37,     0,    28,     0,    28, 
    0,    29,     0,    15,     0,    27,     0,     0,     0,     1,   213,   201,     0,     2,   214,   199,     0,     2,   215,   193,     0,     4,   217,   181,     0,     5,   219,   168, 
    0,     7,   220,   155,     0,     9,   222,   139,     0,    12,   223,   120,     0,    16,   225,    96,     0,    21,   227,    70,     0,    25,   228,    46,     0,    29,   228,    26, 
    0,    32,   226,    13,     0,    35,   224,     6,     0,    37,   222,     2,     0,    39,   220,     0,     0,    56,   209,     0,     0,     3,   198,   205,     0,     0,   200,   199, 
    0,     0,   201,   190,     0,     0,   203,   177,     0,     0,   205,   167,     0,     1,   207,   154,     0,     1,   208,   137,     0,     2,   210,   115,     0,     5,   211,    90, 
    0,    10,   211,    62,     0,    14,   211,    37,     0,    19,   210,    18,     0,    23,   208,     6,     0,    30,   203,     3,     0,    35,   199,     1,     0,    40,   196,     1, 
    0,    48,   197,     0,     0,     3,   183,   209,     0,     0,   186,   203,     0,     0,   189,   186,     0,     0,   192,   171,     0,     0,   194,   159,     0,     0,   195,   148, 
    0,     0,   196,   134,     0,     0,   197,   114,     0,     0,   199,    89,     0,     2,   200,    58,     0,     4,   201,    29,     0,     8,   200,     9,     0,    16,   194,     3, 
    0,    25,   188,     1,     0,    31,   184,     1,     0,    36,   181,     0,     0,    43,   187,     0,     0,     5,   168,   215,     0,     1,   172,   210,     0,     0,   176,   193, 
    0,     0,   179,   169,     0,     0,   181,   152,     0,     0,   183,   143,     0,     0,   183,   131,     0,     0,   184,   116,     0,     0,   185,    93,     0,     0,   186,    65, 
    0,     1,   186,    33,     0,     3,   186,    10,     0,    11,   181,     2,     0,    21,   174,     0,     0,    28,   168,     0,     0,    34,   166,     0,     0,    38,   174,     0, 
    0,     6,   153,   220,     0,     2,   156,   219,     0,     0,   161,   201,     0,     0,   165,   177,     0,     0,   167,   152,     0,     0,   168,   138,     0,     0,   169,   128, 
    0,     0,   169,   115,     0,     0,   169,    95,     0,     0,   169,    71,     0,     1,   170,    41,     0,     2,   170,    14,     0,    10,   165,     2,     0,    20,   158,     0, 
    0,    28,   153,     0,     0,    33,   150,     0,     0,    35,   160,     0,     0,     7,   135,   226,     0,     4,   138,   226,     0,     1,   144,   211,     0,     0,   149,   188, 
    0,     0,   152,   162,     0,     0,   151,   142,     0,     0,   150,   130,     0,     0,   151,   119,     0,     0,   152,    95,     0,     0,   152,    73,     0,     1,   152,    48, 
    0,     1,   152,    20,     0,     8,   149,     3,     0,    19,   142,     0,     0,    27,   137,     0,     0,    32,   134,     0,     0,    33,   143,     0,     0,     9,   117,   233, 
    0,     7,   118,   234,     0,     4,   124,   223,     0,     1,   131,   202,     0,     1,   136,   175,     0,     0,   136,   152,     0,     0,   134,   128,     0,     0,   135,   113, 
    0,     0,   136,    93,     0,     1,   135,    76,     0,     1,   135,    53,     0,     1,   136,    27,     0,     5,   135,     5,     0,    17,   127,     0,     0,    27,   120,     0, 
    0,    32,   115,     0,     0,    31,   124,     0,     0,     8,   104,   234,     0,     6,   106,   229,     0,     4,   109,   219,     0,     3,   113,   207,     0,     2,   117,   188, 
    0,     1,   120,   164,     0,     1,   123,   138,     0,     1,   120,   113,     0,     1,   120,    99,     0,     1,   120,    84,     0,     1,   120,    57,     0,     1,   120,    33, 
    0,     3,   120,     9,     0,    15,   111,     2,     0,    26,   102,     0,     0,    32,    96,     0,     0,    29,   102,     0,     0,     8,    91,   237,     0,     5,    95,   224, 
    0,     4,    97,   211,     0,     4,    99,   200,     0,     3,   101,   188,     0,     3,   103,   172,     0,     2,   106,   149,     0,     0,   109,   127,     0,     1,   104,   100, 
    0,     2,   105,    83,     0,     1,   106,    58,     0,     1,   105,    38,     0,     2,   105,    15,     0,    13,    98,     3,     0,    24,    89,     0,     0,    31,    82,     0, 
    0,    27,    84,     0,     0,     9,    74,   241,     0,     6,    79,   230,     0,     5,    84,   215,     0,     5,    86,   199,     0,     5,    88,   184,     0,     5,    90,   170, 
    0,     6,    90,   155,     0,     6,    91,   134,     0,     6,    91,   106,     0,     5,    91,    83,     0,     4,    91,    67,     0,     2,    92,    49,     0,     2,    92,    22, 
    0,     9,    88,     4,     0,    22,    78,     0,     0,    29,    71,     0,     0,    26,    72,     0,     0,    10,    54,   246,     0,    11,    56,   239,     0,    10,    61,   227, 
    0,     7,    70,   204,     0,     7,    74,   185,     0,     7,    76,   167,     0,     9,    75,   143,     0,    10,    76,   131,     0,    12,    75,   112,     0,    11,    77,    87, 
    0,    11,    75,    68,     0,     7,    78,    50,     0,     4,    79,    26,     0,     5,    79,     6,     0,    19,    68,     1,     0,    27,    61,     0,     0,    25,    61,     0, 
    0,    10,    39,   249,     0,    12,    41,   238,     0,    12,    46,   224,     0,     9,    54,   205,     0,     9,    57,   188,     0,     9,    60,   173,     0,    11,    61,   154, 
    0,    11,    63,   133,     0,    13,    62,   110,     0,    14,    61,    93,     0,    13,    61,    71,     0,    11,    62,    51,     0,     8,    63,    34,     0,     5,    65,    17, 
    0,    17,    58,     3,     0,    26,    50,     0,     0,    23,    49,     0,     0,     9,    29,   249,     0,    10,    34,   229,     0,    10,    38,   214,     0,    10,    40,   202, 
    0,    11,    41,   190,     0,    12,    43,   176,     0,    13,    45,   162,     0,    12,    47,   137,     0,    15,    46,   111,     0,    15,    47,    92,     0,    16,    47,    75, 
    0,    16,    46,    54,     0,    16,    45,    35,     0,    11,    49,    21,     0,    15,    46,     4,     0,    21,    40,     0,     0,    20,    39,     0,     0,     8,    18,   253, 
    0,    10,    24,   226,     0,    10,    28,   210,     0,    10,    29,   199,     0,    10,    30,   187,     0,    11,    31,   174,     0,    11,    32,   161,     0,     8,    35,   139, 
    0,    11,    34,   115,     0,    13,    34,    95,     0,    16,    32,    76,     0,    16,    32,    59,     0,    17,    32,    40,     0,    12,    35,    24,     0,    11,    37,     8, 
    0,    15,    32,     2,     0,    16,    29,     0,     0,     8,    10,   255,     0,    10,    16,   224,     0,    10,    18,   208,     0,    10,    18,   197,     0,    11,    19,   186, 
    0,    11,    19,   173,     0,    12,    19,   160,     0,    12,    19,   143,     0,    13,    20,   122,     0,    10,    22,   103,     0,    12,    21,    82,     0,    14,    20,    63, 
    0,    15,    20,    43,     0,    15,    20,    27,     0,    11,    23,     9,     0,    16,    21,     0,     0,    14,    19,     0,     0,     7,     4,   255,     0,    11,     4,   242, 
    0,    11,     4,   231,     0,    11,     4,   219,     0,    11,     5,   204,     0,    11,     5,   188,     0,    12,     5,   172,     0,    13,     6,   149,     0,    13,     7,   129, 
    0,    10,    10,   109,     0,    11,     9,    89,     0,    14,     8,    71,     0,    15,     8,    51,     0,    15,     8,    35,     0,    18,     6,    22,     0,    13,     8,    11, 
    0,    14,     7,     0,     0,    22,     0,   251,     0,    20,     0,   247,     0,    18,     0,   241,     0,    16,     0,   232,     0,    15,     0,   217,     0,    14,     0,   198, 
    0,    14,     0,   179,     0,    14,     0,   155,     0,    15,     0,   119,     0,    15,     0,    97,     0,    15,     0,    78,     0,    15,     0,    61,     0,    16,     0,    49, 
    0,    15,     0,    37,     0,    15,     0,    26,     0,    14,     0,    14,     0,    13,     0,     0,     0,     0,   211,   197,     0,     0,   210,   195,     0,     2,   211,   190, 
    0,     3,   212,   180,     0,     5,   213,   170,     0,     7,   214,   159,     0,     9,   215,   146,     0,    12,   217,   131,     0,    15,   218,   113,     0,    19,   221,    92, 
    0,    23,   222,    69,     0,    27,   223,    48,     0,    30,   223,    31,     0,    32,   222,    18,     0,    33,   221,     9,     0,    33,   221,     4,     0,    33,   220,     0, 
    0,     0,   196,   201,     0,     0,   202,   186,     0,     0,   203,   180,     0,     0,   204,   171,     0,     0,   206,   161,     0,     0,   207,   151,     0,     2,   209,   141, 
    0,     4,   209,   126,     0,     7,   210,   109,     0,    11,   211,    87,     0,    16,   211,    65,     0,    20,   211,    48,     0,    24,   211,    34,     0,    26,   210,    23, 
    0,    27,   208,    14,     0,    26,   207,     7,     0,    22,   205,     0,     0,     0,   182,   205,     0,     0,   188,   192,     0,     0,   194,   173,     0,     0,   195,   164, 
    0,     0,   197,   153,     0,     0,   198,   145,     0,     0,   199,   135,     0,     0,   199,   121,     0,     0,   200,   103,     0,     2,   203,    80,     0,     6,   203,    56, 
    0,    10,   203,    39,     0,    14,   202,    25,     0,    16,   201,    14,     0,    17,   199,     7,     0,    17,   198,     2,     0,    16,   195,     0,     0,     0,   169,   208, 
    0,     0,   174,   199,     0,     0,   179,   182,     0,     0,   183,   159,     0,     0,   185,   146,     0,     0,   186,   137,     0,     0,   187,   129,     0,     0,   187,   118, 
    0,     0,   188,   102,     0,     0,   190,    80,     0,     0,   191,    54,     0,     2,   192,    32,     0,     4,   192,    17,     0,     6,   191,     6,     0,     9,   188,     1, 
    0,    11,   185,     0,     0,    11,   184,     0,     0,     0,   154,   212,     0,     0,   159,   204,     0,     0,   164,   189,     0,     0,   168,   168,     0,     0,   171,   142, 
    0,     0,   172,   131,     0,     0,   172,   122,     0,     0,   173,   113,     0,     0,   173,   101,     0,     0,   173,    85,     0,     0,   174,    64,     0,     0,   176,    38, 
    0,     0,   176,    16,     0,     1,   175,     3,     0,     6,   171,     0,     0,     9,   169,     0,     0,     9,   167,     0,     0,     0,   137,   217,     0,     0,   142,   210, 
    0,     0,   148,   197,     0,     0,   152,   177,     0,     0,   154,   152,     0,     0,   155,   123,     0,     0,   155,   114,     0,     0,   155,   107,     0,     0,   155,    98, 
    0,     0,   155,    86,     0,     0,   155,    68,     0,     0,   156,    45,     0,     0,   157,    20,     0,     0,   156,     3,     0,     6,   152,     0,     0,     8,   150,     0, 
    0,     8,   149,     0,     0,     0,   120,   222,     0,     0,   124,   218,     0,     0,   130,   206,     0,     0,   135,   188,     0,     0,   138,   164,     0,     0,   139,   136, 
    0,     0,   137,   107,     0,     0,   137,   100,     0,     0,   136,    93,     0,     0,   136,    83,     0,     0,   135,    69,     0,     0,   136,    50,     0,     0,   136,    27, 
    0,     0,   136,     6,     0,     4,   133,     0,     0,     8,   131,     0,     0,     7,   129,     0,     0,     0,   105,   226,     0,     0,   108,   220,     0,     0,   113,   211, 
    0,     0,   117,   199,     0,     0,   121,   177,     0,     0,   124,   151,     0,     0,   122,   121,     0,     0,   119,    94,     0,     0,   119,    89,     0,     0,   118,    81, 
    0,     0,   117,    67,     0,     0,   117,    50,     0,     0,   116,    31,     0,     0,   116,    12,     0,     4,   114,     2,     0,     7,   110,     0,     0,     7,   108,     0, 
    0,     0,    92,   229,     0,     0,    96,   219,     0,     0,    99,   210,     0,     0,   101,   200,     0,     0,   104,   185,     0,     0,   108,   164,     0,     0,   108,   137, 
    0,     0,   105,   108,     0,     0,   101,    79,     0,     0,   101,    75,     0,     0,   100,    64,     0,     0,    99,    50,     0,     0,    98,    34,     0,     0,    97,    17, 
    0,     2,    96,     4,     0,     6,    91,     0,     0,     7,    90,     0,     0,     0,    78,   233,     0,     0,    82,   225,     0,     0,    85,   214,     0,     0,    88,   201, 
    0,     0,    90,   186,     0,     0,    93,   168,     0,     0,    93,   146,     0,     0,    92,   124,     0,     0,    89,    88,     0,     0,    89,    69,     0,     0,    88,    63, 
    0,     0,    88,    53,     0,     0,    87,    36,     0,     0,    86,    21,     0,     0,    84,     6,     0,     4,    80,     0,     0,     8,    76,     0,     0,     0,    59,   239, 
    0,     0,    60,   235,     0,     0,    66,   225,     0,     0,    73,   207,     0,     0,    77,   188,     0,     0,    79,   166,     0,     0,    72,   134,     0,     0,    73,   120, 
    0,     0,    75,    98,     0,     0,    75,    73,     0,     0,    77,    59,     0,     0,    76,    52,     0,     0,    76,    37,     0,     0,    75,    24,     0,     0,    73,     9, 
    0,     4,    70,     1,     0,     8,    65,     0,     0,     0,    41,   244,     0,     0,    43,   234,     0,     0,    48,   222,     0,     0,    54,   207,     0,     0,    60,   191, 
    0,     0,    65,   169,     0,     0,    64,   145,     0,     0,    63,   124,     0,     0,    60,    95,     0,     0,    59,    80,     0,     0,    62,    61,     0,     0,    64,    48, 
    0,     0,    63,    39,     0,     0,    62,    28,     0,     0,    61,    11,     0,     2,    60,     1,     0,     8,    54,     0,     0,     0,    28,   247,     0,     0,    33,   232, 
    0,     0,    37,   220,     0,     0,    40,   205,     0,     0,    43,   189,     0,     0,    46,   172,     0,     0,    49,   155,     0,     0,    50,   130,     0,     0,    48,    95, 
    0,     0,    46,    78,     0,     0,    46,    67,     0,     0,    46,    46,     0,     0,    49,    35,     0,     0,    50,    27,     0,     0,    49,    14,     0,     1,    48,     3, 
    0,     6,    43,     0,     0,     0,    19,   250,     0,     0,    31,   215,     0,     0,    34,   203,     0,     0,    35,   193,     0,     0,    35,   181,     0,     0,    35,   171, 
    0,     0,    35,   157,     0,     0,    37,   134,     0,     0,    36,   104,     0,     0,    34,    82,     0,     0,    34,    64,     0,     0,    33,    52,     0,     0,    33,    35, 
    0,     0,    37,    27,     0,     0,    37,    18,     0,     0,    36,     9,     0,     3,    33,     0,     0,     0,    11,   252,     0,     0,    23,   210,     0,     0,    26,   197, 
    0,     0,    26,   188,     0,     0,    26,   178,     0,     0,    25,   167,     0,     0,    24,   155,     0,     0,    25,   137,     0,     0,    24,   111,     0,     0,    25,    85, 
    0,     0,    24,    67,     0,     0,    22,    52,     0,     0,    22,    38,     0,     0,    22,    27,     0,     0,    25,    18,     0,     0,    25,    11,     0,     0,    24,     0, 
    0,     0,     4,   255,     0,     0,    16,   210,     0,     0,    19,   194,     0,     0,    18,   182,     0,     0,    17,   170,     0,     0,    15,   160,     0,     0,    14,   148, 
    0,     0,    13,   131,     0,     0,    13,   104,     0,     0,    14,    81,     0,     0,    14,    67,     0,     0,    13,    56,     0,     0,    13,    43,     0,     0,    13,    30, 
    0,     0,    12,    17,     0,     0,    13,     9,     0,     0,    12,     0,     0,     0,     0,   255,     0,     0,     0,   255,     0,     0,     0,   251,     0,     0,     0,   236, 
    0,     0,     0,   215,     0,     0,     0,   196,     0,     0,     0,   177,     0,     0,     0,   150,     0,     0,     0,   118,     0,     0,     0,    96,     0,     0,     0,    82, 
    0,     0,     0,    67,     0,     0,     0,    51,     0,     0,     0,    35,     0,     0,     0,    19,     0,     0,     0,    10,     0,     0,     0,     0
};

APDK_END_NAMESPACE

#endif

