#!/usr/bin/python2

import sys
import getopt
import os

def ldconfig(topDir):
    def getDSOList(list, dirname, names):
	for name in names:
	    if name.find(".so") > -1:
		fullname = os.path.join(dirname, name)
		if os.path.islink(fullname):
		    continue
		list.append(fullname)

	return list

    soList = []
    os.path.walk(topDir, getDSOList, soList)
    
    for so in soList:
	    od = os.popen("/usr/bin/readelf -d %s 2>/dev/null" % so).readlines()
	    for line in od:
		if not line.find("SONAME") > -1:
		    continue

		linkName = "%s/%s" % (os.path.dirname(so), 
				      line.split()[-1][1:-1])

		if so == linkName:
		    continue

		#print "%s ==> %s" % (linkName, os.path.basename(so))
		try:
		    os.symlink(os.path.basename(so), linkName)
		except OSError, msg:
		    pass

try:
    opt, arg = getopt.getopt(sys.argv[1:], 'r:', ['root='])
except:
    usage()

rootDir = None

for o, a in opt:
    if o in ('-r', '--root'):
	rootDir = os.path.abspath(a)

if rootDir is None:
    rootDir = arg[0]

if rootDir is None:
    print >> sys.stderr, "%s: no such file or directory" % rootDir
    usage()

if not os.access(rootDir, os.W_OK):
    print >> sys.stderr, "%s: permission denied" % rootDir
    usage()

ldconfig(rootDir)

