#############################################################
#
# tcpdump
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
TCPDUMP_SOURCE:=tcpdump.tar.gz
TCPDUMP_SITE:=ftp://ftp.gnu.org/gnu/tcpdump
TCPDUMP_CAT:=zcat
endif

TCPDUMP_DIR:=$(BUILD_DIR)/tcpdump
TCPDUMP_BINARY:=tcpdump
TCPDUMP_TARGET_BINARY:=usr/sbin/tcpdump

ifneq ($(USE_CVS),true)
tcpdump-fetch:
	 $(WGET) -P $(DL_DIR) $(TCPDUMP_SITE)/$(TCPDUMP_SOURCE)

tcpdump-source: $(DL_DIR)/$(TCPDUMP_SOURCE)
else
tcpdump-source:
endif

TCPDUMP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d tcpdump $(CVS_TAG) $(CVS_PREFIX)tcpdump

tcpdump-checkout:
	@$(TCPDUMP_CVSCO)

$(TCPDUMP_DIR)/.unpacked: $(DL_DIR)/$(TCPDUMP_SOURCE)
ifneq ($(USE_CVS),true)
	$(TCPDUMP_CAT) $(DL_DIR)/$(TCPDUMP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(TCPDUMP_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(TCPDUMP_DIR)/
	touch $(TCPDUMP_DIR)/.unpacked

$(TCPDUMP_DIR)/.configured: $(TCPDUMP_DIR)/.unpacked
	(cd $(TCPDUMP_DIR); rm -rf config.cache; \
		ac_cv_linux_vers=2 \
		ac_cv_search_getaddrinfo="none required" \
		td_cv_buggygetaddrinfo=no \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--with-crypto \
		--enable-ipv6 \
	);
	touch  $(TCPDUMP_DIR)/.configured

$(TCPDUMP_DIR)/$(TCPDUMP_BINARY): $(TCPDUMP_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(TCPDUMP_DIR)

$(TARGET_DIR)/$(TCPDUMP_TARGET_BINARY): $(TCPDUMP_DIR)/$(TCPDUMP_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(TCPDUMP_DIR) install
	$(STRIP) $(TARGET_DIR)/$(TCPDUMP_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/tcpdump
	install -m0644 $(TCPDUMP_DIR)/LICENSE $(DOC_DIR)/doc/tcpdump/LICENSE

tcpdump: uclibc libpcap $(TARGET_DIR)/$(TCPDUMP_TARGET_BINARY)

tcpdump-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(TCPDUMP_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/tcpdump
	-$(MAKE) -C $(TCPDUMP_DIR) clean

tcpdump-dirclean:
	rm -rf $(TCPDUMP_DIR)
endif

