#############################################################
#
# strace
#
#############################################################
ifneq ($(USE_CVS),true)
STRACE_SOURCE:=strace.tar.gz
STRACE_CAT:=zcat
endif

STRACE_DIR:=$(BUILD_DIR)/strace

ifneq ($(USE_CVS),true)
strace-fetch:
	 $(WGET) -P $(DL_DIR) $(STRACE_SITE)/$(STRACE_SOURCE)

strace-source: $(DL_DIR)/$(STRACE_SOURCE)
else
strace-source:
endif

STRACE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d strace $(CVS_PREFIX)strace

strace-checkout:
	@$(STRACE_CVSCO)

$(STRACE_DIR)/.unpacked: $(DL_DIR)/$(STRACE_SOURCE)
ifneq ($(USE_CVS),true)
	$(STRACE_CAT) $(DL_DIR)/$(STRACE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(STRACE_CVSCO)
endif
	touch $(STRACE_DIR)/.unpacked

$(STRACE_DIR)/.configured: $(STRACE_DIR)/.unpacked
	(cd $(STRACE_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(STRACE_DIR)/.configured

$(STRACE_DIR)/strace: $(STRACE_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(STRACE_DIR)

$(TARGET_DIR)/usr/bin/strace: $(STRACE_DIR)/strace
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(STRACE_DIR) install
	$(STRIP) $(TARGET_DIR)/usr/bin/strace > /dev/null 2>&1
	# we won't have perl so this is useless
	-rm -f $(TARGET_DIR)/usr/bin/strace-graph
	install -d $(DOC_DIR)/doc/strace
	for f in COPYING COPYRIGHT ; do \
	    install -m 0644 $(STRACE_DIR)/$$f $(DOC_DIR)/doc/strace/$$f ; \
	done

strace: uclibc $(TARGET_DIR)/usr/bin/strace 

strace-clean: 
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(STRACE_DIR) uninstall
	$(MAKE) -C $(STRACE_DIR) clean
	-rm -rf $(DOC_DIR)/doc/strace

strace-dirclean: 
	rm -rf $(STRACE_DIR) 


