#############################################################
#
# iptables
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
IPTABLES_SOURCE:=iptables.tar.gz
IPTABLES_CAT:=zcat
endif

IPTABLES_DIR:=$(BUILD_DIR)/iptables
IPTABLES_BINARY:=iptables
IPTABLES_TARGET_BINARY:=sbin/iptables

ifneq ($(USE_CVS),true)
iptables-fetch:
	 $(WGET) -P $(DL_DIR) $(IPTABLES_SITE)/$(IPTABLES_SOURCE)

iptables-source: $(DL_DIR)/$(IPTABLES_SOURCE)
else
iptables-source:
endif

IPTABLES_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d iptables $(CVS_TAG) $(CVS_PREFIX)iptables

iptables-checkout: 
	@$(IPTABLES_CVSCO)

$(IPTABLES_DIR)/.unpacked: $(DL_DIR)/$(IPTABLES_SOURCE)
ifneq ($(USE_CVS),true)
	$(IPTABLES_CAT) $(DL_DIR)/$(IPTABLES_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(IPTABLES_CVSCO)
endif
	touch $(IPTABLES_DIR)/.unpacked

$(IPTABLES_DIR)/$(IPTABLES_BINARY): $(IPTABLES_DIR)/.unpacked
	$(MAKE) KERNEL_DIR=$(STAGING_DIR)/usr PREFIX= $(TARGET_CONFIGURE_OPTS) -C $(IPTABLES_DIR)

$(TARGET_DIR)/$(IPTABLES_TARGET_BINARY): $(IPTABLES_DIR)/$(IPTABLES_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) PREFIX= -C $(IPTABLES_DIR) install
	$(STRIP) $(TARGET_DIR)/sbin/{iptables,ip6tables}* \
		$(TARGET_DIR)/lib/iptables/*.so
	install -m0755 $(IPTABLES_DIR)/iptables.init $(TARGET_DIR)/etc/rc.d/init.d/iptables
	install -d $(DOC_DIR)/doc/iptables
	@for f in INCOMPATIBILITIES COPYING ; do \
		install -m0644 $(IPTABLES_DIR)/$$f $(DOC_DIR)/doc/iptables/$$f ;\
	done

iptables: modutils initscripts uclibc $(TARGET_DIR)/$(IPTABLES_TARGET_BINARY)

iptables-clean:
	-rm -f $(TARGET_DIR)/sbin/iptables* \
		$(TARGET_DIR)/sbin/ip6tables* \
		$(TARGET_DIR)/etc/rc.d/init.d/iptables
	-rm -rf	$(TARGET_DIR)/lib/iptables
	-rm -rf $(DOC_DIR)/doc/iptables
	-$(MAKE) -C $(IPTABLES_DIR) clean

iptables-dirclean:
	rm -rf $(IPTABLES_DIR)
endif

