#############################################################
#
# autofs
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
AUTOFS_SOURCE:=autofs.tar.gz
AUTOFS_SITE:=http://ftp.wayne.edu/pub/linux/daemons/autofs/v3
AUTOFS_CAT:=zcat
endif

AUTOFS_DIR:=$(BUILD_DIR)/autofs
AUTOFS_BINARY:=daemon/automount
AUTOFS_TARGET_BINARY:=usr/sbin/automount

ifneq ($(USE_CVS),true)
autofs-source: $(DL_DIR)/$(AUTOFS_SOURCE)
else
autofs-source:
endif

AUTOFS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d autofs $(CVS_TAG) $(CVS_PREFIX)autofs

autofs-checkout:
	@$(AUTOFS_CVSCO)

$(AUTOFS_DIR)/.unpacked: $(DL_DIR)/$(AUTOFS_SOURCE)
ifneq ($(USE_CVS),true)
	$(AUTOFS_CAT) $(DL_DIR)/$(AUTOFS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(AUTOFS_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(AUTOFS_DIR)/
	sed -i.orig -e 's,<limits\.h>,<linux/limits.h>,g;' $(AUTOFS_DIR)/modules/lookup_program.c
	touch $(AUTOFS_DIR)/.unpacked

$(AUTOFS_DIR)/.configured: $(AUTOFS_DIR)/.unpacked
	(cd $(AUTOFS_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(AUTOFS_DIR)/.configured

$(AUTOFS_DIR)/$(AUTOFS_BINARY): $(AUTOFS_DIR)/.configured
	$(MAKE) STRIP=$(TARGET_CROSS)strip $(TARGET_CONFIGURE_OPTS) -C $(AUTOFS_DIR)

$(TARGET_DIR)/$(AUTOFS_TARGET_BINARY): $(AUTOFS_DIR)/$(AUTOFS_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(AUTOFS_DIR) install install_samples
	install -d $(DOC_DIR)/doc/autofs
	install -d $(DOC_DIR)/doc/autofs/samples
	@for f in COPYING COPYRIGHT ; do \
		install -m0644 $(AUTOFS_DIR)/$$f $(DOC_DIR)/doc/autofs/$$f ;\
	done
	@for f in auto.master auto.misc rc.autofs ; do \
		install -m0644 $(AUTOFS_DIR)/samples/$$f $(DOC_DIR)/doc/autofs/samples/$$f ; \
	done

autofs: uclibc $(TARGET_DIR)/$(AUTOFS_TARGET_BINARY)

autofs-clean:
	-rm -f $(TARGET_DIR)/$(AUTOFS_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/man/man5/autofs.5
	-rm -f $(TARGET_DIR)/usr/man/man5/auto.master.5
	-rm -f $(TARGET_DIR)/usr/man/man8/autofs.8
	-rm -f $(TARGET_DIR)/usr/man/man8/automount.8
	-rm -rf $(TARGET_DIR)/usr/lib/autofs
	-rm -rf $(DOC_DIR)/doc/autofs
	-$(MAKE) -C $(AUTOFS_DIR) clean

autofs-dirclean:
	rm -rf $(AUTOFS_DIR)

autofs-fetch:
	 $(WGET) -P $(DL_DIR) $(AUTOFS_SITE)/$(AUTOFS_SOURCE)


endif

