#ifndef _ASM_IRQ_H_
#define _ASM_IRQ_H_

#include <linux/config.h>

/*
 * the system has an on-CPU PIC and another PIC on the FPGA
 */
extern struct hw_interrupt_type fr403_irq_type;
#define CPU_IRQS	19

extern struct hw_interrupt_type fpga_irq_type;
#define FPGA_IRQS	15

#ifdef CONFIG_FUJITSU_MB93493
extern struct hw_interrupt_type mb93493_irq_type;
#define MB93493_IRQS	16
#define NR_IRQS		(CPU_IRQS + FPGA_IRQS + MB93493_IRQS)
#else
#define NR_IRQS		(CPU_IRQS + FPGA_IRQS)
#endif

/* probe returns a 32-bit IRQ mask:-/ */
#define MIN_PROBE_IRQ	(NR_IRQS - 32)

static __inline__ int irq_cannonicalize(int irq)
{
	return irq;
}

extern void disable_irq_nosync(unsigned int irq);
extern void disable_irq(unsigned int irq);
extern void enable_irq(unsigned int irq);


#endif /* _ASM_IRQ_H_ */
