Summary: Header files for the Linux kernel for use by glibc
Name: glibc-kernheaders
Version: 2.4
Release: 8.36.frv.040820.3
License: GPL
Group: Development/System
ExclusiveOS: Linux
Obsoletes: kernel-headers
Provides: kernel-headers = 2.4.2
Prereq: fileutils initscripts >= 5.83
%undefine _enable_debug_packages

BuildRoot: %{_tmppath}/glibc-kernheaders-root

%ifarch i386 i586 i686 athlon
%define _arch i386
%endif

Source0: glibc-kernheaders.tar.bz2


%description 
Kernel-headers includes the C header files that specify the interface
between the Linux kernel and userspace libraries and programs.  The
header files define structures and constants that are needed for
building most standard programs and are also needed for rebuilding the
glibc package



%prep
%setup -q -c

%build

%install
mkdir -p $RPM_BUILD_ROOT
tar -cf -  usr | tar -xf - -C $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/include/asm
pushd $RPM_BUILD_ROOT/usr/include
d1=asm-%{_arch}
d2=asm
%ifarch x86_64
p1='defined __x86_64__'
d2=asm-i386
p2='defined __i386__'
%endif
%ifarch sparc sparc64
d1=asm-sparc
p1='defined __sparc__ && !defined __arch64__'
d2=asm-sparc64
p2='defined __sparc__ && defined __arch64__'
%endif
%ifarch ppc ppc64
d1=asm-ppc
p1='defined __powerpc__ && !defined __powerpc64__'
d2=asm-ppc64
p2='defined __powerpc64__'
%endif
%ifarch s390 s390x
d1=asm-s390
p1='defined __s390__ && !defined __s390x__'
d2=asm-s390x
p2='defined __s390x__'
%endif
for i in asm-*; do
  case $i in $d1|$d2) ;; *) rm -rf $i;; esac
done
if [ "$d2" = "asm" ]; then
  rm -rf asm
  mv $d1 asm
else
  for f in `find $d1 $d2 -name \*.h -exec basename {} \; | sort -u`; do
    F=`echo $f | tr a-z. A-Z_`
    ( cat <<EOF
#ifndef __ASM_STUB_${F}__
# define __ASM_STUB_${F}__
EOF
      echo "# if $p1"
      if [ -f $d1/$f ]; then
	echo "#  include <$d1/$f>"
      else
	echo "#  error <$d1/$f> does not exist"
      fi
      echo "# endif"
      echo "# if $p2"
      if [ -f $d2/$f ]; then
	echo "#  include <$d2/$f>"
      else
	echo "#  error <$d2/$f> does not exist"
      fi
      echo "# endif"
      echo "#endif"
    ) > asm/$f
  done
fi
popd

%clean
rm -rf $RPM_BUILD_ROOT


%pre 
[ -L /usr/include/linux ] && rm -f /usr/include/linux || :
[ -L /usr/include/asm ] && rm -f /usr/include/asm || :
%ifarch sparc
[ -L /usr/include/asm-sparc ] && rm -f /usr/include/asm-sparc
[ -L /usr/include/asm-sparc64 ] && rm -f /usr/include/asm-sparc64
%endif
exit 0

%post
exit 0

###
### file lists
###

%files
%defattr(-,root,root)
/usr/include/linux
/usr/include/asm*


%changelog
* Wed Oct 22 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.35
- fix broken shift_hz
* Wed Sep 24 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.34
- fix ppc64 sigcontext.h (#104915)

* Mon Sep  8 2003 Bill Nottingham <notting@redhat.com>
- oops, bring arp_tables.h back

* Wed Sep  3 2003 Bill Nottingham <notting@redhat.com>
- remove some exports of __constant_hton*

* Sat Aug 23 2003 Arjan van de Ven <arjanv@redhat.com>
- fix typo in netdevice.h as per #102951

* Thu Aug 21 2003 Arjan van de Ven <arjanv@redhat.com>
- update personality.h for the amd64 3Gb 32 bit personality

* Tue Aug 19 2003 Arjan van de Ven <arjanv@redhat.com>
- add asm/types.h to a few .h files that need it
- remove unistd.h from linux/limits.h; it breaks samba builds

* Tue Aug 19 2003 Doug Ledford <dledford@redhat.com>
- Add updated prctl.h file that includes process timing defines

* Sat Aug 16 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.27
- add tgkill to unistd.h on ppc64, x86_64 and alpha

* Thu Jul 31 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.26
- update ia64/sigcontext.h from 2.5.73+ (#101344)

* Wed Jul 30 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.25
- make ppc64/uaccess.h match the upstream ABI

* Mon Jul 28 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.24
- rebuilt

* Mon Jul 28 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.23
- add tgkill to unistd.h on i386, ia64 and ppc32
- remove __KERNEL_SYSCALLS__ cruft on ia64/ppc32

* Mon Jul 14 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.22
- add arptables headers

* Fri Jun 27 2003 Arjan van de Ven <arjanv@redhat.com> 2.4.8.20
- update ptrace headers for amd64

* Wed Jun 18 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.19
- update for new bonding interface

* Fri Jun 06 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.18
- change syscall stubs to use the glibc ones

* Thu Jun  5 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.17
- rebuilt

* Mon Jun  2 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.16
- add new scsi majors to <linux/major.h> (#91696)

* Fri May 30 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.15
- add amd64 nptl syscalls

* Tue May 27 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.14
- unifdef'd a bunch of header files for __KERNEL__

* Sun Apr 13 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.13
- remove more kernel private files

* Fri Apr 11 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.12
- update <linux/prctl.h> header
- remove i386 <asm/io.h>, replace it with a warning and <sys/io.h> include
  (Arjan van de Ven)

* Mon Feb 10 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.11
- update syscall numbers for all arches from 2.5.64 headers

* Fri Feb  7 2003 Bill Nottingham <notting@redhat.com> 2.4-8.10
- update more wireless headers

* Wed Feb  5 2003 Bill Nottingham <notting@redhat.com> 2.4-8.9
- update wireless headers

* Thu Jan 30 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.7
- make /usr/include/asm during build if it doesn't exist

* Thu Jan 30 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.6
- remove unpackaged file

* Thu Jan 30 2003 Bill Nottingham <notting@redhat.com>
- update netfilter headers

* Thu Jan 30 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.5
- don't include <linux/types.h> etc. in <asm-s390*/ptrace.h>

* Thu Jan 16 2003 Jakub Jelinek <jakub@redhat.com> 2.4-8.4
- updated s390 headers, added s390x headers
- HTB in <linux/pkt_sched.h>
- no -debuginfo subpackage

* Thu Dec 12 2002 Jakub Jelinek <jakub@redhat.com> 2.4-8.3
- update version.h from kernel-2.4.20-0.pp.6

* Tue Nov 26 2002 Jakub Jelinek <jakub@redhat.com> 2.4-8.2
- update unistd.h from kernel-2.4.19-0.pp.19

* Thu Oct 10 2002 Jakub Jelinek <jakub@redhat.com>
- generate stubs automatically
- remove /usr/include/scsi from file list

* Thu Oct 10 2002 Arjan van de Ven <arjanv@redhat.com
- added support for mixed 32/64 headers

* Tue Mar 21 2002 Arjan van de Ven <arjanv@redhat.com
- update ethtool and other network ioctls

* Tue Feb 10 2002 Arjan van de Ven <arjanv@redhat.com
- removed autoconf.h content

* Sun Feb 10 2002 Arjan van de Ven <arjanv@redhat.com
- fix missing include that broke quota.h

* Mon Jan 07 2002 Arjan van de Ven <arjanv@redhat.com
- fix rhconfig.h include file to not care about /boot/kernel.h

* Wed Jan 02 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- fix #warning in <asm-i386/rwlock.h> and <asm-i386/spinlock.h>

* Thu Dec 6 2001 Arjan van de Ven <arjanv@redhat.com>
- fix misplaced #endif

* Tue Dec 4 2001 Arjan van de Ven <arjanv@redhat.com>
- fix version.h to not include /boot/kernel.h

* Wed Oct 31 2001 Arjan van de Ven <arjanv@redhat.com>
- Initial packaging
