// +build linux

package logger

import (
	"os"

	"golang.org/x/sys/unix"
)

const SupportsColorEscapes = true

func GetTerminalInfo(file *os.File) (info TerminalInfo) {
	fd := file.Fd()

	// Is this file descriptor a terminal?
	if _, err := unix.IoctlGetTermios(int(fd), unix.TCGETS); err == nil {
		info.IsTTY = true
		info.UseColorEscapes = true

		// Get the width of the window
		if w, err := unix.IoctlGetWinsize(int(fd), unix.TIOCGWINSZ); err == nil {
			info.Width = int(w.Col)
		}
	}

	return
}

func writeStringWithColor(file *os.File, text string) {
	file.WriteString(text)
}
