#ifndef BACKENDS_PORTAUDIO_HPP
#define BACKENDS_PORTAUDIO_HPP

#include "base.h"

struct PortBackendFactory final : public BackendFactory {
public:
    auto init() -> bool final;

    auto querySupport(BackendType type) -> bool final;

    auto enumerate(BackendType type) -> std::vector<std::string> final;

    auto createBackend(DeviceBase *device, BackendType type) -> BackendPtr final;

    static auto getFactory() -> BackendFactory&;
};

#endif /* BACKENDS_PORTAUDIO_HPP */
