// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 4
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +xsfmmbase \
// RUN:   -target-feature +zvfhmin -target-feature +zvfbfmin \
// RUN:   -target-feature +zve64d \
// RUN:   -disable-O0-optnone -emit-llvm %s -o - | \
// RUN:   opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV64 %s

#include <sifive_vector.h>

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_bf16m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 32 x bfloat> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv32bf16.i64(i64 [[TSS]], <vscale x 32 x bfloat> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_bf16m8(size_t tss, vbfloat16m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_bf16m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_f16m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 32 x half> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv32f16.i64(i64 [[TSS]], <vscale x 32 x half> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_f16m8(size_t tss, vfloat16m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_f16m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_f32m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 16 x float> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv16f32.i64(i64 [[TSS]], <vscale x 16 x float> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_f32m8(size_t tss, vfloat32m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_f32m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_f64m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 8 x double> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv8f64.i64(i64 [[TSS]], <vscale x 8 x double> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_f64m8(size_t tss, vfloat64m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_f64m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_i8m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv64i8.i64(i64 [[TSS]], <vscale x 64 x i8> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_i8m8(size_t tss, vint8m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_i8m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_i16m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv32i16.i64(i64 [[TSS]], <vscale x 32 x i16> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_i16m8(size_t tss, vint16m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_i16m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_i32m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv16i32.i64(i64 [[TSS]], <vscale x 16 x i32> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_i32m8(size_t tss, vint32m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_i32m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_i64m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv8i64.i64(i64 [[TSS]], <vscale x 8 x i64> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_i64m8(size_t tss, vint64m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_i64m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_u8m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv64i8.i64(i64 [[TSS]], <vscale x 64 x i8> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_u8m8(size_t tss, vuint8m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_u8m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_u16m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv32i16.i64(i64 [[TSS]], <vscale x 32 x i16> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_u16m8(size_t tss, vuint16m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_u16m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_u32m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv16i32.i64(i64 [[TSS]], <vscale x 16 x i32> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_u32m8(size_t tss, vuint32m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_u32m8(tss, src, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtmv_t_v_u64m8(
// CHECK-RV64-SAME: i64 noundef [[TSS:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtmv.t.v.nxv8i64.i64(i64 [[TSS]], <vscale x 8 x i64> [[SRC]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtmv_t_v_u64m8(size_t tss, vuint64m8_t src, size_t vl) {
  return __riscv_sf_vtmv_t_v_u64m8(tss, src, vl);
}

