# The Singularity Image Format (SIF)

[![PkgGoDev](https://pkg.go.dev/badge/github.com/apptainer/sif?status.svg)](https://pkg.go.dev/github.com/apptainer/sif/v2)
[![Build Status](https://github.com/apptainer/sif/actions/workflows/ci.yml/badge.svg)](https://github.com/apptainer/sif/actions/workflows/ci.yml)
[![Code Coverage](https://codecov.io/gh/apptainer/sif/branch/main/graph/badge.svg)](https://codecov.io/gh/apptainer/sif)
[![Go Report Card](https://goreportcard.com/badge/github.com/apptainer/sif)](https://goreportcard.com/report/github.com/apptainer/sif)
[![Powered By GoReleaser](https://img.shields.io/badge/powered%20by-goreleaser-green.svg)](https://github.com/goreleaser)

This module contains an open source implementation of the
Singularity Image Format (SIF) that makes it easy to create complete and
encapsulated container environments stored in a single file.

![SIF Image](doc/sif.png)

Unless otherwise noted, the SIF source files are distributed under the
BSD-style license found in the [LICENSE.md](LICENSE.md) file.

## Install Siftool

Pre-built binaries are available with the [latest release](https://github.com/apptainer/sif/releases).

## Go Version Compatibility

This module aims to maintain support for the two most recent stable versions
of Go. This corresponds to the Go
[Release Maintenance Policy](https://github.com/golang/go/wiki/Go-Release-Cycle#release-maintenance)
and [Security Policy](https://golang.org/security), ensuring critical bug
fixes and security patches are available for all supported language versions.

## Contributing

SIF and [Apptainer](https://github.com/apptainer/apptainer) are the work of many
contributors. We appreciate your help!

This is maintained as a sub-project by the Apptainer project.
To contribute, see the [Apptainer CONTRIBUTING
file](https://github.com/apptainer/apptainer/blob/main/CONTRIBUTING.md).
