#############################################################
#
# openssh
#
#############################################################
ifneq ($(USE_CVS),true)
OPENSSH_SITE:=ftp://ftp.tux.org/bsd/openbsd/OpenSSH/portable/
OPENSSH_SOURCE:=openssh.tar.gz
endif

ifeq ($(USE_GLIBC),true)
OPENSSH_CONFIG_DIR:=/etc/ssh
OPENSSH_TARGET:=openssh-standalone
OPENSSH_CONFIG_PAM:=--with-pam
OPENSSH_CONFIG_TCP_WRAPPERS=--with-tcp-wrappers
else
OPENSSH_CONFIG_DIR:=/etc
OPENSSH_TARGET:=openssh-inetd
OPENSSH_CONFIG_PAM:=--without-pam
OPENSSH_CONFIG_TCP_WRAPPERS=--without-tcp-wrappers
endif

OPENSSH_DIR:=$(BUILD_DIR)/openssh
OPENSSH_PATCH:=$(SOURCE_DIR)/openssh.patch

ifneq ($(USE_CVS),true)
openssh-fetch:
	$(WGET) -P $(DL_DIR) $(OPENSSH_SITE)/$(OPENSSH_SOURCE)
endif

OPENSSH_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d openssh $(CVS_TAG) $(CVS_PREFIX)openssh

openssh-checkout:
	@$(OPENSSH_CVSCO)

$(OPENSSH_DIR)/.unpacked: $(DL_DIR)/$(OPENSSH_SOURCE) $(OPENSSH_PATCH)
ifneq ($(USE_CVS),true)
	zcat $(DL_DIR)/$(OPENSSH_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(OPENSSH_CVSCO)
endif
	touch  $(OPENSSH_DIR)/.unpacked

$(OPENSSH_DIR)/.configured: $(OPENSSH_DIR)/.unpacked
	(cd $(OPENSSH_DIR); rm -rf config.cache; autoconf; autoheader ; \
		$(TARGET_CONFIGURE_OPTS) \
		LD=$(TARGET_CROSS)gcc \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/sbin \
		--sysconfdir=$(OPENSSH_CONFIG_DIR) \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--includedir=$(STAGING_DIR)/usr/include \
		--disable-lastlog \
		--disable-utmpx --disable-wtmpx \
		--without-x $(DISABLE_NLS) \
		$(OPENSSH_CONFIG_PAM) \
		$(OPENSSH_CONFIG_TCP_WRAPPERS) \
	);
	# what about --with-md5-passwords ?
	touch  $(OPENSSH_DIR)/.configured

$(OPENSSH_DIR)/ssh: $(OPENSSH_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(OPENSSH_DIR)

$(TARGET_DIR)/usr/bin/ssh: $(OPENSSH_DIR)/ssh
	touch $(OPENSSH_DIR)/touchme
	$(MAKE) CC=$(TARGET_CC) DESTDIR=$(TARGET_DIR) -C $(OPENSSH_DIR) install-nokeys
	@echo "Stripping OpenSSH binaries..."
	@set -x ; for f in `find $(TARGET_DIR) -type f -newer $(OPENSSH_DIR)/touchme -exec file {} \; | \
                grep "ELF.*not stripped" | cut -d : -f 1` ; do \
            $(STRIP) $$f ; \
        done
	rm -f $(OPENSSH_DIR)/touchme
	# allow empty passwords
	sed -i -e 's,^#PermitEmptyPasswords no,PermitEmptyPasswords yes,' $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/sshd_config
	mkdir -p $(DOC_DIR)/doc/openssh
	for f in LICENCE README ; do \
	    install -m0644 $(OPENSSH_DIR)/$$f $(DOC_DIR)/doc/openssh/$$f ; \
	done 

openssh: uclibc $(OPENSSH_TARGET)

openssh-inetd: netkitbase $(TARGET_DIR)/usr/bin/ssh
	# add ssh to inetd.conf
	sed -i -e 's,^\# End\.$$,# SSH\nssh\tstream\ttcp\tnowait\troot\t/usr/sbin/sshd\t/usr/sbin/sshd -i\n# End.,' $(TARGET_DIR)/etc/inetd.conf
	# generate host keys
	if [ ! -f $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/ssh_host_key ] ; then \
		echo Generating RSA Key... ; \
		/usr/bin/ssh-keygen -t rsa1 -f $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/ssh_host_key -C '' -N '' ; \
	fi
	if [ ! -f $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/ssh_host_rsa_key ] ; then \
		echo Generating RSA Key... ; \
		/usr/bin/ssh-keygen -t rsa -f $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/ssh_host_rsa_key -C '' -N '' ; \
	fi
	if [ ! -f $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/ssh_host_dsa_key ] ; then \
		echo Generating DSA Key... ; \
		echo THIS CAN TAKE A MINUTE OR TWO DEPENDING ON YOUR PROCESSOR! ; \
		echo ; \
		/usr/bin/ssh-keygen -t dsa -f $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/ssh_host_dsa_key -C '' -N '' ; \
	fi

openssh-standalone: initscripts pam $(TARGET_DIR)/usr/bin/ssh
	install -m0755 $(OPENSSH_DIR)/contrib/redhat/sshd.init $(TARGET_DIR)/etc/rc.d/init.d/sshd
	sed -i -e 's,^UsePrivilegeSeparation no,UsePrivilegeSeparation yes,' $(TARGET_DIR)$(OPENSSH_CONFIG_DIR)/sshd_config
	install -m0644 $(OPENSSH_DIR)/contrib/redhat/sshd.pam \
		$(TARGET_DIR)/etc/pam.d/sshd
	$(SOURCE_DIR)/addservice $(TARGET_DIR) sshd

openssh-source: $(DL_DIR)/$(OPENSSH_SOURCE)

openssh-clean: 
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(OPENSSH_DIR) uninstallall
	-rm -f $(TARGET_DIR)/etc/pam.d/sshd
	-rm -rf $(DOC_DIR)/doc/openssh
	$(MAKE) -C $(OPENSSH_DIR) clean

openssh-dirclean: 
	rm -rf $(OPENSSH_DIR)

