#############################################################
#
# netkittelnet
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITTELNET_SOURCE:=netkit-telnet.tar.gz
NETKITTELNET_SITE:=ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/
NETKITTELNET_DIR:=$(BUILD_DIR)/${shell basename $(NETKITTELNET_SOURCE) .tar.gz}

NETKITTELNET_CAT:=zcat
else
NETKITTELNET_DIR:=$(BUILD_DIR)/netkit-telnet
endif
NETKITTELNET_BINARY:=telnetd/telnetd
NETKITTELNET_TARGET_BINARY:=usr/sbin/in.telnetd
NETKITTELNET_PATCH:=$(SOURCE_DIR)/netkittelnet.patch

ifneq ($(USE_CVS),true)
netkittelnet-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITTELNET_SITE)/$(NETKITTELNET_SOURCE)

netkittelnet-source: $(DL_DIR)/$(NETKITTELNET_SOURCE)
else
netkittelnet-source:
endif

NETKITTELNET_CVSCO:=cd $(BUILD_DIR) && $(CVS)  $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d netkit-telnet $(CVS_PREFIX)netkit-telnet

netkittelnet-checkout:
	@$(NETKITTELNET_CVSCO)

$(NETKITTELNET_DIR)/.unpacked: $(DL_DIR)/$(NETKITTELNET_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITTELNET_CAT) $(DL_DIR)/$(NETKITTELNET_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITTELNET_CVSCO)
endif
	touch $(NETKITTELNET_DIR)/.unpacked

$(NETKITTELNET_DIR)/.configured: $(NETKITTELNET_DIR)/.unpacked
	(cd $(NETKITTELNET_DIR); $(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITTELNET_DIR)/.configured

$(NETKITTELNET_DIR)/$(NETKITTELNET_BINARY): $(NETKITTELNET_DIR)/.configured
	$(MAKE) SUB=telnetd CC=$(TARGET_CC) -C $(NETKITTELNET_DIR)

$(TARGET_DIR)/$(NETKITTELNET_TARGET_BINARY): $(NETKITTELNET_DIR)/$(NETKITTELNET_BINARY)
	$(MAKE) SUB=telnetd INSTALLROOT=$(TARGET_DIR) -C $(NETKITTELNET_DIR) install
	$(STRIP) $(TARGET_DIR)/$(NETKITTELNET_TARGET_BINARY)
	# Enable telnet in inetd
	sed -i -e "s~^#telnet.*~telnet\tstream\ttcp\tnowait\troot\t/usr/sbin/in.telnetd\t/usr/sbin/in.telnetd~;" $(TARGET_DIR)/etc/inetd.conf
	mkdir -p $(DOC_DIR)/doc/netkit-telnet
	for f in BUGS README ; do \
	    install -m0644 $(NETKITTELNET_DIR)/$$f $(DOC_DIR)/doc/netkit-telnet/$$f ; \
	done

netkittelnet: uclibc $(TARGET_DIR)/$(NETKITTELNET_TARGET_BINARY)

netkittelnet-clean:
	-rm -f $(TARGET_DIR)/$(NETKITTELNET_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/etc/issue.net
	-$(MAKE) -C $(NETKITTELNET_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-telnet

netkittelnet-dirclean:
	rm -rf $(NETKITTELNET_DIR)

