#############################################################
#
# netkitrouted
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITROUTED_SOURCE:=netkit-routed.tar.gz
NETKITROUTED_SITE:=ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/
NETKITROUTED_DIR:=$(BUILD_DIR)/${shell basename $(NETKITROUTED_SOURCE) .tar.gz}

NETKITROUTED_CAT:=zcat
else
# using CVS
NETKITROUTED_DIR:=$(BUILD_DIR)/netkit-routed
endif

NETKITROUTED_BINARY:=routed/routed
NETKITROUTED_TARGET_BINARY:=usr/sbin/routed
NETKITROUTED_PATCH:=$(SOURCE_DIR)/netkitrouted.patch

ifneq ($(USE_CVS),true)
netkitrouted-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITROUTED_SITE)/$(NETKITROUTED_SOURCE)

netkitrouted-source: $(DL_DIR)/$(NETKITROUTED_SOURCE)
else
netkitrouted-source:
endif

NETKITROUTED_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-routed $(CVS_TAG) $(CVS_PREFIX)netkit-routed

netkitrouted-checkout:
	@$(NETKITROUTED_CVSCO)

$(NETKITROUTED_DIR)/.unpacked: $(DL_DIR)/$(NETKITROUTED_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITROUTED_CAT) $(DL_DIR)/$(NETKITROUTED_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITROUTED_CVSCO)
endif
	touch $(NETKITROUTED_DIR)/.unpacked

$(NETKITROUTED_DIR)/.configured: $(NETKITROUTED_DIR)/.unpacked
	(cd $(NETKITROUTED_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITROUTED_DIR)/.configured

$(NETKITROUTED_DIR)/$(NETKITROUTED_BINARY): $(NETKITROUTED_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITROUTED_DIR)

$(TARGET_DIR)/$(NETKITROUTED_TARGET_BINARY): $(NETKITROUTED_DIR)/$(NETKITROUTED_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(NETKITROUTED_DIR) install
	$(STRIP) $(TARGET_DIR)/usr/sbin/routed
	$(STRIP) $(TARGET_DIR)/usr/sbin/ripquery
	mkdir -p $(DOC_DIR)/doc/netkit-routed
	install -m0644 $(NETKITROUTED_DIR)/README $(DOC_DIR)/doc/netkit-routed/README

netkitrouted: uclibc $(TARGET_DIR)/$(NETKITROUTED_TARGET_BINARY)

netkitrouted-clean:
	-rm -f $(TARGET_DIR)/usr/sbin/routed
	-rm -f $(TARGET_DIR)/usr/sbin/ripquery
	-$(MAKE) -C $(NETKITROUTED_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-routed

netkitrouted-dirclean:
	rm -rf $(NETKITROUTED_DIR)

