#############################################################
#
# mingetty
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
MINGETTY_SOURCE:=mingetty.tar.gz
MINGETTY_CAT:=zcat
endif

MINGETTY_DIR:=$(BUILD_DIR)/mingetty
MINGETTY_BINARY:=mingetty
MINGETTY_TARGET_BINARY:=sbin/mingetty

ifneq ($(USE_CVS),true)
mingetty-fetch:
	 $(WGET) -P $(DL_DIR) $(MINGETTY_SITE)/$(MINGETTY_SOURCE)

mingetty-source: $(DL_DIR)/$(MINGETTY_SOURCE)
else
mingetty-source:
endif

MINGETTY_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d mingetty $(CVS_TAG) $(CVS_PREFIX)mingetty

mingetty-checkout:
	@$(MINGETTY_CVSCO)

$(MINGETTY_DIR)/.unpacked: $(DL_DIR)/$(MINGETTY_SOURCE)
ifneq ($(USE_CVS),true)
	$(MINGETTY_CAT) $(DL_DIR)/$(MINGETTY_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(MINGETTY_CVSCO)
endif
	touch $(MINGETTY_DIR)/.unpacked

$(MINGETTY_DIR)/$(MINGETTY_BINARY): $(MINGETTY_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) -C $(MINGETTY_DIR)

$(TARGET_DIR)/$(MINGETTY_TARGET_BINARY): $(MINGETTY_DIR)/$(MINGETTY_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(MINGETTY_DIR) install
	install -d $(DOC_DIR)/doc/mingetty
	@for f in COPYING ; do \
		install -m0644 $(MINGETTY_DIR)/$$f $(DOC_DIR)/doc/mingetty/$$f ;\
	done

mingetty: uclibc $(TARGET_DIR)/$(MINGETTY_TARGET_BINARY)

mingetty-clean:
	-rm -f $(TARGET_DIR)/$(MINGETTY_TARGET_BINARY) $(TARGET_DIR)/usr/share/man/man8/mingetty.8
	-rm -rf $(DOC_DIR)/doc/mingetty
	-$(MAKE) -C $(MINGETTY_DIR) clean

mingetty-dirclean:
	rm -rf $(MINGETTY_DIR)
endif

