#############################################################
#
# e2fsprogs
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
E2FSPROGS_SOURCE:=e2fsprogs.tar.gz
E2FSPROGS_SITE:=http://aleron.dl.sourceforge.net/sourceforge/e2fsprogs
E2FSPROGS_CAT:=zcat
endif

E2FSPROGS_DIR:=$(BUILD_DIR)/e2fsprogs
E2FSPROGS_BINARY:=lib/libext2fs.so.2.4
E2FSPROGS_TARGET_BINARY:=usr/lib/libext2fs.so.2.4

ifneq ($(USE_CVS),true)
e2fsprogs-fetch:
	 $(WGET) -P $(DL_DIR) $(E2FSPROGS_SITE)/$(E2FSPROGS_SOURCE)

e2fsprogs-source: $(DL_DIR)/$(E2FSPROGS_SOURCE)
else
e2fsprogs-source:
endif

E2FSPROGS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d e2fsprogs $(CVS_TAG) $(CVS_PREFIX)e2fsprogs

e2fsprogs-checkout:
	@$(E2FSPROGS_CVSCO)

$(E2FSPROGS_DIR)/.unpacked: $(DL_DIR)/$(E2FSPROGS_SOURCE)
ifneq ($(USE_CVS),true)
	$(E2FSPROGS_CAT) $(DL_DIR)/$(E2FSPROGS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(E2FSPROGS_CVSCO)
endif
	chmod u+w $(E2FSPROGS_DIR)/config.sub
	cp $(SOURCE_DIR)/config.sub $(E2FSPROGS_DIR)/
	touch $(E2FSPROGS_DIR)/.unpacked

$(E2FSPROGS_DIR)/.configured: $(E2FSPROGS_DIR)/.unpacked
	(cd $(E2FSPROGS_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--enable-dynamic-e2fsck \
		--enable-elf-shlibs \
	);
	touch  $(E2FSPROGS_DIR)/.configured

$(E2FSPROGS_DIR)/$(E2FSPROGS_BINARY): $(E2FSPROGS_DIR)/.configured
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(E2FSPROGS_DIR)

$(STAGING_DIR)/$(E2FSPROGS_TARGET_BINARY): $(E2FSPROGS_DIR)/$(E2FSPROGS_BINARY)
	$(MAKE) STRIP=$(TARGET_CROSS)strip DESTDIR=$(STAGING_DIR) -C $(E2FSPROGS_DIR) install
	$(MAKE) STRIP=$(TARGET_CROSS)strip DESTDIR=$(STAGING_DIR) -C $(E2FSPROGS_DIR) install-libs

$(TARGET_DIR)/$(E2FSPROGS_TARGET_BINARY): $(STAGING_DIR)/$(E2FSPROGS_TARGET_BINARY)
	@touch $(TARGET_DIR)/.touchme
	$(MAKE) STRIP=$(TARGET_CROSS)strip DESTDIR=$(TARGET_DIR) -C $(E2FSPROGS_DIR) install
	@for f in `find $(TARGET_DIR)/usr/lib -type f \
		   	-newer $(TARGET_DIR)/.touchme -exec file {} \; \
			| grep 'ELF.*not stripped' | cut -d: -f1` ; do \
		$(STRIP) $$f ;\
	done
	@rm -f $(TARGET_DIR)/.touchme
	install -d $(DOC_DIR)/doc/e2fsprogs
	@for f in COPYING doc/libblkid.txt doc/libext2fs.info ; do \
		install -m0644 $(E2FSPROGS_DIR)/$$f $(DOC_DIR)/doc/e2fsprogs/`basename $$f` ;\
	done

e2fsprogs: uclibc $(TARGET_DIR)/$(E2FSPROGS_TARGET_BINARY)

e2fsprogs-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(E2FSPROGS_DIR) uninstall
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(E2FSPROGS_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/e2fsprogs
	-$(MAKE) -C $(E2FSPROGS_DIR) clean

e2fsprogs-dirclean:
	rm -rf $(E2FSPROGS_DIR)
endif

