#############################################################
#
# dump
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
DUMP_SOURCE:=dump.tar.gz
DUMP_SITE:=ftp://ftp.gnu.org/gnu/dump
DUMP_CAT:=zcat
endif

DUMP_DIR:=$(BUILD_DIR)/dump
DUMP_BINARY:=dump/dump
DUMP_TARGET_BINARY:=sbin/dump

ifneq ($(USE_CVS),true)
dump-fetch:
	 $(WGET) -P $(DL_DIR) $(DUMP_SITE)/$(DUMP_SOURCE)

dump-source: $(DL_DIR)/$(DUMP_SOURCE)
else
dump-source:
endif

DUMP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d dump $(CVS_TAG) $(CVS_PREFIX)dump

dump-checkout:
	@$(DUMP_CVSCO)

$(DUMP_DIR)/.unpacked: $(DL_DIR)/$(DUMP_SOURCE)
ifneq ($(USE_CVS),true)
	$(DUMP_CAT) $(DL_DIR)/$(DUMP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(DUMP_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(DUMP_DIR)/
	touch $(DUMP_DIR)/.unpacked

$(DUMP_DIR)/.configured: $(DUMP_DIR)/.unpacked
	(cd $(DUMP_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		LD=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=$(TARGET_DIR) \
		--exec-prefix=$(TARGET_DIR) \
		--bindir=$(TARGET_DIR)/bin \
		--sbindir=$(TARGET_DIR)/sbin \
		--sysconfdir=$(TARGET_DIR)/etc \
		--mandir=$(TARGET_DIR)/usr/man \
		--infodir=$(TARGET_DIR)/info \
		$(DISABLE_NLS) \
		--disable-rmt \
		--disable-readline \
	);
	touch  $(DUMP_DIR)/.configured

$(DUMP_DIR)/$(DUMP_BINARY): $(DUMP_DIR)/.configured
	$(MAKE) -C $(DUMP_DIR)

$(TARGET_DIR)/$(DUMP_TARGET_BINARY): $(DUMP_DIR)/$(DUMP_BINARY)
	$(MAKE) -C $(DUMP_DIR) install
	$(STRIP) $(TARGET_DIR)/$(DUMP_TARGET_BINARY) \
		$(TARGET_DIR)/sbin/rdump \
		$(TARGET_DIR)/sbin/restore \
		$(TARGET_DIR)/sbin/rrestore 
	install -d $(DOC_DIR)/doc/dump
	@for f in COPYRIGHT KNOWNBUGS README REPORTING-BUGS ; do \
		install -m0644 $(DUMP_DIR)/$$f $(DOC_DIR)/doc/dump/$$f ;\
	done

dump: uclibc $(TARGET_DIR)/$(DUMP_TARGET_BINARY)

dump-clean:
	-rm -f $(TARGET_DIR)/$(DUMP_TARGET_BINARY) \
		$(TARGET_DIR)/sbin/rdump \
		$(TARGET_DIR)/sbin/restore \
		$(TARGET_DIR)/sbin/rrestore 
	-rm -f $(TARGET_DIR)/usr/man/man1/dump.1
	-rm -rf $(DOC_DIR)/doc/dump
	-$(MAKE) -C $(DUMP_DIR) clean

dump-dirclean:
	rm -rf $(DUMP_DIR)
endif

