# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class KnowledgeBaseActivityRecordType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of activity record."""

    SEARCH_INDEX = "searchIndex"
    """Search index retrieval activity."""
    AZURE_BLOB = "azureBlob"
    """Azure Blob retrieval activity."""
    INDEXED_SHARE_POINT = "indexedSharePoint"
    """Indexed SharePoint retrieval activity."""
    INDEXED_ONE_LAKE = "indexedOneLake"
    """Indexed OneLake retrieval activity."""
    WEB = "web"
    """Web retrieval activity."""
    REMOTE_SHARE_POINT = "remoteSharePoint"
    """Remote SharePoint retrieval activity."""
    MODEL_QUERY_PLANNING = "modelQueryPlanning"
    """LLM query planning activity."""
    MODEL_ANSWER_SYNTHESIS = "modelAnswerSynthesis"
    """LLM answer synthesis activity."""
    AGENTIC_REASONING = "agenticReasoning"
    """Agentic reasoning activity."""


class KnowledgeBaseMessageContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of message content."""

    TEXT = "text"
    """Text message content kind."""
    IMAGE = "image"
    """Image message content kind."""


class KnowledgeBaseReferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of reference."""

    SEARCH_INDEX = "searchIndex"
    """Search index document reference."""
    AZURE_BLOB = "azureBlob"
    """Azure Blob document reference."""
    INDEXED_SHARE_POINT = "indexedSharePoint"
    """Indexed SharePoint document reference."""
    INDEXED_ONE_LAKE = "indexedOneLake"
    """Indexed OneLake document reference."""
    WEB = "web"
    """Web document reference."""
    REMOTE_SHARE_POINT = "remoteSharePoint"
    """Remote SharePoint document reference."""


class KnowledgeRetrievalIntentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of knowledge base configuration to use."""

    SEMANTIC = "semantic"
    """A natural language semantic query intent."""


class KnowledgeRetrievalOutputMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The output configuration for this retrieval."""

    EXTRACTIVE_DATA = "extractiveData"
    """Return data from the knowledge sources directly without generative alteration."""
    ANSWER_SYNTHESIS = "answerSynthesis"
    """Synthesize an answer for the response payload."""


class KnowledgeRetrievalReasoningEffortKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The amount of effort to use during retrieval."""

    MINIMAL = "minimal"
    """Does not perform any source selections, query planning, or iterative search."""
    LOW = "low"
    """Use low reasoning during retrieval."""
    MEDIUM = "medium"
    """Use a moderate amount of reasoning during retrieval."""
