# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.postgresqlflexibleservers.aio import PostgreSQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPostgreSQLManagementVirtualEndpointsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PostgreSQLManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_endpoints_get(self, resource_group):
        response = await self.client.virtual_endpoints.get(
            resource_group_name=resource_group.name,
            server_name="str",
            virtual_endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_endpoints_begin_create(self, resource_group):
        response = await (
            await self.client.virtual_endpoints.begin_create(
                resource_group_name=resource_group.name,
                server_name="str",
                virtual_endpoint_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {"endpointType": "str", "members": ["str"], "virtualEndpoints": ["str"]},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_endpoints_begin_update(self, resource_group):
        response = await (
            await self.client.virtual_endpoints.begin_update(
                resource_group_name=resource_group.name,
                server_name="str",
                virtual_endpoint_name="str",
                parameters={"properties": {"endpointType": "str", "members": ["str"], "virtualEndpoints": ["str"]}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_endpoints_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_endpoints.begin_delete(
                resource_group_name=resource_group.name,
                server_name="str",
                virtual_endpoint_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_endpoints_list_by_server(self, resource_group):
        response = self.client.virtual_endpoints.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
