# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.postgresqlflexibleservers.aio import PostgreSQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPostgreSQLManagementMigrationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PostgreSQLManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_migrations_get(self, resource_group):
        response = await self.client.migrations.get(
            resource_group_name=resource_group.name,
            server_name="str",
            migration_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_migrations_create(self, resource_group):
        response = await self.client.migrations.create(
            resource_group_name=resource_group.name,
            server_name="str",
            migration_name="str",
            parameters={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "cancel": "str",
                    "currentStatus": {
                        "currentSubStateDetails": {
                            "currentSubState": "str",
                            "dbDetails": {
                                "str": {
                                    "appliedChanges": 0,
                                    "cdcDeleteCounter": 0,
                                    "cdcInsertCounter": 0,
                                    "cdcUpdateCounter": 0,
                                    "databaseName": "str",
                                    "endedOn": "2020-02-20 00:00:00",
                                    "fullLoadCompletedTables": 0,
                                    "fullLoadErroredTables": 0,
                                    "fullLoadLoadingTables": 0,
                                    "fullLoadQueuedTables": 0,
                                    "incomingChanges": 0,
                                    "latency": 0,
                                    "message": "str",
                                    "migrationOperation": "str",
                                    "migrationState": "str",
                                    "startedOn": "2020-02-20 00:00:00",
                                }
                            },
                            "validationDetails": {
                                "dbLevelValidationDetails": [
                                    {
                                        "databaseName": "str",
                                        "endedOn": "2020-02-20 00:00:00",
                                        "startedOn": "2020-02-20 00:00:00",
                                        "summary": [
                                            {
                                                "messages": [{"message": "str", "state": "str"}],
                                                "state": "str",
                                                "type": "str",
                                            }
                                        ],
                                    }
                                ],
                                "serverLevelValidationDetails": [
                                    {"messages": [{"message": "str", "state": "str"}], "state": "str", "type": "str"}
                                ],
                                "status": "str",
                                "validationEndTimeInUtc": "2020-02-20 00:00:00",
                                "validationStartTimeInUtc": "2020-02-20 00:00:00",
                            },
                        },
                        "error": "str",
                        "state": "str",
                    },
                    "dbsToCancelMigrationOn": ["str"],
                    "dbsToMigrate": ["str"],
                    "dbsToTriggerCutoverOn": ["str"],
                    "migrateRoles": "str",
                    "migrationId": "str",
                    "migrationInstanceResourceId": "str",
                    "migrationMode": "str",
                    "migrationOption": "str",
                    "migrationWindowEndTimeInUtc": "2020-02-20 00:00:00",
                    "migrationWindowStartTimeInUtc": "2020-02-20 00:00:00",
                    "overwriteDbsInTarget": "str",
                    "secretParameters": {
                        "adminCredentials": {"sourceServerPassword": "str", "targetServerPassword": "str"},
                        "sourceServerUsername": "str",
                        "targetServerUsername": "str",
                    },
                    "setupLogicalReplicationOnSourceDbIfNeeded": "str",
                    "sourceDbServerFullyQualifiedDomainName": "str",
                    "sourceDbServerMetadata": {
                        "location": "str",
                        "sku": {"name": "str", "tier": "str"},
                        "storageMb": 0,
                        "version": "str",
                    },
                    "sourceDbServerResourceId": "str",
                    "sourceType": "str",
                    "sslMode": "str",
                    "startDataMigration": "str",
                    "targetDbServerFullyQualifiedDomainName": "str",
                    "targetDbServerMetadata": {
                        "location": "str",
                        "sku": {"name": "str", "tier": "str"},
                        "storageMb": 0,
                        "version": "str",
                    },
                    "targetDbServerResourceId": "str",
                    "triggerCutover": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_migrations_update(self, resource_group):
        response = await self.client.migrations.update(
            resource_group_name=resource_group.name,
            server_name="str",
            migration_name="str",
            parameters={
                "properties": {
                    "cancel": "str",
                    "dbsToCancelMigrationOn": ["str"],
                    "dbsToMigrate": ["str"],
                    "dbsToTriggerCutoverOn": ["str"],
                    "migrateRoles": "str",
                    "migrationMode": "str",
                    "migrationWindowStartTimeInUtc": "2020-02-20 00:00:00",
                    "overwriteDbsInTarget": "str",
                    "secretParameters": {
                        "adminCredentials": {"sourceServerPassword": "str", "targetServerPassword": "str"},
                        "sourceServerUsername": "str",
                        "targetServerUsername": "str",
                    },
                    "setupLogicalReplicationOnSourceDbIfNeeded": "str",
                    "sourceDbServerFullyQualifiedDomainName": "str",
                    "sourceDbServerResourceId": "str",
                    "startDataMigration": "str",
                    "targetDbServerFullyQualifiedDomainName": "str",
                    "triggerCutover": "str",
                },
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_migrations_cancel(self, resource_group):
        response = await self.client.migrations.cancel(
            resource_group_name=resource_group.name,
            server_name="str",
            migration_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_migrations_list_by_target_server(self, resource_group):
        response = self.client.migrations.list_by_target_server(
            resource_group_name=resource_group.name,
            server_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_migrations_check_name_availability(self, resource_group):
        response = await self.client.migrations.check_name_availability(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={"name": "str", "type": "str", "message": "str", "nameAvailable": bool, "reason": "str"},
        )

        # please add some check logic here by yourself
        # ...
