# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.postgresqlflexibleservers.aio import PostgreSQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPostgreSQLManagementBackupsLongTermRetentionOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PostgreSQLManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backups_long_term_retention_check_prerequisites(self, resource_group):
        response = await self.client.backups_long_term_retention.check_prerequisites(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={"backupSettings": {"backupName": "str"}},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backups_long_term_retention_begin_start(self, resource_group):
        response = await (
            await self.client.backups_long_term_retention.begin_start(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={"backupSettings": {"backupName": "str"}, "targetDetails": {"sasUriList": ["str"]}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backups_long_term_retention_get(self, resource_group):
        response = await self.client.backups_long_term_retention.get(
            resource_group_name=resource_group.name,
            server_name="str",
            backup_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backups_long_term_retention_list_by_server(self, resource_group):
        response = self.client.backups_long_term_retention.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
