# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.nginx.aio import NginxManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNginxManagementConfigurationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NginxManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_list(self, resource_group):
        response = self.client.configurations.list(
            resource_group_name=resource_group.name,
            deployment_name="str",
            api_version="2025-03-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_get(self, resource_group):
        response = await self.client.configurations.get(
            resource_group_name=resource_group.name,
            deployment_name="str",
            configuration_name="str",
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.configurations.begin_create_or_update(
                resource_group_name=resource_group.name,
                deployment_name="str",
                configuration_name="str",
                api_version="2025-03-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_begin_delete(self, resource_group):
        response = await (
            await self.client.configurations.begin_delete(
                resource_group_name=resource_group.name,
                deployment_name="str",
                configuration_name="str",
                api_version="2025-03-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_analysis(self, resource_group):
        response = await self.client.configurations.analysis(
            resource_group_name=resource_group.name,
            deployment_name="str",
            configuration_name="str",
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...
