# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cosmosdb.aio import CosmosDBManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCosmosDBManagementCassandraClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CosmosDBManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_list_by_subscription(self, resource_group):
        response = self.client.cassandra_clusters.list_by_subscription(
            api_version="2025-10-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_list_by_resource_group(self, resource_group):
        response = self.client.cassandra_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-10-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_get(self, resource_group):
        response = await self.client.cassandra_clusters.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2025-10-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_begin_delete(self, resource_group):
        response = await (
            await self.client.cassandra_clusters.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2025-10-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_begin_create_update(self, resource_group):
        response = await (
            await self.client.cassandra_clusters.begin_create_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                body={
                    "id": "str",
                    "identity": {"principalId": "str", "tenantId": "str", "type": "str"},
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "authenticationMethod": "str",
                        "azureConnectionMethod": "str",
                        "cassandraAuditLoggingEnabled": bool,
                        "cassandraVersion": "str",
                        "clientCertificates": [{"pem": "str"}],
                        "clusterNameOverride": "str",
                        "deallocated": bool,
                        "delegatedManagementSubnetId": "str",
                        "externalGossipCertificates": [{"pem": "str"}],
                        "externalSeedNodes": [{"ipAddress": "str"}],
                        "gossipCertificates": [{"pem": "str"}],
                        "hoursBetweenBackups": 0,
                        "initialCassandraAdminPassword": "str",
                        "privateLinkResourceId": "str",
                        "prometheusEndpoint": {"ipAddress": "str"},
                        "provisionError": {
                            "additionalErrorInfo": "str",
                            "code": "str",
                            "message": "str",
                            "target": "str",
                        },
                        "provisioningState": "str",
                        "repairEnabled": bool,
                        "restoreFromBackupId": "str",
                        "seedNodes": [{"ipAddress": "str"}],
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-10-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_begin_update(self, resource_group):
        response = await (
            await self.client.cassandra_clusters.begin_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                body={
                    "id": "str",
                    "identity": {"principalId": "str", "tenantId": "str", "type": "str"},
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "authenticationMethod": "str",
                        "azureConnectionMethod": "str",
                        "cassandraAuditLoggingEnabled": bool,
                        "cassandraVersion": "str",
                        "clientCertificates": [{"pem": "str"}],
                        "clusterNameOverride": "str",
                        "deallocated": bool,
                        "delegatedManagementSubnetId": "str",
                        "externalGossipCertificates": [{"pem": "str"}],
                        "externalSeedNodes": [{"ipAddress": "str"}],
                        "gossipCertificates": [{"pem": "str"}],
                        "hoursBetweenBackups": 0,
                        "initialCassandraAdminPassword": "str",
                        "privateLinkResourceId": "str",
                        "prometheusEndpoint": {"ipAddress": "str"},
                        "provisionError": {
                            "additionalErrorInfo": "str",
                            "code": "str",
                            "message": "str",
                            "target": "str",
                        },
                        "provisioningState": "str",
                        "repairEnabled": bool,
                        "restoreFromBackupId": "str",
                        "seedNodes": [{"ipAddress": "str"}],
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-10-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_begin_invoke_command(self, resource_group):
        response = await (
            await self.client.cassandra_clusters.begin_invoke_command(
                resource_group_name=resource_group.name,
                cluster_name="str",
                body={
                    "command": "str",
                    "host": "str",
                    "arguments": {"str": "str"},
                    "cassandra-stop-start": bool,
                    "readwrite": bool,
                },
                api_version="2025-10-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_begin_deallocate(self, resource_group):
        response = await (
            await self.client.cassandra_clusters.begin_deallocate(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2025-10-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_begin_start(self, resource_group):
        response = await (
            await self.client.cassandra_clusters.begin_start(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2025-10-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_clusters_status(self, resource_group):
        response = await self.client.cassandra_clusters.status(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2025-10-15",
        )

        # please add some check logic here by yourself
        # ...
