# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AcrAccessToken(_Model):
    """The ACR access token response containing the access token for authentication.

    :ivar access_token: The access token for performing authenticated requests.
    :vartype access_token: str
    """

    access_token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The access token for performing authenticated requests."""

    @overload
    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AcrErrorInfo(_Model):
    """Error information.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar detail: Error details.
    :vartype detail: any
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message."""
    detail: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        detail: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AcrErrors(_Model):
    """Acr error response describing why the operation failed.

    :ivar errors: Array of detailed error.
    :vartype errors: list[~azure.containerregistry._generated.models.AcrErrorInfo]
    """

    errors: Optional[list["_models.AcrErrorInfo"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of detailed error."""

    @overload
    def __init__(
        self,
        *,
        errors: Optional[list["_models.AcrErrorInfo"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AcrManifests(_Model):
    """Manifest attributes.

    :ivar registry_login_server: Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io.
    :vartype registry_login_server: str
    :ivar repository: Image name.
    :vartype repository: str
    :ivar manifests: List of manifests.
    :vartype manifests: list[~azure.containerregistry._generated.models.ManifestAttributesBase]
    :ivar link: Link to the next page of results.
    :vartype link: str
    """

    registry_login_server: Optional[str] = rest_field(
        name="registry", visibility=["read", "create", "update", "delete", "query"]
    )
    """Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io."""
    repository: Optional[str] = rest_field(name="imageName", visibility=["read", "create", "update", "delete", "query"])
    """Image name."""
    manifests: Optional[list["_models.ManifestAttributesBase"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of manifests."""
    link: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Link to the next page of results."""

    @overload
    def __init__(
        self,
        *,
        registry_login_server: Optional[str] = None,
        repository: Optional[str] = None,
        manifests: Optional[list["_models.ManifestAttributesBase"]] = None,
        link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AcrRefreshToken(_Model):
    """The ACR refresh token response containing the refresh token for authentication.

    :ivar refresh_token: The refresh token to be used for generating access tokens.
    :vartype refresh_token: str
    """

    refresh_token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The refresh token to be used for generating access tokens."""

    @overload
    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Annotations(_Model):
    """Additional information provided through arbitrary metadata.

    :ivar created: Date and time on which the image was built (string, date-time as defined by
     `https://tools.ietf.org/html/rfc3339#section-5.6
     <https://tools.ietf.org/html/rfc3339#section-5.6>`_).
    :vartype created: ~datetime.datetime
    :ivar authors: Contact details of the people or organization responsible for the image.
    :vartype authors: str
    :ivar url: URL to find more information on the image.
    :vartype url: str
    :ivar documentation: URL to get documentation on the image.
    :vartype documentation: str
    :ivar source: URL to get source code for building the image.
    :vartype source: str
    :ivar version: Version of the packaged software. The version MAY match a label or tag in the
     source code repository, may also be Semantic versioning-compatible.
    :vartype version: str
    :ivar revision: Source control revision identifier for the packaged software.
    :vartype revision: str
    :ivar vendor: Name of the distributing entity, organization or individual.
    :vartype vendor: str
    :ivar licenses: License(s) under which contained software is distributed as an SPDX License
     Expression.
    :vartype licenses: str
    :ivar name: Name of the reference for a target.
    :vartype name: str
    :ivar title: Human-readable title of the image.
    :vartype title: str
    :ivar description: Human-readable description of the software packaged in the image.
    :vartype description: str
    """

    created: Optional[datetime.datetime] = rest_field(
        name="org.opencontainers.image.created",
        visibility=["read", "create", "update", "delete", "query"],
        format="rfc3339",
    )
    """Date and time on which the image was built (string, date-time as defined by
     `https://tools.ietf.org/html/rfc3339#section-5.6
     <https://tools.ietf.org/html/rfc3339#section-5.6>`_)."""
    authors: Optional[str] = rest_field(
        name="org.opencontainers.image.authors",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Contact details of the people or organization responsible for the image."""
    url: Optional[str] = rest_field(
        name="org.opencontainers.image.url",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """URL to find more information on the image."""
    documentation: Optional[str] = rest_field(
        name="org.opencontainers.image.documentation",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """URL to get documentation on the image."""
    source: Optional[str] = rest_field(
        name="org.opencontainers.image.source",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """URL to get source code for building the image."""
    version: Optional[str] = rest_field(
        name="org.opencontainers.image.version",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Version of the packaged software. The version MAY match a label or tag in the
     source code repository, may also be Semantic versioning-compatible."""
    revision: Optional[str] = rest_field(
        name="org.opencontainers.image.revision",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Source control revision identifier for the packaged software."""
    vendor: Optional[str] = rest_field(
        name="org.opencontainers.image.vendor",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Name of the distributing entity, organization or individual."""
    licenses: Optional[str] = rest_field(
        name="org.opencontainers.image.licenses",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """License(s) under which contained software is distributed as an SPDX License
     Expression."""
    name: Optional[str] = rest_field(
        name="org.opencontainers.image.ref.name",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Name of the reference for a target."""
    title: Optional[str] = rest_field(
        name="org.opencontainers.image.title",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Human-readable title of the image."""
    description: Optional[str] = rest_field(
        name="org.opencontainers.image.description",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Human-readable description of the software packaged in the image."""

    @overload
    def __init__(
        self,
        *,
        created: Optional[datetime.datetime] = None,
        authors: Optional[str] = None,
        url: Optional[str] = None,
        documentation: Optional[str] = None,
        source: Optional[str] = None,
        version: Optional[str] = None,
        revision: Optional[str] = None,
        vendor: Optional[str] = None,
        licenses: Optional[str] = None,
        name: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ArtifactManifestPlatform(_Model):
    """The artifact's platform, consisting of operating system and architecture.

    :ivar digest: Manifest digest. Required.
    :vartype digest: str
    :ivar architecture: CPU architecture. Known values are: "386", "amd64", "arm", "arm64", "mips",
     "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", and "wasm".
    :vartype architecture: str or ~azure.containerregistry._generated.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Known values are: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", and "windows".
    :vartype operating_system: str or
     ~azure.containerregistry._generated.models.ArtifactOperatingSystem
    """

    digest: str = rest_field(visibility=["read"])
    """Manifest digest. Required."""
    architecture: Optional[Union[str, "_models.ArtifactArchitecture"]] = rest_field(visibility=["read"])
    """CPU architecture. Known values are: \"386\", \"amd64\", \"arm\", \"arm64\", \"mips\",
     \"mipsle\", \"mips64\", \"mips64le\", \"ppc64\", \"ppc64le\", \"riscv64\", \"s390x\", and
     \"wasm\"."""
    operating_system: Optional[Union[str, "_models.ArtifactOperatingSystem"]] = rest_field(
        name="os", visibility=["read"]
    )
    """Operating system. Known values are: \"aix\", \"android\", \"darwin\", \"dragonfly\",
     \"freebsd\", \"illumos\", \"ios\", \"js\", \"linux\", \"netbsd\", \"openbsd\", \"plan9\",
     \"solaris\", and \"windows\"."""


class ArtifactManifestProperties(_Model):
    """Manifest attributes details.

    :ivar registry_login_server: Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io.
    :vartype registry_login_server: str
    :ivar repository_name: Repository name.
    :vartype repository_name: str
    :ivar manifest: Manifest attributes. Required.
    :vartype manifest: ~azure.containerregistry._generated.models.ManifestAttributesBase
    """

    registry_login_server: Optional[str] = rest_field(name="registry", visibility=["read"])
    """Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io."""
    repository_name: Optional[str] = rest_field(name="imageName", visibility=["read"])
    """Repository name."""
    manifest: "_models.ManifestAttributesBase" = rest_field(visibility=["read"])
    """Manifest attributes. Required."""


class ArtifactTagProperties(_Model):
    """Tag attributes.

    :ivar registry_login_server: Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io. Required.
    :vartype registry_login_server: str
    :ivar repository_name: Image name. Required.
    :vartype repository_name: str
    :ivar tag: List of tag attribute details. Required.
    :vartype tag: ~azure.containerregistry._generated.models.TagAttributesBase
    """

    registry_login_server: str = rest_field(name="registry", visibility=["read"])
    """Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io. Required."""
    repository_name: str = rest_field(name="imageName", visibility=["read"])
    """Image name. Required."""
    tag: "_models.TagAttributesBase" = rest_field(visibility=["read"])
    """List of tag attribute details. Required."""


class ContainerRepositoryProperties(_Model):
    """Properties of this repository.

    :ivar registry_login_server: Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io. Required.
    :vartype registry_login_server: str
    :ivar name: Image name. Required.
    :vartype name: str
    :ivar created_on: Image created time. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Image last update time. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar manifest_count: Number of the manifests. Required.
    :vartype manifest_count: int
    :ivar tag_count: Number of the tags. Required.
    :vartype tag_count: int
    :ivar changeable_attributes: Writeable properties of the resource. Required.
    :vartype changeable_attributes:
     ~azure.containerregistry._generated.models.RepositoryWriteableProperties
    """

    registry_login_server: str = rest_field(name="registry", visibility=["read"])
    """Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io. Required."""
    name: str = rest_field(name="imageName", visibility=["read"])
    """Image name. Required."""
    created_on: datetime.datetime = rest_field(name="createdTime", visibility=["read"], format="rfc3339")
    """Image created time. Required."""
    last_updated_on: datetime.datetime = rest_field(name="lastUpdateTime", visibility=["read"], format="rfc3339")
    """Image last update time. Required."""
    manifest_count: int = rest_field(name="manifestCount", visibility=["read"])
    """Number of the manifests. Required."""
    tag_count: int = rest_field(name="tagCount", visibility=["read"])
    """Number of the tags. Required."""
    changeable_attributes: "_models.RepositoryWriteableProperties" = rest_field(
        name="changeableAttributes",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Writeable properties of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        changeable_attributes: "_models.RepositoryWriteableProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Descriptor(_Model):
    """Docker V2 image layer descriptor including config and layers.

    :ivar media_type: Layer media type.
    :vartype media_type: str
    :ivar size: Layer size.
    :vartype size: int
    :ivar digest: Layer digest.
    :vartype digest: str
    :ivar urls: Specifies a list of URIs from which this object may be downloaded.
    :vartype urls: list[str]
    :ivar annotations: Additional information provided through arbitrary metadata.
    :vartype annotations: ~azure.containerregistry._generated.models.Annotations
    """

    media_type: Optional[str] = rest_field(name="mediaType", visibility=["read", "create", "update", "delete", "query"])
    """Layer media type."""
    size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Layer size."""
    digest: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Layer digest."""
    urls: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies a list of URIs from which this object may be downloaded."""
    annotations: Optional["_models.Annotations"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional information provided through arbitrary metadata."""

    @overload
    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        urls: Optional[list[str]] = None,
        annotations: Optional["_models.Annotations"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FsLayer(_Model):
    """Image layer information.

    :ivar blob_sum: SHA of an image layer.
    :vartype blob_sum: str
    """

    blob_sum: Optional[str] = rest_field(name="blobSum", visibility=["read", "create", "update", "delete", "query"])
    """SHA of an image layer."""

    @overload
    def __init__(
        self,
        *,
        blob_sum: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class History(_Model):
    """A list of unstructured historical data for v1 compatibility.

    :ivar v1_compatibility: The raw v1 compatibility information.
    :vartype v1_compatibility: str
    """

    v1_compatibility: Optional[str] = rest_field(
        name="v1Compatibility",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """The raw v1 compatibility information."""

    @overload
    def __init__(
        self,
        *,
        v1_compatibility: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageSignature(_Model):
    """Signature of a signed manifest.

    :ivar header: A JSON web signature.
    :vartype header: ~azure.containerregistry._generated.models.JWK
    :ivar signature: A signature for the image manifest, signed by a libtrust private key.
    :vartype signature: str
    :ivar protected: The signed protected header.
    :vartype protected: str
    """

    header: Optional["_models.JWK"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON web signature."""
    signature: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A signature for the image manifest, signed by a libtrust private key."""
    protected: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The signed protected header."""

    @overload
    def __init__(
        self,
        *,
        header: Optional["_models.JWK"] = None,
        signature: Optional[str] = None,
        protected: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JWK(_Model):
    """A JSON web signature.

    :ivar jwk: JSON web key parameter.
    :vartype jwk: ~azure.containerregistry._generated.models.JWKHeader
    :ivar alg: The algorithm used to sign or encrypt the JWT.
    :vartype alg: str
    """

    jwk: Optional["_models.JWKHeader"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """JSON web key parameter."""
    alg: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The algorithm used to sign or encrypt the JWT."""

    @overload
    def __init__(
        self,
        *,
        jwk: Optional["_models.JWKHeader"] = None,
        alg: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JWKHeader(_Model):
    """JSON web key parameter.

    :ivar crv: crv value.
    :vartype crv: str
    :ivar kid: kid value.
    :vartype kid: str
    :ivar kty: kty value.
    :vartype kty: str
    :ivar x: x value.
    :vartype x: str
    :ivar y: y value.
    :vartype y: str
    """

    crv: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """crv value."""
    kid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """kid value."""
    kty: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """kty value."""
    x: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """x value."""
    y: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """y value."""

    @overload
    def __init__(
        self,
        *,
        crv: Optional[str] = None,
        kid: Optional[str] = None,
        kty: Optional[str] = None,
        x: Optional[str] = None,
        y: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Manifest(_Model):
    """Returns the requested manifest file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    """

    schema_version: Optional[int] = rest_field(
        name="schemaVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schema version."""

    @overload
    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManifestAttributesBase(_Model):
    """Manifest details.

    :ivar digest: Manifest. Required.
    :vartype digest: str
    :ivar size: Image size.
    :vartype size: int
    :ivar created_on: Created time. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Last update time. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar architecture: CPU architecture. Known values are: "386", "amd64", "arm", "arm64", "mips",
     "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", and "wasm".
    :vartype architecture: str or ~azure.containerregistry._generated.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Known values are: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", and "windows".
    :vartype operating_system: str or
     ~azure.containerregistry._generated.models.ArtifactOperatingSystem
    :ivar related_artifacts: List of artifacts that are referenced by this manifest list, with
     information
     about the platform each supports.  This list will be empty if this is a leaf
     manifest and not a manifest list.
    :vartype related_artifacts:
     list[~azure.containerregistry._generated.models.ArtifactManifestPlatform]
    :ivar config_media_type: Config blob media type.
    :vartype config_media_type: str
    :ivar tags: List of tags.
    :vartype tags: list[str]
    :ivar changeable_attributes: Writeable properties of the resource.
    :vartype changeable_attributes:
     ~azure.containerregistry._generated.models.ManifestWriteableProperties
    """

    digest: str = rest_field(visibility=["read"])
    """Manifest. Required."""
    size: Optional[int] = rest_field(name="imageSize", visibility=["read"])
    """Image size."""
    created_on: datetime.datetime = rest_field(name="createdTime", visibility=["read"], format="rfc3339")
    """Created time. Required."""
    last_updated_on: datetime.datetime = rest_field(name="lastUpdateTime", visibility=["read"], format="rfc3339")
    """Last update time. Required."""
    architecture: Optional[Union[str, "_models.ArtifactArchitecture"]] = rest_field(visibility=["read"])
    """CPU architecture. Known values are: \"386\", \"amd64\", \"arm\", \"arm64\", \"mips\",
     \"mipsle\", \"mips64\", \"mips64le\", \"ppc64\", \"ppc64le\", \"riscv64\", \"s390x\", and
     \"wasm\"."""
    operating_system: Optional[Union[str, "_models.ArtifactOperatingSystem"]] = rest_field(
        name="os", visibility=["read"]
    )
    """Operating system. Known values are: \"aix\", \"android\", \"darwin\", \"dragonfly\",
     \"freebsd\", \"illumos\", \"ios\", \"js\", \"linux\", \"netbsd\", \"openbsd\", \"plan9\",
     \"solaris\", and \"windows\"."""
    related_artifacts: Optional[list["_models.ArtifactManifestPlatform"]] = rest_field(
        name="references", visibility=["read"]
    )
    """List of artifacts that are referenced by this manifest list, with information
     about the platform each supports.  This list will be empty if this is a leaf
     manifest and not a manifest list."""
    config_media_type: Optional[str] = rest_field(
        name="configMediaType",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Config blob media type."""
    tags: Optional[list[str]] = rest_field(visibility=["read"])
    """List of tags."""
    changeable_attributes: Optional["_models.ManifestWriteableProperties"] = rest_field(
        name="changeableAttributes",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Writeable properties of the resource."""

    @overload
    def __init__(
        self,
        *,
        config_media_type: Optional[str] = None,
        changeable_attributes: Optional["_models.ManifestWriteableProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManifestListAttributes(_Model):
    """Attributes of a manifest in a manifest list.

    :ivar media_type: The MIME type of the referenced object. This will generally be
     application/vnd.docker.image.manifest.v2+json, but it could also be
     application/vnd.docker.image.manifest.v1+json.
    :vartype media_type: str
    :ivar size: The size in bytes of the object.
    :vartype size: int
    :ivar digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :vartype digest: str
    :ivar platform: The platform object describes the platform which the image in the manifest runs
     on. A full list of valid operating system and architecture values are listed in
     the Go language documentation for $GOOS and $GOARCH.
    :vartype platform: ~azure.containerregistry._generated.models.Platform
    """

    media_type: Optional[str] = rest_field(name="mediaType", visibility=["read", "create", "update", "delete", "query"])
    """The MIME type of the referenced object. This will generally be
     application/vnd.docker.image.manifest.v2+json, but it could also be
     application/vnd.docker.image.manifest.v1+json."""
    size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The size in bytes of the object."""
    digest: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The digest of the content, as defined by the Registry V2 HTTP API Specification."""
    platform: Optional["_models.Platform"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The platform object describes the platform which the image in the manifest runs
     on. A full list of valid operating system and architecture values are listed in
     the Go language documentation for $GOOS and $GOARCH."""

    @overload
    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        platform: Optional["_models.Platform"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManifestWrapper(Manifest):
    """Returns the requested manifest file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    :ivar media_type: Media type for this Manifest.
    :vartype media_type: str
    :ivar manifests: (ManifestList, OCIIndex) List of V2 image layer information.
    :vartype manifests: list[~azure.containerregistry._generated.models.ManifestListAttributes]
    :ivar config: (V2, OCI) Image config descriptor.
    :vartype config: ~azure.containerregistry._generated.models.Descriptor
    :ivar layers: (V2, OCI) List of V2 image layer information.
    :vartype layers: list[~azure.containerregistry._generated.models.Descriptor]
    :ivar annotations: (OCI, OCIIndex) Additional metadata.
    :vartype annotations: ~azure.containerregistry._generated.models.Annotations
    :ivar architecture: (V1) CPU architecture.
    :vartype architecture: str
    :ivar name: (V1) Image name.
    :vartype name: str
    :ivar tag: (V1) Image tag.
    :vartype tag: str
    :ivar fs_layers: (V1) List of layer information.
    :vartype fs_layers: list[~azure.containerregistry._generated.models.FsLayer]
    :ivar history: (V1) Image history.
    :vartype history: list[~azure.containerregistry._generated.models.History]
    :ivar signatures: (V1) Image signature.
    :vartype signatures: list[~azure.containerregistry._generated.models.ImageSignature]
    """

    media_type: Optional[str] = rest_field(name="mediaType", visibility=["read", "create", "update", "delete", "query"])
    """Media type for this Manifest."""
    manifests: Optional[list["_models.ManifestListAttributes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """(ManifestList, OCIIndex) List of V2 image layer information."""
    config: Optional["_models.Descriptor"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(V2, OCI) Image config descriptor."""
    layers: Optional[list["_models.Descriptor"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """(V2, OCI) List of V2 image layer information."""
    annotations: Optional["_models.Annotations"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """(OCI, OCIIndex) Additional metadata."""
    architecture: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(V1) CPU architecture."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(V1) Image name."""
    tag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(V1) Image tag."""
    fs_layers: Optional[list["_models.FsLayer"]] = rest_field(
        name="fsLayers", visibility=["read", "create", "update", "delete", "query"]
    )
    """(V1) List of layer information."""
    history: Optional[list["_models.History"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(V1) Image history."""
    signatures: Optional[list["_models.ImageSignature"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """(V1) Image signature."""

    @overload
    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
        media_type: Optional[str] = None,
        manifests: Optional[list["_models.ManifestListAttributes"]] = None,
        config: Optional["_models.Descriptor"] = None,
        layers: Optional[list["_models.Descriptor"]] = None,
        annotations: Optional["_models.Annotations"] = None,
        architecture: Optional[str] = None,
        name: Optional[str] = None,
        tag: Optional[str] = None,
        fs_layers: Optional[list["_models.FsLayer"]] = None,
        history: Optional[list["_models.History"]] = None,
        signatures: Optional[list["_models.ImageSignature"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManifestWriteableProperties(_Model):
    """Changeable attributes.

    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    can_delete: Optional[bool] = rest_field(
        name="deleteEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Delete enabled."""
    can_write: Optional[bool] = rest_field(
        name="writeEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Write enabled."""
    can_list: Optional[bool] = rest_field(
        name="listEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """List enabled."""
    can_read: Optional[bool] = rest_field(
        name="readEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Read enabled."""

    @overload
    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MultipartBodyParameter(_Model):
    """The multipart body parameter for AAD token exchange.

    :ivar grant_type: Can take a value of access_token_refresh_token, or access_token, or
     refresh_token. Required. Known values are: "access_token_refresh_token", "access_token", and
     "refresh_token".
    :vartype grant_type: str or
     ~azure.containerregistry._generated.models.PostContentSchemaGrantType
    :ivar service: Indicates the name of your Azure container registry. Required.
    :vartype service: str
    :ivar tenant: AAD tenant associated to the AAD credentials.
    :vartype tenant: str
    :ivar refresh_token: AAD refresh token, mandatory when grant_type is access_token_refresh_token
     or
     refresh_token.
    :vartype refresh_token: str
    :ivar access_token: AAD access token, mandatory when grant_type is access_token_refresh_token
     or
     access_token.
    :vartype access_token: str
    """

    grant_type: Union[str, "_models.PostContentSchemaGrantType"] = rest_field(
        name="grantType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Can take a value of access_token_refresh_token, or access_token, or
     refresh_token. Required. Known values are: \"access_token_refresh_token\", \"access_token\",
     and \"refresh_token\"."""
    service: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates the name of your Azure container registry. Required."""
    tenant: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """AAD tenant associated to the AAD credentials."""
    refresh_token: Optional[str] = rest_field(
        name="refreshToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """AAD refresh token, mandatory when grant_type is access_token_refresh_token or
     refresh_token."""
    access_token: Optional[str] = rest_field(
        name="accessToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """AAD access token, mandatory when grant_type is access_token_refresh_token or
     access_token."""

    @overload
    def __init__(
        self,
        *,
        grant_type: Union[str, "_models.PostContentSchemaGrantType"],
        service: str,
        tenant: Optional[str] = None,
        refresh_token: Optional[str] = None,
        access_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Platform(_Model):
    """The platform object describes the platform which the image in the manifest runs
    on. A full list of valid operating system and architecture values are listed in
    the Go language documentation for $GOOS and $GOARCH.

    :ivar architecture: Specifies the CPU architecture, for example amd64 or ppc64le.
    :vartype architecture: str
    :ivar os: The os field specifies the operating system, for example linux or windows.
    :vartype os: str
    :ivar os_version: The optional os.version field specifies the operating system version, for
     example 10.0.10586.
    :vartype os_version: str
    :ivar os_features: The optional os.features field specifies an array of strings, each listing a
     required OS feature (for example on Windows win32k.
    :vartype os_features: list[str]
    :ivar variant: The optional variant field specifies a variant of the CPU, for example armv6l
     to specify a particular CPU variant of the ARM CPU.
    :vartype variant: str
    :ivar features: The optional features field specifies an array of strings, each listing a
     required CPU feature (for example sse4 or aes.
    :vartype features: list[str]
    """

    architecture: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the CPU architecture, for example amd64 or ppc64le."""
    os: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The os field specifies the operating system, for example linux or windows."""
    os_version: Optional[str] = rest_field(
        name="os.version", visibility=["read", "create", "update", "delete", "query"]
    )
    """The optional os.version field specifies the operating system version, for
     example 10.0.10586."""
    os_features: Optional[list[str]] = rest_field(
        name="os.features", visibility=["read", "create", "update", "delete", "query"]
    )
    """The optional os.features field specifies an array of strings, each listing a
     required OS feature (for example on Windows win32k."""
    variant: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The optional variant field specifies a variant of the CPU, for example armv6l
     to specify a particular CPU variant of the ARM CPU."""
    features: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The optional features field specifies an array of strings, each listing a
     required CPU feature (for example sse4 or aes."""

    @overload
    def __init__(
        self,
        *,
        architecture: Optional[str] = None,
        os: Optional[str] = None,
        os_version: Optional[str] = None,
        os_features: Optional[list[str]] = None,
        variant: Optional[str] = None,
        features: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RepositoryWriteableProperties(_Model):
    """Changeable attributes for Repository.

    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    can_delete: Optional[bool] = rest_field(
        name="deleteEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Delete enabled."""
    can_write: Optional[bool] = rest_field(
        name="writeEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Write enabled."""
    can_list: Optional[bool] = rest_field(
        name="listEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """List enabled."""
    can_read: Optional[bool] = rest_field(
        name="readEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Read enabled."""

    @overload
    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TagAttributesBase(_Model):
    """Tag attribute details.

    :ivar name: Tag name. Required.
    :vartype name: str
    :ivar digest: Tag digest. Required.
    :vartype digest: str
    :ivar created_on: Tag created time. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Tag last update time. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar signed: Is signed.
    :vartype signed: bool
    :ivar changeable_attributes: Writeable properties of the resource. Required.
    :vartype changeable_attributes:
     ~azure.containerregistry._generated.models.TagWriteableProperties
    """

    name: str = rest_field(visibility=["read"])
    """Tag name. Required."""
    digest: str = rest_field(visibility=["read"])
    """Tag digest. Required."""
    created_on: datetime.datetime = rest_field(name="createdTime", visibility=["read"], format="rfc3339")
    """Tag created time. Required."""
    last_updated_on: datetime.datetime = rest_field(name="lastUpdateTime", visibility=["read"], format="rfc3339")
    """Tag last update time. Required."""
    signed: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Is signed."""
    changeable_attributes: "_models.TagWriteableProperties" = rest_field(
        name="changeableAttributes",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """Writeable properties of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        changeable_attributes: "_models.TagWriteableProperties",
        signed: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TagList(_Model):
    """List of tag details.

    :ivar registry_login_server: Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io. Required.
    :vartype registry_login_server: str
    :ivar repository: Image name. Required.
    :vartype repository: str
    :ivar tag_attribute_bases: List of tag attribute details. Required.
    :vartype tag_attribute_bases:
     list[~azure.containerregistry._generated.models.TagAttributesBase]
    :ivar link: Link to the next page of results.
    :vartype link: str
    """

    registry_login_server: str = rest_field(name="registry", visibility=["read", "create", "update", "delete", "query"])
    """Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io. Required."""
    repository: str = rest_field(name="imageName", visibility=["read", "create", "update", "delete", "query"])
    """Image name. Required."""
    tag_attribute_bases: list["_models.TagAttributesBase"] = rest_field(
        name="tags", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of tag attribute details. Required."""
    link: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Link to the next page of results."""

    @overload
    def __init__(
        self,
        *,
        registry_login_server: str,
        repository: str,
        tag_attribute_bases: list["_models.TagAttributesBase"],
        link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TagWriteableProperties(_Model):
    """Changeable attributes.

    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    can_delete: Optional[bool] = rest_field(
        name="deleteEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Delete enabled."""
    can_write: Optional[bool] = rest_field(
        name="writeEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Write enabled."""
    can_list: Optional[bool] = rest_field(
        name="listEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """List enabled."""
    can_read: Optional[bool] = rest_field(
        name="readEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Read enabled."""

    @overload
    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
