# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ArtifactArchitecture(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The artifact platform's architecture."""

    I386 = "386"
    """i386"""
    AMD64 = "amd64"
    """AMD64"""
    ARM = "arm"
    """ARM"""
    ARM64 = "arm64"
    """ARM64"""
    MIPS = "mips"
    """MIPS"""
    MIPS_LE = "mipsle"
    """MIPSLE"""
    MIPS64 = "mips64"
    """MIPS64"""
    MIPS64_LE = "mips64le"
    """MIPS64LE"""
    PPC64 = "ppc64"
    """PPC64"""
    PPC64_LE = "ppc64le"
    """PPC64LE"""
    RISC_V64 = "riscv64"
    """RISCv64"""
    S390_X = "s390x"
    """s390x"""
    WASM = "wasm"
    """Wasm"""


class ArtifactManifestOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sort options for ordering manifests in a collection."""

    NONE = "none"
    """Do not provide an orderby value in the request."""
    LAST_UPDATED_ON_DESCENDING = "timedesc"
    """Order manifests by LastUpdatedOn field, from most recently updated to least
    recently updated."""
    LAST_UPDATED_ON_ASCENDING = "timeasc"
    """Order manifest by LastUpdatedOn field, from least recently updated to most
    recently updated."""


class ArtifactOperatingSystem(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The artifact platform's operating system."""

    AIX = "aix"
    """AIX operating system"""
    ANDROID = "android"
    """Android operating system"""
    DARWIN = "darwin"
    """Darwin operating system"""
    DRAGONFLY = "dragonfly"
    """Dragonfly operating system"""
    FREE_BSD = "freebsd"
    """FreeBSD operating system"""
    ILLUMOS = "illumos"
    """Illumos operating system"""
    I_OS = "ios"
    """iOS operating system"""
    JS = "js"
    """JavaScript operating system"""
    LINUX = "linux"
    """Linux operating system"""
    NET_BSD = "netbsd"
    """NetBSD operating system"""
    OPEN_BSD = "openbsd"
    """OpenBSD operating system"""
    PLAN9 = "plan9"
    """Plan 9 operating system"""
    SOLARIS = "solaris"
    """Solaris operating system"""
    WINDOWS = "windows"
    """Windows operating system"""


class ArtifactTagOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sort options for ordering tags in a collection."""

    NONE = "none"
    """Do not provide an orderby value in the request."""
    LAST_UPDATED_ON_DESCENDING = "timedesc"
    """Order tags by LastUpdatedOn field, from most recently updated to least recently
    updated."""
    LAST_UPDATED_ON_ASCENDING = "timeasc"
    """Order tags by LastUpdatedOn field, from least recently updated to most recently
    updated."""


class PostContentSchemaGrantType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Can take a value of access_token_refresh_token, or access_token, or
    refresh_token.
    """

    ACCESS_TOKEN_REFRESH_TOKEN = "access_token_refresh_token"
    """Grant type for exchanging both access token and refresh token"""
    ACCESS_TOKEN = "access_token"
    """Grant type for exchanging access token only"""
    REFRESH_TOKEN = "refresh_token"
    """Grant type for exchanging refresh token only"""


class TokenGrantType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Grant type is expected to be refresh_token."""

    REFRESH_TOKEN = "refresh_token"
    """Grant type for refreshing the token"""
    PASSWORD = "password"
    """Grant type for password authentication"""
