# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AcceleratorManufacturer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Accelerator manufacturers supported by Azure VMs."""

    AMD = "AMD"
    """AMD GpuType."""
    NVIDIA = "Nvidia"
    """Nvidia GpuType."""
    XILINX = "Xilinx"
    """Xilinx GpuType."""


class AcceleratorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Accelerator types supported by Azure VMs."""

    GPU = "GPU"
    """GPU Accelerator."""
    FPGA = "FPGA"
    """FPGA Accelerator."""


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AllocationStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allocation strategy types for LaunchBulkInstancesOperation."""

    LOWEST_PRICE = "LowestPrice"
    """Default. VM sizes distribution will be determined to optimize for price. Note: Capacity will
    still be considered here but will be given much less weight."""
    CAPACITY_OPTIMIZED = "CapacityOptimized"
    """VM sizes distribution will be determined to optimize for capacity."""
    PRIORITIZED = "Prioritized"
    """VM sizes distribution will be determined to optimize for the 'rank' specified for each vm size."""


class ArchitectureType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Architecture types supported by Azure VMs."""

    ARM64 = "ARM64"
    """ARM64 Architecture."""
    X64 = "X64"
    """X64 Architecture."""


class CachingTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.**
    The default values are: **None for Standard storage. ReadOnly for Premium storage**.
    """

    NONE = "None"
    """Caching type:None."""
    READ_ONLY = "ReadOnly"
    """Caching type:ReadOnly."""
    READ_WRITE = "ReadWrite"
    """Caching type:ReadWrite."""


class CapacityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Capacity types for LaunchBulkInstancesOperation."""

    VM = "VM"
    """Default. VM is the default capacity type for LaunchBulkInstancesOperation where capacity is
    provisioned in terms of VMs."""
    V_CPU = "VCpu"
    """VCpu is the capacity type for LaunchBulkInstancesOperation where capacity is provisioned in
    terms of VCpus. If VCpu capacity is not exactly divisible by VCpu count in VMSizes, capacity in
    VCpus will be overprovisioned by default."""


class CpuManufacturer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cpu Manufacturers  supported by Azure VMs."""

    INTEL = "Intel"
    """Intel CPU."""
    AMD = "AMD"
    """AMD CPU."""
    MICROSOFT = "Microsoft"
    """Microsoft CPU."""
    AMPERE = "Ampere"
    """Ampere CPU."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DeadlineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The types of deadlines supported by Bulkactions."""

    UNKNOWN = "Unknown"
    """Default value of Unknown."""
    INITIATE_AT = "InitiateAt"
    """Initiate the operation at the given deadline."""
    COMPLETE_BY = "CompleteBy"
    """Complete the operation by the given deadline."""


class DeleteOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify what happens to the network interface when the VM is deleted."""

    DELETE = "Delete"
    """Delete network interface when the VM is deleted."""
    DETACH = "Detach"
    """Detach network interface when the VM is deleted."""


class DiffDiskOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the ephemeral disk option for operating system disk."""

    LOCAL = "Local"
    """Local Ephemeral disk option: Local."""


class DiffDiskPlacement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the ephemeral disk placement for operating system disk. This property can be used by
    user in the request to choose the location i.e, cache disk, resource disk or nvme disk space
    for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size
    requirements, please refer Ephemeral OS disk size requirements for Windows VM at
    `https://docs.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
    <https://docs.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements>`_
    and Linux VM at
    `https://docs.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements
    <https://docs.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>`_.
    Minimum api-version for NvmeDisk: 2024-03-01.
    """

    CACHE_DISK = "CacheDisk"
    """CacheDisk disk placement."""
    RESOURCE_DISK = "ResourceDisk"
    """ResourceDisk disk placement."""
    NVME_DISK = "NvmeDisk"
    """NvmeDisk disk placement."""


class DiskControllerTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the disk controller type configured for the VM and VirtualMachineScaleSet. This
    property is only supported for virtual machines whose operating system disk and VM sku supports
    Generation 2 (`https://docs.microsoft.com/en-us/azure/virtual-machines/generation-2
    <https://docs.microsoft.com/en-us/azure/virtual-machines/generation-2>`_), please check the
    HyperVGenerations capability returned as part of VM sku capabilities in the response of
    Microsoft.Compute SKUs api for the region contains V2
    (`https://docs.microsoft.com/rest/api/compute/resourceskus/list
    <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_). For more information about
    Disk Controller Types supported please refer to `https://aka.ms/azure-diskcontrollertypes
    <https://aka.ms/azure-diskcontrollertypes>`_.
    """

    SCSI = "SCSI"
    """SCSI disk controller type."""
    NV_ME = "NVMe"
    """NVMe disk controller type."""


class DiskCreateOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies how the virtual machine disk should be created. Possible values are **Attach:** This
    value is used when you are using a specialized disk to create the virtual machine.
    **FromImage:** This value is used when you are using an image to create the virtual machine. If
    you are using a platform image, you should also use the imageReference element described above.
    If you are using a marketplace image, you should also use the plan element previously
    described. **Empty:** This value is used when creating an empty data disk. **Copy:** This value
    is used to create a data disk from a snapshot or another disk. **Restore:** This value is used
    to create a data disk from a disk restore point.
    """

    FROM_IMAGE = "FromImage"
    """Create disk FromImage."""
    EMPTY = "Empty"
    """Empty value."""
    ATTACH = "Attach"
    """Create disk by Attach."""
    COPY = "Copy"
    """Create disk by Copy."""
    RESTORE = "Restore"
    """Create disk by Restore."""


class DiskDeleteOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the behavior of the managed disk when the VM gets deleted, for example whether the
    managed disk is deleted or detached. Supported values are: **Delete.** If this value is used,
    the managed disk is deleted when VM gets deleted. **Detach.** If this value is used, the
    managed disk is retained after VM gets deleted. Minimum api-version: 2021-03-01.
    """

    DELETE = "Delete"
    """Delete the disk upon VM deletion."""
    DETACH = "Detach"
    """Detach the disk upon VM deletion."""


class DiskDetachOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the detach behavior to be used while detaching a disk or which is already in the
    process of detachment from the virtual machine. Supported values are: **ForceDetach.**
    detachOption: **ForceDetach** is applicable only for managed data disks. If a previous
    detachment attempt of the data disk did not complete due to an unexpected failure from the
    virtual machine and the disk is still not released then use force-detach as a last resort
    option to detach the disk forcibly from the VM. All writes might not have been flushed when
    using this detach behavior. **This feature is still in preview**. To force-detach a data disk
    update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
    """

    FORCE_DETACH = "ForceDetach"
    """ForceDetach the disk."""


class DomainNameLabelScopeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Domain name label scope.The concatenation of the hashed domain name label that generated
    according to the policy from domain name label scope and vm index will be the domain name
    labels of the PublicIPAddress resources that will be created.
    """

    TENANT_REUSE = "TenantReuse"
    """TenantReuse scope type."""
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    """SubscriptionReuse scope type."""
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    """ResourceGroupReuse scope type."""
    NO_REUSE = "NoReuse"
    """NoReuse scope type."""


class EvictionPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Different kind of eviction policies."""

    DELETE = "Delete"
    """When evicted, the Spot VM will be deleted and the corresponding capacity will be updated to
    reflect this."""
    DEALLOCATE = "Deallocate"
    """When evicted, the Spot VM will be deallocated/stopped."""


class HyperVGeneration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HyperVGenerations supported by Azure VMs."""

    GEN1 = "Gen1"
    """Gen1 hyperV."""
    GEN2 = "Gen2"
    """Gen2 hyperV."""


class IPVersions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available from compute Api-Version 2017-03-30 onwards, it represents whether the specific
    ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and
    'IPv6'.
    """

    I_PV4 = "IPv4"
    """IPv4 version."""
    I_PV6 = "IPv6"
    """IPv6 version."""


class LinuxPatchAssessmentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br />
    Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments
    on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic
    patch assessments. The property provisionVMAgent must be true.
    """

    IMAGE_DEFAULT = "ImageDefault"
    """ImageDefault mode."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """AutomaticByPlatform mode."""


class LinuxVMGuestPatchAutomaticByPlatformRebootSetting(  # pylint: disable=name-too-long
    str, Enum, metaclass=CaseInsensitiveEnumMeta
):
    """Specifies the reboot setting for all AutomaticByPlatform patch installation operations."""

    UNKNOWN = "Unknown"
    """Unknown reboot setting."""
    IF_REQUIRED = "IfRequired"
    """Reboot if required."""
    NEVER = "Never"
    """Never reboot."""
    ALWAYS = "Always"
    """Always reboot."""


class LinuxVMGuestPatchMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated
    to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values
    are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is
    used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated
    by the platform. The property provisionVMAgent must be true.
    """

    IMAGE_DEFAULT = "ImageDefault"
    """ImageDefault linux VM guest patch mode."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """AutomaticByPlatform linux VM guest patch mode."""


class LocalStorageDiskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Local storage disk types supported by Azure VMs."""

    HDD = "HDD"
    """HDD DiskType."""
    SSD = "SSD"
    """SSD DiskType."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class Mode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will
    start to audit or monitor but not enforce access control over requests to host endpoints in
    Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce
    mode.
    """

    AUDIT = "Audit"
    """Audit mode."""
    ENFORCE = "Enforce"
    """Enforce mode."""


class Modes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the access
    control policy, including emitting access denial entries in the logs but it does not actually
    deny any requests to host endpoints. In Enforce mode, the system will enforce the access
    control and it is the recommended mode of operation.
    """

    AUDIT = "Audit"
    """Audit mode."""
    ENFORCE = "Enforce"
    """Enforce mode."""
    DISABLED = "Disabled"
    """Disabled mode."""


class NetworkApiVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the Microsoft.Network API version used when creating networking resources in the
    Network Interface Configurations.
    """

    ENUM_2020_11_01 = "2020-11-01"
    """2020-11-01 version."""
    ENUM_2022_11_01 = "2022-11-01"
    """2022-11-01 version."""


class NetworkInterfaceAuxiliaryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the Auxiliary mode is enabled for the Network Interface resource."""

    NONE = "None"
    """None mode."""
    ACCELERATED_CONNECTIONS = "AcceleratedConnections"
    """AcceleratedConnections mode."""
    FLOATING = "Floating"
    """Floating mode."""


class NetworkInterfaceAuxiliarySku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the Auxiliary sku is enabled for the Network Interface resource."""

    NONE = "None"
    """None: None sku."""
    A1 = "A1"
    """A1 sku."""
    A2 = "A2"
    """A2 sku."""
    A4 = "A4"
    """A4 sku."""
    A8 = "A8"
    """A8 sku."""


class OperatingSystemTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the supported type of the OS that application is built for.
    Possible values are: **Windows,** **Linux.**.
    """

    WINDOWS = "Windows"
    """Windows OS."""
    LINUX = "Linux"
    """Linux OS."""


class OperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Values that define the states of operations in BulkActions."""

    UNKNOWN = "Unknown"
    """The default value for the operation state enum."""
    PENDING_SCHEDULING = "PendingScheduling"
    """Operations that are pending scheduling."""
    SCHEDULED = "Scheduled"
    """Operations that have been scheduled."""
    PENDING_EXECUTION = "PendingExecution"
    """Operations that are waiting to be executed."""
    EXECUTING = "Executing"
    """Operations that are in the process of being executed."""
    SUCCEEDED = "Succeeded"
    """Operations that succeeded."""
    FAILED = "Failed"
    """Operations that have failed."""
    CANCELLED = "Cancelled"
    """Operations that have been Cancelled by the user."""
    BLOCKED = "Blocked"
    """Operations that are blocked."""


class OptimizationPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The preferences customers can select to optimize their requests to Bulkactions."""

    COST = "Cost"
    """Optimize while considering cost savings."""
    AVAILABILITY = "Availability"
    """Optimize while considering availability of resources."""
    COST_AVAILABILITY_BALANCED = "CostAvailabilityBalanced"
    """Optimize while considering a balance of cost and availability."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProtocolTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**."""

    HTTP = "Http"
    """Http protocol."""
    HTTPS = "Https"
    """Https protocol."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the LaunchBulkInstancesOperation."""

    CREATING = "Creating"
    """Initial creation in progress."""
    SUCCEEDED = "Succeeded"
    """The operation has completed successfully."""
    FAILED = "Failed"
    """The operation has failed."""
    DELETING = "Deleting"
    """Deletion in progress."""
    CANCELED = "Canceled"
    """The operation has been canceled."""


class PublicIPAddressSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify public IP sku name."""

    BASIC = "Basic"
    """Basic IP sku name."""
    STANDARD = "Standard"
    """Standard IP sku name."""


class PublicIPAddressSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify public IP sku tier."""

    REGIONAL = "Regional"
    """Regional IP address sku tier."""
    GLOBALEnum = "Global"
    """Global IP address sku tier."""


class PublicIPAllocationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify the public IP allocation type."""

    DYNAMIC = "Dynamic"
    """Dynamic IP allocation."""
    STATIC = "Static"
    """Static IP allocation."""


class ResourceOperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of operation types that can be performed on resources eg Virtual Machines, using
    BulkActions.
    """

    UNKNOWN = "Unknown"
    """The default value for this enum type."""
    START = "Start"
    """Start operations on the resources."""
    DEALLOCATE = "Deallocate"
    """Deallocate operations on the resources."""
    HIBERNATE = "Hibernate"
    """Hibernate operations on the resources."""
    CREATE = "Create"
    """Create operations on the resources."""
    DELETE = "Delete"
    """Delete operations on the resources."""


class SecurityEncryptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for
    encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of
    just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the
    VMGuestState blob.. **Note:** It can be set for only Confidential VMs.
    """

    VM_GUEST_STATE_ONLY = "VMGuestStateOnly"
    """VMGuestStateOnly encryption."""
    DISK_WITH_VM_GUEST_STATE = "DiskWithVMGuestState"
    """DiskWithVMGuestState encryption."""
    NON_PERSISTED_TPM = "NonPersistedTPM"
    """NonPersistedTPM encryption."""


class SecurityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the SecurityType of the virtual machine. It has to be set to any specified value to
    enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this
    property is set.
    """

    TRUSTED_LAUNCH = "TrustedLaunch"
    """TrustedLaunch security type."""
    CONFIDENTIAL_VM = "ConfidentialVM"
    """ConfidentialVM security type."""


class SettingNames(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the name of the setting to which the content applies. Possible values are:
    FirstLogonCommands and AutoLogon.
    """

    AUTO_LOGON = "AutoLogon"
    """AutoLogon mode."""
    FIRST_LOGON_COMMANDS = "FirstLogonCommands"
    """FirstLogonCommands mode."""


class StorageAccountTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the storage account type for the managed disk. Managed OS disk storage account type
    can only be set when you create the scale set. NOTE: UltraSSD_LRS can only be used with data
    disks. It cannot be used with OS Disk. Standard_LRS uses Standard HDD. StandardSSD_LRS uses
    Standard SSD. Premium_LRS uses Premium SSD. UltraSSD_LRS uses Ultra disk. Premium_ZRS uses
    Premium SSD zone redundant storage. StandardSSD_ZRS uses Standard SSD zone redundant storage.
    For more information regarding disks supported for Windows Virtual Machines, refer to
    `https://docs.microsoft.com/azure/virtual-machines/windows/disks-types
    <https://docs.microsoft.com/azure/virtual-machines/windows/disks-types>`_ and, for Linux
    Virtual Machines, refer to `https://docs.microsoft.com/azure/virtual-machines/linux/disks-types
    <https://docs.microsoft.com/azure/virtual-machines/linux/disks-types>`_.
    """

    STANDARD_LRS = "Standard_LRS"
    """Standard_LRS storage account type."""
    PREMIUM_LRS = "Premium_LRS"
    """Premium_LRS storage account type."""
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    """StandardSSD_LRS storage account type."""
    ULTRA_SSD_LRS = "UltraSSD_LRS"
    """UltraSSD_LRS storage account type."""
    PREMIUM_ZRS = "Premium_ZRS"
    """Premium_ZRS storage account type."""
    STANDARD_SSD_ZRS = "StandardSSD_ZRS"
    """StandardSSD_ZRS storage account type."""
    PREMIUM_V2_LRS = "PremiumV2_LRS"
    """PremiumV2_LRS storage account type."""


class VirtualMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the priority type of virtual machines to launch."""

    REGULAR = "Regular"
    """Default. Regular/On-demand VMs will be launched."""
    SPOT = "Spot"
    """Spot VMs will be launched."""


class VMAttributeSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VMSizes supported by Azure VMs. Included is a union of Excluded and Required."""

    EXCLUDED = "Excluded"
    """All VMSizes having the feature support will be excluded."""
    INCLUDED = "Included"
    """ VMSizes that have the feature support and that do not have the feature support will be used.
    Included is a union of Excluded and Required."""
    REQUIRED = "Required"
    """Only the VMSizes having the feature support will be used."""


class VMCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """

    .. code-block:: indented

         VMCategories defined for Azure VMs.
         See:
    https://learn.microsoft.com/en-us/azure/virtual-machines/sizes/overview?tabs=breakdownseries%2Cgeneralsizelist%2Ccomputesizelist%2Cmemorysizelist%2Cstoragesizelist%2Cgpusizelist%2Cfpgasizelist%2Chpcsizelist#general-purpose.
    """

    GENERAL_PURPOSE = "GeneralPurpose"
    """
    
    .. code-block:: indented
    
       General purpose VM sizes provide balanced CPU-to-memory ratio. Ideal for testing and
    development, small to medium databases, and low to medium traffic web servers."""
    COMPUTE_OPTIMIZED = "ComputeOptimized"
    """
    
    .. code-block:: indented
    
       Compute optimized VM sizes have a high CPU-to-memory ratio. These sizes are good for medium
    traffic web servers, network appliances, batch processes, and application servers."""
    MEMORY_OPTIMIZED = "MemoryOptimized"
    """
    
    .. code-block:: indented
    
       Memory optimized VM sizes offer a high memory-to-CPU ratio that is great for relational
    database servers, medium to large caches, and in-memory analytics."""
    STORAGE_OPTIMIZED = "StorageOptimized"
    """
    
    .. code-block:: indented
    
       Storage optimized virtual machine (VM) sizes offer high disk throughput and IO, and are
    ideal for Big Data, SQL, NoSQL databases, data warehousing, and large transactional databases.
       Examples include Cassandra, MongoDB, Cloudera, and Redis."""
    GPU_ACCELERATED = "GpuAccelerated"
    """
    
    .. code-block:: indented
    
       GPU optimized VM sizes are specialized virtual machines available with single, multiple, or
    fractional GPUs.
       These sizes are designed for compute-intensive, graphics-intensive, and visualization
    workloads."""
    FPGA_ACCELERATED = "FpgaAccelerated"
    """
    
    .. code-block:: indented
    
       FPGA optimized VM sizes are specialized virtual machines available with single or multiple
    FPGA.
       These sizes are designed for compute-intensive workloads. This article provides information
    about the number and type of FPGA, vCPUs, data disks, and NICs.
       Storage throughput and network bandwidth are also included for each size in this grouping."""
    HIGH_PERFORMANCE_COMPUTE = "HighPerformanceCompute"
    """
    
    .. code-block:: indented
    
       Azure High Performance Compute VMs are optimized for various HPC workloads such as
    computational fluid dynamics, finite element analysis, frontend and backend EDA,
       rendering, molecular dynamics, computational geo science, weather simulation, and financial
    risk analysis."""


class VMOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Virtual Machine operation status values."""

    CREATING = "Creating"
    """Indicates that the virtual machine is either in the process of being created or is scheduled to
    be created."""
    CANCELED = "Canceled"
    """Indicates that the cancellation request was successful because the virtual machine had not been
    created yet."""
    CANCEL_FAILED_STATUS_UNKNOWN = "CancelFailedStatusUnknown"
    """Indicates that the cancellation request could not be applied because the virtual machine had
    already been created."""
    FAILED = "Failed"
    """Indicates that the virtual machine operation failed."""
    SUCCEEDED = "Succeeded"
    """Indicates that the virtual machine operation completed successfully."""
    DELETING = "Deleting"
    """Indicates that the virtual machine is being deleted."""
    CANCELLING = "Cancelling"
    """Indicates that the virtual machine operation is being cancelled."""


class WindowsPatchAssessmentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br />
    Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments
    on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic
    patch assessments. The property provisionVMAgent must be true.
    """

    IMAGE_DEFAULT = "ImageDefault"
    """ImageDefault patch assessment mode."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """AutomaticByPlatform patch assessment mode."""


class WindowsVMGuestPatchAutomaticByPlatformRebootSetting(  # pylint: disable=name-too-long
    str, Enum, metaclass=CaseInsensitiveEnumMeta
):
    """Specifies the reboot setting for all AutomaticByPlatform patch installation operations."""

    UNKNOWN = "Unknown"
    """Reboot setting for Unknown."""
    IF_REQUIRED = "IfRequired"
    """Reboot setting for IfRequired."""
    NEVER = "Never"
    """Reboot setting for Never."""
    ALWAYS = "Always"
    """Reboot setting for Always."""


class WindowsVMGuestPatchMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated
    to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values
    are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You
    do this by applying patches manually inside the VM. In this mode, automatic updates are
    disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br />
    **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
    WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform**
    - the virtual machine will automatically updated by the platform. The properties
    provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true.
    """

    MANUAL = "Manual"
    """Manual VM guest patch mode."""
    AUTOMATIC_BY_OS = "AutomaticByOS"
    """AutomaticByOS VM guest patch mode."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """AutomaticByPlatform VM guest patch mode."""


class ZoneDistributionStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Distribution strategies for LaunchBulkInstancesOperation zone allocation policy."""

    BEST_EFFORT_SINGLE_ZONE = "BestEffortSingleZone"
    """
    
    .. code-block:: indented
    
       Default. Launch instances in a single zone based on best effort.
       If capacity is not available, LaunchBulkInstancesOperation can allocate capacity in
    different zones."""
    PRIORITIZED = "Prioritized"
    """
    
    .. code-block:: indented
    
       Launch instances based on zone preferences.
       Higher priority zones are filled first before allocating to lower priority zones."""
    BEST_EFFORT_BALANCED = "BestEffortBalanced"
    """
    
    .. code-block:: indented
    
       Balance launching instances across zones specified based on best effort.
       If capacity is not available, LaunchBulkInstancesOperation can deviate balancing across all
    zones."""
    STRICT_BALANCED = "StrictBalanced"
    """Launch instances across all provided zones, ensuring the difference between any two zones is no
    more than one instance."""
