

# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Optional, Dict, List


class api_version_validation:
    def __init__(
        self,
        *,
        api_versions: Optional[List[str]] = None,
        params: Optional[Dict[str, List[str]]] = None,
    ):
        self.api_versions = api_versions or []
        self.params = params or {}

    def __call__(self, func):
        api_versions = self.api_versions
        params = self.params
        def wrapper(self, *args, **kwargs):
            func_name = func.__name__
            if hasattr(self, "_get_api_version"):
                client_api_version = self._get_api_version(func_name)
            else:
                client_api_version = self._api_version
            if api_versions and client_api_version not in api_versions:
                raise ValueError(
                    f"'{func_name}' is not available in API version "
                    f"{client_api_version}. Pass service API version {api_versions[0]} or newer to your client."
                )
            unsupported = [
                parameter
                for parameter, api_versions in params.items()
                if parameter in kwargs and client_api_version not in api_versions
            ]
            if unsupported:
                raise ValueError(
                    "".join(
                        [
                            f"'{param}' is not available in API version {client_api_version}. "
                            f"Use service API version {params[param][0]} or newer.\n"
                            for param, version in unsupported
                        ]
                    )
                )
            return func(self, *args, **kwargs)

        return wrapper
