# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class LastModifiedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that last modified the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the resource.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class TokenCertificateName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    CERTIFICATE1 = "certificate1"
    CERTIFICATE2 = "certificate2"

class TokenPasswordName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The password name "password1" or "password2"
    """

    PASSWORD1 = "password1"
    PASSWORD2 = "password2"

class TokenStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the token example enabled or disabled.
    """

    ENABLED = "enabled"
    DISABLED = "disabled"
