# Google OAuth Client Library for Java

## <a name='maintenance'>Library maintenance</a>

This client library is supported but in maintenance mode only. We are fixing necessary bugs and
adding essential features to ensure this library continues to meet your needs for accessing Google
APIs. Non-critical issues will be closed. Any issue may be reopened if it is causing ongoing
problems.

## Description

Written by Google, the Google OAuth Client Library for Java is a powerful and easy-to-use Java
library for the OAuth 1.0a and OAuth 2.0 authorization standards. The Google OAuth Client Library
for Java is designed to work with any OAuth service on the web, not just with Google APIs. It is
built on the [Google HTTP Client Library for Java](https://github.com/googleapis/google-http-java-client).

The library supports the following Java environments:

- Java 7 (or higher)
- Android 4.0 (Ice Cream Sandwich) (or higher)
- Google App Engine

For access to Google APIs, see the
[Google APIs Client Library for Java](https://github.com/googleapis/google-api-java-client).

This is an open-source library, and [contributions](CONTRIBUTING.md) are welcome.

## Documentation

- [Developer's Guide](https://github.com/googleapis/google-oauth-java-client/wiki)
- [Setup Instructions](https://github.com/googleapis/google-oauth-java-client/wiki/Setup-Instructions)
- [Samples](https://github.com/googleapis/google-oauth-java-client/tree/main/samples)
- [JavaDoc](https://googleapis.dev/java/google-oauth-client/latest/)
- [Release Notes](https://github.com/googleapis/google-oauth-java-client/releases)
- [Support (Questions, Bugs)](https://github.com/googleapis/google-oauth-java-client/issues)

## CI Status

Java Version | Status
------------ | ------
Java 7 | [![Kokoro CI](http://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java7.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java7.html)
Java 8 | [![Kokoro CI](http://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java8.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java8.html)
Java 11 | [![Kokoro CI](http://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java11.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java11.html)
