.\" Copyright (c) 1993, 1999 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH file-pr 8 "November 2002" "GNATS @VERSION@" "GNATS Internal Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
file-pr \- files incoming problem reports in GNATS database
.SH SYNOPSIS
.hy 0
.na
.B file\-pr
[
.B \-f \fIfile\fB 
| 
.B \-\-file=\fIfile\fB
]
[
.B \-h 
| 
.B \-\-help
]
.br
[
.B \-V 
| 
.B \-\-version
]
[
.BI -H \ host
|
.BI --host= host
]
.br
[
.BI -P \ port
|
.BI --port= port
]
[
.BI -v \ user
|
.BI --user= user
]
.br
[
.BI -w \ password
|
.BI --passwd= password
]
.br
[
.BI -d \ databasename
|
.BI --database= databasename
]

.ad b
.hy 1
.SH DESCRIPTION
\fBfile-pr\fR files incoming Problem Reports in the GNATS
database, sends acknowledgments to approriate parties and logs
database activity.
.P
\fBfile-pr\fR assigns the Problem Report an identification number and
then files it in the GNATS database either under the category
specified in the Category field of the PR, or under the default
category if the Category field is nonexistent or contains an invalid
category name.
.P
For the default GNATS configuration, the person responsible for that
category and the person responsible for the submitter site where the
PR originated receive a copy of the PR in its entirety.  Optionally,
the originator of the PR receives an acknowledgment that the PR
arrived and was filed
.SH OPTIONS
.TP
.B \-f \fIfile\fB, \-\-filename=\fIfile\fB
Accept
.I file
as input; if this option is not present, standard input is used.
.TP
.B \-h, \-\-help
Display usage summary for
.BR file\-pr .
.TP
.B \-V, \-\-version
Display version number for
.BR file\-pr .
.TP
.B -d\fR,\fB --database
Specifies the database to which the PR is to be submitted.  If no
database is specified, the database named \fIdefault\fR is assumed.
This option overrides the database specified in the \fBGNATSDB\fR
environment variable.
.SS
GNATS network options:
.TP
.B -H\fR,\fB --host
Hostname of the GNATS server.
.TP
.B -P\fR,\fB --port
The port that the GNATS server runs on.
.TP
.B -v\fR,\fB --username
Username used to log into the GNATS server.
.TP
.B -w\fR,\fB --passwd
Password used to log into the GNATS server.
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database, in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted, but at least one colon must appear;
otherwise, the value is assumed to be the name of a local database.
.P
If \fBGNATSDB\fR is not set, it is assumed that the database is local
and that its name is \fIdefault\fR.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 1993, 1999, 2002, Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
