!include "MUI2.nsh"
!include "WriteEnvStr.nsh"

Name "Ball and Paddle"
OutFile "BallAndPaddle-Install-0.8.1.exe"
SetCompressor /SOLID "lzma"

InstallDir "$PROGRAMFILES\Ball and Paddle"

InstallDirRegKey HKCU "Software\Ball and Paddle" ""

RequestExecutionLevel user

Var StartMenuFolder

!define MUI_ABORTWARNING

;!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY

!define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\Ball and Paddle"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"

!insertmacro MUI_PAGE_STARTMENU Application $StartMenuFolder
!insertmacro MUI_PAGE_INSTFILES
;!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
;!insertmacro MUI_UNPAGE_FINISH

!insertmacro MUI_LANGUAGE "English"

Section
  SetOutPath "$INSTDIR"
  File /r "ballandpaddle-0.8.1/*"

  Push "GUILE_LOAD_PATH"
  Push "$INSTDIR"
  Call WriteEnvStr
  WriteRegStr HKCU "Software\Ball and Paddle" "" $INSTDIR

  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Ball and Paddle" "DisplayName" "Ball and Paddle"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Ball and Paddle" "UninstallString" "$\"$INSTDIR\Uninstall.exe$\""

  WriteUninstaller "$INSTDIR\Uninstall.exe"

  CreateShortCut "$DESKTOP\Ball and Paddle.lnk" "$INSTDIR\ballandpaddle.exe" ""

  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
    CreateDirectory "$SMPROGRAMS\Ball and Paddle"
    CreateShortCut "$SMPROGRAMS\Ball and Paddle\Ball and Paddle.lnk" "$INSTDIR\ballandpaddle.exe" ""
    CreateShortCut "$SMPROGRAMS\Ball and Paddle\Uninstall.exe.lnk" "$INSTDIR\Uninstall.exe" ""
  !insertmacro MUI_STARTMENU_WRITE_END

SectionEnd

Section "Uninstall"
  RMDir /r "$INSTDIR"

  !insertmacro MUI_STARTMENU_GETFOLDER Application $StartMenuFolder

  Delete "$DESKTOP\Ball and Paddle.lnk"
  RMDir /r "$SMPROGRAMS\$StartMenuFolder"

  DeleteRegKey HKEY_LOCAL_MACHINE "Software\Ball and Paddle"

  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Ball and Paddle"

SectionEnd

