/* 
 * prototypes and std includes
 * 
 * 
 */
#include <types.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <varargs.h>
#include <md5lib.h>

#ifdef __MINT__
#include <support.h>
#include <portlib.h>
#include <sys/socket.h>
#endif

#if defined (_mainPOP3) || defined (_pop3POP3) || defined(_cmdsPOP3)
#include <signal.h>
#include <netdb.h>
#include <time.h>
#include <netinet/in.h>
#endif

#if defined (_mainPOP3) || defined (_pop3POP3)
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/file.h>
#include <arpa/inet.h>
#endif

#ifndef FALSE
#define FALSE	0
#define TRUE	1
#endif

#include "pathnames.h"
#include "pop3_var.h"

/* main.c */
void usagehelp(void);
void usage(char c, char *arg);
void myerror(char *msg, int num);
void fatal(char *msg, char *msg2, int error);
void getmydomain(void);
sig_t intr(void);
sig_t lostpeer(void);
void cmdscanner(int top);
struct cmd *getcmd(char *name);
void makeargv(void);
char *slurpstring(void);
int help(int argc, char *argv[]);
char *rfc822_time(char *buf);
void make_id_prefix();

/* cmds.c */
int setpeer(int argc, char *argv[]);
char *onoff(int bool);
int showstatus(int argc, char *argv[]);
int setbell(int argc, char *argv[]);
int setverbose(int argc, char *argv[]);
int setautodeliver(int argc, char *argv[]);
int setdebug(int argc, char *argv[]);
int usrpass(int argc, char **argv);
int apop(int argc, char **argv);
int getstatus(int argc, char *argv[]);
int list(int argc, char *argv[]);
int uidl(int argc, char *argv[]);
int retrieve(int argc, char *argv[]);
int delete(int argc, char *argv[]);
int last(int argc, char *argv[]);
int reset(int argc, char *argv[]);
int top(int argc, char *argv[]);
int sethost(int argc, char *argv[]);
int disconnect(void);
int getall(int argc, char *argv[]);
int deliver(int argc, char *argv[]);
int printlist(int argc, char *argv[]);
void quit(void);

/* cmdtab.c */
int lock_retrieve(int mode);

/* getpass.c */
char *getpass(char *prompt);

/* pop3.c */
char *hookup(char *host, int port);
int login(char *host);
sig_t cmdabort(void);
int getreply(int expectnumber);
int multiline(void);
int do_retrieve(char *m_id);
int get_mails(int deletem);
MSGLIST *add_2list(char *id1, char *id2, char *uidl);
int do_deliver(char *to, int to_uid, char *box, char *cmd);
int deliver_by(FILE *the_message, char *box, char *recip, int n_uid, char *cmd);
int store_in_box(FILE *the_message, char* box);
int do_printlist(void);
int savelist(void);
int do_deliverqueue(char *to, int to_uid, char *box, char *cmd);
int lockfmsg(void);
#ifndef _pop3POP3
int logmessage(int what, ... );
int command(int resp, char  *fmt, ...);
#endif

/* ruserpass.c */
int mruserpass(char *host, char **auser, char **apass, char **aname, char **aacct);

/* eof */
