/*
 */
#define _pop3POP3

#ifdef SCCS
static char sccsid[] = "@(#)pop3.c, pop3 (j.g.geiger) 95/12/08";
#endif

#include "pop3.h"

#include <support.h>
#include <wait.h>


#ifdef NOVFPRINTF
#define vfprintf(a,b,c) _doprnt(b,c,a)
#endif


struct	sockaddr_in	hisctladdr;

int	abrtflag = 0;

struct	sockaddr_in myctladdr;
uid_t	getuid();
sig_t	lostpeer();

FILE	*cin, *cout;



/* 
 * the following variables are pointers to buffers
 * allocated by modified ruserpass() and are used for authentication
 * pass and secret buffers are zeroed after usage.
 * user and pass are used for USER/PASS; name and secret are used for APOP
 */

char *r_user;	/* readable for show command !	*/
static char  *user, *pass, *name, *secret; /* all NULL ! */
	/* the used hostname (after resolving address)	*/
static char hostnamebuf[MAXHOSTNAMELEN+1];

/* 
 * In a POP3 communication the server replies always with a 
 * status line. In a non-multi-line reply there is access to this
 * reply-string : var reply-string
 * The first token (reply-code) is to find as PSI or NSI in var code.
 * Sometimes it includes one or two numerical values
 * put to reply_dig[0] and [1] by the client if
 * func command() was called with a value 1 or 2 in arg1.
 * The pointer reply_tok points to the remaining tokens or EOS in
 * var reply_string.
 */

static char reply_string[BUFSIZ];		/* last line of previous reply */
long reply_dig[2];
char *reply_tok;

 /* apop_id is a pointer to an allocated buffer holding the
  * "timestamp" string from the server's greeting.
  */

char *apop_id = NULL;

char *hookup(host, port)
	char *host;
	int port;
{
	register struct hostent *hp = 0;
	int s,len, apop_succ, n;
	char hostnbuf[80];
	char *p, *p1;

	if(user) {free(user); user = NULL;}
	if(pass) {free(pass); pass = NULL;}
	if(name) {free(name); name = NULL;}
	if(secret) {free(secret); secret = NULL;}

	if(!host) {	/* use default/mailserver from ~/.poprc	*/
		hostname = host = hostnbuf;
		*host = '\0';
		if (mruserpass(host, &user, &pass, &name, &secret) < 0) {
			code = -1;
			return(0);
		}
		if(!*host) {
			code = -1;
			return(0);
		}
	} 


	bzero((char *)&hisctladdr, sizeof (hisctladdr));
	hisctladdr.sin_addr.s_addr = inet_addr(host);
	if (hisctladdr.sin_addr.s_addr != -1) {
		hisctladdr.sin_family = AF_INET;
		(void) strncpy(hostnamebuf, host, sizeof(hostnamebuf));
	} else {
		hp = gethostbyname(host);
		if (hp == NULL) {
			fprintf(stderr, "pop3: %s: ", host);
			herror((char *)NULL);
			code = -1;
			return((char *) 0);
		}
		hisctladdr.sin_family = hp->h_addrtype;
		bcopy(hp->h_addr_list[0],
		    (caddr_t)&hisctladdr.sin_addr, hp->h_length);
		(void) strncpy(hostnamebuf, hp->h_name, sizeof(hostnamebuf));
	}
	hostname = hostnamebuf;
	s = socket(hisctladdr.sin_family, SOCK_STREAM, 0);
	if (s < 0) {
		myerror("socket", errno);
		code = -1;
		return (0);
	}
	hisctladdr.sin_port = port;
	while (connect(s, (struct sockaddr *)&hisctladdr, sizeof (hisctladdr)) < 0) {
		if (hp && hp->h_addr_list[1]) {
			int oerrno = errno;

			fprintf(stderr, "pop3: connect to address %s: ",
				inet_ntoa(hisctladdr.sin_addr));
			errno = oerrno;
			myerror("", errno);
			hp->h_addr_list++;
			bcopy(hp->h_addr_list[0],
			     (caddr_t)&hisctladdr.sin_addr, hp->h_length);
			fprintf(stdout, "Trying %s...\n",
				inet_ntoa(hisctladdr.sin_addr));
			(void) close(s);
			s = socket(hisctladdr.sin_family, SOCK_STREAM, 0);
			if (s < 0) {
				myerror("socket", errno);
				code = -1;
				return (0);
			}
			continue;
		}
		myerror("connect", errno);
		code = -1;
		goto bad;
	}
	len = sizeof (myctladdr);
	if (getsockname(s, (struct sockaddr *)&myctladdr, &len) < 0) {
		myerror("getsockname", errno);
		code = -1;
		goto bad;
	}
	cin = fdopen(s, "r");
	cout = fdopen(s, "w");
	if (cin == NULL || cout == NULL) {
		fprintf(stderr, "pop3: fdopen failed.\n");
		if (cin)
			(void) fclose(cin);
		if (cout)
			(void) fclose(cout);
		code = -1;
		goto bad;
	}
	if (verbose)
		printf("Connected to %s (%s,%d).\n", hostname, 
		inet_ntoa(hisctladdr.sin_addr),(int)hisctladdr.sin_port);

	connected = CONNECTED;	

	logmessage(LOGCONNECTED);

	if (getreply(0) != PSI) { 	/* read startup message from server */
		if (cin)
			(void) fclose(cin);
		if (cout)
			(void) fclose(cout);
		code = -1;	/* overwrite NSI : serious error	*/
		goto bad;
	} else {	/* and find the APOP_id string in there */
		apop_succ = FALSE;
		p = strtok(reply_string, " \t\r\n");
		while(p) {
			if(*p == '<') {	/* I really don't know how to identify 
								the apop time-stamp string in the banner 
								greeting; maybe test hostname */
				if(apop_id = malloc(strlen(p)+1)) {
					strcpy(apop_id, p);
					if(p1 = strrchr(p, '>')) {
						*p1 = '\0';
						if(p1 = strrchr(p, '@'))
							if(!strcasecmp(p1, hostname))
								apop_succ = TRUE;
					}
					if(!apop_succ) {	/* free and zero apop_id !?	*/
						myerror("bad APOP timestamp", 0);
					}
				} else
					myerror("no mem for APOP timestamp", errno);
			}
			p = strtok(NULL, " \t\r\n");
		}
		
		connected = AUTHORI;
	}
#ifdef SO_OOBINLINE
	{
	int on = 1;

	if (setsockopt(s, SOL_SOCKET, SO_OOBINLINE, &on, sizeof(on))
		< 0 && debug) {
			myerror("setsockopt", errno);
		}
	}
#endif SO_OOBINLINE

	return (hostname);
bad:
	(void) close(s);
	return ((char *)0);
}

	/* auto-login function	*/
login(host)
	char *host;
{
	char tmp[80], *p;
	char *getlogin(), *getpass();
	int n, aflag = 0;

	reply_tok = "";	/* reset from greeting	*/
	
	if(!name && !user) {
		if (mruserpass(host, &user, &pass, &name, &secret) < 0) {
			code = -1;
			logmessage(LOGLOGFAIL);
			myerror("Login failed.", 0);
			return(0);
		}
	}
	if( (apop_id && !name) || (!apop_id && !user) ){
		if(interactive < 2) {
			code = -1;
			logmessage(LOGLOGFAIL);
			return(0);
		}	
		do {
			char *myname = getlogin();

			if (myname == NULL)
				myname = the_user;

			if(apop_id) {
				printf("APOP time-stamp authentication ? (y/n) ");
				n = fgetc(stdin);
			} else
				n = 0;
			if( n == 'y' || n == 'Y' || n == '\r') {
				printf("Name %s ? ", myname ? myname : "");
				n = 1;
			} else {
				if (myname)
					printf("User (%s@%s)? ", myname, host);
				else
					printf("User (?@%s): ", host);
			}
			(void) fgets(tmp, sizeof(tmp) - 1, stdin);
			tmp[strlen(tmp) - 1] = '\0';
			if(n)
				name = (*tmp == '\0') ? myname : tmp;
			else
				user = (*tmp == '\0') ? myname : tmp;
		} while ((name == NULL) && (user == NULL)) ;
	}
	/* command APOP <NAME> <DIGEST> */
	if(name && apop_id) {
		if(!secret)
			secret = getpass("Secret:");
		if( secret && (p = malloc(strlen(apop_id)+strlen(secret)+1)) ) {
			strcpy(p, apop_id);
			strcat(p, secret);
			n = command(0, "APOP %s %s", name, MD5digest(p, NULL));
			bzero(p, strlen(p));
			bzero(secret, strlen(secret));
			free(p);
			if (n )
				if(r_user = malloc(strlen(name)+1))
					strcpy(r_user,name);
		} else 
			code = -1;
	} else {
		if (command(0, "USER %s", user)) {
			if (pass == NULL)
				pass = getpass("Password:");
			if (command(0, "PASS %s", pass))
				if(r_user = malloc(strlen(user)+1))
					strcpy(r_user,user);
		}

	}
	if (code != PSI) {
		myerror("Login failed.", 0);
		logmessage(LOGLOGFAIL);
		return (0);
	}

	connected = TRANSACT;
	
	return (1);
}




sig_t
cmdabort()
{
	if(debug)
			printf("\npop3: SIGINT received\n");
	else
		printf("\n");
	(void) fflush(stdout);
	abrtflag++;
}



#include <ctype.h>

/* getreply()
 * Reads the first line of a possible multi-line reply.
 * The command-functions should know to handle multiline replies!
 * returns PSI or NSI (positive or negative success indicator)
 *  : positive ("+OK") and negative ("-ERR")
 * The complete reply-string (without the CRLF EOL) is stored in
 * buffer reply_string. 
 */

int getreply(int expectnumber)
{
	register int c, rtok, expecteol, i;
	long *dig;
	register char *cp;
	sig_t (*oldintr)();

	oldintr = signal(SIGINT,cmdabort);

	reply_dig[0] = 0;
	reply_dig[1] = 0;
	dig = &reply_dig[0];
	rtok = code = 0;
	cp = reply_string;
	reply_tok = cp;
	*cp = '\0';
	
	for (i = 0;;) {
		while ((c = getc(cin)) != '\n') {
			expecteol = FALSE;
			if (c == EOF) {
				lostpeer();
				return(code = LSP);
			}
			if( c == '\r' )
				expecteol = TRUE;
			else {		/* if (c != '\r') */
				if ( verbose > 0 )
					(void) putchar(c);
				if(i < sizeof(reply_string)) {
					*cp++ = c; i++;
				}
			}

			if(!code) {
				if ( c == '+')
					code = PSI;
				else if (c == '-')
					code = NSI;
			} else {
				if((c == ' ')||(c == '\t')) { /* ||expecteol */
					if(expectnumber) {
						if (rtok <= expectnumber)
							reply_tok = cp;
						if(rtok == 1)
							dig++;	/* second token follows now */
					}
					rtok++;
					if(rtok == 1)
						reply_tok = cp;
				} else {
					if( (expectnumber >= rtok) && (code == PSI) ) {
						/* extract digit1 and maybe digit2	*/
						if (isdigit(c))
							*dig = *dig * 10 + (c - '0');
					}
				}
			}
		}	/* endwhile */
		if(expecteol)
			break;
		else {
			if (verbose > 0)
				(void) putchar(c);
			rtok++;
		}
	}
	 
	if (verbose > 0) {
		(void) putchar(c);
		(void) fflush (stdout);
	}
	*cp = '\0';
	if(!code) {
		myerror("bad reply sequence from server", 0);
		if(!verbose)
			fprintf(stderr, " %s\n", reply_string);
	}
	if(debug)	
		printf("reply tokens:values: %d val1>%ld< val2 >%ld< >%s<\n", 
			expectnumber, reply_dig[0], reply_dig[1], reply_tok);
		
	(void) signal(SIGINT,oldintr);
	return(code);
}

/* 
 * read & print a multi-line response
 * 
 * 
 */

int multiline()
{
	register int c, expectend;
	sig_t (*oldintr)();


	oldintr = signal(SIGINT,cmdabort);

	expectend = 2;	/* we start with the last line's \r\n */
	
	for (;;) {
		while ((c = getc(cin)) != '\n') {
			if (c == EOF) {
				lostpeer();
				return(LSP);
			}
			if(expectend) {
				if((c == '.') && (expectend == 2))
					expectend++;
				else if((c == '\r') && (expectend == 3))
					expectend++;
				else
					expectend = 0;
			}
			if(!expectend) {
				if (c != '\r' && (verbose > 0) )
					(void) putchar(c);

				if( c == '\r' )
					expectend++;
			}
			
		}	/* while	*/
		expectend++;
		if(expectend == 5)
			break;
		else {
			if (verbose > 0)
				(void) putchar(c);
		}
	}
	 
	if (verbose > 0) {
		/* (void) putchar(c); */
		(void) fflush (stdout);
	}
	(void) signal(SIGINT,oldintr);
	return(0);
}

static int bufsize = 1024;
static char buf[1024];
static char receivestr[1024];
static int hasuidl = 0;

int do_retrieve(char *m_id)
{
	sig_t (*oldintr)();

	register char *cp;
	FILE *f_message;
	MSGLIST *thismsg;
	char fname[256];
	long bytes = 0, sbytes = 0;
	int n, c, d, r;
	int expectend;
	int receive = 0;

	/* message id and list entry	*/
	if(hasuidl >= 0) {
		if(!command(1, "UIDL %s", m_id) ) {
			if(hasuidl)
				return(FALSE); /* else hasuidl == 0 */
		} else {
			hasuidl = 1;
			thismsg = add_2list(id_prefix, m_id, reply_tok);
		}
	}
	if(hasuidl <= 0)
		thismsg = add_2list(id_prefix, m_id, NULL);
	if(!thismsg)
		return(-1);
	
	/* open spool file	*/
	sprintf(fname, "%s/%s", spooldir, thismsg->id);
	if(! (f_message = fopen(fname, "w")) ) {
		fprintf(stderr, "%s: can't open spoolfile '%s' %s\n", myname, 
			fname, strerror(errno));
		code = -1;
		return(FALSE);
	}
		
	/* make Received: string */
	rfc822_time(buf);
	sprintf(receivestr, 
		"Received: by %s (pop3-%s)\r\n\t  form %s (%s) with pop3\r\n"
		"\t  id <%s>; %s\r\n\t  for %s@%s\r\n",
		the_host, Version, hostname, inet_ntoa(hisctladdr.sin_addr),
		thismsg->id, buf, r_user, hostname);
	
	oldintr = signal(SIGINT,cmdabort);
	if( command(1, "RETR %s", m_id) ) {
		if(!hasuidl)
			hasuidl = -1;
		/* get the message and store it	*/
		cp = buf;
		n = 0;
		expectend = 2;
		while( (c = getc(cin)) != EOF ) {
			if(expectend) {
				switch (c) {
				case '\n':
					if((expectend == 1) || (expectend == 4))
						expectend++;
					else
						expectend = 0;
					break;
				case '.':
					if (expectend == 2)
						expectend++;
					else
						expectend = 0;
					break;
				case '\r':
					if(expectend == 3)
						expectend++;
					else
						expectend = 1;
					break;
				default:
					expectend=0;
				}
			} else {
				if(c == '\r') {
					expectend = 1;
				}
				/* if (c == '\n') */
			}
			if(expectend < 3) {
				*cp++ = c;
				n++;
			}
			/* add a "Received:" header ?	*/
			if( !receive && (c == '\n') && 
				(!strncmp(buf,"Received:",9) || !strncmp(buf,"Date:",5)) ){
				receive = TRUE;
				write(fileno(f_message), receivestr, strlen(receivestr));
			}
			if( (c == '\n') || (expectend == 5) || (n == bufsize) ) {
				d = write(fileno(f_message), buf, n);
				sbytes += d;
				if( d != n)
					break;
				bytes +=n;
				cp = buf;
				n = 0;
			}
			if(expectend == 5)
				break;
		}
		if(c == EOF) {
			if(n) {
				d = write(fileno(f_message), buf, n);
				sbytes += d;
				bytes += n;
			}
			lostpeer();
		}
		if(n && (d != n)) {
			fprintf(stderr, "pop3: short write in file '%s'\n", fname);
		}
		fclose(f_message);
		chmod(fname, 0660);
		chown(fname, getuid(), getegid());
		if( reply_dig[0] > bytes) {	/* some servers can't count newlines	*/
			r = FALSE; code = BADREC;
			logmessage(LOGRECEIVED, "receive error", id_prefix, m_id);
		} else if ( bytes != sbytes) {
			r = FALSE; code = BADSTORE; 
			logmessage(LOGRECEIVED, "write error", id_prefix, m_id);
		} else {
			r = TRUE; code = SUCCREC;
			logmessage(LOGRECEIVED, "received", id_prefix, m_id);
		}
		if(!r) {
			if(keepbadmsgs||debug) {
				sprintf(buf, "%s.bad", fname);
				rename(fname, buf);
			} else
				unlink(fname);
		}
		if(verbose > 0) {
			printf("bytes expected: %ld received: %ld saved: %ld\n",
					reply_dig[0], bytes, sbytes);
			if(r)
				printf("message saved: %s\n", r ? fname : buf);
			(void) fflush(stdout);
		}
		thismsg->code = code;
		(void) signal(SIGINT,oldintr);
		return(r);
	} else {
		fclose(f_message);
		remove(fname);
		(void) signal(SIGINT,oldintr);
	}

	return(FALSE);
}


/* 
 * the builtin auto cmds
 * (called by main() if not interactive)
 * 
 */


/* 
 * after the successfull STAT cmd with msgs = reply_dig[0]
 * 	for (n = 1; n <= msgs; n++) {
 * 		if(retrieve n)
 *			delete n
 *	}
 *	close
 */
int get_mails(int deletem)
{
	long msgs, n, l = 0;
	char number[10];
	
	if (!command(2, "STAT"))
		return(FALSE);
		
	msgs = reply_dig[0];
	if(msgs > 0) {
		for (n = 1; n <= msgs; n++) {
			abrtflag = 0;
			if(do_retrieve(_ltoa(n, number, 10))) {
				l++;
				if(deletem && (code == SUCCREC) && !abrtflag)
					command(0, "DELE %s", number);
			}
			if(abrtflag)
				break;
		}
	}
	if(verbose)
		printf("%ld of %ld messages received\n", l, msgs);

	return(TRUE);
}

MSGLIST *recmsgs = NULL;
static MSGLIST *lastrecmsgs;
static FILE *deliverfile;


MSGLIST *add_2list(char *id1, char *id2, char *uidl)
{
	MSGLIST *newmsg;
	int l;
		
	if(! (newmsg = (MSGLIST *)malloc(sizeof(MSGLIST))) ) {
		myerror("no memory", errno);
		return(NULL);
	}

	newmsg->next = NULL;
	l = strlen(id1)+strlen(id2) + 1;
	if(uidl)
		l += strlen(uidl);
	if(!(newmsg->id = malloc(l))) {
		myerror("no memory", errno);
		free(newmsg);
		return(NULL);
	}
	if(uidl)
		sprintf(newmsg->id, "%s.%s.%s", id1, id2, uidl);
	else
		sprintf(newmsg->id, "%s.%s", id1, id2);
	newmsg->code = 0;

	if(recmsgs)
		lastrecmsgs->next = newmsg;
	else
		recmsgs = newmsg;
	lastrecmsgs = newmsg;

	return(newmsg);
}


int do_deliver(char *to, int to_uid, char *box, char *cmd)
{
	MSGLIST *curmsg;
	FILE *f_message;
	int succ, succ1 = TRUE;
	sig_t (*oldintr)();
	char fname[256];
	
	if(!recmsgs) {
		if(verbose)
			printf("no mails to deliver from this session\n");
		return(TRUE);
	}
		
	abrtflag = 0;
	oldintr = signal(SIGINT,cmdabort);	
	for(curmsg = recmsgs; curmsg; curmsg=curmsg->next) {
		if(abrtflag)
			break;
		if(curmsg->code == SUCCREC) {
			if(verbose)
				printf("deliver id : %s\n", curmsg->id);
			sprintf(fname, "%s/%s", spooldir, curmsg->id);
			
			if(! (f_message = fopen(fname, "r")) ) {
				myerror("no message", errno);
				succ = FALSE;
			} else {
				succ = deliver_by(f_message, box, to, to_uid, cmd);
				fclose(f_message);
				if(succ) {
					logmessage(LOGDELIVER, curmsg->id, to );
					unlink(fname);
					curmsg->code |= DELIVERED;
				} else	/*id '%s' curmsg->id, */
					 succ1 = FALSE;
			}
		}
	}
	signal(SIGINT, oldintr);
	return(succ1);
}


int deliver_by(FILE *the_message, char *box, char *recip, int n_uid, char *cmd)
{
	int  s_pid, r_val;
	if(!(s_pid = fork()) ) {
//			close(fileno(stdin));
//			if(dup(fileno(f_message)) != fileno(stdin))
		if(n_uid != getuid())
			if(setuid(n_uid))
				myerror("can't set uid\n", errno);
		if(box)
			exit(store_in_box(the_message, box));
		else {
			if(dup2(fileno(the_message),fileno(stdin)) != fileno(stdin))
				exit(1);
			execl(cmd, cmd, recip, NULL);
			exit(1);
		}
	} else if (s_pid > 0)
		wait(&r_val);
	else {
		if(verbose|debug)
			myerror("can't fork", 0);
		r_val = -1;
	}
	if(r_val) {
		if(verbose > 1 || debug)
			printf("deliver failed (%d): %x.%x/%d.%d \n", 
					s_pid, (r_val<<8)&0xff, r_val&0xff,
							(r_val<<8)&0xff, r_val&0xff);
		return(FALSE);
	}
	return(TRUE);
}

store_in_box(FILE *the_message, char *box)
{
	/* FromSPACE, Return-Path strings ?	*/	

	myerror("deliver to mailbox not yet implemented", 0);
	return(1);	/* exit value! */
}


do_printlist()
{
	MSGLIST *curmsg;

	if(!recmsgs) {
		printf("no mails received in this session\n");
		return(TRUE);
	}
	printf("  status    msg id\n");
	for(curmsg = recmsgs; curmsg; curmsg=curmsg->next) {
		if(curmsg->code & DELIVERED)
			printf("delivered");
		else if(curmsg->code & SUCCREC)
			printf("receievd");
		else if(curmsg->code & BADREC)
			printf("rec err");
		else if(curmsg->code & BADSTORE)
			printf("loc err");
		if(curmsg->code & BADSTORE|BADREC|SUCCREC|DELIVERED)
			printf("  %s\n", curmsg->id);
	}	
	return(TRUE);
}

savelist()
{
	char fname[256];
	MSGLIST *curmsg;

	if(!recmsgs)
		return(TRUE);
	
	sprintf(fname, "%s/deliver.%s", spooldir, the_user);
	if(deliverfile = fopen(fname, "a")) {
		chmod(fname, 0660);
		chown(fname, getuid(), getegid());
	} else {
		myerror("cant't save deliver list", errno);
		return(FALSE);
	}
	
	for(curmsg = recmsgs; curmsg; curmsg=curmsg->next) {
		if(curmsg->code == SUCCREC)
			fprintf(deliverfile, "%s\n", curmsg->id);
	}

	fclose(deliverfile);
	return(TRUE);
}

/* 
 * deliverlist
 * try to deliver all mails from deliverlist
 * called by main() if deliver-only mode, ...
 */
static MSGLIST delimsg;

int	do_deliverqueue( char *to, int to_uid, char *box, char *cmd)
{
	int	succ = TRUE;
	MSGLIST *oldrecmsgs = NULL;
	FILE *newdeliverfile;
	char *cp, *cp1;
	sig_t (*oldintr)();
	char fname[256];
	char buf[1024];
	
	sprintf(fname, "%s/deliver.%s", spooldir, the_user);
	sprintf(buf, "%s/deliver.%s.tmp", spooldir, the_user);
	if(access(fname, R_OK)) {
		if(!access(fname, F_OK)) {
			fprintf(stderr, "%s: can't open '%s'\n", myname, fname);
			return(FALSE);
		}
		return(TRUE);
	}
	if(rename(fname, buf)) {
		myerror("can't use tmp deliver file", errno);
		return(FALSE);
	}
	if( (deliverfile = fopen(buf, "r")) == NULL) {
		myerror("can't use tmp deliver file", errno);
		return(FALSE);
	}
	if( (newdeliverfile = fopen(fname, "w")) == NULL) {
		myerror("can't create new deliver file", errno);
		return(TRUE);
	}

	abrtflag = 0;
	oldintr = signal(SIGINT,cmdabort);	

	if(recmsgs)
		oldrecmsgs = recmsgs;
	recmsgs = &delimsg;
	delimsg.next = NULL;
	
	fprintf(newdeliverfile, "# %c(%c)deliver.%s created by %s(%d;uid%d)\n",
		'@', '#', the_user, myname, getpid(), getuid());
	while( fgets(buf, 1024, deliverfile) ){
		cp = strtok(buf, " \r\n");
		if(!cp)
			continue;
		if(*cp == '#')
			continue;

		delimsg.id =  cp;
		delimsg.code = SUCCREC;

		if(abrtflag || !do_deliver(to, to_uid, box, cmd))
			fprintf(newdeliverfile, "%s\n", cp);
	}
	fclose(newdeliverfile);
	fclose(deliverfile);
	unlink(fname);
	sprintf(buf, "%s/deliver.%s.tmp", spooldir, the_user);	

	if(rename(buf, fname))
		myerror("can't rename tmp deliver file", errno);


	recmsgs = oldrecmsgs;
	signal(SIGINT, oldintr);

	return(TRUE);

}	/* deliverlist	*/



/* 
 * 
 */
int logmessage( int what, char *msg, char *mida, char *midb )
{
	FILE *log_file;
	time_t cur_time;

	time(&cur_time);
	
	if( !(log_file = fopen(logfile, "a")) )
		return(FALSE);

	fprintf(log_file, "%s(%d,uid:%d): %d,%s %s", myname, getpid(), getuid(),
			(int)myctladdr.sin_port, inet_ntoa(myctladdr.sin_addr),
			ctime(&cur_time));

	if(what == LOGCONNECTED) {
		fprintf(log_file, 
			"\tconnected to %s (%s,%d)\n", hostname,
			inet_ntoa(hisctladdr.sin_addr),(int)hisctladdr.sin_port);
			
	} else if(what == LOGLOGFAIL) {
		fprintf(log_file, 
			"\t--> %s(%s,%d)\n\t login failed: '%s'\n", hostname, 
			inet_ntoa(hisctladdr.sin_addr),(int)hisctladdr.sin_port,
			reply_tok);
	} else if(what == LOGDISSCON) {
		fprintf(log_file, 
			"\t--> %s(%s,%d)\n\t disconnect\n", hostname, 
			inet_ntoa(hisctladdr.sin_addr),(int)hisctladdr.sin_port);
	} else if(what == LOGRECEIVED) {
		fprintf(log_file, 
			"\t--> %s(%s,%d)\n\tmessage <%s.%s> %s\n", hostname, 
			inet_ntoa(hisctladdr.sin_addr),(int)hisctladdr.sin_port,
			mida, midb, msg);
	} else if(what == LOGDELIVER) {
		fprintf(log_file, 
			"\tmessage <%s> delivered to %s\n",
			msg, mida);
	} else if(what == LOGLOSTPEER) {
		fprintf(log_file, 
			"\t--> %s(%s,%d)\n\tlost connection\n", hostname, 
			inet_ntoa(hisctladdr.sin_addr),(int)hisctladdr.sin_port);
	} else if(what == LOGFATAL) {
		if(connected) {
			fprintf(log_file, 
			"\t--> %s(%s,%d)\n\tfatal: '%s(%s): %s'\n in %s state\n", hostname, 
			inet_ntoa(hisctladdr.sin_addr),(int)hisctladdr.sin_port,
			msg, mida, midb,
			(connected == AUTHORI ? "AUTHORIZATION" : "TRANSACTION"));
		} else {
			fprintf(log_file, 
			"\n\tfatal: '%s (%s): %s' (no connection)\n", msg,
					mida, midb);
		}
	}
	
	fclose(log_file);
	return(TRUE);	
}


/*VARARGS1*/
command(int resp, va_dcl, ... )
{
	va_list ap;
	char *fmt;
	int r = 0;
	sig_t (*oldintr)(), cmdabort();

	abrtflag = 0;
	if (debug) {
		printf("---> ");
		va_start(ap);
		fmt = va_arg(ap, char *);
		vfprintf(stdout, fmt, ap);
		va_end(ap);
		printf("\n");
		(void) fflush(stdout);
	}
	if (cout == NULL) {
		myerror ("No connection", errno);
		code = -1;
		return (0);
	}
	oldintr = signal(SIGINT,cmdabort);
	va_start(ap);
	fmt = va_arg(ap, char *);
	vfprintf(cout, fmt, ap);
	va_end(ap);
	fprintf(cout, "\r\n");
	(void) fflush(cout);

	r = getreply(resp);
	if (abrtflag && oldintr != SIG_IGN)
		(*oldintr)();
	(void) signal(SIGINT, oldintr);
	return( r == PSI ? TRUE : FALSE);
}

 /* eof	*/
