


NcFTP(1)                                                 NcFTP(1)


NNAAMMEE
       NcFTP - Internet file transfer program

SSYYNNOOPPSSIISS
       nnccffttpp    [_p_r_o_g_r_a_m    _o_p_t_i_o_n_s]    [[_o_p_e_n   _o_p_t_i_o_n_s]   _h_o_s_t_
       _n_a_m_e[::_p_a_t_h_n_a_m_e]]

OOPPTTIIOONNSS
       Program options:
         -D   : Turn debug mode and trace mode on.
         -L   : Don't use visual mode (use line mode).
         -V   : Use visual mode.
         -H   : Dump the version information.

       Command-line open options:
         -a   : Open anonymously.
         -u   : Open with username and password prompt.
         -p X : Use port number X when opening.
         -r   : Redial until connected.
         -d X : Redial, delaying X seconds between tries.
         -g X : Give up after X redials without connection.

       Command-line retrieve options:
         -C   : Force continuation (reget).
         -f   : Force overwrite.
         -G   : Don't use wildcard matching.
         -R   : Recursive.  Useful for  fetching  whole  directo
       ries.
         -n X : Get selected files only if X days old or newer.

DDEESSCCRRIIPPTTIIOONN
       _N_c_F_T_P  is  a  user interface to the Internet standard _F_i_l_e
       _T_r_a_n_s_f_e_r _P_r_o_t_o_c_o_l.  This program allows a user to transfer
       files  to and from a remote network site, and offers addi
       tional features that are not found in the standard  inter
       face, _f_t_p.

       The  program runs in one of three modes: _v_i_s_u_a_l _m_o_d_e, _l_i_n_e
       _m_o_d_e, and _c_o_l_o_n _m_o_d_e.

       If your system is somewhat modern, the default mode should
       be _v_i_s_u_a_l _m_o_d_e.  This is a full-screen interface that uses
       the _c_u_r_s_e_s library.  With visual mode, you edit  the  pro
       gram's  settings  with  a nice screen interface instead of
       typing arcane commands.

       If you are not in visual mode, you will be using _l_i_n_e _m_o_d_e
       for  the interactive shell.  This mode is a no-frills com
       mand-line interface that will look like  the  default  _f_t_p
       program's command shell.

       The  third mode, _c_o_l_o_n _m_o_d_e, refers to the program's abil
       ity to do a quick retrieve of a file  directly  from  your
       shell  command  line, without going into the program's own



NCEMRSoft                     2.4.2                             1





NcFTP(1)                                                 NcFTP(1)


       shell.  This mode is useful for shell scripts.

IINNTTRROODDUUCCTTIIOONN TTOO VVIISSUUAALL MMOODDEE
       When entering  visual  mode,  the  screen  clears  and  is
       rewritten  with  the  splash  screen.   You should see the
       black status bar occupying the second to last row  on  the
       screen.   Beneath  the status bar is the input line, where
       you type commands to the program's shell.

       The program then waits for you to do  something.   Usually
       this  means you want to open a remote filesystem to trans
       fer files to and from your local machine's filesystem.  To
       do  that, you need to know the symbolic name of the remote
       system, or its _I_n_t_e_r_n_e_t _P_r_o_t_o_c_o_l (IP) address.  For  exam
       ple, a symbolic name might be ``typhoon.unl.edu,'' and its
       IP address could be ``129.93.33.24.''  To open  a  connec
       tion to that system, you use the program's _o_p_e_n command:

            open typhoon.unl.edu
            open 129.93.33.24

       Both  of  these  try to open the machine called typhoon at
       the _U_n_i_v_e_r_s_i_t_y _o_f _N_e_b_r_a_s_k_a.  Using the  symbolic  name  is
       the preferred way, because IP addresses may change without
       notice, while the symbolic names usually stay the same.

       When you open a remote filesystem, you need to  have  per
       mission.  The _F_T_P _P_r_o_t_o_c_o_l's authentication system is very
       similar to that of logging in to your account.   You  have
       to  give  an  account name, and its password for access to
       that account's files.  However, most remote  systems  that
       have  anything you might be interested in don't require an
       account name for use.  You can often get anonymous  access
       to  a  remote filesystem and exchange files that have been
       made publicly accessible.  The  program  attempts  to  get
       anonymous  permission to a remote system by default.  What
       actually happens is that the program tries to use ``anony
       mous''  as the account name, and when prompted for a pass
       word, uses your E-mail address as a courtesy to the remote
       system's  maintainer.  You can have the program try to use
       a specific account also.  That will be explained later.

       If the connection succeeded, you should see the status bar
       change  to  hold the remote system's name on one side, and
       the current remote directory on the other  side.   To  see
       what's  in  the  current remote directory, you can use the
       program's _l_s and _d_i_r commands.  The former is terse,  pre
       ferring  more  remote  files in less screen space, and the
       latter is more verbose, giving detailed information  about
       each item in the directory.

       You  can  use  the  program's  _c_d command to move to other
       directories on the remote system.  The cd command  behaves
       very  much like the command of the same name in the _B_o_u_r_n_e



NCEMRSoft                     2.4.2                             2





NcFTP(1)                                                 NcFTP(1)


       and _K_o_r_n shell.

       The purpose of the program is to exchange data with  other
       systems.   You can use the program's _g_e_t command to copy a
       file from the remote system to your local system:

            get README.txt

       The program will display the progress of the  transfer  on
       the  screen,  so  you  can  tell how much needs to be done
       before the transfer finishes.  When the transfer does fin
       ish,  then  you  can  enter more commands to the program's
       command shell.

       You can use the program's _p_u_t command to copy a file  from
       your system to the remote system:

            put something.tar

       When  you  are  finished  using the remote system, you can
       open another one or use the _q_u_i_t command to terminate  the
       program.

TTHHEE BBOOOOKKMMAARRKKSS FFIILLEE
       One of the program's goals is to minimize typing and maxi
       mize convenience.  The program automatically saves  infor
       mation  about  the  sites  you  call  on in a special file
       called the _b_o_o_k_m_a_r_k_s file, which is stored in  the  ._n_c_f_t_p
       subdirectory  of your home directory.  Each bookmark saves
       the host name along with  other  settings,  including  the
       remote directory you were in, the account information, and
       more.  This makes it easy to call back a  site  later  and
       have  everything  be  like  it  was when you left the last
       time.

       A big advantage of saving this information is that you can
       refer  to  a  site  by  a  shorter,  more meaningful name,
       instead of using the full symbolic host name for  a  site.
       For    example,    if    you    called    a   site   named
       ``typhoon.unl.edu'' frequently, its bookmark name might be
       just ``typhoon.''  Then, instead of:

            open typhoon.unl.edu

       you could use:

            open typhoon

       You  could  also  abbreviate the bookmark name further, as
       long as the program will know which site you are referring
       to.   If  no other bookmark's name starts with the letters
       ``ty,'' you could do just:

            open ty



NCEMRSoft                     2.4.2                             3





NcFTP(1)                                                 NcFTP(1)


       Use the bookmarking feature to assign  mnemonic  names  to
       hosts  whose  real  names don't give much hint to what you
       call there for.  A popular game called _N_e_t_h_a_c_k is archived
       at  linc.cis.upenn.edu,  in the /pub/NH3.1 directory.  You
       could assign ``nethack'' as the  bookmark  name  for  this
       site.  Then you could try:

            open nethack

       instead of:

            open linc.cis.upenn.edu

UUSSIINNGG TTHHEE BBOOOOKKMMAARRKK EEDDIITTOORR
       To manipulate the bookmarks stored in your bookmarks file,
       you use the program's bookmark editor.  Run  the  bookmark
       editor  by  typing  the  _b_o_o_k_m_a_r_k_s command from within the
       program.  This brings up a new screen of information.

       On the right side is the list of remote systems  the  pro
       gram has saved for you already.  Each time you open a con
       nection to a remote system, the program saves an entry  in
       your bookmark file for you automatically.  If you have not
       opened any sites successfully  yet,  this  list  would  be
       empty.

       On  the left side is some instructions saying what you can
       do with the list.  The bookmark editor is waiting for  you
       to do something, like select a bookmark whose settings you
       want to edit.

       Some bookmark editor ``hot  key''  commands  are  one  key
       only.  You do not need to hit enter after the hot key com
       mands.  To exit the bookmark editor for example, you would
       just  type  the  ``x''  key  only.  The multi-key commands
       require a slash first and do require the  enter  key.   To
       delete  the selected site, for example, you would type the
       ``/'' key, then ``del,'' and then the enter key.

       You can use the ``d'' key to move down  one  line  in  the
       list,  and the ``u'' key to move up one line.  If you have
       many entries in the bookmark list, you won't  be  able  to
       see them all at once.  The bookmark list scrolls as appro
       priate to bring the other sites into view.  Use the  ``p''
       and ``n'' keys to move pages at a time.

       Another  way  to  select a site in the bookmark list is to
       use the capital letters.  If I  had  many  entries  in  my
       bookmark  list, but wanted to select a site whose bookmark
       name was ``nethack,'' I could  type  ``N''  and  the  list
       would  zoom  to the first site with bookmark starting with
       the letter ``n.''

       After you have hilited a bookmark you want  to  edit,  use



NCEMRSoft                     2.4.2                             4





NcFTP(1)                                                 NcFTP(1)


       the /_e_d command.  Doing that brings up another screen with
       the settings for that bookmark.

       In the _B_o_o_k_m_a_r_k _O_p_t_i_o_n_s screen, you use hot keys to select
       a  setting  to edit.  To edit the bookmark name, for exam
       ple, you would type ``a.''  When you are finished  editing
       this bookmark, hit the ``x'' key to return to the bookmark
       editor's screen.

BBOOOOKKMMAARRKK OOPPTTIIOONNSS
       Edit the _B_o_o_k_m_a_r_k _n_a_m_e field to change the name you use to
       open  this site with.  Remember, when you change the book
       mark name , you must use this name to refer to  this  par
       ticular  bookmark,  so if you change it to ``foobar,'' you
       need to use ``open foobar.''  This is required because you
       can have multiple entries for a remote host.  For example,
       you could  have  two  bookmarks  for  wuarchive.wustl.edu,
       named  ``wumac''  and  ``wuwindows.''   If you were to say
       ``open wuarchive.wustl.edu,'' it would not be clear to the
       program which host entry to use.

       Change  the  login information for the site by editing the
       _U_s_e_r, _P_a_s_s_w_o_r_d, and _A_c_c_o_u_n_t fields.   Normally  you  would
       want to leave these as is for anonymous logins.  Depending
       on your situation,  you  might  want  to  use  a  specific
       account  on the remote system.  This is one way to get the
       program to use a non-anonymous login.

       The _D_i_r_e_c_t_o_r_y field specifies the  directory  to  move  to
       upon  successful  connection  to  the remote host for this
       bookmark.  When you close the site, this field is  updated
       for you automatically to be the directory you were in when
       you closed the site.

       The _T_r_a_n_s_f_e_r _T_y_p_e field can be changed to use a  different
       translation mode when transferring files.  This program is
       usually running on a _U_N_I_X system, and most remote  systems
       are  also  _U_N_I_X  variants, so the default transfer type is
       _b_i_n_a_r_y, which does no translation at all.

       However, when you need to work with plain text  files  and
       transfer  them  between  non-_U_N_I_X  systems, you can change
       this to _A_S_C_I_I.  That will  guarantee  that  the  text-only
       files will translate correctly.  Most often, you will need
       to use the _b_i_n_a_r_y transfer type.

       The _P_o_r_t field can be changed so that the program tries to
       use a non-standard port number.  I have yet to ever need a
       different port number, but this capability is here in case
       it's needed.

       The  _H_a_s  _S_I_Z_E  _C_o_m_m_a_n_d field will probably not need to be
       edited.  This field is mostly for your  information  only.
       The  _S_I_Z_E  command  is  an  _F_T_P  _P_r_o_t_o_c_o_l command that the



NCEMRSoft                     2.4.2                             5





NcFTP(1)                                                 NcFTP(1)


       program would like the remote server to support.  If it is
       supported, the program can get an exact number of bytes of
       remote files before transferring.  That is nice to know so
       the progress reports work better.

       The  _H_a_s  _M_D_T_M  _C_o_m_m_a_n_d field will probably not need to be
       edited either.  If the remote server supports it, the pro
       gram  can  get  the  exact modification date of the remote
       file, and set the local file to the same date.

       The _C_a_n _U_s_e _P_a_s_s_i_v_e _F_T_P field specifies whether the remote
       server  allows  use  of  the  _F_T_P _P_r_o_t_o_c_o_l's _P_A_S_V command.
       There are two ways to set up FTP connections.  The default
       way is what I call _P_o_r_t _F_T_P.  Unfortunately, _P_o_r_t _F_T_P can
       not be used when your local host is hiding behind a  _F_i_r_e_
       _w_a_l_l.  _P_a_s_s_i_v_e _F_T_P can be used with a firewall, and that's
       why I would like to use  that  method  if  possible.   You
       probably  will not need to edit this field, since this can
       be detected automatically most of the time.

       The _O_p_e_r_a_t_i_n_g _S_y_s_t_e_m field is used by the program to  tell
       if it can rely on certain dependencies to specific operat
       ing systems.  If the OS is a UNIX variant, the program can
       make some assumptions about the remote server's responses.
       For example, if the OS is _U_N_I_X, the _l_s  command  tries  to
       use  the _-_C_F flags, like you could with ``/bin/ls -CF'' on
       _U_N_I_X.  If the OS wasn't _U_N_I_X, the ``-CF'' might  not  make
       sense  to  the  remote  server and it might complain.  You
       probably will not need to edit this field, since this  can
       be detected automatically most of the time.

       The comment field can be used to store a brief description
       about the site.  For example, for my ``nethack'' entry,  I
       could  use  this  field  to hold ``Archive site for latest
       version of Nethack.''  When you are in the  bookmark  edi
       tor's  window, if you hilite a site that has a comment, it
       is printed at the bottom of the screen so you do not  have
       to edit the site to look at it.

PPRREEFFEERREENNCCEESS
       In  addition  to remote-host specific options, the program
       has global options that are user-configurable.  To  change
       the  program's  preferences,  run  the  _p_r_e_f_s command from
       within the program.

       The _D_e_f_a_u_l_t _o_p_e_n _m_o_d_e  field  specifies  how  the  program
       should try to open connections.  If you do a lot of anony
       mous FTPing, you should leave this set to _a_n_o_n_y_m_o_u_s.   You
       might  want  to  set  this field to _u_s_e_r _& _p_a_s_s_w_o_r_d if the
       hosts you FTP to most often don't allow anonymous  logins.
       For  example, if you are using the program on your company
       network to copy things from  different  company  machines,
       you would not want to use _a_n_o_n_y_m_o_u_s FTP mode.




NCEMRSoft                     2.4.2                             6





NcFTP(1)                                                 NcFTP(1)


       The  _A_n_o_n_y_m_o_u_s  _p_a_s_s_w_o_r_d  field  lets you change the value
       given to the remote host when you use an anonymous  login.
       It  is  customary  (and sometimes required) to use your e-
       mail address as the password for  anonymous  FTP,  so  the
       remote  host's  administrator  knows who is using the ser
       vice.  If the  program  didn't  get  your  e-mail  address
       right,  or  you  want  to use something different, you can
       change it here.

       The program now uses more whitespace than before to reduce
       eyestrain.   If  you prefer, you can turn off that feature
       by changing the _B_l_a_n_k _l_i_n_e_s _b_e_t_w_e_e_n _c_m_d_s field.

       The program can log the transfers you do to a file so  you
       can  refer  to the log if you can't remember where you got
       something.   To  turn  on  the  log,  which  is  saved  as
       _~_/_._n_c_f_t_p_/_l_o_g,  you  can  set  the _U_s_e_r _l_o_g _s_i_z_e field to a
       number greater than zero.  You probably do not want to let
       this file grow forever, so you set the maximum size of the
       log by setting that field.

       Although the program is perfectly happy saving every  site
       you  ever  open in the bookmarks file, you may want to put
       an upper bound on the number of sites saved.  If you  have
       a  slow  machine,  which  might  cause the program to take
       awhile to load and save the bookmarks, or if disk space is
       at  a premium, you can set the _M_a_x _b_o_o_k_m_a_r_k_s _t_o _s_a_v_e field
       to limit the number of bookmarks saved.  Once  that  limit
       is  reached,  the  program  will  discard sites whose time
       since the last connection is the longest.  In other words,
       a  site  you  only  called once a long time ago and forgot
       about will be the first to go.

       A few program functions need to use  a  _p_a_g_e_r  program  to
       view large amounts of text.  For example, the _p_a_g_e command
       retrieves a remote file and uses the  pager  to  view  it.
       You  can  specify the program to use (and its command line
       flags, if any) by setting the _p_a_g_e_r field.

       When you transfer files between the remote host  and  your
       local  host, the program uses a _p_r_o_g_r_e_s_s _m_e_t_e_r to show you
       the status of the transfer.  The program has a few differ
       ent  progress  meters  to choose from, and you can try out
       the other ones by changing the _P_r_o_g_r_e_s_s _m_e_t_e_r field.

       You can control how much of the remote server's chatter is
       printed  by  changing the _R_e_m_o_t_e _m_e_s_s_a_g_e_s field.  The pro
       gram always prints error messages, but most  of  the  time
       the  remote  server  doesn't  have anything useful to say.
       There are a couple of messages that may be worth printing.
       The  first  is  the  _s_t_a_r_t_u_p _m_e_s_s_a_g_e.  Typically, when you
       connect to a server  it  has  some  important  information
       about the server.  Some servers have _c_h_d_i_r _m_e_s_s_a_g_e_s, which
       are sent when you enter a special directory.  You  specify



NCEMRSoft                     2.4.2                             7





NcFTP(1)                                                 NcFTP(1)


       whether  to  print  these  messages by toggling the _R_e_m_o_t_e
       _m_e_s_s_a_g_e_s field.

       By default, the program stays in the  same  directory  you
       were  in  when you ran the program, so that downloads will
       go in that directory.  I like to use a  ``download  direc
       tory'' so that all of my downloads go to a specific direc
       tory.  This prevents me from exceeding my quota, and over
       writing  my other files.  You can set the _S_t_a_r_t_u_p _i_n _L_o_c_a_l
       _D_i_r field to have the program change the  local  directory
       each time when the program starts up.  Then you know where
       to expect your downloads to end up.

       The program itself has some messages  which  you  may  get
       tired of and want to turn off.  You can change the _S_t_a_r_t_u_p
       _m_e_s_s_a_g_e_s field to specify whether the program  prints  its
       ``splash  screen''  and  whether it prints a _t_i_p on how to
       maximize use of the program.

       When you retrieve a remote file, by  default  the  program
       tries to also set the exact modification time of the local
       file as the remote file.  You can turn that off by  chang
       ing the _F_i_l_e _t_i_m_e_s_t_a_m_p_s field.

       If  you  don't  like the full-screen graphics, you can use
       the line-oriented mode by  changing  the  _S_c_r_e_e_n  _g_r_a_p_h_i_c_s
       field.  Once you turn _v_i_s_u_a_l mode off from the _P_r_e_f_e_r_e_n_c_e_s
       screen, you won't be able to get back to  the  preferences
       screen  again  when  using  _l_i_n_e  mode.   To get back into
       visual mode, you can run the program with the ``-V'' flag,
       like:

            ncftp -V

CCOOMMMMAANNDD RREEFFEERREENNCCEE
       I  will  now describe the commands that the program's com
       mand shell supports.  The first command to know  is  _h_e_l_p.
       If you just type

            help

       from  the  command  shell, the program prints the names of
       all of the supported commands.  From there,  you  can  get
       specific  help  for a command by typing the command after,
       for example:

            help open

       prints information about the _o_p_e_n command.

       The shell escape command is simply the exclamation  point,
       _!  To spawn a shell, just do:

            !



NCEMRSoft                     2.4.2                             8





NcFTP(1)                                                 NcFTP(1)


       You can also use this to do one command only, like:

            !date +%H:%M:%S


       The _c_d command changes the working directory on the remote
       host.  Use this command to move to different areas on  the
       remote  server.   If you just opened a new site, you might
       be in the root directory.  Perhaps there was  a  directory
       called  ``/pub/news/comp.sources.d'' that someone told you
       about.  From the root directory, you could:

            cd pub
            cd news
            cd comp.sources.d

       or, more concisely,

            cd /pub/news/comp.sources.d

       Then, commands such as _g_e_t, _p_u_t, and _l_s could be  used  to
       refer to items in that directory.

       Some shells in the _U_N_I_X environment have a feature I like,
       which is switching to the previous directory.  Like  those
       shells, you can do:

            cd -

       to change to the last directory you were in.

       The  _c_l_o_s_e command disconnects you from the remote server.
       The program does this for you automatically  when  needed,
       so  you  can  simply  open other sites or quit the program
       without worrying about closing the connection by hand.

       Sometimes it may be necessary to use the  _c_r_e_a_t_e  command.
       This  makes an empty file on the remote host.  This can be
       useful when you are unable to contact the remote  server's
       administrator, but hope someone in the know will spot your
       file.  For example,

            create readline2.0.tar_is_corrupt

       might persuade someone to repost that file.

       The _d_e_b_u_g command is mostly for use by me and the testers.
       You could type

            debug 1

       to  turn  debugging  mode on.  Then you could see all mes
       sages between the  program  and  the  remote  server,  and
       things  I  print  only in debugging mode.  If you report a



NCEMRSoft                     2.4.2                             9





NcFTP(1)                                                 NcFTP(1)


       bug, I might ask you to send me a _t_r_a_c_e file.  To do that,
       you would run the program, and then type

            debug trace 1

       And so I could see how the program was compiled, you would
       type

            version

       After you quit the program, you  could  then  send  me  an
       email  with the contents of the _~_/_._n_c_f_t_p_/_t_r_a_c_e file, which
       would also have the version information in it.

       The _d_i_r command prints a detailed directory  listing.   It
       tries  to  behave  like _U_N_I_X's ``/bin/ls -l'' command.  If
       the remote server seems to be a _U_N_I_X host,  you  can  also
       use the same flags you would with _l_s, for instance

            dir -rt

       would try to act like

            /bin/ls -lrt

       would on _U_N_I_X.

       The  _e_c_h_o command wouldn't seem very useful, but it can be
       nice for use with the program's macros.  It  behaves  like
       the  equivalent  command  does  under  a  _U_N_I_X  shell, but
       accepts some extra flags.  All ``percent'' flags  are  fed
       through _s_t_r_f_t_i_m_e(4).  So you could type

            echo It is now %H:%M on %B %d.

       and  you  should  get  something like this printed on your
       screen:

            It is now 19:00 on January 22.

       There are also ``at'' flags, which the program expands:

            @H : Name of connected host
            @D : Full pathname of remote current working directory
            @J : Short name of remote current working directory
            @N : Newline.
            @n : Bookmark name of connected host

       Example:

            echo "Connected to @H at %H:%M." >> junk

       If you later looked at the contents of ``junk,'' it  might
       say:



NCEMRSoft                     2.4.2                            10





NcFTP(1)                                                 NcFTP(1)


            Connected to sphygmomanometer.unl.edu at 20:37.

       The  _g_e_t  command  copies  files  from the current working
       directory on the remote host  to  your  machine's  current
       working  directory.  To place a copy of ``README'' in your
       local directory, you could try:

            get README

       The _g_e_t command  has  some  powerful  features  which  are
       described below, in ``SPECIAL DOWNLOADING FEATURES.''

       The  _b_o_o_k_m_a_r_k_s  command  runs  the  _B_o_o_k_m_a_r_k  _E_d_i_t_o_r.  You
       already know how what that does, since you read  the  sec
       tion above on it, right?

       The  _l_c_d command is the first of a few ``l'' commands that
       work with the local host.  This changes the current  work
       ing  directory on the local host.  If you want to download
       files into a different local directory, you could use  _l_c_d
       to change to that directory and then do your downloads.

       Another  local command that comes in handy is the _l_l_s com
       mand, which runs ``/bin/ls'' on the local  host  and  dis
       plays  the  results  in the program's window.  You can use
       the same flags with _l_l_s  as  you  would  in  your  command
       shell, so you can do things like:

            lcd ~/doc
            lls -lrt p*.txt

       The program also has a built-in interface to the name ser
       vice via the _l_o_o_k_u_p command.  This means  you  can  lookup
       entries for remote hosts, like:

            lookup cse.unl.edu ftp.cs.unl.edu sphygmomanometer.unl.edu

       prints:

            cse.unl.edu  129.93.33.1
            typhoon.unl.edu  129.93.33.24
            sphygmomanometer.unl.edu  129.93.33.126

       There is also a more detailed option, enabled with ``-v,''
       i.e.:

            lookup -v cse.unl.edu ftp.cs.unl.edu

       prints:

            cse.unl.edu:
                Name:     cse.unl.edu
                Address:  129.93.33.1




NCEMRSoft                     2.4.2                            11





NcFTP(1)                                                 NcFTP(1)


            ftp.cs.unl.edu:
                Name:     typhoon.unl.edu
                Alias:    ftp.cs.unl.edu
                Address:  129.93.33.24

       You can also give _I_P addresses, so this would work too:

            lookup 129.93.33.24

       prints:

            typhoon.unl.edu  129.93.33.24

       The _l_p_a_g_e command views a local file one page at  a  time.
       By  default,  the  program uses your pager program to view
       the files.  You can choose to use the  built-in  pager  by
       using the ``-b'' flag.  Example:

            lpage -b ~/.ncftp/bookmarks

       The  _l_p_w_d  command  is prints the current local directory.
       Use this command when you forget where  you  are  on  your
       local machine.

       The _l_s command prints a brief directory listing.  It tries
       to behave like _U_N_I_X's ``/bin/ls  -CF''  command.   If  the
       remote  server  seems  to be a _U_N_I_X host, you can also use
       the same flags you would with _l_s, for instance

            ls -rt

       would try to act like

            /bin/ls -CFrt

       would on _U_N_I_X.

       The _m_k_d_i_r command tries to create a new directory  on  the
       remote host.  For many public archives, you won't have the
       proper access permissions to do that.

       Some servers let you use different transfer  modes.   Most
       servers  support  only  the  default mode, which is _s_t_r_e_a_m
       mode.  The program supports that mode and also _b_l_o_c_k mode.
       The  primary  advantage to using this mode is that you can
       use the same data connection for all your transfers.  With
       _s_t_r_e_a_m  mode  the  program and server must establish a new
       data connection for each file, and doing that takes  extra
       time  and  bandwidth.   To use the _m_o_d_e command to turn on
       block mode, you would type

            mode b

       and the command to use stream mode would be



NCEMRSoft                     2.4.2                            12





NcFTP(1)                                                 NcFTP(1)


            mode s

       The program turns on  block  mode  automatically  when  it
       knows the remote server supports it and implements it cor
       rectly, so you should not need to use this command.

       The _o_p_e_n command connects you  to  a  remote  host.   Many
       times,  you  will  simply  open  a  host without using any
       flags, but nonetheless the _o_p_e_n command has some flags  to
       enable certain features.

       To  force  an anonymous open, use the ``-a'' flag.  On the
       _f_t_p_._p_r_o_b_e_._n_e_t machine, which is the official archive  site
       for  _N_c_F_T_P, I have a need to use both anonymous logins and
       user logins.  The _B_o_o_k_m_a_r_k _E_d_i_t_o_r remembers type of  login
       I used last, so if the last time was a user login, I could
       use the ``-a'' flag to switch back to the anonymous  login
       type  without  having to use the _B_o_o_k_m_a_r_k _E_d_i_t_o_r to change
       that.

       Likewise, I could use the ``-u''  flag  to  force  a  user
       open.   Then  I could give my account name and password to
       access that account.

       Many of the big archive sites like _w_u_a_r_c_h_i_v_e_._w_u_s_t_l_._e_d_u are
       busy,  so you aren't guaranteed a connection to them.  The
       program lets you ``redial'' sites  periodically,  until  a
       connection  succeeds.  Use the ``-r' flag to turn on auto
       matic redial.

       Redial itself has a  few  parameters.   You  can  set  the
       delay, in seconds, of the time spent waiting between redi
       als.  You can also have the program give up after a  maxi
       mum  number of redials is reached.  Here's an example that
       fully utilizes redial mode:

       open -r -d 75 -g 10 bowser.nintendo.co.jp

       The ``-r'' turns on redialing, the ``-d'' sets the  redial
       delay  to 75 seconds, and the ``-g'' flag limits redialing
       to 10 tries.  If you like, you can just trust the  default
       redial settings and only use ``-r.''

       The _o_p_e_n command will run the _B_o_o_k_m_a_r_k _E_d_i_t_o_r if you don't
       supply a hostname to open.  You can use the _B_o_o_k_m_a_r_k  _E_d_i_
       _t_o_r  to  select  a  host and open it by hitting the _r_e_t_u_r_n
       key.

       The _p_a_g_e command lets you browse a remote file one page at
       a time.  This is useful for reading README's on the remote
       host without downloading them first.   This  command  uses
       whatever program you have set the _p_a_g_e_r field in the _P_r_e_f_
       _e_r_e_n_c_e_s screen to view the file.




NCEMRSoft                     2.4.2                            13





NcFTP(1)                                                 NcFTP(1)


       The _p_d_i_r and _p_l_s commands are equivalent  to  _d_i_r  and  _l_s
       respectively,  only  they feed their output to your pager.
       These commands are primarily for _l_i_n_e _m_o_d_e because  direc
       tory listings can scroll offscreen.  If you do a normal _l_s
       while in _v_i_s_u_a_l mode, if it would go offscreen, the built-
       in pager kicks in automatically.  Therefore I don't recom
       mend using _p_d_i_r and _p_l_s while in _v_i_s_u_a_l mode.

       The _r_e_d_i_r and _p_r_e_d_i_r commands give you a way to re-display
       the  last directory listing.  The program saves the output
       from the last _d_i_r or _l_s command you did, so if you want to
       see it again you can do this without wasting network band
       width.  The _p_r_e_d_i_r command is the same  as  _r_e_d_i_r,  except
       that the output is fed to your pager.

       I  have  found that I mostly download, and have next to no
       need at all to upload.  But the _p_u_t command  is  there  in
       case  you need to upload files to remote hosts.  For exam
       ple, if I wanted to send some files to a  remote  host,  I
       could do:

            lcd ~/docs/files
            put 02.txt 03.txt 05.txt 07.txt 11.txt

       The  _p_u_t  command  won't work if you don't have the proper
       access permissions on the remote host.  Also, this command
       doesn't have any of the special features that the _g_e_t com
       mand has, except for the ``-z'' option.

       The _p_w_d command prints the current remote  working  direc
       tory.  In _v_i_s_u_a_l mode, this is in the status bar.

       If  you  need to change the name of a remote file, you can
       use the _r_e_n_a_m_e command, like:

            rename SPHYGMTR.TAR sphygmomanometer-2.3.1.tar

       Of course, when you finish using the program, type _q_u_i_t to
       end the program (You could also use _b_y_e, _e_x_i_t, or _^_D).

       The  _q_u_o_t_e command can be used to send a direct _F_T_P _P_r_o_t_o_
       _c_o_l command to the remote server.   Generally  this  isn't
       too useful to the average user (or me either).

       The  _r_h_e_l_p  command  sends  a  help  request to the remote
       server.  The  list  of  _F_T_P  _P_r_o_t_o_c_o_l  commands  is  often
       printed,  and  sometimes  some  other  information that is
       actually useful, like how to reach the site administrator.

       Depending  on the remote server, you may be able to give a
       parameter to the server also, like:

            rhelp NLST




NCEMRSoft                     2.4.2                            14





NcFTP(1)                                                 NcFTP(1)


       One server responded:

            Syntax: NLST [ <sp> path-name ]

       If you need to delete a remote file you  can  try  the  _r_m
       command.   Much  of  the  time this won't work because you
       won't have the proper access  permissions.   This  command
       doesn't  accept  any flags, so you can't nuke a whole tree
       by using ``-rf'' flags like you can on _U_N_I_X.

       Similarly, the _r_m_d_i_r command removes a directory.  Depend
       ing on the remote server, you may be able to remove a non-
       empty directory, so be careful.

       The _s_e_t command is  provided  for  backward  compatibility
       with  older  versions of the program, and is superseded by
       the _p_r_e_f_s command.  The basic syntax is:

            set option value

       Where the option is the short name  of  the  corresponding
       field  in  the _P_r_e_f_e_r_e_n_c_e_s screen.  The short names of the
       preferences  fields  can  be  found   by   browsing   your
       _~_/_._n_c_f_t_p_/_p_r_e_f_s  file.  This command is mainly for use with
       _l_i_n_e _m_o_d_e, but since that mode  is  no  longer  officially
       supported by me, I want to discourage the use of this com
       mand.

       One obscure command you may have to use someday  is  _s_i_t_e.
       The  _F_T_P  _P_r_o_t_o_c_o_l  allows for ``site specific'' commands.
       These ``site'' commands vary of  course,  but  one  common
       sub-command  that  is  useful  that  some sites support is
       _c_h_m_o_d, i.e.:

            site chmod 644 README

       Try doing one of these to see what the remote server  sup
       ports, if any:

            rhelp SITE
            site help

       You may need to change transfer types during the course of
       a session with a server.  You can use the _t_y_p_e command  to
       do this.  Try one of these:

            type ascii
            type binary
            type image

       If  you  ever need to contact me about the program, please
       familiarize yourself with the _v_e_r_s_i_o_n command.  This  com
       mand  dumps  a lot of information that tells me which edi
       tion of  the  program  you  are  using,  and  how  it  was



NCEMRSoft                     2.4.2                            15





NcFTP(1)                                                 NcFTP(1)


       installed on your system.  Here's a way to save the output
       of this command to a file, so you can send it to me:

            version > version.txt


SSPPEECCIIAALL DDOOWWNNLLOOAADDIINNGG FFEEAATTUURREESS
       You probably already know that you use the _g_e_t command  to
       copy  files on the remote host to the local host.  But the
       _g_e_t command has a few other tricks  that  you  might  find
       useful.  First of all, _n_c_f_t_p skips files you already have.
       If you try to

            get file24

       and there is a file named ``file24'' in the current  local
       directory   already,  the  program  uses  some  additional
       heuristics to determine if it should actually  waste  net
       work bandwidth to download it again.

       The  program  tries to get the date and size of the remote
       file ``file24.''  If that file has the exact same date and
       size  as  the local file ``file24,'' the program will skip
       over that file.  If the program could not get the date  or
       size  of the remote file, or the size differs, the program
       will go ahead and fetch the file.

       In addition, if the local file's date is  newer  than  the
       remote file's date, the program skips the download because
       it concludes you already have a more recent version.

       What all this means for you is that you can use  the  pro
       gram  to  _m_i_r_r_o_r  another archive.  For example, you might
       have a task that requires you keep a  mirror  of  all  the
       files  of  a  remote  directory called ``files.''  In that
       directory, there might be dozens of files, some  of  which
       are updated occasionally.  You could use _n_c_f_t_p to help you
       out by setting the appropriate local and  remote  directo
       ries, then simply doing:

            get *

       The  program  will skip over the old files, and only down
       load the files that you don't have or  have  been  updated
       since the last time.

       Nonetheless,  you  may want to ignore the program's advice
       and download a file anyway, despite the program's thinking
       that  you don't need to.  You can use the ``-f'' flag with
       _g_e_t to force a download:

            get -f README

       You may also need to use the  ``-C''  flag  to  force  the



NCEMRSoft                     2.4.2                            16





NcFTP(1)                                                 NcFTP(1)


       program  to  continue  downloading  where  it left off.  I
       sometimes call that feature ``forced reget'' for  histori
       cal reasons.

       You  can also turn off _w_i_l_d_c_a_r_d _m_a_t_c_h_i_n_g with _g_e_t by using
       the ``-G'' flag.  Other _F_T_P programs used the syntax

            get remote-file [local-file]

       which allowed you to specify a local pathname for the file
       you  were  trying  to  download.   _N_c_F_T_P  differs  in that
       respect, and if you used the  older  programs,  you  would
       find  that the program's _g_e_t behaves more like those other
       program's _m_g_e_t command.  This means that in _N_c_F_T_P_,that

            get file01 file02

       tries  to  download  remote  files  named  ``file01''  and
       ``file02.''   If you like, you can get that older behavior
       by using the ``-z'' flag, so:

            get -z file01 ../junk/files/01.txt

       would   get   ``file01''   and   use   the   local    name
       ``../junk/files/01.txt.''

       Another thing that _g_e_t does is that you can use the ``-n''
       flag to fetch files that are a certain number of days  old
       or  newer.  If you just want to get the newest files at an
       archive, you don't have to use a  full  mirror.   You  can
       just  say  ``download  all  files  that  are 3 days old or
       newer.''  Do that by going to a directory, and trying:

            get -n 3 *

       The program also has ``reget'' mode  built  into  the  _g_e_t
       command.   Other  FTP  programs  provided a _r_e_g_e_t command,
       which was useful when you lost a connection during a down
       load.   Instead  of  the  remote host resending the entire
       file, you could use the  _r_e_g_e_t  command  to  continue  the
       transfer where it was cut off.

       _N_c_F_T_P  has  this  capability built-in, and it examines the
       date and size of the remote file and local file to  deter
       mine if the program should continue where it left off last
       time.  If the dates are the same, but the  local  file  is
       smaller, the program attempts to ``reget.''

       The  last,  and  most wasteful feature of _g_e_t is recursive
       mode, which is turned on with the ``-R'' flag.  This  fea
       ture  lets  you  download  an entire directory's contents,
       i.e.:

            get -R /pub/info/help



NCEMRSoft                     2.4.2                            17





NcFTP(1)                                                 NcFTP(1)


       That creates a directory called ``./help'' in the  current
       local  directory,  and copies all files and subdirectories
       into it.

       Please use some discretion with this feature.  If you  get
       a  large  directory,  you could really bog down the remote
       host.  Archive administrators are providing a public  ser
       vice, so don't abuse the archive so much that they have to
       shut down public access because the  real  users  of  that
       archive can't get their work done.

MMAACCRROOSS
       The  program  has  a simple macro/alias facility.  You can
       use macros to roll your own commands, or  do  things  when
       certain events happen.

       To use macros, you will need to create and edit the _m_a_c_r_o_s
       file in your _._n_c_f_t_p subdirectory of your  home  directory.
       Your  _~_/_._n_c_f_t_p  directory is created for you automatically
       the first time you run the program, but you have  to  make
       the  _m_a_c_r_o_s  file  yourself  since most users won't have a
       need for them.

       You can have any number of macros.  The syntax is:

            macro macro-name
                macro-body...
            end

       Here's a simple macro that users of the  old  _f_t_p  program
       might appreciate:

            macro binary
                type i
            end

       You could run that macro simply by running the program and
       typing the macro name as if it were a regular  _n_c_f_t_p  com
       mand.

       Macros  can  also  have  parameters,  much  like  the _K_o_r_n
       _S_h_e_l_l's shell functions and the _C_-_S_h_e_l_l's aliases.   These
       parameters  are sent to your macro, and if your macro uses
       the appropriate ``dollar'' variables, they  are  expanded.
       To illustrate, try this macro:

            macro cdls
                cd $1
                ls
            end

       To run that macro, open a connection and try:

            cdls /pub



NCEMRSoft                     2.4.2                            18





NcFTP(1)                                                 NcFTP(1)


       That  would  try  to  _c_d to /pub, and then try to list its
       contents with _l_s.

       Dollar variables are somewhat like those in the _B_o_u_r_n_e and
       _K_o_r_n shells.  Example syntax:

            $4     :  Argument 4
            $*     :  All arguments.
            $@     :  All arguments, each of them surrounded by double quotes.
            $(2-5) :  Arguments 2, 3, 4, and 5.
            $(2,5) :  Arguments 2 and 5.
            $(3+)  :  Arguments 3, 4, 5, ..., N.

       A better way to code the ``cdls'' macro might be:

            macro cdls
                cd $1
                ls $(2+)
            end

       There  are some special macros, which I call _e_v_e_n_t _m_a_c_r_o_s.
       The program looks for macros by special names, and if they
       exist, runs the macro when that event happens.

       One  event macro is the _._s_t_a_r_t_._n_c_f_t_p macro.  If you have a
       macro by that name defined in your macros file,  the  pro
       gram will run that macro each time you run the program.

       Similarly,  there  is also a _._q_u_i_t_._n_c_f_t_p macro that is run
       each time you quit the program.

       Another set of event macros are site-specific.  For  exam
       ple,  if  I  have a site bookmarked as ``typhoon'' I could
       then define macros named _._o_p_e_n_._t_y_p_h_o_o_n and  _._c_l_o_s_e_._t_y_p_h_o_o_n
       which would run each time I opened and closed ``typhoon.''

       Another,  more  generic  set  of  event  macros  are   the
       _._o_p_e_n_._a_n_y  and  _._c_l_o_s_e_._a_n_y macros which run when I open or
       close any site.  One possible use for these macros  is  to
       run separate shell scripts to do some processing after you
       finish using a site.  I could have a macro like this:

            macro .quit.ncftp
                echo "Started post-processing downloads at %H:%M:%S"
                !sh ~/scripts/download-decoder
                echo "Finished post-processing downloads at %H:%M:%S"
            end

       Another use is to duplicate the old _m_a_c_d_e_f _i_n_i_t hack  that
       the  traditional _f_t_p program used in its _._n_e_t_r_c file.  For
       example:

            macro .open.infomac
                echo "Getting recent files list"



NCEMRSoft                     2.4.2                            19





NcFTP(1)                                                 NcFTP(1)


                get -z /pub/info-mac/help/recent-files ~/docs/recent
                ls -lrt
            end

UUSSIINNGG CCOOLLOONN MMOODDEE
       The _c_o_l_o_n_-_m_o_d_e feature is used from your  shell's  command
       line.

       In ancient times, way back during the Disco Era, you could
       use a program called _t_f_t_p to fetch a file using the Inter
       net  standard  _T_r_i_v_i_a_l  _F_i_l_e _T_r_a_n_s_f_e_r _P_r_o_t_o_c_o_l_.  You could
       use that program to do something like this from within its
       shell:

            get wuarchive.wustl.edu:/graphics/gif/README

       and that would call wuarchive and fetch the README file.

       You  can  use  this program to do the same thing from your
       shell's command line:

            csh> ncftp wuarchive.wustl.edu:/graphics/gif/README
            csh> head README

       This tells your shell, in this case  the  _C_-_s_h_e_l_l  to  run
       _N_c_F_T_P,   which   would   open   wuarchive,  fetch  /graph
       ics/gif/README and write the file /README in  the  current
       working directory, and then exits.

       The _c_o_l_o_n_-_m_o_d_e feature is nice if you don't want to browse
       around the remote site, and  you  know  exactly  want  you
       want.   It also comes in handy in shell scripts, where you
       don't want to enter the command shell, and might not  want
       the program to spew output.

       You  can  use  the _U_n_i_f_o_r_m _R_e_s_o_u_r_c_e _L_o_c_a_t_o_r standard also.
       For example, this would work:

            csh> ncftp ftp://wuarchive.wustl.edu/graphics/gif/README

       There are times where you might not want  the  program  to
       write  a _c_o_l_o_n_-_m_o_d_e file in the current working directory,
       or perhaps you want to pipe the output of  a  remote  file
       into  something  else.  _C_o_l_o_n_-_m_o_d_e has options to do this.
       It was inspired by the  guy  who  wrote  the  _f_t_p_c_a_t  perl
       script.   The  ``-c'' option tells the program to write on
       the standard output stream.  The ``-m'' option  pipes  the
       file into your pager (like _m_o_r_e) Of course this won't work
       if the thing you give _c_o_l_o_n_-_m_o_d_e  is  a  directory!   This
       example just dumps a remote file to stdout:

            csh> ncftp -c wuarc:/graphics/gif/README

       This  example  redirects  a  remote  file into a different



NCEMRSoft                     2.4.2                            20





NcFTP(1)                                                 NcFTP(1)


       location:

            csh> ncftp -c wu:/README > ~pdietz/thesis.tex

       This one shows how to use a pipeline:

            csh> ncftp -c wuarc:/README | tail | wc -l
            10
            csh>

       This shows how to page a remote file:

            csh> ncftp -m wuarc:/graphics/gif/README

UUSSIINNGG LLIINNEE MMOODDEE
       The only reason I provide _l_i_n_e _m_o_d_e is so that the  primi
       tive  operating systems whose _c_u_r_s_e_s library is missing or
       dysfunctional won't render the program completely useless.

       exceptions of the functions that require _v_i_s_u_a_l _m_o_d_e, such
       as the _P_r_e_f_e_r_e_n_c_e_s screen and the  _B_o_o_k_m_a_r_k  _E_d_i_t_o_r.   You
       will    have    to    edit    the    _~_/_._n_c_f_t_p_/_p_r_e_f_s    and
       _~_/_._n_c_f_t_p_/_b_o_o_k_m_a_r_k_s file manually, with a text editor.

       As a small consolation, you get to  use  the  full-powered
       line-editing  libraries,  like  _G_N_U  _R_e_a_d_l_i_n_e if they were
       compiled with the program.

SSUUMMMMAARRYY OOFF CCOOMMMMAANNDD LLIINNEE OOPPTTIIOONNSS
       When you invoke the program from  your  shell,  there  are
       ``dash  flags''  you  can use like you can with most other
       _U_N_I_X programs.

       Here's a list of options you  can  use  from  the  command
       line:


            -D : Turns on debugging mode and tracing.
            -V : Uses ``visual'' mode for this session.
            -L : Uses ``line mode'' for this session.
            -H : Prints the information from the ``version'' command and exits.

       When  you  turn  on tracing, the program writes a log with
       debugging information to  a  file  called  _t_r_a_c_e  in  your
       _._n_c_f_t_p  subdirectory  of your home directory.  If you need
       to report a bug, it would be helpful to mail me the  _t_r_a_c_e
       file so I can track it down better.

       In  addition  to the program flags, you can also use flags
       from the _o_p_e_n and _g_e_t commands with  a  _c_o_l_o_n  _m_o_d_e  path.
       Here's a really complex example:

            csh> ncftp -r -d 120 -n 3 sphygmomanometer.unl.edu:/pub/stuff/*




NCEMRSoft                     2.4.2                            21





NcFTP(1)                                                 NcFTP(1)


       This  tries  redialing  that  host  every two minutes, and
       fetching all files from the ``/pub/stuff'' directory  that
       are 3 days old or newer.

AAUUTTHHOORR
       _N_c_F_T_P  was  written  by  Mike  Gleason,  _N_C_E_M_R_S_o_f_t (mglea
       son@probe.net).  _N_c_F_T_P is copyrighted 1995  by  NCEMRSoft.
       All rights reserved.

       As of this writing, the most recent version is archived in
       /pub/ncftp, on _f_t_p_._p_r_o_b_e_._n_e_t.

TTHHAANNKKSS
       Ideas and some code contributed by my partner, Phil Dietz,
       _N_C_E_M_R_S_o_f_t (dietz@wtc.com).

       Thanks  to  everyone  who has helped test the program, and
       sent in feedback over the years.   Your  support  is  what
       drives me to improve the program!

       I'd  like  to  thank my former system administrators, most
       notably Charles Daniel, for making testing on a variety of
       platforms possible, letting me have some extra disk space,
       and for maintaining the UNL FTP site.

       I also thank Dale Botkin and Tim Russell at _P_r_o_b_e _T_e_c_h_n_o_l_
       _o_g_y,  for  giving _n_c_f_t_p a home on _p_r_o_b_e_._n_e_t, the midwest's
       best connection to the internet.

       For testing above and beyond the call of duty, I am  espe
       cially    grateful   to:   Phil   Dietz,   Kok   Hon   Yin
       (hkok@cse.unl.edu),        Andrey        A.        Chernov
       (ache@astral.msk.su).

       Thanks  to  Tim  MacKenzie (t.mackenzie@trl.oz.au) for the
       filename completion code.

       Thanks to  DaviD  W.  Sanderson  (dws@ssec.wisc.edu),  for
       helping me out with the man page.

BBUUGGSS
       Due  to  a limitation in the _c_u_r_s_e_s library, scrolling may
       be slow in visual mode.

       Shell escapes, suspending (^Z) and resuming, and interrup
       ing (^C) still have quirks with _v_i_s_u_a_l _m_o_d_e.

       There  are  no  such  sites named _b_o_w_s_e_r_._n_i_n_t_e_n_d_o_._c_o_._j_p or
       _s_p_h_y_g_m_o_m_a_n_o_m_e_t_e_r_._u_n_l_._e_d_u.

SSEEEE AALLSSOO
       _f_t_p(1), _f_t_p_d(8), _n_s_l_o_o_k_u_p(1), _a_r_c_h_i_e(1), _r_c_p(1),  _t_f_t_p(1).





NCEMRSoft                     2.4.2                            22


