/*
 * monTcp.h --
 *
 *      This header file describes the the TCP/IP interface from GUI client
 *      to monitor daemon.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monTcp.h,v 1.2 1996/10/02 19:45:40 miked Exp $
 * $Log: monTcp.h,v $
 * Revision 1.2  1996/10/02 19:45:40  miked
 * Removed error number, error message from function prototypes.
 *
 * Revision 1.1.1.1  1996/08/30  02:43:50  miked
 * Initial version.
 *
 * Revision 1.5  1996/07/30  21:01:03  miked
 * Yet another copyright notice.
 *
 * Revision 1.4  1996/07/18  20:40:05  miked
 * Added #define INADDR_NONE.
 *
 * Revision 1.3  1996/07/17  23:48:06  miked
 * Moved typedef SOCKET here from monPort.h so as to not clash with other headers.
 *
 * Revision 1.2  1996/07/09  23:57:51  miked
 * Added new copyright notice.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:44  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONTCP
#define _H_MONTCP

#include "monPort.h"

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */

#define MON_GUI_TCP_PORT        5051 /* TCP port for GUI to monitor path */

#ifndef INADDR_NONE
#define INADDR_NONE             0xffffffff
#endif

/*
 *----------------------------------------------------------------------
 *    P R O C E D U R E S
 *----------------------------------------------------------------------
 */

#ifdef __cplusplus
extern "C" {
#endif

EXTERN S5IOHandle
Mon_TcpConnect _ANSI_ARGS_(( /* Returns socket on success; -1 on failure */
    CONST char FAR*    hostName,    /* IN -- Hostname of firewall */
    int                port         /* IN -- TCP/IP port */
));

EXTERN int
Mon_TcpClose _ANSI_ARGS_((
    S5IOHandle         s            /* IN -- Socket descriptor */
));

EXTERN int
Mon_TcpRecv _ANSI_ARGS_(( /* Returns bytes recvd on success; -1 on failure */
    S5IOHandle         s,           /* IN  -- socket descriptor */
    Uint16             bufLen,      /* IN  -- Max length of buffer */
    VOID FAR*          bufPtr       /* OUT -- Pointer to received buffer */
));

EXTERN int
Mon_TcpSend _ANSI_ARGS_(( /* Returns bytes sent on success; -1 on failure */
    S5IOHandle         s,           /* IN  -- socket descriptor */
    Uint16             bufLen,      /* IN  -- Buffer length */
    CONST VOID FAR*    bufPtr       /* IN  -- Pointer to buffer to send */
));

#ifdef __cplusplus
}
#endif

#endif /* _H_MONTCP */
