/* itemList.h
   header file for itemList.c */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#ifndef ITEMLIST_H
#define ITEMLIST_H

#include "gopher.h"


gopherItemP	acquireItem(
		);

void		releaseItem(
#ifdef PROTO
			gopherItemP	/* gi */
#endif
		);

void		initItemList(
#ifdef PROTO
			gopherItemListP	/* list */
#endif
		);

void		freeItemList(
#ifdef PROTO
			gopherItemListP	/* list */
#endif
		);

void		appendItem(
#ifdef PROTO
			gopherItemListP,/* list */
			gopherItemP	/* gi */
#endif
		);

gopherItemP	getItemN(
#ifdef PROTO
			gopherItemListP,/* list */
			int		/* n */
#endif
		);

gopherItemP	nextItem(
#ifdef PROTO
			gopherItemP	/* gi */
#endif
		);

void		removeItemN(
#ifdef PROTO
			gopherItemListP,/* list */
			int		/* n */
#endif
		);

void		removeItem(
#ifdef PROTO
			gopherItemListP,/* list */
			gopherItemP	/* gi */
#endif
		);

int		itemListLength(
#ifdef PROTO
			gopherItemListP /* list */
#endif
		);



static void	allocGopherItem(
#ifdef PROTO
			int		/* n */
#endif
);

static void	releaseItems(
#ifdef PROTO
			gopherItemP	/* gi */
#endif
);

static void	pushItem(
#ifdef PROTO
			gopherItemListP,/* list, gi */
			gopherItemP	/* list, gi */
#endif
);


#ifdef DEBUG_LIST
void		printItemList(
#ifdef PROTO
			gopherItemListP,/* list */
			char *		/* label */
#endif
);
#endif /* DEBUG_LIST */

#endif /* ITEMLIST_H */
