/******
  
main.c	sets things up and handles Forms2. callbacks.
         Many of the global variables do not have to be global
	 redraw_face and refresh_face should always be called to
	 draw the 3D head.


*******/
/* Main Pull3d Experimental Controller */

#include <forms.h>
#include <malloc.h>
#include "muscles.h"
#include "standard.h"
#include "master_fl.h"
#include <gl/gl.h>
#include <gl/device.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "proto.h"
#include "IPC.h"
#include "lights.h"

/* yeah...alot of global variables, most don't have to be */

float 	*perm_face;		
float	*face;			/* The actual vertex values of face points*/
int	*tconn;			/* Triangular COnnections */
int	*qconn;			/* Quadralteral connections */
int	*llip_indx;		/* List of points in lower lip */
int	*ulip_indx;		/* List of points in upper lip */
int	*jaw_indx;		/* List of points in jaw */
int 	*nrml_indx;		/* normal vectors indexes to calc normals from */
float	*face_nrmls;		/* the actual normal vectors */
float	*tex_coor;		/* Mapping table for texture map */
long	face_size;		/* in bytes */
long	fgid;
long	mgid;
camera_pos	camera;		/* Keyboard control of camera position */
cntrl_options	option;
eye_info	iball;
head_info	head;
Object		eye;		/* the GL object ID for the eye */
struct muscle musc[NUM_MUSCLES];
struct sphinctor mouth_sphin;

/** Use static for global variables only accessed in main.c **/

param_vals	param[NUM_PARMS];	
static int		skt;
packet_format	data_pak;

main()
     
{

    float	val;
    float	ftemp;
    int		i;
    FL_OBJECT	*obj;
    long	dev;


   /* mallopt(M_DEBUG,TRUE);	/* turn on malloc debugging,
				   this slows down alot */
    option.ortho = TRUE;
    option.light = TRUE;
    


    /** Initialize Socket Communication **/
    skt= setup_server_IPC();
    printf("Server/Client Connection Complete (%d)... \n",skt);

    foreground();		/* bind to window for debugging */
    create_the_forms();		/* Initialize Forms */

      
    load_face("New-Data/Face");	/* This sets up face[] and conn[] */
    setup_muscles("New-Data/Muscle.indx");/* Sets up the muscle parameters  */
    init_muscles();				/*  in musc[14]	  */
    init_sphinctor();
    init_params();

    jaw_indx  = load_jaw("New-Data/Jaw.indx");
    ulip_indx = load_lips("New-Data/ULip.indx");
    llip_indx = load_lips("New-Data/LLip.indx");
    nrml_indx = assign_normals(face[0],qconn);
    face_nrmls= (float *) malloc(sizeof(float) * (face[0]+1) * 3);

	/* Raised eye-ypos, decreased radius and increased z-pos to compensate
	- pehaps specify zpos as forward position and solve equation
	based on radius to get the real center zpos SWF */
    iball.pupil = 0.30;         /* pupil size */
    iball.iris  = 0.40;         /* iris size */
    iball.xpos	= 0.71 	* 	3.0;
    iball.ypos	= 0.92	*	3.0;
    iball.zpos	= 0.6475	*	10.0;
    iball.xrot	= 0.00;
    iball.yrot  = 0.00;
    iball.dist	= 0.83	*	5.0;
    iball.size	= 0.5	*	2.0;
    eye = make_eye_object();




    /* Make A Copy of Facial Position while it is at"rest" */
    face_size = (face[0]*3+1) * sizeof(float);
    perm_face = (float *) malloc(face_size);
    bcopy(face,perm_face,face_size);	

    fgid      = init_face_win();	/* Open a Window For the Face */
    init_gl_env();			/* Do misc. GL setup */
   

    /* Always Load the texture Map, then toggle via FORMS2.0 */
    load_texture(1,"New-Data/Face");
    tex_coor = bind_texture_coor(face,"New-Data/Face");

    fl_set_form_position(cntrl_menu,10,-1);
    fl_show_form(cntrl_menu,FL_PLACE_POSITION,TRUE,"RENDERER");
    
    redraw_face(); 
    bcopy(perm_face,face,face_size);
    fl_qdevice(MIDDLEMOUSE);	/* for selecting vertexes */
    fl_qdevice(LEFTMOUSE);	/* switching  polymode to PYM_FILL */
    fl_qdevice(RIGHTMOUSE);	/* switching  polymode to PYM_LINE */
    queue_keypad();
    
    monitor_loop();
    event_loop(); 
}


/*** event_loop() ***/
void	event_loop()
{
    short int	val;
    long	dev,curr_win;
    FL_OBJECT	*obj;
    
    while ((obj=fl_check_forms()) !=0) {
	if (obj!=FL_EVENT) {
	    printf("Strange Object returned %d \n",obj);
	}
	if (obj==FL_EVENT) {
	    dev = fl_qread(&val);
	    if (dev == INPUTCHANGE) 	{
		curr_win = val; 
	    }
	    else if (dev == REDRAW) {
		winset(val);
		reshapeviewport();
		redraw_face(NULL,NULL); 
		if (mgid >0 ) {
		  draw_msc_chart(mgid);
			winset(fgid);
	}
	    }	    
	    
	    else if ((dev == MIDDLEMOUSE) &&(val==1) &&(curr_win==fgid)) {
		select_vertex(fgid);
	    }
	    
	    else if ((dev == LEFTMOUSE) &&(val==1) &&(curr_win==fgid)) {
		winset(fgid); polymode(PYM_LINE);
		linewidth(1);
		redraw_face(NULL,NULL);
	    }
	    
	    else if ((dev == RIGHTMOUSE) &&(val==1) &&(curr_win==fgid)) {
		winset(fgid); polymode(PYM_FILL);
		redraw_face(NULL,NULL);
	    }
	    else if( keypad_event(dev,val)==TRUE) {
	    }
	    
	    else {
		/* 
	      printf("Unkown Event:  %d  - %d \n",dev,val);
	      */
	    }

	} /* obj==FL_EVENT */		
	
    }		
}


/*** monitor_loop() - monitor the socket and animate based on input ***/    
void monitor_loop()
{
    /** The priority is checking the communcation socket, however
       after every frame is rendered the FORMS gui is checked to
       see if the user wants to change any parameters **/

 
    struct timeval	new_time,old_time,timeout;
    struct timezone	time_zone;
    float		delta_time;
    fd_set		tmp_mask,mask;
    int			nfound,frame,old_frame,delta_frame;
    int			nfds;
	
    FD_ZERO(&mask);
    FD_SET(skt,&mask);
    nfds = skt+1;
    frame = 0 ; 

    printf("Monitor Loop skt = %d \n",skt);
    while (1) { 
	
#define TO_SEC 0
#define TO_USEC 8500

	/* Wait up to 1/2 for new frameinfo on Unix Socket */
	timeout.tv_sec = TO_SEC;		
	timeout.tv_usec= TO_USEC;
	tmp_mask = mask;
	nfound = select(nfds,&tmp_mask,(fd_set *)NULL,(fd_set *)NULL,&timeout);

	if (nfound !=0) {	/* If there was any data, animate it */
	    receive_data_packet(skt,&data_pak,sizeof(packet_format));
	    frame++;
	 /*   printf("Data PacketID  # %d \n",data_pak.id); */
	    
	    iball.xrot = (data_pak.param[I_XDIR]-0.5)*600; 
	    iball.yrot = (data_pak.param[I_YDIR]-0.5)*900;
	    head.xrot  = (data_pak.param[XROT]-0.5)*600;
	    head.yrot  = (data_pak.param[YROT]-0.5)*900;
	    
	    /* need a special signal to know when to regenrate the
	       eye object for different iris/pupil size */
	    
	    redraw_face();
	}
	else if (nfound == -1) {
	    perror("select error");
	    printf("errno = %d -- %s \n",errno,strerror(errno));
	    printf("oserrornum %d \n",oserror());
	}
	else {  /* a timeout has occured */	
	 /*   gettimeofday(&new_time,&time_zone);
	    delta_frame = frame - old_frame;
	  
	    delta_time = (float)((new_time.tv_sec -old_time.tv_sec-TO_SEC)+
			 ((new_time.tv_usec-old_time.tv_usec-TO_USEC)
			  /1000000.0));

	    printf("%d Frames rendered in %5.4f seconds \n",delta_frame,
		   delta_time); 
	    old_frame = frame;
	    old_time = new_time;
	*/

	}
	event_loop();

    }
}


/*** redraw_face - recalculate face position and refresh display ***/
void redraw_face(FL_OBJECT *obj, long val)
{
    int	i;

    /** need to re-write this to new parameter structure **/
    bcopy(perm_face,face,face_size);

    rot_jaw(face,jaw_indx,(data_pak.param[JAW] * param[JAW].scale));
    
    lip_sep((data_pak.param[LIP_Y]*param[LIP_Y].scale),
	    (data_pak.param[LIP_Z]*param[LIP_Z].scale));
    
    for (i=0;i<14;i ++)		/* The 14 main 3-Dimensional Muscles */
      if (data_pak.param[i] !=0)
	pull3d(face,i,(data_pak.param[i]*param[i].scale));

    if (data_pak.param[ML_FRONT] != 0)
      pull1d(face,14,(data_pak.param[ML_FRONT]*param[ML_FRONT].scale));
     
    if (data_pak.param[MR_FRONT]!= 0)
      pull1d(face,15,(data_pak.param[MR_FRONT]*param[MR_FRONT].scale));
      
    /*sphincter(data_pak.param[KISS]);
      This data parameter isn;'t defined yet!*/

    refresh_face(obj,val);

}



void refresh_face(FL_OBJECT *obj,long val)
{
   
    plot_face(fgid,face,qconn,tconn,nrml_indx);
/*    plot_eyelids(0.0);	 /* still debugging */


/*    plot_face_normals(fgid,face,face_nrmls); 
      /* */

    plot_eyes(iball,eye);
    plot_eyelids(0.0);	 /* still debugging */


  
    if (option.disp_musc) {
	/*plot_static_muscles(fgid); */
	plot_dynamic_muscles(fgid,face);
    }
   
    swapbuffers();
    if (option.movie) {
	winset(fgid);
	savemovieframe();	/* add a frame rate variable */
 	printf("Done Saving Frame \n");  
	 }
    
}





void	exit_session(FL_OBJECT *,long)
{
    printf("Exiting Gracefully..\n");
    printf("Closing IPC Port \n");
    close_server_IPC();
    exit(0);
}


void	option_param(FL_OBJECT *obj, long val)
{

    int	new_val;

    /* Note: The new method of binding texture and lighting only
       when changed might screw things up for other debugging graphics!*/
    new_val = fl_get_button(obj);
    switch ((int)val) {
      case 1:
	option.movie = new_val;
	break;

      case 2:
	winset(fgid);
	option.texture = new_val;
	if (option.texture)
	  tevbind(TV_ENV0,1);		/* Turn on texture mapping */
	else 
	  tevbind(TV_ENV0,0);		/* turn off texture mapping */
	break;

      case 3:
	winset(fgid);
      	lmbind(MATERIAL,MYSKIN);	/* The front of skin looks like */
/*	lmbind(BACKMATERIAL,BSKIN);	/* The back of the skin looks like */
	option.light = new_val;
	break;

      case 5:			/* show muscle position */
	printf("Toggling Muscle Position \n");
	option.disp_musc = new_val;
	break;
    }
    refresh_face(NULL,NULL);
}



void	show_form(FL_OBJECT *obj,long val)
{
    int	new_val;
    new_val = fl_get_button(obj);	/* is is on or off now ? */

    if (new_val ==1) { /* Turn on/show the form */
	switch ((int) val) {
	  case 1:
	printf("show_form::Showing Muscle Chart \n");
	    mgid = init_msc_chart();
	    winset(fgid);
	    break;
	    
	  case 2:
	    break;
	    
	  case 3:

	    break;
	    
	    
	}
    }

    if (new_val==0) { /* turn off or hide the form */
	
	switch ((int) val) {
	  case 1:
	    winclose(mgid);
	    mgid = -3 ;
	    break;
	    
	  case 2:

	    break;
	    
	  case 3:

	    break;
	}
    }

}












