# Persian (fa-IR) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                   | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                              | 1986-12-27T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                 | 0005-01-01T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | س‌م1                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | س‌م2                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | سه‌ماهه 1                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | سه‌ماهه 2                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | س‌م1                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | س‌م2                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | سه‌ماهه 1                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | سه‌ماهه 2                                         | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | فور                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جولـ                                              | Invalid Date             |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | فوریه                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جولای                                             | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | ف                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ج                                                 | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | فور                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جولـ                                              | Invalid Date             |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | فوریه                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جولای                                             | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | ف                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ج                                                 | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                 | 2018-12-29T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49                                                | 2019-11-30T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | د                                                 | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-22T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | 2ش                                                | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-22T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | د                                                 | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | 2ش                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 3                                                 | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 7                                                 | 2019-02-22T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | د                                                 | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-22T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | 2ش                                                | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-22T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 3                                                 | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 7                                                 | 2019-02-22T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | دوشنبه                                            | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعه                                              | 2019-02-22T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | د                                                 | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-22T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | 2ش                                                | 2019-02-18T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                 | 2019-02-22T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | قبل‌ازظهر                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | قبل‌ازظهر                                         | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ق                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب.ظ.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق.ظ.                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | قبل‌ازظهر                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | قبل‌ازظهر                                         | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ق                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ب                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ق                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | صبح                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | عصر                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | شب                                                | 2019-02-11T12:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | صبح                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | عصر                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | شب                                                | 2019-02-11T12:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | صبح                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | عصر                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | شب                                                | 2019-02-11T12:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | صبح                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعدازظهر                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | عصر                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | شب                                                | 2019-02-11T12:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ص                                                 | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ب.ظ.                                              | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ش                                                 | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 1987/02/11                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                        | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 فور 1987                                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 می 1453                                        | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 فوریه 1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 می 1453                                        | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | چهارشنبه 11 فوریه 1987                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | یکشنبه 29 می 1453                                 | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 ب.ظ.                                        | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 ب.ظ.                                        | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 ب.ظ.                                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ب.ظ.                                     | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 ب.ظ. GMT+0                               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ب.ظ. GMT+0                               | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 ب.ظ. GMT+00:00                           | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ب.ظ. GMT+00:00                           | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 1987/02/11, 12:13 ب.ظ.                            | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29, 11:59 ب.ظ.                            | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 فور 1987, 12:13:14 ب.ظ.                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 می 1453, 11:59:59 ب.ظ.                         | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 فوریه 1987 در 12:13:14 ب.ظ. GMT+0              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 می 1453 در 11:59:59 ب.ظ. GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | چهارشنبه 11 فوریه 1987 در 12:13:14 ب.ظ. GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | یکشنبه 29 می 1453 در 11:59:59 ب.ظ. GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result           | `includeSeconds: true` | `addSuffix: true`    |
| ------------------------ | ---------------- | ---------------------- | -------------------- |
| 2006-01-01T00:00:00.000Z | حدود 6 سال       | حدود 6 سال             | در حدود 6 سال        |
| 2005-01-01T00:00:00.000Z | حدود 5 سال       | حدود 5 سال             | در حدود 5 سال        |
| 2004-01-01T00:00:00.000Z | حدود 4 سال       | حدود 4 سال             | در حدود 4 سال        |
| 2003-01-01T00:00:00.000Z | حدود 3 سال       | حدود 3 سال             | در حدود 3 سال        |
| 2002-01-01T00:00:00.000Z | حدود 2 سال       | حدود 2 سال             | در حدود 2 سال        |
| 2001-06-01T00:00:00.000Z | بیشتر از 1 سال   | بیشتر از 1 سال         | در بیشتر از 1 سال    |
| 2001-02-01T00:00:00.000Z | حدود 1 سال       | حدود 1 سال             | در حدود 1 سال        |
| 2001-01-01T00:00:00.000Z | حدود 1 سال       | حدود 1 سال             | در حدود 1 سال        |
| 2000-06-01T00:00:00.000Z | 5 ماه            | 5 ماه                  | در 5 ماه             |
| 2000-03-01T00:00:00.000Z | 2 ماه            | 2 ماه                  | در 2 ماه             |
| 2000-02-01T00:00:00.000Z | حدود 1 ماه       | حدود 1 ماه             | در حدود 1 ماه        |
| 2000-01-15T00:00:00.000Z | 14 روز           | 14 روز                 | در 14 روز            |
| 2000-01-02T00:00:00.000Z | 1 روز            | 1 روز                  | در 1 روز             |
| 2000-01-01T06:00:00.000Z | حدود 6 ساعت      | حدود 6 ساعت            | در حدود 6 ساعت       |
| 2000-01-01T01:00:00.000Z | حدود 1 ساعت      | حدود 1 ساعت            | در حدود 1 ساعت       |
| 2000-01-01T00:45:00.000Z | حدود 1 ساعت      | حدود 1 ساعت            | در حدود 1 ساعت       |
| 2000-01-01T00:30:00.000Z | 30 دقیقه         | 30 دقیقه               | در 30 دقیقه          |
| 2000-01-01T00:15:00.000Z | 15 دقیقه         | 15 دقیقه               | در 15 دقیقه          |
| 2000-01-01T00:01:00.000Z | 1 دقیقه          | 1 دقیقه                | در 1 دقیقه           |
| 2000-01-01T00:00:25.000Z | کمتر از یک دقیقه | نیم دقیقه              | در کمتر از یک دقیقه  |
| 2000-01-01T00:00:15.000Z | کمتر از یک دقیقه | کمتر از 20 ثانیه       | در کمتر از یک دقیقه  |
| 2000-01-01T00:00:05.000Z | کمتر از یک دقیقه | کمتر از 10 ثانیه       | در کمتر از یک دقیقه  |
| 2000-01-01T00:00:00.000Z | کمتر از یک دقیقه | کمتر از 5 ثانیه        | کمتر از یک دقیقه قبل |
| 1999-12-31T23:59:55.000Z | کمتر از یک دقیقه | کمتر از 10 ثانیه       | کمتر از یک دقیقه قبل |
| 1999-12-31T23:59:45.000Z | کمتر از یک دقیقه | کمتر از 20 ثانیه       | کمتر از یک دقیقه قبل |
| 1999-12-31T23:59:35.000Z | کمتر از یک دقیقه | نیم دقیقه              | کمتر از یک دقیقه قبل |
| 1999-12-31T23:59:00.000Z | 1 دقیقه          | 1 دقیقه                | 1 دقیقه قبل          |
| 1999-12-31T23:45:00.000Z | 15 دقیقه         | 15 دقیقه               | 15 دقیقه قبل         |
| 1999-12-31T23:30:00.000Z | 30 دقیقه         | 30 دقیقه               | 30 دقیقه قبل         |
| 1999-12-31T23:15:00.000Z | حدود 1 ساعت      | حدود 1 ساعت            | حدود 1 ساعت قبل      |
| 1999-12-31T23:00:00.000Z | حدود 1 ساعت      | حدود 1 ساعت            | حدود 1 ساعت قبل      |
| 1999-12-31T18:00:00.000Z | حدود 6 ساعت      | حدود 6 ساعت            | حدود 6 ساعت قبل      |
| 1999-12-30T00:00:00.000Z | 2 روز            | 2 روز                  | 2 روز قبل            |
| 1999-12-15T00:00:00.000Z | 17 روز           | 17 روز                 | 17 روز قبل           |
| 1999-12-01T00:00:00.000Z | حدود 1 ماه       | حدود 1 ماه             | حدود 1 ماه قبل       |
| 1999-11-01T00:00:00.000Z | 2 ماه            | 2 ماه                  | 2 ماه قبل            |
| 1999-06-01T00:00:00.000Z | 7 ماه            | 7 ماه                  | 7 ماه قبل            |
| 1999-01-01T00:00:00.000Z | حدود 1 سال       | حدود 1 سال             | حدود 1 سال قبل       |
| 1998-12-01T00:00:00.000Z | حدود 1 سال       | حدود 1 سال             | حدود 1 سال قبل       |
| 1998-06-01T00:00:00.000Z | بیشتر از 1 سال   | بیشتر از 1 سال         | بیشتر از 1 سال قبل   |
| 1998-01-01T00:00:00.000Z | حدود 2 سال       | حدود 2 سال             | حدود 2 سال قبل       |
| 1997-01-01T00:00:00.000Z | حدود 3 سال       | حدود 3 سال             | حدود 3 سال قبل       |
| 1996-01-01T00:00:00.000Z | حدود 4 سال       | حدود 4 سال             | حدود 4 سال قبل       |
| 1995-01-01T00:00:00.000Z | حدود 5 سال       | حدود 5 سال             | حدود 5 سال قبل       |
| 1994-01-01T00:00:00.000Z | حدود 6 سال       | حدود 6 سال             | حدود 6 سال قبل       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result   | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | -------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 سال    | در 6 سال          | 52608 ساعت                     |
| 2005-01-01T00:00:00.000Z | 5 سال    | در 5 سال          | 43848 ساعت                     |
| 2004-01-01T00:00:00.000Z | 4 سال    | در 4 سال          | 35064 ساعت                     |
| 2003-01-01T00:00:00.000Z | 3 سال    | در 3 سال          | 26304 ساعت                     |
| 2002-01-01T00:00:00.000Z | 2 سال    | در 2 سال          | 17544 ساعت                     |
| 2001-06-01T00:00:00.000Z | 1 سال    | در 1 سال          | 12408 ساعت                     |
| 2001-02-01T00:00:00.000Z | 1 سال    | در 1 سال          | 9528 ساعت                      |
| 2001-01-01T00:00:00.000Z | 1 سال    | در 1 سال          | 8784 ساعت                      |
| 2000-06-01T00:00:00.000Z | 5 ماه    | در 5 ماه          | 3648 ساعت                      |
| 2000-03-01T00:00:00.000Z | 2 ماه    | در 2 ماه          | 1440 ساعت                      |
| 2000-02-01T00:00:00.000Z | 1 ماه    | در 1 ماه          | 744 ساعت                       |
| 2000-01-15T00:00:00.000Z | 14 روز   | در 14 روز         | 336 ساعت                       |
| 2000-01-02T00:00:00.000Z | 1 روز    | در 1 روز          | 24 ساعت                        |
| 2000-01-01T06:00:00.000Z | 6 ساعت   | در 6 ساعت         | 6 ساعت                         |
| 2000-01-01T01:00:00.000Z | 1 ساعت   | در 1 ساعت         | 1 ساعت                         |
| 2000-01-01T00:45:00.000Z | 45 دقیقه | در 45 دقیقه       | 1 ساعت                         |
| 2000-01-01T00:30:00.000Z | 30 دقیقه | در 30 دقیقه       | 1 ساعت                         |
| 2000-01-01T00:15:00.000Z | 15 دقیقه | در 15 دقیقه       | 0 ساعت                         |
| 2000-01-01T00:01:00.000Z | 1 دقیقه  | در 1 دقیقه        | 0 ساعت                         |
| 2000-01-01T00:00:25.000Z | 25 ثانیه | در 25 ثانیه       | 0 ساعت                         |
| 2000-01-01T00:00:15.000Z | 15 ثانیه | در 15 ثانیه       | 0 ساعت                         |
| 2000-01-01T00:00:05.000Z | 5 ثانیه  | در 5 ثانیه        | 0 ساعت                         |
| 2000-01-01T00:00:00.000Z | 0 ثانیه  | 0 ثانیه قبل       | 0 ساعت                         |
| 1999-12-31T23:59:55.000Z | 5 ثانیه  | 5 ثانیه قبل       | 0 ساعت                         |
| 1999-12-31T23:59:45.000Z | 15 ثانیه | 15 ثانیه قبل      | 0 ساعت                         |
| 1999-12-31T23:59:35.000Z | 25 ثانیه | 25 ثانیه قبل      | 0 ساعت                         |
| 1999-12-31T23:59:00.000Z | 1 دقیقه  | 1 دقیقه قبل       | 0 ساعت                         |
| 1999-12-31T23:45:00.000Z | 15 دقیقه | 15 دقیقه قبل      | 0 ساعت                         |
| 1999-12-31T23:30:00.000Z | 30 دقیقه | 30 دقیقه قبل      | 1 ساعت                         |
| 1999-12-31T23:15:00.000Z | 45 دقیقه | 45 دقیقه قبل      | 1 ساعت                         |
| 1999-12-31T23:00:00.000Z | 1 ساعت   | 1 ساعت قبل        | 1 ساعت                         |
| 1999-12-31T18:00:00.000Z | 6 ساعت   | 6 ساعت قبل        | 6 ساعت                         |
| 1999-12-30T00:00:00.000Z | 2 روز    | 2 روز قبل         | 48 ساعت                        |
| 1999-12-15T00:00:00.000Z | 17 روز   | 17 روز قبل        | 408 ساعت                       |
| 1999-12-01T00:00:00.000Z | 1 ماه    | 1 ماه قبل         | 744 ساعت                       |
| 1999-11-01T00:00:00.000Z | 2 ماه    | 2 ماه قبل         | 1464 ساعت                      |
| 1999-06-01T00:00:00.000Z | 7 ماه    | 7 ماه قبل         | 5136 ساعت                      |
| 1999-01-01T00:00:00.000Z | 1 سال    | 1 سال قبل         | 8760 ساعت                      |
| 1998-12-01T00:00:00.000Z | 1 سال    | 1 سال قبل         | 9504 ساعت                      |
| 1998-06-01T00:00:00.000Z | 2 سال    | 2 سال قبل         | 13896 ساعت                     |
| 1998-01-01T00:00:00.000Z | 2 سال    | 2 سال قبل         | 17520 ساعت                     |
| 1997-01-01T00:00:00.000Z | 3 سال    | 3 سال قبل         | 26280 ساعت                     |
| 1996-01-01T00:00:00.000Z | 4 سال    | 4 سال قبل         | 35064 ساعت                     |
| 1995-01-01T00:00:00.000Z | 5 سال    | 5 سال قبل         | 43824 ساعت                     |
| 1994-01-01T00:00:00.000Z | 6 سال    | 6 سال قبل         | 52584 ساعت                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                     |
| ------------------------ | -------------------------- |
| 2000-01-10T00:00:00.000Z | 2000/01/10                 |
| 2000-01-05T00:00:00.000Z | چهارشنبه در 12:00 ق.ظ.     |
| 2000-01-02T00:00:00.000Z | فردا در 12:00 ق.ظ.         |
| 2000-01-01T00:00:00.000Z | امروز در 12:00 ق.ظ.        |
| 1999-12-31T00:00:00.000Z | دیروز در 12:00 ق.ظ.        |
| 1999-12-27T00:00:00.000Z | دوشنبه گذشته در 12:00 ق.ظ. |
| 1999-12-21T00:00:00.000Z | 1999/12/21                 |
